/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.proxy;

import com.beust.jcommander.IStringConverter;
import com.beust.jcommander.Parameter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Properties;
import org.apache.accumulo.core.cli.Help;
import org.apache.accumulo.core.client.ClientConfiguration;
import org.apache.accumulo.core.client.impl.ClientContext;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.client.security.tokens.KerberosToken;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.rpc.SslConnectionParams;
import org.apache.accumulo.core.util.HostAndPort;
import org.apache.accumulo.minicluster.MiniAccumuloCluster;
import org.apache.accumulo.proxy.ProxyServer;
import org.apache.accumulo.proxy.thrift.AccumuloProxy;
import org.apache.accumulo.server.metrics.MetricsFactory;
import org.apache.accumulo.server.rpc.RpcWrapper;
import org.apache.accumulo.server.rpc.SaslServerConnectionParams;
import org.apache.accumulo.server.rpc.ServerAddress;
import org.apache.accumulo.server.rpc.TServerUtils;
import org.apache.accumulo.server.rpc.ThriftServerType;
import org.apache.accumulo.server.rpc.TimedProcessor;
import org.apache.accumulo.server.rpc.UGIAssumingProcessor;
import org.apache.accumulo.start.spi.KeywordExecutable;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Proxy
implements KeywordExecutable {
    private static final Logger log = LoggerFactory.getLogger(Proxy.class);
    public static final String USE_MINI_ACCUMULO_KEY = "useMiniAccumulo";
    public static final String USE_MINI_ACCUMULO_DEFAULT = "false";
    public static final String USE_MOCK_INSTANCE_KEY = "useMockInstance";
    public static final String USE_MOCK_INSTANCE_DEFAULT = "false";
    public static final String ACCUMULO_INSTANCE_NAME_KEY = "instance";
    public static final String ZOOKEEPERS_KEY = "zookeepers";
    public static final String THRIFT_THREAD_POOL_SIZE_KEY = "numThreads";
    public static final String THRIFT_THREAD_POOL_SIZE_DEFAULT = "5";
    public static final String THRIFT_MAX_FRAME_SIZE_KEY = "maxFrameSize";
    public static final String THRIFT_MAX_FRAME_SIZE_DEFAULT = "16M";
    public static final String THRIFT_SERVER_TYPE = "thriftServerType";
    public static final String THRIFT_SERVER_TYPE_DEFAULT = "";
    public static final ThriftServerType DEFAULT_SERVER_TYPE = ThriftServerType.getDefault();
    public static final String KERBEROS_PRINCIPAL = "kerberosPrincipal";
    public static final String KERBEROS_KEYTAB = "kerberosKeytab";
    public static final String THRIFT_SERVER_HOSTNAME = "thriftServerHostname";
    public static final String THRIFT_SERVER_HOSTNAME_DEFAULT = "0.0.0.0";

    public String keyword() {
        return "proxy";
    }

    public void execute(String[] args) throws Exception {
        Opts opts = new Opts();
        opts.parseArgs(Proxy.class.getName(), args, new Object[0]);
        boolean useMini = Boolean.parseBoolean(opts.prop.getProperty(USE_MINI_ACCUMULO_KEY, "false"));
        boolean useMock = Boolean.parseBoolean(opts.prop.getProperty(USE_MOCK_INSTANCE_KEY, "false"));
        String instance = opts.prop.getProperty(ACCUMULO_INSTANCE_NAME_KEY);
        String zookeepers = opts.prop.getProperty(ZOOKEEPERS_KEY);
        if (!useMini && !useMock && instance == null) {
            System.err.println("Properties file must contain one of : useMiniAccumulo=true, useMockInstance=true, or instance=<instance name>");
            System.exit(1);
        }
        if (instance != null && zookeepers == null) {
            System.err.println("When instance is set in properties file, zookeepers must also be set.");
            System.exit(1);
        }
        if (!opts.prop.containsKey("port")) {
            System.err.println("No port property");
            System.exit(1);
        }
        if (useMini) {
            log.info("Creating mini cluster");
            final File folder = Files.createTempDirectory(System.currentTimeMillis() + THRIFT_SERVER_TYPE_DEFAULT, new FileAttribute[0]).toFile();
            final MiniAccumuloCluster accumulo = new MiniAccumuloCluster(folder, "secret");
            accumulo.start();
            opts.prop.setProperty(ACCUMULO_INSTANCE_NAME_KEY, accumulo.getConfig().getInstanceName());
            opts.prop.setProperty(ZOOKEEPERS_KEY, accumulo.getZooKeepers());
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void start() {
                    try {
                        accumulo.stop();
                    }
                    catch (Exception e) {
                        throw new RuntimeException();
                    }
                    finally {
                        if (!folder.delete()) {
                            log.warn("Unexpected error removing " + folder);
                        }
                    }
                }
            });
        }
        Class<TProtocolFactory> protoFactoryClass = Class.forName(opts.prop.getProperty("protocolFactory", TCompactProtocol.Factory.class.getName())).asSubclass(TProtocolFactory.class);
        TProtocolFactory protoFactory = protoFactoryClass.newInstance();
        int port = Integer.parseInt(opts.prop.getProperty("port"));
        String hostname = opts.prop.getProperty(THRIFT_SERVER_HOSTNAME, THRIFT_SERVER_HOSTNAME_DEFAULT);
        HostAndPort address = HostAndPort.fromParts((String)hostname, (int)port);
        ServerAddress server = Proxy.createProxyServer(address, protoFactory, opts.prop);
        while (!server.server.isServing()) {
            Thread.sleep(100L);
        }
        log.info("Proxy server started on " + server.getAddress());
        while (server.server.isServing()) {
            Thread.sleep(1000L);
        }
    }

    public static void main(String[] args) throws Exception {
        new Proxy().execute(args);
    }

    public static ServerAddress createProxyServer(HostAndPort address, TProtocolFactory protocolFactory, Properties properties) throws Exception {
        return Proxy.createProxyServer(address, protocolFactory, properties, ClientConfiguration.loadDefault());
    }

    public static ServerAddress createProxyServer(HostAndPort address, TProtocolFactory protocolFactory, Properties properties, ClientConfiguration clientConf) throws Exception {
        int numThreads = Integer.parseInt(properties.getProperty(THRIFT_THREAD_POOL_SIZE_KEY, THRIFT_THREAD_POOL_SIZE_DEFAULT));
        long maxFrameSize = AccumuloConfiguration.getMemoryInBytes((String)properties.getProperty(THRIFT_MAX_FRAME_SIZE_KEY, THRIFT_MAX_FRAME_SIZE_DEFAULT));
        int simpleTimerThreadpoolSize = Integer.parseInt(Property.GENERAL_SIMPLETIMER_THREADPOOL_SIZE.getDefaultValue());
        long threadpoolResizeInterval = 5000L;
        long serverSocketTimeout = 0L;
        MetricsFactory metricsFactory = new MetricsFactory(false);
        String serverName = "Proxy";
        String threadName = "Accumulo Thrift Proxy";
        ProxyServer impl = new ProxyServer(properties);
        AccumuloProxy.Iface wrappedImpl = (AccumuloProxy.Iface)RpcWrapper.service((Object)impl, new AccumuloProxy.Processor<ProxyServer>(impl));
        UGIAssumingProcessor processor = new AccumuloProxy.Processor(wrappedImpl);
        String serverTypeStr = properties.getProperty(THRIFT_SERVER_TYPE, THRIFT_SERVER_TYPE_DEFAULT);
        ThriftServerType serverType = DEFAULT_SERVER_TYPE;
        if (!THRIFT_SERVER_TYPE_DEFAULT.equals(serverTypeStr)) {
            serverType = ThriftServerType.get((String)serverTypeStr);
        }
        SslConnectionParams sslParams = null;
        SaslServerConnectionParams saslParams = null;
        switch (serverType) {
            case SSL: {
                sslParams = SslConnectionParams.forClient((AccumuloConfiguration)ClientContext.convertClientConfig((Configuration)clientConf));
                break;
            }
            case SASL: {
                if (!clientConf.hasSasl()) {
                    log.error("FATAL: SASL thrift server was requested but it is disabled in client configuration");
                    throw new RuntimeException("SASL is not enabled in configuration");
                }
                if (!UserGroupInformation.isSecurityEnabled()) {
                    log.error("FATAL: Hadoop security is not enabled");
                    throw new RuntimeException();
                }
                String kerberosPrincipal = properties.getProperty(KERBEROS_PRINCIPAL, THRIFT_SERVER_TYPE_DEFAULT);
                String kerberosKeytab = properties.getProperty(KERBEROS_KEYTAB, THRIFT_SERVER_TYPE_DEFAULT);
                if (StringUtils.isBlank((String)kerberosPrincipal) || StringUtils.isBlank((String)kerberosKeytab)) {
                    log.error("FATAL: Kerberos principal and keytab must be provided");
                    throw new RuntimeException();
                }
                UserGroupInformation.loginUserFromKeytab((String)kerberosPrincipal, (String)kerberosKeytab);
                UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
                log.info("Logged in as " + ugi.getUserName());
                String shortName = ugi.getShortUserName();
                log.info("Setting server primary to {}", (Object)shortName);
                clientConf.setProperty(ClientConfiguration.ClientProperty.KERBEROS_SERVER_PRIMARY, shortName);
                KerberosToken token = new KerberosToken();
                saslParams = new SaslServerConnectionParams(clientConf, (AuthenticationToken)token, null);
                processor = new UGIAssumingProcessor(processor);
                break;
            }
        }
        TimedProcessor timedProcessor = new TimedProcessor(metricsFactory, processor, "Proxy", "Accumulo Thrift Proxy");
        ServerAddress serverAddr = TServerUtils.startTServer((ThriftServerType)serverType, (TimedProcessor)timedProcessor, (TProtocolFactory)protocolFactory, (String)"Proxy", (String)"Accumulo Thrift Proxy", (int)numThreads, (int)simpleTimerThreadpoolSize, (long)5000L, (long)maxFrameSize, (SslConnectionParams)sslParams, saslParams, (long)0L, (HostAndPort[])new HostAndPort[]{address});
        return serverAddr;
    }

    public static class Opts
    extends Help {
        @Parameter(names={"-p"}, required=true, description="properties file name", converter=PropertiesConverter.class)
        Properties prop;
    }

    public static class PropertiesConverter
    implements IStringConverter<Properties> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Properties convert(String fileName) {
            Properties prop = new Properties();
            try (FileInputStream is = new FileInputStream(fileName);){
                prop.load(is);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return prop;
        }
    }
}

