/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.cluster.ClusterUser;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.BatchWriterConfig;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.MutationsRejectedException;
import org.apache.accumulo.core.client.NamespaceExistsException;
import org.apache.accumulo.core.client.NamespaceNotEmptyException;
import org.apache.accumulo.core.client.NamespaceNotFoundException;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.TableExistsException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.admin.NamespaceOperations;
import org.apache.accumulo.core.client.admin.NewTableConfiguration;
import org.apache.accumulo.core.client.admin.TableOperations;
import org.apache.accumulo.core.client.impl.Tables;
import org.apache.accumulo.core.client.impl.thrift.TableOperation;
import org.apache.accumulo.core.client.impl.thrift.TableOperationExceptionType;
import org.apache.accumulo.core.client.impl.thrift.ThriftTableOperationException;
import org.apache.accumulo.core.client.security.SecurityErrorCode;
import org.apache.accumulo.core.client.security.tokens.PasswordToken;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.ConstraintViolationSummary;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.Filter;
import org.apache.accumulo.core.iterators.IteratorUtil;
import org.apache.accumulo.core.iterators.SortedKeyValueIterator;
import org.apache.accumulo.core.iterators.user.VersioningIterator;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.security.NamespacePermission;
import org.apache.accumulo.core.security.SystemPermission;
import org.apache.accumulo.core.security.TablePermission;
import org.apache.accumulo.examples.simple.constraints.NumericValueConstraint;
import org.apache.accumulo.fate.util.UtilWaitThread;
import org.apache.accumulo.harness.AccumuloClusterHarness;
import org.apache.accumulo.test.categories.MiniClusterOnlyTests;
import org.apache.hadoop.io.Text;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MiniClusterOnlyTests.class})
public class NamespacesIT
extends AccumuloClusterHarness {
    private Connector c;
    private String namespace;

    @Override
    public int defaultTimeoutSeconds() {
        return 60;
    }

    @Before
    public void setupConnectorAndNamespace() throws Exception {
        Assume.assumeTrue((AccumuloClusterHarness.ClusterType.MINI == NamespacesIT.getClusterType() ? 1 : 0) != 0);
        this.c = this.getConnector();
        this.namespace = "ns_" + this.getUniqueNames(1)[0];
    }

    @After
    public void swingMj\u00f6lnir() throws Exception {
        if (null == this.c) {
            return;
        }
        for (String t : this.c.tableOperations().list()) {
            if (((String)Tables.qualify((String)t).getFirst()).equals("accumulo")) continue;
            this.c.tableOperations().delete(t);
        }
        Assert.assertEquals((long)3L, (long)this.c.tableOperations().list().size());
        for (String n : this.c.namespaceOperations().list()) {
            if (n.equals("accumulo") || n.equals("")) continue;
            this.c.namespaceOperations().delete(n);
        }
        Assert.assertEquals((long)2L, (long)this.c.namespaceOperations().list().size());
        for (String u : this.c.securityOperations().listLocalUsers()) {
            if (NamespacesIT.getAdminPrincipal().equals(u)) continue;
            this.c.securityOperations().dropLocalUser(u);
        }
        Assert.assertEquals((long)1L, (long)this.c.securityOperations().listLocalUsers().size());
    }

    @Test
    public void checkReservedNamespaces() throws Exception {
        Assert.assertEquals((Object)this.c.namespaceOperations().defaultNamespace(), (Object)"");
        Assert.assertEquals((Object)this.c.namespaceOperations().systemNamespace(), (Object)"accumulo");
    }

    @Test
    public void checkBuiltInNamespaces() throws Exception {
        Assert.assertTrue((boolean)this.c.namespaceOperations().exists(""));
        Assert.assertTrue((boolean)this.c.namespaceOperations().exists("accumulo"));
    }

    @Test
    public void createTableInDefaultNamespace() throws Exception {
        String tableName = "1";
        this.c.tableOperations().create(tableName);
        Assert.assertTrue((boolean)this.c.tableOperations().exists(tableName));
    }

    @Test(expected=AccumuloException.class)
    public void createTableInAccumuloNamespace() throws Exception {
        String tableName = "accumulo.1";
        Assert.assertFalse((boolean)this.c.tableOperations().exists(tableName));
        this.c.tableOperations().create(tableName);
    }

    @Test(expected=AccumuloSecurityException.class)
    public void deleteDefaultNamespace() throws Exception {
        this.c.namespaceOperations().delete("");
    }

    @Test(expected=AccumuloSecurityException.class)
    public void deleteAccumuloNamespace() throws Exception {
        this.c.namespaceOperations().delete("accumulo");
    }

    @Test
    public void createTableInMissingNamespace() throws Exception {
        String t = this.namespace + ".1";
        Assert.assertFalse((boolean)this.c.namespaceOperations().exists(this.namespace));
        Assert.assertFalse((boolean)this.c.tableOperations().exists(t));
        try {
            this.c.tableOperations().create(t);
            Assert.fail();
        }
        catch (AccumuloException e) {
            Assert.assertEquals((Object)NamespaceNotFoundException.class.getName(), (Object)e.getCause().getClass().getName());
            Assert.assertFalse((boolean)this.c.namespaceOperations().exists(this.namespace));
            Assert.assertFalse((boolean)this.c.tableOperations().exists(t));
        }
    }

    @Test
    public void createAndDeleteNamespace() throws Exception {
        String t1 = this.namespace + ".1";
        String t2 = this.namespace + ".2";
        Assert.assertFalse((boolean)this.c.namespaceOperations().exists(this.namespace));
        Assert.assertFalse((boolean)this.c.tableOperations().exists(t1));
        Assert.assertFalse((boolean)this.c.tableOperations().exists(t2));
        try {
            this.c.namespaceOperations().delete(this.namespace);
        }
        catch (NamespaceNotFoundException namespaceNotFoundException) {
            // empty catch block
        }
        try {
            this.c.tableOperations().delete(t1);
        }
        catch (TableNotFoundException e) {
            Assert.assertEquals((Object)NamespaceNotFoundException.class.getName(), (Object)e.getCause().getClass().getName());
        }
        this.c.namespaceOperations().create(this.namespace);
        Assert.assertTrue((boolean)this.c.namespaceOperations().exists(this.namespace));
        Assert.assertFalse((boolean)this.c.tableOperations().exists(t1));
        Assert.assertFalse((boolean)this.c.tableOperations().exists(t2));
        this.c.tableOperations().create(t1);
        Assert.assertTrue((boolean)this.c.namespaceOperations().exists(this.namespace));
        Assert.assertTrue((boolean)this.c.tableOperations().exists(t1));
        Assert.assertFalse((boolean)this.c.tableOperations().exists(t2));
        this.c.tableOperations().create(t2);
        Assert.assertTrue((boolean)this.c.namespaceOperations().exists(this.namespace));
        Assert.assertTrue((boolean)this.c.tableOperations().exists(t1));
        Assert.assertTrue((boolean)this.c.tableOperations().exists(t2));
        this.c.tableOperations().delete(t1);
        Assert.assertTrue((boolean)this.c.namespaceOperations().exists(this.namespace));
        Assert.assertFalse((boolean)this.c.tableOperations().exists(t1));
        Assert.assertTrue((boolean)this.c.tableOperations().exists(t2));
        this.c.tableOperations().delete(t2);
        Assert.assertTrue((boolean)this.c.namespaceOperations().exists(this.namespace));
        Assert.assertFalse((boolean)this.c.tableOperations().exists(t1));
        Assert.assertFalse((boolean)this.c.tableOperations().exists(t2));
        this.c.namespaceOperations().delete(this.namespace);
        Assert.assertFalse((boolean)this.c.namespaceOperations().exists(this.namespace));
        Assert.assertFalse((boolean)this.c.tableOperations().exists(t1));
        Assert.assertFalse((boolean)this.c.tableOperations().exists(t2));
    }

    @Test(expected=NamespaceNotEmptyException.class)
    public void deleteNonEmptyNamespace() throws Exception {
        String tableName1 = this.namespace + ".1";
        Assert.assertFalse((boolean)this.c.namespaceOperations().exists(this.namespace));
        Assert.assertFalse((boolean)this.c.tableOperations().exists(tableName1));
        this.c.namespaceOperations().create(this.namespace);
        this.c.tableOperations().create(tableName1);
        Assert.assertTrue((boolean)this.c.namespaceOperations().exists(this.namespace));
        Assert.assertTrue((boolean)this.c.tableOperations().exists(tableName1));
        this.c.namespaceOperations().delete(this.namespace);
    }

    @Test
    public void verifyPropertyInheritance() throws Exception {
        String t0 = "0";
        String t1 = this.namespace + ".1";
        String t2 = this.namespace + ".2";
        String k = Property.TABLE_SCAN_MAXMEM.getKey();
        String v = "42K";
        Assert.assertFalse((boolean)this.c.namespaceOperations().exists(this.namespace));
        Assert.assertFalse((boolean)this.c.tableOperations().exists(t1));
        Assert.assertFalse((boolean)this.c.tableOperations().exists(t2));
        this.c.namespaceOperations().create(this.namespace);
        this.c.tableOperations().create(t1);
        this.c.tableOperations().create(t0);
        Assert.assertTrue((boolean)this.c.namespaceOperations().exists(this.namespace));
        Assert.assertTrue((boolean)this.c.tableOperations().exists(t1));
        Assert.assertTrue((boolean)this.c.tableOperations().exists(t0));
        Assert.assertFalse((boolean)this.checkNamespaceHasProp(this.namespace, k, v));
        Assert.assertFalse((boolean)this.checkTableHasProp(t1, k, v));
        Assert.assertFalse((boolean)this.checkNamespaceHasProp("", k, v));
        Assert.assertFalse((boolean)this.checkTableHasProp(t0, k, v));
        this.c.namespaceOperations().setProperty(this.namespace, k, v);
        Assert.assertTrue((boolean)this.checkNamespaceHasProp(this.namespace, k, v));
        Assert.assertTrue((boolean)this.checkTableHasProp(t1, k, v));
        Assert.assertFalse((boolean)this.checkNamespaceHasProp("", k, v));
        Assert.assertFalse((boolean)this.checkTableHasProp(t0, k, v));
        Assert.assertFalse((boolean)this.c.tableOperations().exists(t2));
        this.c.tableOperations().create(t2);
        Assert.assertTrue((boolean)this.c.tableOperations().exists(t2));
        Assert.assertTrue((boolean)this.checkNamespaceHasProp(this.namespace, k, v));
        Assert.assertTrue((boolean)this.checkTableHasProp(t1, k, v));
        Assert.assertTrue((boolean)this.checkTableHasProp(t2, k, v));
        Assert.assertFalse((boolean)this.checkNamespaceHasProp("", k, v));
        Assert.assertFalse((boolean)this.checkTableHasProp(t0, k, v));
        this.c.namespaceOperations().removeProperty(this.namespace, k);
        Assert.assertFalse((boolean)this.checkNamespaceHasProp(this.namespace, k, v));
        Assert.assertFalse((boolean)this.checkTableHasProp(t1, k, v));
        Assert.assertFalse((boolean)this.checkTableHasProp(t2, k, v));
        Assert.assertFalse((boolean)this.checkNamespaceHasProp("", k, v));
        Assert.assertFalse((boolean)this.checkTableHasProp(t0, k, v));
        this.c.namespaceOperations().setProperty("", k, v);
        Assert.assertFalse((boolean)this.checkNamespaceHasProp(this.namespace, k, v));
        Assert.assertFalse((boolean)this.checkTableHasProp(t1, k, v));
        Assert.assertFalse((boolean)this.checkTableHasProp(t2, k, v));
        Assert.assertTrue((boolean)this.checkNamespaceHasProp("", k, v));
        Assert.assertTrue((boolean)this.checkTableHasProp(t0, k, v));
        String k2 = Property.TABLE_FILE_MAX.getKey();
        String v2 = "42";
        String table_v2 = "13";
        this.c.namespaceOperations().setProperty(this.namespace, k2, v2);
        this.c.tableOperations().setProperty(t2, k2, table_v2);
        Assert.assertTrue((boolean)this.checkNamespaceHasProp(this.namespace, k2, v2));
        Assert.assertTrue((boolean)this.checkTableHasProp(t1, k2, v2));
        Assert.assertTrue((boolean)this.checkTableHasProp(t2, k2, table_v2));
        this.c.tableOperations().delete(t1);
        this.c.tableOperations().delete(t2);
        this.c.tableOperations().delete(t0);
        this.c.namespaceOperations().delete(this.namespace);
    }

    @Test
    public void verifyIteratorInheritance() throws Exception {
        String t1 = this.namespace + ".1";
        this.c.namespaceOperations().create(this.namespace);
        this.c.tableOperations().create(t1);
        String iterName = this.namespace + "_iter";
        BatchWriter bw = this.c.createBatchWriter(t1, new BatchWriterConfig());
        Mutation m = new Mutation((CharSequence)"r");
        m.put((CharSequence)"a", (CharSequence)"b", new Value("abcde".getBytes()));
        bw.addMutation(m);
        bw.flush();
        bw.close();
        IteratorSetting setting = new IteratorSetting(250, iterName, SimpleFilter.class.getName());
        Scanner s = this.c.createScanner(t1, Authorizations.EMPTY);
        Assert.assertTrue((boolean)s.iterator().hasNext());
        Assert.assertFalse((boolean)this.c.namespaceOperations().listIterators(this.namespace).containsKey(iterName));
        Assert.assertFalse((boolean)this.c.tableOperations().listIterators(t1).containsKey(iterName));
        this.c.namespaceOperations().checkIteratorConflicts(this.namespace, setting, EnumSet.allOf(IteratorUtil.IteratorScope.class));
        this.c.namespaceOperations().attachIterator(this.namespace, setting);
        UtilWaitThread.sleepUninterruptibly((long)2L, (TimeUnit)TimeUnit.SECONDS);
        try {
            this.c.namespaceOperations().checkIteratorConflicts(this.namespace, setting, EnumSet.allOf(IteratorUtil.IteratorScope.class));
            Assert.fail();
        }
        catch (AccumuloException e) {
            Assert.assertEquals((Object)IllegalArgumentException.class.getName(), (Object)e.getCause().getClass().getName());
        }
        IteratorSetting setting2 = this.c.namespaceOperations().getIteratorSetting(this.namespace, setting.getName(), IteratorUtil.IteratorScope.scan);
        Assert.assertEquals((Object)setting, (Object)setting2);
        Assert.assertTrue((boolean)this.c.namespaceOperations().listIterators(this.namespace).containsKey(iterName));
        Assert.assertTrue((boolean)this.c.tableOperations().listIterators(t1).containsKey(iterName));
        s = this.c.createScanner(t1, Authorizations.EMPTY);
        Assert.assertFalse((boolean)s.iterator().hasNext());
        this.c.namespaceOperations().removeIterator(this.namespace, setting.getName(), EnumSet.allOf(IteratorUtil.IteratorScope.class));
        UtilWaitThread.sleepUninterruptibly((long)2L, (TimeUnit)TimeUnit.SECONDS);
        Assert.assertFalse((boolean)this.c.namespaceOperations().listIterators(this.namespace).containsKey(iterName));
        Assert.assertFalse((boolean)this.c.tableOperations().listIterators(t1).containsKey(iterName));
        s = this.c.createScanner(t1, Authorizations.EMPTY);
        Assert.assertTrue((boolean)s.iterator().hasNext());
    }

    @Test
    public void cloneTable() throws Exception {
        String namespace2 = this.namespace + "_clone";
        String t1 = this.namespace + ".1";
        String t2 = this.namespace + ".2";
        String t3 = namespace2 + ".2";
        String k1 = Property.TABLE_FILE_MAX.getKey();
        String k2 = Property.TABLE_FILE_REPLICATION.getKey();
        String k1v1 = "55";
        String k1v2 = "66";
        String k2v1 = "5";
        String k2v2 = "6";
        this.c.namespaceOperations().create(this.namespace);
        this.c.tableOperations().create(t1);
        Assert.assertTrue((boolean)this.c.tableOperations().exists(t1));
        Assert.assertFalse((boolean)this.c.namespaceOperations().exists(namespace2));
        Assert.assertFalse((boolean)this.c.tableOperations().exists(t2));
        Assert.assertFalse((boolean)this.c.tableOperations().exists(t3));
        try {
            this.c.tableOperations().clone(t1, t3, false, null, null);
            Assert.fail();
        }
        catch (AccumuloException e) {
            Assert.assertEquals((Object)NamespaceNotFoundException.class.getName(), (Object)e.getCause().getClass().getName());
        }
        this.c.namespaceOperations().create(namespace2);
        this.c.tableOperations().create(t2);
        this.c.tableOperations().create(t3);
        for (String t : Arrays.asList(t2, t3)) {
            try {
                this.c.tableOperations().clone(t1, t, false, null, null);
                Assert.fail();
            }
            catch (TableExistsException e) {
                this.c.tableOperations().delete(t);
            }
        }
        Assert.assertTrue((boolean)this.c.tableOperations().exists(t1));
        Assert.assertTrue((boolean)this.c.namespaceOperations().exists(namespace2));
        Assert.assertFalse((boolean)this.c.tableOperations().exists(t2));
        Assert.assertFalse((boolean)this.c.tableOperations().exists(t3));
        Assert.assertFalse((boolean)this.checkNamespaceHasProp(this.namespace, k1, k1v1));
        Assert.assertFalse((boolean)this.checkNamespaceHasProp(namespace2, k1, k1v2));
        Assert.assertFalse((boolean)this.checkTableHasProp(t1, k1, k1v1));
        Assert.assertFalse((boolean)this.checkTableHasProp(t1, k1, k1v2));
        Assert.assertFalse((boolean)this.checkNamespaceHasProp(this.namespace, k2, k2v1));
        Assert.assertFalse((boolean)this.checkNamespaceHasProp(namespace2, k2, k2v1));
        Assert.assertFalse((boolean)this.checkTableHasProp(t1, k2, k2v1));
        Assert.assertFalse((boolean)this.checkTableHasProp(t1, k2, k2v2));
        this.c.namespaceOperations().setProperty(this.namespace, k1, k1v1);
        this.c.namespaceOperations().setProperty(namespace2, k1, k1v2);
        this.c.namespaceOperations().setProperty(this.namespace, k2, k2v1);
        this.c.namespaceOperations().setProperty(namespace2, k2, k2v1);
        this.c.tableOperations().setProperty(t1, k2, k2v2);
        Assert.assertTrue((boolean)this.checkNamespaceHasProp(this.namespace, k1, k1v1));
        Assert.assertTrue((boolean)this.checkNamespaceHasProp(namespace2, k1, k1v2));
        Assert.assertTrue((boolean)this.checkTableHasProp(t1, k1, k1v1));
        Assert.assertFalse((boolean)this.checkTableHasProp(t1, k1, k1v2));
        Assert.assertTrue((boolean)this.checkNamespaceHasProp(this.namespace, k2, k2v1));
        Assert.assertTrue((boolean)this.checkNamespaceHasProp(namespace2, k2, k2v1));
        Assert.assertFalse((boolean)this.checkTableHasProp(t1, k2, k2v1));
        Assert.assertTrue((boolean)this.checkTableHasProp(t1, k2, k2v2));
        for (String t : Arrays.asList(t2, t3)) {
            this.c.tableOperations().clone(t1, t, false, null, null);
        }
        Assert.assertTrue((boolean)this.c.namespaceOperations().exists(namespace2));
        Assert.assertTrue((boolean)this.c.tableOperations().exists(t1));
        Assert.assertTrue((boolean)this.c.tableOperations().exists(t2));
        Assert.assertTrue((boolean)this.c.tableOperations().exists(t3));
        Assert.assertTrue((boolean)this.checkTableHasProp(t1, k1, k1v1));
        Assert.assertTrue((boolean)this.checkTableHasProp(t2, k1, k1v1));
        Assert.assertTrue((boolean)this.checkTableHasProp(t3, k1, k1v2));
        Assert.assertTrue((boolean)this.checkTableHasProp(t1, k2, k2v2));
        Assert.assertTrue((boolean)this.checkTableHasProp(t2, k2, k2v2));
        Assert.assertTrue((boolean)this.checkTableHasProp(t3, k2, k2v2));
    }

    @Test
    public void renameNamespaceWithTable() throws Exception {
        String namespace2 = this.namespace + "_renamed";
        String t1 = this.namespace + ".t";
        String t2 = namespace2 + ".t";
        this.c.namespaceOperations().create(this.namespace);
        this.c.tableOperations().create(t1);
        Assert.assertTrue((boolean)this.c.namespaceOperations().exists(this.namespace));
        Assert.assertTrue((boolean)this.c.tableOperations().exists(t1));
        Assert.assertFalse((boolean)this.c.namespaceOperations().exists(namespace2));
        Assert.assertFalse((boolean)this.c.tableOperations().exists(t2));
        String namespaceId = (String)this.c.namespaceOperations().namespaceIdMap().get(this.namespace);
        String tableId = (String)this.c.tableOperations().tableIdMap().get(t1);
        this.c.namespaceOperations().rename(this.namespace, namespace2);
        Assert.assertFalse((boolean)this.c.namespaceOperations().exists(this.namespace));
        Assert.assertFalse((boolean)this.c.tableOperations().exists(t1));
        Assert.assertTrue((boolean)this.c.namespaceOperations().exists(namespace2));
        Assert.assertTrue((boolean)this.c.tableOperations().exists(t2));
        String namespaceId2 = (String)this.c.namespaceOperations().namespaceIdMap().get(namespace2);
        String tableId2 = (String)this.c.tableOperations().tableIdMap().get(t2);
        Assert.assertEquals((Object)namespaceId, (Object)namespaceId2);
        Assert.assertEquals((Object)tableId, (Object)tableId2);
    }

    @Test
    public void verifyConstraintInheritance() throws Exception {
        BatchWriter bw;
        int i;
        String t1 = this.namespace + ".1";
        this.c.namespaceOperations().create(this.namespace);
        this.c.tableOperations().create(t1, new NewTableConfiguration().withoutDefaultIterators());
        String constraintClassName = NumericValueConstraint.class.getName();
        Assert.assertFalse((boolean)this.c.namespaceOperations().listConstraints(this.namespace).containsKey(constraintClassName));
        Assert.assertFalse((boolean)this.c.tableOperations().listConstraints(t1).containsKey(constraintClassName));
        this.c.namespaceOperations().addConstraint(this.namespace, constraintClassName);
        boolean passed = false;
        for (int i2 = 0; i2 < 5; ++i2) {
            if (!this.c.namespaceOperations().listConstraints(this.namespace).containsKey(constraintClassName)) {
                Thread.sleep(500L);
                continue;
            }
            if (!this.c.tableOperations().listConstraints(t1).containsKey(constraintClassName)) {
                Thread.sleep(500L);
                continue;
            }
            passed = true;
            break;
        }
        Assert.assertTrue((String)"Failed to observe newly-added constraint", (boolean)passed);
        passed = false;
        Integer namespaceNum = null;
        for (int i3 = 0; i3 < 5; ++i3) {
            namespaceNum = (Integer)this.c.namespaceOperations().listConstraints(this.namespace).get(constraintClassName);
            if (null == namespaceNum) {
                Thread.sleep(500L);
                continue;
            }
            Integer tableNum = (Integer)this.c.tableOperations().listConstraints(t1).get(constraintClassName);
            if (null == tableNum) {
                Thread.sleep(500L);
                continue;
            }
            Assert.assertEquals((Object)namespaceNum, (Object)tableNum);
            passed = true;
        }
        Assert.assertTrue((String)"Failed to observe constraint in both table and namespace", (boolean)passed);
        Mutation m1 = new Mutation((CharSequence)"r1");
        Mutation m2 = new Mutation((CharSequence)"r2");
        Mutation m3 = new Mutation((CharSequence)"r3");
        m1.put((CharSequence)"a", (CharSequence)"b", new Value("abcde".getBytes(StandardCharsets.UTF_8)));
        m2.put((CharSequence)"e", (CharSequence)"f", new Value("123".getBytes(StandardCharsets.UTF_8)));
        m3.put((CharSequence)"c", (CharSequence)"d", new Value("zyxwv".getBytes(StandardCharsets.UTF_8)));
        passed = false;
        for (i = 0; i < 5; ++i) {
            bw = this.c.createBatchWriter(t1, new BatchWriterConfig());
            bw.addMutations(Arrays.asList(m1, m2, m3));
            try {
                bw.close();
                Thread.sleep(500L);
                continue;
            }
            catch (MutationsRejectedException e) {
                passed = true;
                Assert.assertEquals((long)1L, (long)e.getConstraintViolationSummaries().size());
                Assert.assertEquals((long)2L, (long)((ConstraintViolationSummary)e.getConstraintViolationSummaries().get(0)).getNumberOfViolatingMutations());
                break;
            }
        }
        Assert.assertTrue((String)"Failed to see mutations rejected after constraint was added", (boolean)passed);
        Assert.assertNotNull((String)"Namespace constraint ID should not be null", (Object)namespaceNum);
        this.c.namespaceOperations().removeConstraint(this.namespace, namespaceNum.intValue());
        passed = false;
        for (i = 0; i < 5; ++i) {
            if (this.c.namespaceOperations().listConstraints(this.namespace).containsKey(constraintClassName)) {
                Thread.sleep(500L);
                continue;
            }
            if (this.c.tableOperations().listConstraints(t1).containsKey(constraintClassName)) {
                Thread.sleep(500L);
                continue;
            }
            passed = true;
        }
        Assert.assertTrue((String)"Failed to verify that constraint was removed from namespace and table", (boolean)passed);
        passed = false;
        for (i = 0; i < 5; ++i) {
            bw = this.c.createBatchWriter(t1, new BatchWriterConfig());
            try {
                bw.addMutations(Arrays.asList(m1, m2, m3));
                bw.close();
            }
            catch (MutationsRejectedException e) {
                Thread.sleep(500L);
                continue;
            }
            passed = true;
        }
        Assert.assertTrue((String)"Failed to add mutations that should be allowed", (boolean)passed);
    }

    @Test
    public void renameTable() throws Exception {
        String namespace2 = this.namespace + "_renamed";
        String t1 = this.namespace + ".1";
        String t2 = namespace2 + ".2";
        String t3 = this.namespace + ".3";
        String t4 = this.namespace + ".4";
        String t5 = "5";
        this.c.namespaceOperations().create(this.namespace);
        this.c.namespaceOperations().create(namespace2);
        Assert.assertTrue((boolean)this.c.namespaceOperations().exists(this.namespace));
        Assert.assertTrue((boolean)this.c.namespaceOperations().exists(namespace2));
        Assert.assertFalse((boolean)this.c.tableOperations().exists(t1));
        Assert.assertFalse((boolean)this.c.tableOperations().exists(t2));
        Assert.assertFalse((boolean)this.c.tableOperations().exists(t3));
        Assert.assertFalse((boolean)this.c.tableOperations().exists(t4));
        Assert.assertFalse((boolean)this.c.tableOperations().exists(t5));
        this.c.tableOperations().create(t1);
        try {
            this.c.tableOperations().rename(t1, t2);
            Assert.fail();
        }
        catch (AccumuloException e) {
            Assert.assertEquals((Object)ThriftTableOperationException.class.getName(), (Object)e.getCause().getClass().getName());
            Assert.assertEquals((Object)TableOperation.RENAME, (Object)((ThriftTableOperationException)e.getCause()).getOp());
            Assert.assertEquals((Object)TableOperationExceptionType.INVALID_NAME, (Object)((ThriftTableOperationException)e.getCause()).getType());
        }
        try {
            this.c.tableOperations().rename(t1, t5);
            Assert.fail();
        }
        catch (AccumuloException e) {
            Assert.assertEquals((Object)ThriftTableOperationException.class.getName(), (Object)e.getCause().getClass().getName());
            Assert.assertEquals((Object)TableOperation.RENAME, (Object)((ThriftTableOperationException)e.getCause()).getOp());
            Assert.assertEquals((Object)TableOperationExceptionType.INVALID_NAME, (Object)((ThriftTableOperationException)e.getCause()).getType());
        }
        Assert.assertTrue((boolean)this.c.tableOperations().exists(t1));
        Assert.assertFalse((boolean)this.c.tableOperations().exists(t2));
        Assert.assertFalse((boolean)this.c.tableOperations().exists(t3));
        Assert.assertFalse((boolean)this.c.tableOperations().exists(t4));
        Assert.assertFalse((boolean)this.c.tableOperations().exists(t5));
        this.c.tableOperations().rename(t1, t3);
        Assert.assertFalse((boolean)this.c.tableOperations().exists(t1));
        Assert.assertFalse((boolean)this.c.tableOperations().exists(t2));
        Assert.assertTrue((boolean)this.c.tableOperations().exists(t3));
        Assert.assertFalse((boolean)this.c.tableOperations().exists(t4));
        Assert.assertFalse((boolean)this.c.tableOperations().exists(t5));
    }

    private void loginAs(ClusterUser user) throws IOException {
        user.getToken();
    }

    @Test
    public void testPermissions() throws Exception {
        ClusterUser user1 = this.getUser(0);
        ClusterUser user2 = this.getUser(1);
        ClusterUser root = this.getAdminUser();
        String u1 = user1.getPrincipal();
        String u2 = user2.getPrincipal();
        PasswordToken pass = null != user1.getPassword() ? new PasswordToken((CharSequence)user1.getPassword()) : null;
        String n1 = this.namespace;
        String t1 = n1 + ".1";
        String t2 = n1 + ".2";
        String t3 = n1 + ".3";
        String n2 = this.namespace + "_2";
        this.loginAs(root);
        this.c.namespaceOperations().create(n1);
        this.c.tableOperations().create(t1);
        this.c.securityOperations().createLocalUser(u1, pass);
        this.loginAs(user1);
        Connector user1Con = this.c.getInstance().getConnector(u1, user1.getToken());
        try {
            user1Con.tableOperations().create(t2);
            Assert.fail();
        }
        catch (AccumuloSecurityException e) {
            this.expectPermissionDenied(e);
        }
        this.loginAs(root);
        this.c.securityOperations().grantNamespacePermission(u1, n1, NamespacePermission.CREATE_TABLE);
        this.loginAs(user1);
        user1Con.tableOperations().create(t2);
        this.loginAs(root);
        Assert.assertTrue((boolean)this.c.tableOperations().list().contains(t2));
        this.c.securityOperations().revokeNamespacePermission(u1, n1, NamespacePermission.CREATE_TABLE);
        this.loginAs(user1);
        try {
            user1Con.tableOperations().delete(t1);
            Assert.fail();
        }
        catch (AccumuloSecurityException e) {
            this.expectPermissionDenied(e);
        }
        this.loginAs(root);
        this.c.securityOperations().grantNamespacePermission(u1, n1, NamespacePermission.DROP_TABLE);
        this.loginAs(user1);
        user1Con.tableOperations().delete(t1);
        this.loginAs(root);
        Assert.assertTrue((!this.c.tableOperations().list().contains(t1) ? 1 : 0) != 0);
        this.c.securityOperations().revokeNamespacePermission(u1, n1, NamespacePermission.DROP_TABLE);
        this.c.tableOperations().create(t3);
        BatchWriter bw = this.c.createBatchWriter(t3, null);
        Mutation m = new Mutation((CharSequence)"row");
        m.put((CharSequence)"cf", (CharSequence)"cq", (CharSequence)"value");
        bw.addMutation(m);
        bw.close();
        this.loginAs(user1);
        Iterator i = user1Con.createScanner(t3, new Authorizations()).iterator();
        try {
            i.next();
            Assert.fail();
        }
        catch (RuntimeException e) {
            Assert.assertEquals((Object)AccumuloSecurityException.class.getName(), (Object)e.getCause().getClass().getName());
            this.expectPermissionDenied((AccumuloSecurityException)e.getCause());
        }
        this.loginAs(user1);
        m = new Mutation((CharSequence)u1);
        m.put((CharSequence)"cf", (CharSequence)"cq", (CharSequence)"turtles");
        bw = user1Con.createBatchWriter(t3, null);
        try {
            bw.addMutation(m);
            bw.close();
            Assert.fail();
        }
        catch (MutationsRejectedException e) {
            Assert.assertEquals((long)1L, (long)e.getSecurityErrorCodes().size());
            Assert.assertEquals((long)1L, (long)((Set)e.getSecurityErrorCodes().entrySet().iterator().next().getValue()).size());
            switch ((SecurityErrorCode)((Set)e.getSecurityErrorCodes().entrySet().iterator().next().getValue()).iterator().next()) {
                case PERMISSION_DENIED: {
                    break;
                }
                default: {
                    Assert.fail();
                }
            }
        }
        this.loginAs(root);
        this.c.securityOperations().grantNamespacePermission(u1, n1, NamespacePermission.READ);
        this.loginAs(user1);
        i = user1Con.createScanner(t3, new Authorizations()).iterator();
        Assert.assertTrue((boolean)i.hasNext());
        this.loginAs(root);
        this.c.securityOperations().revokeNamespacePermission(u1, n1, NamespacePermission.READ);
        this.c.securityOperations().grantNamespacePermission(u1, n1, NamespacePermission.WRITE);
        this.loginAs(user1);
        m = new Mutation((CharSequence)u1);
        m.put((CharSequence)"cf", (CharSequence)"cq", (CharSequence)"turtles");
        bw = user1Con.createBatchWriter(t3, null);
        bw.addMutation(m);
        bw.close();
        this.loginAs(root);
        this.c.securityOperations().revokeNamespacePermission(u1, n1, NamespacePermission.WRITE);
        this.loginAs(user1);
        try {
            user1Con.tableOperations().setProperty(t3, Property.TABLE_FILE_MAX.getKey(), "42");
            Assert.fail();
        }
        catch (AccumuloSecurityException e) {
            this.expectPermissionDenied(e);
        }
        this.loginAs(root);
        this.c.securityOperations().grantNamespacePermission(u1, n1, NamespacePermission.ALTER_TABLE);
        this.loginAs(user1);
        user1Con.tableOperations().setProperty(t3, Property.TABLE_FILE_MAX.getKey(), "42");
        user1Con.tableOperations().removeProperty(t3, Property.TABLE_FILE_MAX.getKey());
        this.loginAs(root);
        this.c.securityOperations().revokeNamespacePermission(u1, n1, NamespacePermission.ALTER_TABLE);
        this.loginAs(user1);
        try {
            user1Con.namespaceOperations().setProperty(n1, Property.TABLE_FILE_MAX.getKey(), "55");
            Assert.fail();
        }
        catch (AccumuloSecurityException e) {
            this.expectPermissionDenied(e);
        }
        this.loginAs(root);
        this.c.securityOperations().grantNamespacePermission(u1, n1, NamespacePermission.ALTER_NAMESPACE);
        this.loginAs(user1);
        user1Con.namespaceOperations().setProperty(n1, Property.TABLE_FILE_MAX.getKey(), "42");
        user1Con.namespaceOperations().removeProperty(n1, Property.TABLE_FILE_MAX.getKey());
        this.loginAs(root);
        this.c.securityOperations().revokeNamespacePermission(u1, n1, NamespacePermission.ALTER_NAMESPACE);
        this.loginAs(root);
        this.c.securityOperations().createLocalUser(u2, root.getPassword() == null ? null : new PasswordToken((CharSequence)user2.getPassword()));
        this.loginAs(user1);
        try {
            user1Con.securityOperations().grantNamespacePermission(u2, n1, NamespacePermission.ALTER_NAMESPACE);
            Assert.fail();
        }
        catch (AccumuloSecurityException e) {
            this.expectPermissionDenied(e);
        }
        this.loginAs(root);
        this.c.securityOperations().grantNamespacePermission(u1, n1, NamespacePermission.GRANT);
        this.loginAs(user1);
        user1Con.securityOperations().grantNamespacePermission(u2, n1, NamespacePermission.ALTER_NAMESPACE);
        user1Con.securityOperations().revokeNamespacePermission(u2, n1, NamespacePermission.ALTER_NAMESPACE);
        this.loginAs(root);
        this.c.securityOperations().revokeNamespacePermission(u1, n1, NamespacePermission.GRANT);
        this.loginAs(user1);
        try {
            user1Con.namespaceOperations().create(n2);
            Assert.fail();
        }
        catch (AccumuloSecurityException e) {
            this.expectPermissionDenied(e);
        }
        this.loginAs(root);
        this.c.securityOperations().grantSystemPermission(u1, SystemPermission.CREATE_NAMESPACE);
        this.loginAs(user1);
        user1Con.namespaceOperations().create(n2);
        this.loginAs(root);
        this.c.securityOperations().revokeSystemPermission(u1, SystemPermission.CREATE_NAMESPACE);
        this.c.securityOperations().revokeNamespacePermission(u1, n2, NamespacePermission.DROP_NAMESPACE);
        this.loginAs(user1);
        try {
            user1Con.namespaceOperations().delete(n2);
            Assert.fail();
        }
        catch (AccumuloSecurityException e) {
            this.expectPermissionDenied(e);
        }
        this.loginAs(root);
        this.c.securityOperations().grantSystemPermission(u1, SystemPermission.DROP_NAMESPACE);
        this.loginAs(user1);
        user1Con.namespaceOperations().delete(n2);
        this.loginAs(root);
        this.c.securityOperations().revokeSystemPermission(u1, SystemPermission.DROP_NAMESPACE);
        this.loginAs(user1);
        try {
            user1Con.namespaceOperations().setProperty(n1, Property.TABLE_FILE_MAX.getKey(), "33");
            Assert.fail();
        }
        catch (AccumuloSecurityException e) {
            this.expectPermissionDenied(e);
        }
        this.loginAs(root);
        this.c.securityOperations().grantSystemPermission(u1, SystemPermission.ALTER_NAMESPACE);
        this.loginAs(user1);
        user1Con.namespaceOperations().setProperty(n1, Property.TABLE_FILE_MAX.getKey(), "33");
        user1Con.namespaceOperations().removeProperty(n1, Property.TABLE_FILE_MAX.getKey());
        this.loginAs(root);
        this.c.securityOperations().revokeSystemPermission(u1, SystemPermission.ALTER_NAMESPACE);
    }

    @Test
    public void verifySystemPropertyInheritance() throws Exception {
        String t1 = "1";
        String t2 = this.namespace + "." + t1;
        this.c.tableOperations().create(t1);
        this.c.namespaceOperations().create(this.namespace);
        this.c.tableOperations().create(t2);
        this._verifySystemPropertyInheritance(t1, t2, Property.TABLE_ITERATOR_PREFIX.getKey() + "scan.sum", "20," + SimpleFilter.class.getName(), false);
        this._verifySystemPropertyInheritance(t1, t2, Property.TABLE_CONSTRAINT_PREFIX.getKey() + "42", NumericValueConstraint.class.getName(), false);
        this._verifySystemPropertyInheritance(t1, t2, Property.TABLE_LOCALITY_GROUP_PREFIX.getKey() + "dummy", "dummy", true);
    }

    private void _verifySystemPropertyInheritance(String defaultNamespaceTable, String namespaceTable, String k, String v, boolean systemNamespaceShouldInherit) throws Exception {
        Assert.assertFalse((boolean)this.c.instanceOperations().getSystemConfiguration().containsValue(v));
        Assert.assertFalse((boolean)this.checkNamespaceHasProp("accumulo", k, v));
        Assert.assertFalse((boolean)this.checkTableHasProp("accumulo.root", k, v));
        Assert.assertFalse((boolean)this.checkTableHasProp("accumulo.metadata", k, v));
        Assert.assertFalse((boolean)this.checkNamespaceHasProp("", k, v));
        Assert.assertFalse((boolean)this.checkTableHasProp(defaultNamespaceTable, k, v));
        Assert.assertFalse((boolean)this.checkNamespaceHasProp(this.namespace, k, v));
        Assert.assertFalse((boolean)this.checkTableHasProp(namespaceTable, k, v));
        this.c.instanceOperations().setProperty(k, v);
        UtilWaitThread.sleepUninterruptibly((long)250L, (TimeUnit)TimeUnit.MILLISECONDS);
        Assert.assertTrue((boolean)this.c.instanceOperations().getSystemConfiguration().containsValue(v));
        Assert.assertEquals((Object)systemNamespaceShouldInherit, (Object)this.checkNamespaceHasProp("accumulo", k, v));
        Assert.assertEquals((Object)systemNamespaceShouldInherit, (Object)this.checkTableHasProp("accumulo.root", k, v));
        Assert.assertEquals((Object)systemNamespaceShouldInherit, (Object)this.checkTableHasProp("accumulo.metadata", k, v));
        Assert.assertTrue((boolean)this.checkNamespaceHasProp("", k, v));
        Assert.assertTrue((boolean)this.checkTableHasProp(defaultNamespaceTable, k, v));
        Assert.assertTrue((boolean)this.checkNamespaceHasProp(this.namespace, k, v));
        Assert.assertTrue((boolean)this.checkTableHasProp(namespaceTable, k, v));
        this.c.instanceOperations().removeProperty(k);
        UtilWaitThread.sleepUninterruptibly((long)250L, (TimeUnit)TimeUnit.MILLISECONDS);
        Assert.assertFalse((boolean)this.c.instanceOperations().getSystemConfiguration().containsValue(v));
        Assert.assertFalse((boolean)this.checkNamespaceHasProp("accumulo", k, v));
        Assert.assertFalse((boolean)this.checkTableHasProp("accumulo.root", k, v));
        Assert.assertFalse((boolean)this.checkTableHasProp("accumulo.metadata", k, v));
        Assert.assertFalse((boolean)this.checkNamespaceHasProp("", k, v));
        Assert.assertFalse((boolean)this.checkTableHasProp(defaultNamespaceTable, k, v));
        Assert.assertFalse((boolean)this.checkNamespaceHasProp(this.namespace, k, v));
        Assert.assertFalse((boolean)this.checkTableHasProp(namespaceTable, k, v));
    }

    @Test
    public void listNamespaces() throws Exception {
        SortedSet namespaces = this.c.namespaceOperations().list();
        Map map = this.c.namespaceOperations().namespaceIdMap();
        Assert.assertEquals((long)2L, (long)namespaces.size());
        Assert.assertEquals((long)2L, (long)map.size());
        Assert.assertTrue((boolean)namespaces.contains("accumulo"));
        Assert.assertTrue((boolean)namespaces.contains(""));
        Assert.assertFalse((boolean)namespaces.contains(this.namespace));
        Assert.assertEquals((Object)"+accumulo", map.get("accumulo"));
        Assert.assertEquals((Object)"+default", map.get(""));
        Assert.assertNull(map.get(this.namespace));
        this.c.namespaceOperations().create(this.namespace);
        namespaces = this.c.namespaceOperations().list();
        map = this.c.namespaceOperations().namespaceIdMap();
        Assert.assertEquals((long)3L, (long)namespaces.size());
        Assert.assertEquals((long)3L, (long)map.size());
        Assert.assertTrue((boolean)namespaces.contains("accumulo"));
        Assert.assertTrue((boolean)namespaces.contains(""));
        Assert.assertTrue((boolean)namespaces.contains(this.namespace));
        Assert.assertEquals((Object)"+accumulo", map.get("accumulo"));
        Assert.assertEquals((Object)"+default", map.get(""));
        Assert.assertNotNull(map.get(this.namespace));
        this.c.namespaceOperations().delete(this.namespace);
        namespaces = this.c.namespaceOperations().list();
        map = this.c.namespaceOperations().namespaceIdMap();
        Assert.assertEquals((long)2L, (long)namespaces.size());
        Assert.assertEquals((long)2L, (long)map.size());
        Assert.assertTrue((boolean)namespaces.contains("accumulo"));
        Assert.assertTrue((boolean)namespaces.contains(""));
        Assert.assertFalse((boolean)namespaces.contains(this.namespace));
        Assert.assertEquals((Object)"+accumulo", map.get("accumulo"));
        Assert.assertEquals((Object)"+default", map.get(""));
        Assert.assertNull(map.get(this.namespace));
    }

    @Test
    public void loadClass() throws Exception {
        Assert.assertTrue((boolean)this.c.namespaceOperations().testClassLoad("", VersioningIterator.class.getName(), SortedKeyValueIterator.class.getName()));
        Assert.assertFalse((boolean)this.c.namespaceOperations().testClassLoad("", "dummy", SortedKeyValueIterator.class.getName()));
        try {
            this.c.namespaceOperations().testClassLoad(this.namespace, "dummy", "dummy");
            Assert.fail();
        }
        catch (NamespaceNotFoundException namespaceNotFoundException) {
            // empty catch block
        }
    }

    @Test
    public void testModifyingPermissions() throws Exception {
        block26: {
            block25: {
                block24: {
                    block23: {
                        String tableName;
                        block22: {
                            block21: {
                                block20: {
                                    block19: {
                                        block18: {
                                            tableName = this.namespace + ".modify";
                                            this.c.namespaceOperations().create(this.namespace);
                                            this.c.tableOperations().create(tableName);
                                            Assert.assertTrue((boolean)this.c.securityOperations().hasTablePermission(this.c.whoami(), tableName, TablePermission.READ));
                                            this.c.securityOperations().revokeTablePermission(this.c.whoami(), tableName, TablePermission.READ);
                                            Assert.assertFalse((boolean)this.c.securityOperations().hasTablePermission(this.c.whoami(), tableName, TablePermission.READ));
                                            this.c.securityOperations().grantTablePermission(this.c.whoami(), tableName, TablePermission.READ);
                                            Assert.assertTrue((boolean)this.c.securityOperations().hasTablePermission(this.c.whoami(), tableName, TablePermission.READ));
                                            this.c.tableOperations().delete(tableName);
                                            try {
                                                this.c.securityOperations().hasTablePermission(this.c.whoami(), tableName, TablePermission.READ);
                                                Assert.fail();
                                            }
                                            catch (Exception e) {
                                                if (e instanceof AccumuloSecurityException && ((AccumuloSecurityException)((Object)e)).getSecurityErrorCode().equals((Object)SecurityErrorCode.TABLE_DOESNT_EXIST)) break block18;
                                                throw new Exception("Has permission resulted in " + e.getClass().getName(), e);
                                            }
                                        }
                                        try {
                                            this.c.securityOperations().grantTablePermission(this.c.whoami(), tableName, TablePermission.READ);
                                            Assert.fail();
                                        }
                                        catch (Exception e) {
                                            if (e instanceof AccumuloSecurityException && ((AccumuloSecurityException)((Object)e)).getSecurityErrorCode().equals((Object)SecurityErrorCode.TABLE_DOESNT_EXIST)) break block19;
                                            throw new Exception("Has permission resulted in " + e.getClass().getName(), e);
                                        }
                                    }
                                    try {
                                        this.c.securityOperations().revokeTablePermission(this.c.whoami(), tableName, TablePermission.READ);
                                        Assert.fail();
                                    }
                                    catch (Exception e) {
                                        if (e instanceof AccumuloSecurityException && ((AccumuloSecurityException)((Object)e)).getSecurityErrorCode().equals((Object)SecurityErrorCode.TABLE_DOESNT_EXIST)) break block20;
                                        throw new Exception("Has permission resulted in " + e.getClass().getName(), e);
                                    }
                                }
                                Assert.assertTrue((boolean)this.c.securityOperations().hasNamespacePermission(this.c.whoami(), this.namespace, NamespacePermission.READ));
                                this.c.securityOperations().revokeNamespacePermission(this.c.whoami(), this.namespace, NamespacePermission.READ);
                                Assert.assertFalse((boolean)this.c.securityOperations().hasNamespacePermission(this.c.whoami(), this.namespace, NamespacePermission.READ));
                                this.c.securityOperations().grantNamespacePermission(this.c.whoami(), this.namespace, NamespacePermission.READ);
                                Assert.assertTrue((boolean)this.c.securityOperations().hasNamespacePermission(this.c.whoami(), this.namespace, NamespacePermission.READ));
                                this.c.namespaceOperations().delete(this.namespace);
                                try {
                                    this.c.securityOperations().hasTablePermission(this.c.whoami(), tableName, TablePermission.READ);
                                    Assert.fail();
                                }
                                catch (Exception e) {
                                    if (e instanceof AccumuloSecurityException && ((AccumuloSecurityException)((Object)e)).getSecurityErrorCode().equals((Object)SecurityErrorCode.TABLE_DOESNT_EXIST)) break block21;
                                    throw new Exception("Has permission resulted in " + e.getClass().getName(), e);
                                }
                            }
                            try {
                                this.c.securityOperations().grantTablePermission(this.c.whoami(), tableName, TablePermission.READ);
                                Assert.fail();
                            }
                            catch (Exception e) {
                                if (e instanceof AccumuloSecurityException && ((AccumuloSecurityException)((Object)e)).getSecurityErrorCode().equals((Object)SecurityErrorCode.TABLE_DOESNT_EXIST)) break block22;
                                throw new Exception("Has permission resulted in " + e.getClass().getName(), e);
                            }
                        }
                        try {
                            this.c.securityOperations().revokeTablePermission(this.c.whoami(), tableName, TablePermission.READ);
                            Assert.fail();
                        }
                        catch (Exception e) {
                            if (e instanceof AccumuloSecurityException && ((AccumuloSecurityException)((Object)e)).getSecurityErrorCode().equals((Object)SecurityErrorCode.TABLE_DOESNT_EXIST)) break block23;
                            throw new Exception("Has permission resulted in " + e.getClass().getName(), e);
                        }
                    }
                    try {
                        this.c.securityOperations().hasNamespacePermission(this.c.whoami(), this.namespace, NamespacePermission.READ);
                        Assert.fail();
                    }
                    catch (Exception e) {
                        if (e instanceof AccumuloSecurityException && ((AccumuloSecurityException)((Object)e)).getSecurityErrorCode().equals((Object)SecurityErrorCode.NAMESPACE_DOESNT_EXIST)) break block24;
                        throw new Exception("Has permission resulted in " + e.getClass().getName(), e);
                    }
                }
                try {
                    this.c.securityOperations().grantNamespacePermission(this.c.whoami(), this.namespace, NamespacePermission.READ);
                    Assert.fail();
                }
                catch (Exception e) {
                    if (e instanceof AccumuloSecurityException && ((AccumuloSecurityException)((Object)e)).getSecurityErrorCode().equals((Object)SecurityErrorCode.NAMESPACE_DOESNT_EXIST)) break block25;
                    throw new Exception("Has permission resulted in " + e.getClass().getName(), e);
                }
            }
            try {
                this.c.securityOperations().revokeNamespacePermission(this.c.whoami(), this.namespace, NamespacePermission.READ);
                Assert.fail();
            }
            catch (Exception e) {
                if (e instanceof AccumuloSecurityException && ((AccumuloSecurityException)((Object)e)).getSecurityErrorCode().equals((Object)SecurityErrorCode.NAMESPACE_DOESNT_EXIST)) break block26;
                throw new Exception("Has permission resulted in " + e.getClass().getName(), e);
            }
        }
    }

    @Test
    public void verifyTableOperationsExceptions() throws Exception {
        String tableName = this.namespace + ".1";
        IteratorSetting setting = new IteratorSetting(200, VersioningIterator.class);
        Text a = new Text("a");
        Text z = new Text("z");
        TableOperations ops = this.c.tableOperations();
        Assert.assertFalse((boolean)ops.exists(tableName));
        int numRun = 0;
        int i = 0;
        while (true) {
            block50: {
                try {
                    switch (i) {
                        case 0: {
                            ops.create(tableName);
                            Assert.fail();
                            break block50;
                        }
                        case 1: {
                            ops.create("a");
                            ops.clone("a", tableName, true, Collections.emptyMap(), Collections.emptySet());
                            Assert.fail();
                            break block50;
                        }
                        case 2: {
                            ops.importTable(tableName, System.getProperty("user.dir") + "/target");
                            Assert.fail();
                            break block50;
                        }
                        default: {
                            Assert.assertEquals((long)3L, (long)i);
                            Assert.assertEquals((long)3L, (long)numRun);
                            break;
                        }
                    }
                    break;
                }
                catch (Exception e) {
                    ++numRun;
                    if (e instanceof AccumuloException && e.getCause() instanceof NamespaceNotFoundException) break block50;
                    throw new Exception("Case " + i + " resulted in " + e.getClass().getName(), e);
                }
            }
            ++i;
        }
        numRun = 0;
        i = 0;
        while (true) {
            block51: {
                try {
                    switch (i) {
                        case 0: {
                            ops.removeConstraint(tableName, 0);
                            Assert.fail();
                            break block51;
                        }
                        case 1: {
                            ops.removeProperty(tableName, "a");
                            Assert.fail();
                            break block51;
                        }
                        case 2: {
                            ops.setProperty(tableName, "a", "b");
                            Assert.fail();
                            break block51;
                        }
                        default: {
                            Assert.assertEquals((long)3L, (long)i);
                            Assert.assertEquals((long)3L, (long)numRun);
                            break;
                        }
                    }
                    break;
                }
                catch (Exception e) {
                    ++numRun;
                    if (e instanceof AccumuloException && e.getCause() instanceof TableNotFoundException && e.getCause().getCause() instanceof NamespaceNotFoundException) break block51;
                    throw new Exception("Case " + i + " resulted in " + e.getClass().getName(), e);
                }
            }
            ++i;
        }
        numRun = 0;
        i = 0;
        while (true) {
            block52: {
                try {
                    switch (i) {
                        case 0: {
                            ops.addConstraint(tableName, NumericValueConstraint.class.getName());
                            Assert.fail();
                            break block52;
                        }
                        case 1: {
                            ops.addSplits(tableName, new TreeSet());
                            Assert.fail();
                            break block52;
                        }
                        case 2: {
                            ops.attachIterator(tableName, setting);
                            Assert.fail();
                            break block52;
                        }
                        case 3: {
                            ops.cancelCompaction(tableName);
                            Assert.fail();
                            break block52;
                        }
                        case 4: {
                            ops.checkIteratorConflicts(tableName, setting, EnumSet.allOf(IteratorUtil.IteratorScope.class));
                            Assert.fail();
                            break block52;
                        }
                        case 5: {
                            ops.clearLocatorCache(tableName);
                            Assert.fail();
                            break block52;
                        }
                        case 6: {
                            ops.clone(tableName, "2", true, Collections.emptyMap(), Collections.emptySet());
                            Assert.fail();
                            break block52;
                        }
                        case 7: {
                            ops.compact(tableName, a, z, true, true);
                            Assert.fail();
                            break block52;
                        }
                        case 8: {
                            ops.delete(tableName);
                            Assert.fail();
                            break block52;
                        }
                        case 9: {
                            ops.deleteRows(tableName, a, z);
                            Assert.fail();
                            break block52;
                        }
                        case 10: {
                            ops.splitRangeByTablets(tableName, new Range(), 10);
                            Assert.fail();
                            break block52;
                        }
                        case 11: {
                            ops.exportTable(tableName, this.namespace + "_dir");
                            Assert.fail();
                            break block52;
                        }
                        case 12: {
                            ops.flush(tableName, a, z, true);
                            Assert.fail();
                            break block52;
                        }
                        case 13: {
                            ops.getDiskUsage(Collections.singleton(tableName));
                            Assert.fail();
                            break block52;
                        }
                        case 14: {
                            ops.getIteratorSetting(tableName, "a", IteratorUtil.IteratorScope.scan);
                            Assert.fail();
                            break block52;
                        }
                        case 15: {
                            ops.getLocalityGroups(tableName);
                            Assert.fail();
                            break block52;
                        }
                        case 16: {
                            ops.getMaxRow(tableName, Authorizations.EMPTY, a, true, z, true);
                            Assert.fail();
                            break block52;
                        }
                        case 17: {
                            ops.getProperties(tableName);
                            Assert.fail();
                            break block52;
                        }
                        case 18: {
                            ops.importDirectory(tableName, "", "", false);
                            Assert.fail();
                            break block52;
                        }
                        case 19: {
                            ops.testClassLoad(tableName, VersioningIterator.class.getName(), SortedKeyValueIterator.class.getName());
                            Assert.fail();
                            break block52;
                        }
                        case 20: {
                            ops.listConstraints(tableName);
                            Assert.fail();
                            break block52;
                        }
                        case 21: {
                            ops.listIterators(tableName);
                            Assert.fail();
                            break block52;
                        }
                        case 22: {
                            ops.listSplits(tableName);
                            Assert.fail();
                            break block52;
                        }
                        case 23: {
                            ops.merge(tableName, a, z);
                            Assert.fail();
                            break block52;
                        }
                        case 24: {
                            ops.offline(tableName, true);
                            Assert.fail();
                            break block52;
                        }
                        case 25: {
                            ops.online(tableName, true);
                            Assert.fail();
                            break block52;
                        }
                        case 26: {
                            ops.removeIterator(tableName, "a", EnumSet.of(IteratorUtil.IteratorScope.scan));
                            Assert.fail();
                            break block52;
                        }
                        case 27: {
                            ops.rename(tableName, tableName + "2");
                            Assert.fail();
                            break block52;
                        }
                        case 28: {
                            ops.setLocalityGroups(tableName, Collections.emptyMap());
                            Assert.fail();
                            break block52;
                        }
                        default: {
                            Assert.assertEquals((long)29L, (long)i);
                            Assert.assertEquals((long)29L, (long)numRun);
                            break;
                        }
                    }
                    break;
                }
                catch (Exception e) {
                    ++numRun;
                    if (e instanceof TableNotFoundException && e.getCause() instanceof NamespaceNotFoundException) break block52;
                    throw new Exception("Case " + i + " resulted in " + e.getClass().getName(), e);
                }
            }
            ++i;
        }
    }

    @Test
    public void verifyNamespaceOperationsExceptions() throws Exception {
        IteratorSetting setting = new IteratorSetting(200, VersioningIterator.class);
        NamespaceOperations ops = this.c.namespaceOperations();
        Assert.assertFalse((boolean)ops.exists(this.namespace));
        int numRun = 0;
        int i = 0;
        while (true) {
            block30: {
                try {
                    switch (i) {
                        case 0: {
                            ops.addConstraint(this.namespace, NumericValueConstraint.class.getName());
                            Assert.fail();
                            break block30;
                        }
                        case 1: {
                            ops.attachIterator(this.namespace, setting);
                            Assert.fail();
                            break block30;
                        }
                        case 2: {
                            ops.checkIteratorConflicts(this.namespace, setting, EnumSet.of(IteratorUtil.IteratorScope.scan));
                            Assert.fail();
                            break block30;
                        }
                        case 3: {
                            ops.delete(this.namespace);
                            Assert.fail();
                            break block30;
                        }
                        case 4: {
                            ops.getIteratorSetting(this.namespace, "thing", IteratorUtil.IteratorScope.scan);
                            Assert.fail();
                            break block30;
                        }
                        case 5: {
                            ops.getProperties(this.namespace);
                            Assert.fail();
                            break block30;
                        }
                        case 6: {
                            ops.listConstraints(this.namespace);
                            Assert.fail();
                            break block30;
                        }
                        case 7: {
                            ops.listIterators(this.namespace);
                            Assert.fail();
                            break block30;
                        }
                        case 8: {
                            ops.removeConstraint(this.namespace, 1);
                            Assert.fail();
                            break block30;
                        }
                        case 9: {
                            ops.removeIterator(this.namespace, "thing", EnumSet.allOf(IteratorUtil.IteratorScope.class));
                            Assert.fail();
                            break block30;
                        }
                        case 10: {
                            ops.removeProperty(this.namespace, "a");
                            Assert.fail();
                            break block30;
                        }
                        case 11: {
                            ops.rename(this.namespace, this.namespace + "2");
                            Assert.fail();
                            break block30;
                        }
                        case 12: {
                            ops.setProperty(this.namespace, "k", "v");
                            Assert.fail();
                            break block30;
                        }
                        case 13: {
                            ops.testClassLoad(this.namespace, VersioningIterator.class.getName(), SortedKeyValueIterator.class.getName());
                            Assert.fail();
                            break block30;
                        }
                        default: {
                            Assert.assertEquals((long)14L, (long)i);
                            Assert.assertEquals((long)14L, (long)numRun);
                            break;
                        }
                    }
                    break;
                }
                catch (Exception e) {
                    ++numRun;
                    if (e instanceof NamespaceNotFoundException) break block30;
                    throw new Exception("Case " + i + " resulted in " + e.getClass().getName(), e);
                }
            }
            ++i;
        }
        numRun = 0;
        i = 0;
        while (true) {
            block31: {
                try {
                    switch (i) {
                        case 0: {
                            ops.create(this.namespace + "0");
                            ops.create(this.namespace + "0");
                            Assert.fail();
                            break block31;
                        }
                        case 1: {
                            ops.create(this.namespace + i + "_1");
                            ops.create(this.namespace + i + "_2");
                            ops.rename(this.namespace + i + "_1", this.namespace + i + "_2");
                            Assert.fail();
                            break block31;
                        }
                        case 2: {
                            ops.create("");
                            Assert.fail();
                            break block31;
                        }
                        case 3: {
                            ops.create("accumulo");
                            Assert.fail();
                            break block31;
                        }
                        case 4: {
                            ops.create(this.namespace + i + "_1");
                            ops.rename(this.namespace + i + "_1", "");
                            Assert.fail();
                            break block31;
                        }
                        case 5: {
                            ops.create(this.namespace + i + "_1");
                            ops.rename(this.namespace + i + "_1", "accumulo");
                            Assert.fail();
                            break block31;
                        }
                        default: {
                            Assert.assertEquals((long)6L, (long)i);
                            Assert.assertEquals((long)6L, (long)numRun);
                            break;
                        }
                    }
                    break;
                }
                catch (Exception e) {
                    ++numRun;
                    if (e instanceof NamespaceExistsException) break block31;
                    throw new Exception("Case " + i + " resulted in " + e.getClass().getName(), e);
                }
            }
            ++i;
        }
    }

    private boolean checkTableHasProp(String t, String propKey, String propVal) {
        return this.checkHasProperty(t, propKey, propVal, true);
    }

    private boolean checkNamespaceHasProp(String n, String propKey, String propVal) {
        return this.checkHasProperty(n, propKey, propVal, false);
    }

    private boolean checkHasProperty(String name, String propKey, String propVal, boolean nameIsTable) {
        try {
            Iterable iterable = nameIsTable ? this.c.tableOperations().getProperties(name) : this.c.namespaceOperations().getProperties(name);
            for (Map.Entry e : iterable) {
                if (!propKey.equals(e.getKey())) continue;
                return propVal.equals(e.getValue());
            }
            return false;
        }
        catch (Exception e) {
            Assert.fail();
            return false;
        }
    }

    private void expectPermissionDenied(AccumuloSecurityException sec) {
        Assert.assertEquals(sec.getSecurityErrorCode().getClass(), SecurityErrorCode.class);
        switch (sec.getSecurityErrorCode()) {
            case PERMISSION_DENIED: {
                break;
            }
            default: {
                Assert.fail();
            }
        }
    }

    public static class SimpleFilter
    extends Filter {
        public boolean accept(Key k, Value v) {
            return !k.getColumnFamily().toString().equals("a");
        }
    }
}

