/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.randomwalk.bulk;

import java.util.Arrays;
import java.util.Random;
import org.apache.accumulo.test.randomwalk.Environment;
import org.apache.accumulo.test.randomwalk.State;
import org.apache.accumulo.test.randomwalk.bulk.BulkPlusOne;
import org.apache.accumulo.test.randomwalk.bulk.SelectiveBulkTest;
import org.apache.accumulo.test.randomwalk.bulk.Setup;
import org.apache.hadoop.io.Text;

public class Merge
extends SelectiveBulkTest {
    @Override
    protected void runLater(State state, Environment env) throws Exception {
        Text[] points = Merge.getRandomTabletRange(state);
        this.log.info((Object)("merging " + Merge.rangeToString(points)));
        env.getConnector().tableOperations().merge(Setup.getTableName(), points[0], points[1]);
        this.log.info((Object)("merging " + Merge.rangeToString(points) + " complete"));
    }

    public static String rangeToString(Text[] points) {
        return "(" + (points[0] == null ? "-inf" : points[0]) + " -> " + (points[1] == null ? "+inf" : points[1]) + "]";
    }

    public static Text getRandomRow(Random rand) {
        return new Text(String.format(BulkPlusOne.FMT, (rand.nextLong() & Long.MAX_VALUE) % 100000L));
    }

    public static Text[] getRandomTabletRange(State state) {
        Random rand = (Random)state.get("rand");
        Object[] points = new Text[]{Merge.getRandomRow(rand), Merge.getRandomRow(rand)};
        Arrays.sort(points);
        if (rand.nextInt(10) == 0) {
            points[0] = null;
        }
        if (rand.nextInt(10) == 0) {
            points[1] = null;
        }
        if (rand.nextInt(20) == 0) {
            points[0] = null;
            points[1] = null;
        }
        return points;
    }
}

