/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.replication;

import com.google.common.collect.Iterables;
import com.google.protobuf.GeneratedMessage;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.apache.accumulo.cluster.ClusterUser;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.admin.TableOperations;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.IteratorUtil;
import org.apache.accumulo.core.metadata.schema.MetadataSchema;
import org.apache.accumulo.core.protobuf.ProtobufUtil;
import org.apache.accumulo.core.replication.ReplicationSchema;
import org.apache.accumulo.core.replication.ReplicationTable;
import org.apache.accumulo.core.security.TablePermission;
import org.apache.accumulo.harness.SharedMiniClusterBase;
import org.apache.accumulo.server.replication.StatusUtil;
import org.apache.accumulo.server.replication.proto.Replication;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;

@Ignore(value="Replication ITs are not stable and not currently maintained")
public class StatusCombinerMacIT
extends SharedMiniClusterBase {
    @Override
    public int defaultTimeoutSeconds() {
        return 60;
    }

    @BeforeClass
    public static void setup() throws Exception {
        SharedMiniClusterBase.startMiniCluster();
    }

    @AfterClass
    public static void teardown() throws Exception {
        SharedMiniClusterBase.stopMiniCluster();
    }

    @Test
    public void testCombinerSetOnMetadata() throws Exception {
        TableOperations tops = StatusCombinerMacIT.getConnector().tableOperations();
        Map iterators = tops.listIterators("accumulo.metadata");
        Assert.assertTrue((boolean)iterators.containsKey("replcombiner"));
        EnumSet scopes = (EnumSet)iterators.get("replcombiner");
        Assert.assertEquals((long)3L, (long)scopes.size());
        Assert.assertTrue((boolean)scopes.contains(IteratorUtil.IteratorScope.scan));
        Assert.assertTrue((boolean)scopes.contains(IteratorUtil.IteratorScope.minc));
        Assert.assertTrue((boolean)scopes.contains(IteratorUtil.IteratorScope.majc));
        Iterable propIter = tops.getProperties("accumulo.metadata");
        HashMap<String, String> properties = new HashMap<String, String>();
        for (Map.Entry entry : propIter) {
            properties.put((String)entry.getKey(), (String)entry.getValue());
        }
        for (IteratorUtil.IteratorScope scope : scopes) {
            String key = Property.TABLE_ITERATOR_PREFIX.getKey() + scope.name() + "." + "replcombiner" + ".opt.columns";
            Assert.assertTrue((String)("Properties did not contain key : " + key), (boolean)properties.containsKey(key));
            Assert.assertEquals((Object)MetadataSchema.ReplicationSection.COLF.toString(), properties.get(key));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void test() throws Exception {
        Connector conn = StatusCombinerMacIT.getConnector();
        ClusterUser user = this.getAdminUser();
        ReplicationTable.setOnline((Connector)conn);
        conn.securityOperations().grantTablePermission(user.getPrincipal(), "accumulo.replication", TablePermission.WRITE);
        long createTime = System.currentTimeMillis();
        try (BatchWriter bw = ReplicationTable.getBatchWriter((Connector)conn);){
            Mutation m = new Mutation((CharSequence)"file:/accumulo/wal/HW10447.local+56808/93cdc17e-7521-44fa-87b5-37f45bcb92d3");
            ReplicationSchema.StatusSection.add((Mutation)m, (String)"1", (Value)StatusUtil.fileCreatedValue((long)createTime));
            bw.addMutation(m);
        }
        Scanner s = ReplicationTable.getScanner((Connector)conn);
        Map.Entry entry = (Map.Entry)Iterables.getOnlyElement((Iterable)s);
        Assert.assertEquals((Object)StatusUtil.fileCreatedValue((long)createTime), entry.getValue());
        bw = ReplicationTable.getBatchWriter((Connector)conn);
        try {
            Mutation m = new Mutation((CharSequence)"file:/accumulo/wal/HW10447.local+56808/93cdc17e-7521-44fa-87b5-37f45bcb92d3");
            ReplicationSchema.StatusSection.add((Mutation)m, (String)"1", (Value)ProtobufUtil.toValue((GeneratedMessage)StatusUtil.replicated((long)Long.MAX_VALUE)));
            bw.addMutation(m);
        }
        finally {
            bw.close();
        }
        s = ReplicationTable.getScanner((Connector)conn);
        entry = (Map.Entry)Iterables.getOnlyElement((Iterable)s);
        Replication.Status stat = Replication.Status.parseFrom((byte[])((Value)entry.getValue()).get());
        Assert.assertEquals((long)Long.MAX_VALUE, (long)stat.getBegin());
    }
}

