/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.spi.balancer.util;

import java.util.Collections;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.accumulo.core.data.TabletId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThrottledBalancerProblemReporter {
    private static final long TIME_BETWEEN_WARNINGS = TimeUnit.SECONDS.toMillis(60L);
    private final WeakHashMap<Problem, Long> problemReportTimes = new WeakHashMap();
    private final Logger log;

    public ThrottledBalancerProblemReporter(Class<?> loggerClass) {
        this.log = LoggerFactory.getLogger(loggerClass);
    }

    public Problem createNoTabletServersProblem() {
        return () -> this.log.warn("Not balancing because we don't have any tservers.");
    }

    public OutstandingMigrationsProblem createOutstandingMigrationsProblem() {
        return new OutstandingMigrationsProblem(){
            private Set<TabletId> migrations = Collections.emptySet();

            @Override
            public void setMigrations(Set<TabletId> migrations) {
                this.migrations = migrations;
            }

            @Override
            public void report() {
                ThrottledBalancerProblemReporter.this.log.warn("Not balancing due to {} outstanding migrations.", (Object)this.migrations.size());
                if (ThrottledBalancerProblemReporter.this.log.isDebugEnabled()) {
                    ThrottledBalancerProblemReporter.this.log.debug("Sample up to 10 outstanding migrations: {}", (Object)this.migrations.stream().limit(10L).map(String::valueOf).collect(Collectors.joining(", ")));
                }
                this.migrations = Collections.emptySet();
            }
        };
    }

    public void reportProblem(Problem problem) {
        long reportTime = this.problemReportTimes.getOrDefault(problem, -1L);
        if (System.currentTimeMillis() - reportTime > TIME_BETWEEN_WARNINGS) {
            problem.report();
            this.problemReportTimes.put(problem, System.currentTimeMillis());
        }
    }

    public void clearProblemReportTimes() {
        this.problemReportTimes.clear();
    }

    public static interface Problem {
        public void report();
    }

    public static interface OutstandingMigrationsProblem
    extends Problem {
        public void setMigrations(Set<TabletId> var1);
    }
}

