/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.shell.commands;

import org.apache.accumulo.shell.Shell;
import org.apache.accumulo.shell.commands.OptUtil;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.hadoop.io.Text;

public class DeleteRowsCommand
extends Shell.Command {
    private Option forceOpt;

    @Override
    public int execute(String fullCommand, CommandLine cl, Shell shellState) throws Exception {
        String tableName = OptUtil.getTableOpt(cl, shellState);
        Text startRow = OptUtil.getStartRow(cl);
        Text endRow = OptUtil.getEndRow(cl);
        if (!(cl.hasOption(this.forceOpt.getOpt()) || startRow != null && endRow != null)) {
            shellState.getWriter().println("Not deleting unbounded range. Specify both ends, or use --force");
            return 1;
        }
        shellState.getAccumuloClient().tableOperations().deleteRows(tableName, startRow, endRow);
        return 0;
    }

    @Override
    public String description() {
        return "deletes a range of rows in a table. Note that rows matching the start row ARE NOT deleted, but rows matching the end row ARE deleted.";
    }

    @Override
    public int numArgs() {
        return 0;
    }

    @Override
    public Options getOptions() {
        Options o = new Options();
        this.forceOpt = new Option("f", "force", false, "delete data even if start or end are not specified");
        o.addOption(OptUtil.startRowOpt());
        o.addOption(OptUtil.endRowOpt());
        o.addOption(OptUtil.tableOpt("table to delete a row range from"));
        o.addOption(this.forceOpt);
        return o;
    }
}

