/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.coordinator;

import java.util.WeakHashMap;
import org.apache.accumulo.core.util.Pair;

public class QueueAndPriority
implements Comparable<QueueAndPriority> {
    private static WeakHashMap<Pair<String, Short>, QueueAndPriority> CACHE = new WeakHashMap();
    private final String queue;
    private final short priority;

    public static QueueAndPriority get(String queue, short priority) {
        return CACHE.computeIfAbsent((Pair<String, Short>)new Pair((Object)queue, (Object)priority), k -> new QueueAndPriority(queue, priority));
    }

    private QueueAndPriority(String queue, short priority) {
        this.queue = queue;
        this.priority = priority;
    }

    public String getQueue() {
        return this.queue;
    }

    public short getPriority() {
        return this.priority;
    }

    public int hashCode() {
        return this.queue.hashCode() + Short.valueOf(this.priority).hashCode();
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("queue: ").append(this.queue);
        buf.append(", priority: ").append(this.priority);
        return buf.toString();
    }

    public boolean equals(Object obj) {
        if (null == obj) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof QueueAndPriority)) {
            return false;
        }
        QueueAndPriority other = (QueueAndPriority)obj;
        return this.queue.equals(other.queue) && this.priority == other.priority;
    }

    @Override
    public int compareTo(QueueAndPriority other) {
        int result = this.queue.compareTo(other.queue);
        if (result == 0) {
            return Long.compare(other.priority, this.priority);
        }
        return result;
    }
}

