/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.conf.store;

import org.apache.accumulo.core.data.InstanceId;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.fate.zookeeper.ZooUtil;
import org.apache.accumulo.server.ServerContext;
import org.apache.accumulo.server.conf.store.PropStoreKey;

public class TablePropKey
extends PropStoreKey<TableId> {
    public static TablePropKey of(ServerContext context, TableId tableId) {
        return TablePropKey.of(context.getInstanceID(), tableId);
    }

    public static TablePropKey of(InstanceId instanceId, TableId tableId) {
        return new TablePropKey(instanceId, TablePropKey.buildNodePath(instanceId, tableId), tableId);
    }

    private TablePropKey(InstanceId instanceId, String path, TableId tableId) {
        super(instanceId, path, tableId);
    }

    private static String buildNodePath(InstanceId instanceId, TableId id) {
        return ZooUtil.getRoot((InstanceId)instanceId) + "/tables/" + id.canonical() + "/config";
    }
}

