/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.file.blockfile.impl;

import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import java.util.function.IntBinaryOperator;

public class SeekableByteArrayInputStream
extends InputStream {
    private final byte[] buffer;
    private final AtomicInteger cur = new AtomicInteger(0);
    private final int max;

    @Override
    public int read() {
        int currentValue = this.cur.getAndAccumulate(1, (v, x) -> v < this.max ? v + x : v);
        if (currentValue < this.max) {
            return this.buffer[currentValue] & 0xFF;
        }
        return -1;
    }

    @Override
    public int read(byte[] b, int offset, int length) {
        if (b == null) {
            throw new NullPointerException();
        }
        if (length < 0 || offset < 0 || length > b.length - offset) {
            throw new IndexOutOfBoundsException();
        }
        if (length == 0) {
            return 0;
        }
        IntBinaryOperator add = (cur1, length1) -> {
            int available = this.max - cur1;
            if (available <= 0) {
                return cur1;
            }
            if (length1 > available) {
                length1 = available;
            }
            return cur1 + length1;
        };
        int currentValue = this.cur.getAndAccumulate(length, add);
        int avail = this.max - currentValue;
        if (avail <= 0) {
            return -1;
        }
        if (length > avail) {
            length = avail;
        }
        System.arraycopy(this.buffer, currentValue, b, offset, length);
        return length;
    }

    @Override
    public long skip(long requestedSkip) {
        BiFunction<Integer, Integer, Integer> skipValue = (current, skip) -> Math.max(0, Math.min(this.max - current, skip));
        IntBinaryOperator add = (cur1, skip) -> cur1 + (Integer)skipValue.apply(cur1, skip);
        int currentValue = this.cur.getAndAccumulate((int)requestedSkip, add);
        return skipValue.apply(currentValue, (int)requestedSkip).intValue();
    }

    @Override
    public int available() {
        return this.max - this.cur.get();
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public synchronized void mark(int readAheadLimit) {
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized void reset() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() throws IOException {
    }

    public SeekableByteArrayInputStream(byte[] buf) {
        Objects.requireNonNull(buf, "bug argument was null");
        this.buffer = buf;
        this.max = buf.length;
    }

    public SeekableByteArrayInputStream(byte[] buf, int maxOffset) {
        Objects.requireNonNull(buf, "bug argument was null");
        this.buffer = buf;
        this.max = maxOffset;
    }

    public void seek(int position) {
        if (position < 0 || position >= this.max) {
            throw new IllegalArgumentException("position = " + position + " maxOffset = " + this.max);
        }
        this.cur.set(position);
    }

    public int getPosition() {
        return this.cur.get();
    }

    byte[] getBuffer() {
        return this.buffer;
    }
}

