/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.rpc;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.accumulo.core.rpc.FilterTransport;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;

public class UGIAssumingTransport
extends FilterTransport {
    protected UserGroupInformation ugi;

    public UGIAssumingTransport(TTransport wrapped, UserGroupInformation ugi) {
        super(wrapped);
        this.ugi = ugi;
    }

    @Override
    public void open() throws TTransportException {
        AtomicReference<Object> holder = new AtomicReference<Object>(null);
        try {
            this.ugi.doAs(() -> {
                try {
                    this.getWrapped().open();
                }
                catch (TTransportException tte) {
                    holder.set(tte);
                }
                return null;
            });
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        catch (InterruptedException e) {
            throw new IllegalStateException(e);
        }
        TTransportException tte = holder.get();
        if (tte != null) {
            throw tte;
        }
    }
}

