/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.manager;

import com.google.common.collect.ImmutableSortedMap;
import com.google.common.net.HostAndPort;
import com.google.common.util.concurrent.RateLimiter;
import com.google.common.util.concurrent.Uninterruptibles;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.context.Scope;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.accumulo.core.cli.ConfigOpts;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.ScannerBase;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.clientImpl.ClientContext;
import org.apache.accumulo.core.clientImpl.thrift.TableOperation;
import org.apache.accumulo.core.clientImpl.thrift.TableOperationExceptionType;
import org.apache.accumulo.core.clientImpl.thrift.ThriftTableOperationException;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.InstanceId;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.data.TabletId;
import org.apache.accumulo.core.dataImpl.KeyExtent;
import org.apache.accumulo.core.fate.AgeOffStore;
import org.apache.accumulo.core.fate.Fate;
import org.apache.accumulo.core.fate.TStore;
import org.apache.accumulo.core.fate.ZooStore;
import org.apache.accumulo.core.fate.zookeeper.ZooReaderWriter;
import org.apache.accumulo.core.fate.zookeeper.ZooUtil;
import org.apache.accumulo.core.lock.ServiceLock;
import org.apache.accumulo.core.lock.ServiceLockData;
import org.apache.accumulo.core.manager.balancer.AssignmentParamsImpl;
import org.apache.accumulo.core.manager.balancer.BalanceParamsImpl;
import org.apache.accumulo.core.manager.balancer.TServerStatusImpl;
import org.apache.accumulo.core.manager.balancer.TabletServerIdImpl;
import org.apache.accumulo.core.manager.state.tables.TableState;
import org.apache.accumulo.core.manager.thrift.BulkImportState;
import org.apache.accumulo.core.manager.thrift.FateService;
import org.apache.accumulo.core.manager.thrift.ManagerClientService;
import org.apache.accumulo.core.manager.thrift.ManagerGoalState;
import org.apache.accumulo.core.manager.thrift.ManagerMonitorInfo;
import org.apache.accumulo.core.manager.thrift.ManagerState;
import org.apache.accumulo.core.manager.thrift.TableInfo;
import org.apache.accumulo.core.manager.thrift.TabletServerStatus;
import org.apache.accumulo.core.metadata.MetadataTable;
import org.apache.accumulo.core.metadata.RootTable;
import org.apache.accumulo.core.metadata.TServerInstance;
import org.apache.accumulo.core.metadata.TabletLocationState;
import org.apache.accumulo.core.metadata.TabletState;
import org.apache.accumulo.core.metadata.schema.Ample;
import org.apache.accumulo.core.metadata.schema.MetadataSchema;
import org.apache.accumulo.core.metrics.MetricsProducer;
import org.apache.accumulo.core.metrics.MetricsUtil;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.spi.balancer.BalancerEnvironment;
import org.apache.accumulo.core.spi.balancer.SimpleLoadBalancer;
import org.apache.accumulo.core.spi.balancer.TabletBalancer;
import org.apache.accumulo.core.spi.balancer.data.TServerStatus;
import org.apache.accumulo.core.spi.balancer.data.TabletMigration;
import org.apache.accumulo.core.spi.balancer.data.TabletServerId;
import org.apache.accumulo.core.tablet.thrift.TUnloadTabletGoal;
import org.apache.accumulo.core.trace.TraceUtil;
import org.apache.accumulo.core.util.Halt;
import org.apache.accumulo.core.util.Retry;
import org.apache.accumulo.core.util.threads.ThreadPools;
import org.apache.accumulo.core.util.threads.Threads;
import org.apache.accumulo.manager.EventCoordinator;
import org.apache.accumulo.manager.FateServiceHandler;
import org.apache.accumulo.manager.ManagerClientServiceHandler;
import org.apache.accumulo.manager.ManagerTime;
import org.apache.accumulo.manager.TabletGroupWatcher;
import org.apache.accumulo.manager.metrics.ManagerMetrics;
import org.apache.accumulo.manager.recovery.RecoveryManager;
import org.apache.accumulo.manager.state.TableCounts;
import org.apache.accumulo.manager.tableOps.TraceRepo;
import org.apache.accumulo.manager.upgrade.PreUpgradeValidation;
import org.apache.accumulo.manager.upgrade.UpgradeCoordinator;
import org.apache.accumulo.server.AbstractServer;
import org.apache.accumulo.server.HighlyAvailableService;
import org.apache.accumulo.server.ServerContext;
import org.apache.accumulo.server.fs.VolumeManager;
import org.apache.accumulo.server.manager.LiveTServerSet;
import org.apache.accumulo.server.manager.balancer.BalancerEnvironmentImpl;
import org.apache.accumulo.server.manager.state.CurrentState;
import org.apache.accumulo.server.manager.state.DeadServerList;
import org.apache.accumulo.server.manager.state.MergeInfo;
import org.apache.accumulo.server.manager.state.MergeState;
import org.apache.accumulo.server.manager.state.TabletServerState;
import org.apache.accumulo.server.manager.state.TabletStateStore;
import org.apache.accumulo.server.manager.state.UnassignedTablet;
import org.apache.accumulo.server.rpc.HighlyAvailableServiceWrapper;
import org.apache.accumulo.server.rpc.ServerAddress;
import org.apache.accumulo.server.rpc.TServerUtils;
import org.apache.accumulo.server.rpc.ThriftProcessorTypes;
import org.apache.accumulo.server.security.SecurityOperation;
import org.apache.accumulo.server.security.delegation.AuthenticationTokenKeyManager;
import org.apache.accumulo.server.security.delegation.ZooAuthenticationKeyDistributor;
import org.apache.accumulo.server.tables.TableManager;
import org.apache.accumulo.server.tables.TableObserver;
import org.apache.accumulo.server.util.ScanServerMetadataEntries;
import org.apache.accumulo.server.util.ServerBulkImportStatus;
import org.apache.accumulo.server.util.TableInfoUtil;
import org.apache.hadoop.io.DataInputBuffer;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.thrift.TException;
import org.apache.thrift.TMultiplexedProcessor;
import org.apache.thrift.TProcessor;
import org.apache.thrift.server.TServer;
import org.apache.thrift.transport.TTransportException;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Manager
extends AbstractServer
implements LiveTServerSet.Listener,
TableObserver,
CurrentState,
HighlyAvailableService {
    static final Logger log = LoggerFactory.getLogger(Manager.class);
    static final int ONE_SECOND = 1000;
    private static final long TIME_BETWEEN_MIGRATION_CLEANUPS = 300000L;
    static final long WAIT_BETWEEN_ERRORS = 1000L;
    private static final long DEFAULT_WAIT_FOR_WATCHER = 10000L;
    private static final int MAX_CLEANUP_WAIT_TIME = 1000;
    private static final int TIME_TO_WAIT_BETWEEN_LOCK_CHECKS = 1000;
    static final int MAX_TSERVER_WORK_CHUNK = 5000;
    private static final int MAX_BAD_STATUS_COUNT = 3;
    private static final double MAX_SHUTDOWNS_PER_SEC = 0.16666666666666666;
    private final Object balancedNotifier = new Object();
    final LiveTServerSet tserverSet;
    private final List<TabletGroupWatcher> watchers = new ArrayList<TabletGroupWatcher>();
    final SecurityOperation security;
    final Map<TServerInstance, AtomicInteger> badServers = Collections.synchronizedMap(new HashMap());
    final Set<TServerInstance> serversToShutdown = Collections.synchronizedSet(new HashSet());
    final SortedMap<KeyExtent, TServerInstance> migrations = Collections.synchronizedSortedMap(new TreeMap());
    final EventCoordinator nextEvent = new EventCoordinator();
    private final Object mergeLock = new Object();
    RecoveryManager recoveryManager = null;
    private final ManagerTime timeKeeper;
    private final boolean delegationTokensAvailable;
    private ZooAuthenticationKeyDistributor keyDistributor;
    private AuthenticationTokenKeyManager authenticationTokenKeyManager;
    ServiceLock managerLock = null;
    private TServer clientService = null;
    private volatile TabletBalancer tabletBalancer;
    private final BalancerEnvironment balancerEnvironment;
    private ManagerState state = ManagerState.INITIAL;
    private final CountDownLatch fateReadyLatch = new CountDownLatch(1);
    private final AtomicReference<Fate<Manager>> fateRef = new AtomicReference<Object>(null);
    volatile SortedMap<TServerInstance, TabletServerStatus> tserverStatus = Collections.emptySortedMap();
    volatile SortedMap<TabletServerId, TServerStatus> tserverStatusForBalancer = Collections.emptySortedMap();
    final ServerBulkImportStatus bulkImportStatus = new ServerBulkImportStatus();
    private final AtomicBoolean managerInitialized = new AtomicBoolean(false);
    private final AtomicBoolean managerUpgrading = new AtomicBoolean(false);
    private final long timeToCacheRecoveryWalExistence;
    private ExecutorService tableInformationStatusPool = null;
    static final boolean X = true;
    static final boolean O = false;
    static final boolean[][] transitionOK = new boolean[][]{{true, true, false, false, false, false, true}, {false, true, true, true, false, false, true}, {false, false, true, true, true, false, true}, {false, false, true, true, true, false, true}, {false, false, true, true, true, true, true}, {false, false, false, true, true, true, true}, {false, false, false, false, false, true, true}};
    private final UpgradeCoordinator upgradeCoordinator = new UpgradeCoordinator();
    private Future<Void> upgradeMetadataFuture;
    private FateServiceHandler fateServiceHandler;
    private ManagerClientServiceHandler managerClientHandler;

    public synchronized ManagerState getManagerState() {
        return this.state;
    }

    public boolean stillManager() {
        return this.getManagerState() != ManagerState.STOP;
    }

    Fate<Manager> fate() {
        try {
            if (!this.fateReadyLatch.await(30L, TimeUnit.SECONDS)) {
                String msgPrefix = "Unexpected use of fate in thread " + Thread.currentThread().getName() + " at time " + System.currentTimeMillis();
                log.warn("{} blocked until fate starts", (Object)msgPrefix, (Object)new IllegalStateException("Attempted fate action before manager finished starting up; if this doesn't make progress, please report it as a bug to the developers"));
                int minutes = 0;
                while (!this.fateReadyLatch.await(5L, TimeUnit.MINUTES)) {
                    log.warn("{} still blocked after {} minutes; this is getting weird", (Object)msgPrefix, (Object)(minutes += 5));
                }
                log.debug("{} no longer blocked", (Object)msgPrefix);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException("Thread was interrupted; cannot proceed");
        }
        return this.fateRef.get();
    }

    synchronized void setManagerState(ManagerState newState) {
        if (this.state.equals((Object)newState)) {
            return;
        }
        if (!transitionOK[this.state.ordinal()][newState.ordinal()]) {
            log.error("Programmer error: manager should not transition from {} to {}", (Object)this.state, (Object)newState);
        }
        ManagerState oldState = this.state;
        this.state = newState;
        this.nextEvent.event("State changed from %s to %s", oldState, newState);
        if (newState == ManagerState.STOP) {
            ScheduledFuture<?> future = this.getContext().getScheduledExecutor().scheduleWithFixedDelay(() -> {
                this.clientService.stop();
                this.nextEvent.event("stopped event loop", new Object[0]);
            }, 100L, 1000L, TimeUnit.MILLISECONDS);
            ThreadPools.watchNonCriticalScheduledTask(future);
        }
        if (oldState != newState && newState == ManagerState.HAVE_LOCK) {
            new PreUpgradeValidation().validate(this.getContext(), this.nextEvent);
            this.upgradeCoordinator.upgradeZookeeper(this.getContext(), this.nextEvent);
        }
        if (oldState != newState && newState == ManagerState.NORMAL) {
            if (this.fateRef.get() != null) {
                throw new IllegalStateException("Access to Fate should not have been initialized prior to the Manager finishing upgrades. Please save all logs and file a bug.");
            }
            this.upgradeMetadataFuture = this.upgradeCoordinator.upgradeMetadata(this.getContext(), this.nextEvent);
        }
    }

    private int assignedOrHosted(TableId tableId) {
        int result = 0;
        for (TabletGroupWatcher watcher : this.watchers) {
            TableCounts count = watcher.getStats(tableId);
            result += count.hosted() + count.assigned();
        }
        return result;
    }

    private int totalAssignedOrHosted() {
        int result = 0;
        for (TabletGroupWatcher watcher : this.watchers) {
            for (TableCounts counts : watcher.getStats().values()) {
                result += counts.assigned() + counts.hosted();
            }
        }
        return result;
    }

    private int nonMetaDataTabletsAssignedOrHosted() {
        return this.totalAssignedOrHosted() - this.assignedOrHosted(MetadataTable.ID) - this.assignedOrHosted(RootTable.ID);
    }

    private int notHosted() {
        int result = 0;
        for (TabletGroupWatcher watcher : this.watchers) {
            for (TableCounts counts : watcher.getStats().values()) {
                result += counts.assigned() + counts.assignedToDeadServers() + counts.suspended();
            }
        }
        return result;
    }

    int displayUnassigned() {
        int result = 0;
        switch (this.getManagerState()) {
            case NORMAL: {
                for (TabletGroupWatcher watcher : this.watchers) {
                    TableManager manager = this.getContext().getTableManager();
                    for (Map.Entry<TableId, TableCounts> entry : watcher.getStats().entrySet()) {
                        TableId tableId = entry.getKey();
                        TableCounts counts = entry.getValue();
                        if (manager.getTableState(tableId) != TableState.ONLINE) continue;
                        result += counts.unassigned() + counts.assignedToDeadServers() + counts.assigned() + counts.suspended();
                    }
                }
                break;
            }
            case SAFE_MODE: {
                for (TabletGroupWatcher watcher : this.watchers) {
                    TableCounts counts = watcher.getStats(MetadataTable.ID);
                    result += counts.unassigned() + counts.suspended();
                }
                break;
            }
            case UNLOAD_METADATA_TABLETS: 
            case UNLOAD_ROOT_TABLET: {
                for (TabletGroupWatcher watcher : this.watchers) {
                    TableCounts counts = watcher.getStats(MetadataTable.ID);
                    result += counts.unassigned() + counts.suspended();
                }
                break;
            }
        }
        return result;
    }

    public void mustBeOnline(TableId tableId) throws ThriftTableOperationException {
        ServerContext context = this.getContext();
        context.clearTableListCache();
        if (context.getTableState(tableId) != TableState.ONLINE) {
            throw new ThriftTableOperationException(tableId.canonical(), null, TableOperation.MERGE, TableOperationExceptionType.OFFLINE, "table is not online");
        }
    }

    public TableManager getTableManager() {
        return this.getContext().getTableManager();
    }

    public static void main(String[] args) throws Exception {
        try (Manager manager = new Manager(new ConfigOpts(), args);){
            manager.runServer();
        }
    }

    Manager(ConfigOpts opts, String[] args) throws IOException {
        super("manager", opts, args);
        ServerContext context = super.getContext();
        this.balancerEnvironment = new BalancerEnvironmentImpl(context);
        AccumuloConfiguration aconf = context.getConfiguration();
        log.info("Version {}", (Object)"3.0.0");
        log.info("Instance {}", (Object)this.getInstanceID());
        this.timeKeeper = new ManagerTime(this, aconf);
        this.tserverSet = new LiveTServerSet(context, (LiveTServerSet.Listener)this);
        this.initializeBalancer();
        this.security = context.getSecurityOperation();
        long tokenLifetime = aconf.getTimeInMillis(Property.GENERAL_DELEGATION_TOKEN_LIFETIME);
        this.authenticationTokenKeyManager = null;
        this.keyDistributor = null;
        if (this.getConfiguration().getBoolean(Property.INSTANCE_RPC_SASL_ENABLED)) {
            log.info("SASL is enabled, creating delegation token key manager and distributor");
            long tokenUpdateInterval = aconf.getTimeInMillis(Property.GENERAL_DELEGATION_TOKEN_UPDATE_INTERVAL);
            this.keyDistributor = new ZooAuthenticationKeyDistributor(context.getZooReaderWriter(), this.getZooKeeperRoot() + "/delegation_token_keys");
            this.authenticationTokenKeyManager = new AuthenticationTokenKeyManager(context.getSecretManager(), this.keyDistributor, tokenUpdateInterval, tokenLifetime);
            this.delegationTokensAvailable = true;
        } else {
            log.info("SASL is not enabled, delegation tokens will not be available");
            this.delegationTokensAvailable = false;
        }
        this.timeToCacheRecoveryWalExistence = aconf.getTimeInMillis(Property.MANAGER_RECOVERY_WAL_EXISTENCE_CACHE_TIME);
    }

    public InstanceId getInstanceID() {
        return this.getContext().getInstanceID();
    }

    public String getZooKeeperRoot() {
        return this.getContext().getZooKeeperRoot();
    }

    public LiveTServerSet.TServerConnection getConnection(TServerInstance server) {
        return this.tserverSet.getConnection(server);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MergeInfo getMergeInfo(TableId tableId) {
        ServerContext context = this.getContext();
        Object object = this.mergeLock;
        synchronized (object) {
            try {
                String path = this.getZooKeeperRoot() + "/tables/" + tableId + "/merge";
                if (!context.getZooReaderWriter().exists(path)) {
                    return new MergeInfo();
                }
                byte[] data = context.getZooReaderWriter().getData(path);
                DataInputBuffer in = new DataInputBuffer();
                in.reset(data, data.length);
                MergeInfo info = new MergeInfo();
                info.readFields((DataInput)in);
                return info;
            }
            catch (KeeperException.NoNodeException ex) {
                log.info("Error reading merge state, it probably just finished");
                return new MergeInfo();
            }
            catch (Exception ex) {
                log.warn("Unexpected error reading merge state", (Throwable)ex);
                return new MergeInfo();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMergeState(MergeInfo info, MergeState state) throws KeeperException, InterruptedException {
        ServerContext context = this.getContext();
        Object object = this.mergeLock;
        synchronized (object) {
            String path = this.getZooKeeperRoot() + "/tables/" + info.getExtent().tableId() + "/merge";
            info.setState(state);
            if (state.equals((Object)MergeState.NONE)) {
                context.getZooReaderWriter().recursiveDelete(path, ZooUtil.NodeMissingPolicy.SKIP);
            } else {
                DataOutputBuffer out = new DataOutputBuffer();
                try {
                    info.write((DataOutput)out);
                }
                catch (IOException ex) {
                    throw new AssertionError("Unlikely", ex);
                }
                context.getZooReaderWriter().putPersistentData(path, out.getData(), state.equals((Object)MergeState.STARTED) ? ZooUtil.NodeExistsPolicy.FAIL : ZooUtil.NodeExistsPolicy.OVERWRITE);
            }
            this.mergeLock.notifyAll();
        }
        this.nextEvent.event("Merge state of %s set to %s", info.getExtent(), state);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearMergeState(TableId tableId) throws KeeperException, InterruptedException {
        Object object = this.mergeLock;
        synchronized (object) {
            String path = this.getZooKeeperRoot() + "/tables/" + tableId + "/merge";
            this.getContext().getZooReaderWriter().recursiveDelete(path, ZooUtil.NodeMissingPolicy.SKIP);
            this.mergeLock.notifyAll();
        }
        this.nextEvent.event("Merge state of %s cleared", tableId);
    }

    void setManagerGoalState(ManagerGoalState state) {
        try {
            this.getContext().getZooReaderWriter().putPersistentData(this.getZooKeeperRoot() + "/managers/goal_state", state.name().getBytes(), ZooUtil.NodeExistsPolicy.OVERWRITE);
        }
        catch (Exception ex) {
            log.error("Unable to set manager goal state in zookeeper");
        }
    }

    ManagerGoalState getManagerGoalState() {
        while (true) {
            try {
                byte[] data = this.getContext().getZooReaderWriter().getData(this.getZooKeeperRoot() + "/managers/goal_state");
                return ManagerGoalState.valueOf((String)new String(data));
            }
            catch (Exception e) {
                log.error("Problem getting real goal state from zookeeper: ", (Throwable)e);
                Uninterruptibles.sleepUninterruptibly((long)1L, (TimeUnit)TimeUnit.SECONDS);
                continue;
            }
            break;
        }
    }

    public boolean hasCycled(long time) {
        for (TabletGroupWatcher watcher : this.watchers) {
            if (watcher.stats.lastScanFinished() >= time) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearMigrations(TableId tableId) {
        SortedMap<KeyExtent, TServerInstance> sortedMap = this.migrations;
        synchronized (sortedMap) {
            this.migrations.keySet().removeIf(extent -> extent.tableId().equals((Object)tableId));
        }
    }

    TabletGoalState getSystemGoalState(TabletLocationState tls) {
        switch (this.getManagerState()) {
            case NORMAL: {
                return TabletGoalState.HOSTED;
            }
            case SAFE_MODE: 
            case HAVE_LOCK: 
            case INITIAL: {
                if (tls.extent.isMeta()) {
                    return TabletGoalState.HOSTED;
                }
                return TabletGoalState.UNASSIGNED;
            }
            case UNLOAD_METADATA_TABLETS: {
                if (tls.extent.isRootTablet()) {
                    return TabletGoalState.HOSTED;
                }
                return TabletGoalState.UNASSIGNED;
            }
            case UNLOAD_ROOT_TABLET: {
                return TabletGoalState.UNASSIGNED;
            }
            case STOP: {
                return TabletGoalState.UNASSIGNED;
            }
        }
        throw new IllegalStateException("Unknown Manager State");
    }

    TabletGoalState getTableGoalState(KeyExtent extent) {
        TableState tableState = this.getContext().getTableManager().getTableState(extent.tableId());
        if (tableState == null) {
            return TabletGoalState.DELETED;
        }
        switch (tableState) {
            case DELETING: {
                return TabletGoalState.DELETED;
            }
            case OFFLINE: 
            case NEW: {
                return TabletGoalState.UNASSIGNED;
            }
        }
        return TabletGoalState.HOSTED;
    }

    TabletGoalState getGoalState(TabletLocationState tls, MergeInfo mergeInfo) {
        KeyExtent extent = tls.extent;
        TabletGoalState state = this.getSystemGoalState(tls);
        if (state == TabletGoalState.HOSTED) {
            TServerInstance dest;
            if (!this.upgradeCoordinator.getStatus().isParentLevelUpgraded(extent)) {
                return TabletGoalState.UNASSIGNED;
            }
            if (tls.current != null && this.serversToShutdown.contains(tls.current.getServerInstance())) {
                return TabletGoalState.SUSPENDED;
            }
            if (mergeInfo.getExtent() != null) {
                boolean overlaps = mergeInfo.overlaps(extent);
                if (overlaps) {
                    log.debug("mergeInfo overlaps: {} true", (Object)extent);
                    switch (mergeInfo.getState()) {
                        case NONE: 
                        case COMPLETE: {
                            break;
                        }
                        case STARTED: 
                        case SPLITTING: {
                            return TabletGoalState.HOSTED;
                        }
                        case WAITING_FOR_CHOPPED: {
                            if (tls.getState(this.tserverSet.getCurrentServers()).equals((Object)TabletState.HOSTED) ? tls.chopped : tls.chopped && tls.walogs.isEmpty()) {
                                return TabletGoalState.UNASSIGNED;
                            }
                            return TabletGoalState.HOSTED;
                        }
                        case WAITING_FOR_OFFLINE: 
                        case MERGING: {
                            return TabletGoalState.UNASSIGNED;
                        }
                    }
                } else {
                    log.trace("mergeInfo overlaps: {} false", (Object)extent);
                }
            }
            if ((state = this.getTableGoalState(extent)) == TabletGoalState.HOSTED && (dest = (TServerInstance)this.migrations.get(extent)) != null && tls.current != null && !dest.equals((Object)tls.current.getServerInstance())) {
                return TabletGoalState.UNASSIGNED;
            }
        }
        return state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SortedMap<TServerInstance, TabletServerStatus> gatherTableInformation(Set<TServerInstance> currentServers, SortedMap<TabletServerId, TServerStatus> balancerMap) {
        long rpcTimeout = this.getConfiguration().getTimeInMillis(Property.GENERAL_RPC_TIMEOUT);
        int threads = this.getConfiguration().getCount(Property.MANAGER_STATUS_THREAD_POOL_SIZE);
        long start = System.currentTimeMillis();
        ConcurrentSkipListMap result = new ConcurrentSkipListMap();
        RateLimiter shutdownServerRateLimiter = RateLimiter.create((double)0.16666666666666666);
        ArrayList tasks = new ArrayList();
        Iterator<TServerInstance> iterator = currentServers.iterator();
        while (iterator.hasNext()) {
            TServerInstance serverInstance;
            TServerInstance server = serverInstance = iterator.next();
            if (threads == 0) {
                Uninterruptibles.sleepUninterruptibly((long)Math.max(1L, rpcTimeout / 120000L), (TimeUnit)TimeUnit.MILLISECONDS);
            }
            tasks.add(this.tableInformationStatusPool.submit(() -> {
                block12: {
                    try {
                        Thread t = Thread.currentThread();
                        String oldName = t.getName();
                        try {
                            String message = "Getting status from " + server;
                            t.setName(message);
                            long startForServer = System.currentTimeMillis();
                            log.trace(message);
                            LiveTServerSet.TServerConnection connection1 = this.tserverSet.getConnection(server);
                            if (connection1 == null) {
                                throw new IOException("No connection to " + server);
                            }
                            TabletServerStatus status = connection1.getTableMap(false);
                            result.put(server, status);
                            long duration = System.currentTimeMillis() - startForServer;
                            log.trace("Got status from {} in {} ms", (Object)server, (Object)duration);
                        }
                        finally {
                            t.setName(oldName);
                        }
                    }
                    catch (Exception ex) {
                        log.error("unable to get tablet server status {} {}", (Object)server, (Object)ex.toString());
                        log.debug("unable to get tablet server status {}", (Object)server, (Object)ex);
                        if (this.badServers.computeIfAbsent(server, k -> new AtomicInteger(0)).incrementAndGet() <= 3) break block12;
                        if (shutdownServerRateLimiter.tryAcquire()) {
                            log.warn("attempting to stop {}", (Object)server);
                            try {
                                LiveTServerSet.TServerConnection connection2 = this.tserverSet.getConnection(server);
                                if (connection2 != null) {
                                    connection2.halt(this.managerLock);
                                }
                            }
                            catch (TTransportException connection2) {
                            }
                            catch (Exception e2) {
                                log.info("error talking to troublesome tablet server", (Throwable)e2);
                            }
                        } else {
                            log.warn("Unable to shutdown {} as over the shutdown limit of {} per minute", (Object)server, (Object)10.0);
                        }
                        this.badServers.remove(server);
                    }
                }
            }));
        }
        long nanosToWait = Math.max(TimeUnit.SECONDS.toNanos(10L), TimeUnit.MILLISECONDS.toNanos(rpcTimeout) / 3L);
        long startTime = System.nanoTime();
        while (!tasks.isEmpty()) {
            boolean cancel = System.nanoTime() - startTime > nanosToWait;
            Iterator iter = tasks.iterator();
            while (iter.hasNext()) {
                Future f = (Future)iter.next();
                if (cancel) {
                    f.cancel(true);
                    continue;
                }
                if (!f.isDone()) continue;
                iter.remove();
            }
            Uninterruptibles.sleepUninterruptibly((long)1L, (TimeUnit)TimeUnit.MILLISECONDS);
        }
        ImmutableSortedMap info = ImmutableSortedMap.copyOf(result);
        this.tserverStatus.forEach((tsi, status) -> balancerMap.put((TabletServerId)new TabletServerIdImpl(tsi), (TServerStatus)TServerStatusImpl.fromThrift((TabletServerStatus)status)));
        Map<TServerInstance, AtomicInteger> map = this.badServers;
        synchronized (map) {
            this.badServers.keySet().retainAll(currentServers);
            this.badServers.keySet().removeAll(info.keySet());
        }
        log.debug(String.format("Finished gathering information from %d of %d servers in %.2f seconds", info.size(), currentServers.size(), (double)(System.currentTimeMillis() - start) / 1000.0));
        return info;
    }

    public void run() {
        ServerAddress sa;
        ServerContext context = this.getContext();
        final String zroot = this.getZooKeeperRoot();
        this.fateServiceHandler = new FateServiceHandler(this);
        this.managerClientHandler = new ManagerClientServiceHandler(this);
        ManagerClientService.Iface haProxy = (ManagerClientService.Iface)HighlyAvailableServiceWrapper.service((Object)this.managerClientHandler, (HighlyAvailableService)this);
        TMultiplexedProcessor processor = ThriftProcessorTypes.getManagerTProcessor((FateService.Iface)this.fateServiceHandler, (ManagerClientService.Iface)haProxy, (ServerContext)this.getContext());
        try {
            sa = TServerUtils.startServer((ServerContext)context, (String)this.getHostname(), (Property)Property.MANAGER_CLIENTPORT, (TProcessor)processor, (String)"Manager", (String)"Manager Client Service Handler", null, (Property)Property.MANAGER_MINTHREADS, (Property)Property.MANAGER_MINTHREADS_TIMEOUT, (Property)Property.MANAGER_THREADCHECK, (Property)Property.GENERAL_MAX_MESSAGE_SIZE);
        }
        catch (UnknownHostException e) {
            throw new IllegalStateException("Unable to start server on host " + this.getHostname(), e);
        }
        this.clientService = sa.server;
        log.info("Started Manager client service at {}", (Object)sa.address);
        ServiceLockData sld = null;
        try {
            sld = this.getManagerLock(ServiceLock.path((String)(zroot + "/managers/lock")));
        }
        catch (InterruptedException | KeeperException e) {
            throw new IllegalStateException("Exception getting manager lock", e);
        }
        if (this.upgradeCoordinator.getStatus() != UpgradeCoordinator.UpgradeStatus.COMPLETE) {
            this.managerUpgrading.set(true);
        }
        try {
            MetricsUtil.initializeMetrics((AccumuloConfiguration)this.getContext().getConfiguration(), (String)this.applicationName, (HostAndPort)sa.getAddress());
            ManagerMetrics mm = new ManagerMetrics(this.getConfiguration(), this);
            MetricsUtil.initializeProducers((MetricsProducer[])new MetricsProducer[]{this, mm});
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e1) {
            log.error("Error initializing metrics, metrics will not be emitted.", (Throwable)e1);
        }
        this.recoveryManager = new RecoveryManager(this, this.timeToCacheRecoveryWalExistence);
        context.getTableManager().addObserver((TableObserver)this);
        this.tableInformationStatusPool = ThreadPools.getServerThreadPools().createExecutorService(this.getConfiguration(), Property.MANAGER_STATUS_THREAD_POOL_SIZE, false);
        Thread statusThread = Threads.createThread((String)"Status Thread", (Runnable)new StatusThread());
        statusThread.start();
        Threads.createThread((String)"Migration Cleanup Thread", (Runnable)new MigrationCleanupThread()).start();
        this.tserverSet.startListeningForTabletServerChanges();
        try {
            this.blockForTservers();
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
        final ZooReaderWriter zReaderWriter = context.getZooReaderWriter();
        try {
            zReaderWriter.getChildren(zroot + "/recovery", new Watcher(){

                public void process(WatchedEvent event) {
                    Manager.this.nextEvent.event("Noticed recovery changes %s", event.getType());
                    try {
                        zReaderWriter.getChildren(zroot + "/recovery", (Watcher)this);
                    }
                    catch (Exception e) {
                        log.error("Failed to add log recovery watcher back", (Throwable)e);
                    }
                }
            });
        }
        catch (InterruptedException | KeeperException e) {
            throw new IllegalStateException("Unable to read " + zroot + "/recovery", e);
        }
        this.watchers.add(new TabletGroupWatcher(this, TabletStateStore.getStoreForLevel((Ample.DataLevel)Ample.DataLevel.USER, (ClientContext)context, (CurrentState)this), null){

            @Override
            boolean canSuspendTablets() {
                return true;
            }
        });
        this.watchers.add(new TabletGroupWatcher(this, TabletStateStore.getStoreForLevel((Ample.DataLevel)Ample.DataLevel.METADATA, (ClientContext)context, (CurrentState)this), this.watchers.get(0)){

            @Override
            boolean canSuspendTablets() {
                return Manager.this.getConfiguration().getBoolean(Property.MANAGER_METADATA_SUSPENDABLE);
            }
        });
        this.watchers.add(new TabletGroupWatcher(this, TabletStateStore.getStoreForLevel((Ample.DataLevel)Ample.DataLevel.ROOT, (ClientContext)context), this.watchers.get(1)){

            @Override
            boolean canSuspendTablets() {
                return false;
            }
        });
        for (TabletGroupWatcher watcher : this.watchers) {
            watcher.start();
        }
        try {
            if (null != this.upgradeMetadataFuture) {
                this.upgradeMetadataFuture.get();
            }
            this.managerUpgrading.set(false);
        }
        catch (InterruptedException | ExecutionException e) {
            throw new IllegalStateException("Metadata upgrade failed", e);
        }
        try {
            AgeOffStore store = new AgeOffStore(new ZooStore(this.getZooKeeperRoot() + "/fate", context.getZooReaderWriter()), TimeUnit.HOURS.toMillis(8L), System::currentTimeMillis);
            Fate f = new Fate((Object)this, (TStore)store, TraceRepo::toLogString, this.getConfiguration());
            this.fateRef.set((Fate<Manager>)f);
            this.fateReadyLatch.countDown();
            ThreadPools.watchCriticalScheduledTask(context.getScheduledExecutor().scheduleWithFixedDelay(() -> ((AgeOffStore)store).ageOff(), 63000L, 63000L, TimeUnit.MILLISECONDS));
        }
        catch (InterruptedException | KeeperException e) {
            throw new IllegalStateException("Exception setting up FaTE cleanup thread", e);
        }
        ThreadPools.watchCriticalScheduledTask(context.getScheduledExecutor().scheduleWithFixedDelay(() -> ScanServerMetadataEntries.clean((ServerContext)context), 10L, 10L, TimeUnit.MINUTES));
        Thread authenticationTokenKeyManagerThread = null;
        if (this.authenticationTokenKeyManager != null && this.keyDistributor != null) {
            log.info("Starting delegation-token key manager");
            try {
                this.keyDistributor.initialize();
            }
            catch (InterruptedException | KeeperException e) {
                throw new IllegalStateException("Exception setting up delegation-token key manager", e);
            }
            authenticationTokenKeyManagerThread = Threads.createThread((String)"Delegation Token Key Manager", (Runnable)this.authenticationTokenKeyManager);
            authenticationTokenKeyManagerThread.start();
            boolean logged = false;
            while (!this.authenticationTokenKeyManager.isInitialized()) {
                if (!logged) {
                    log.info("Waiting for AuthenticationTokenKeyManager to be initialized");
                    logged = true;
                }
                Uninterruptibles.sleepUninterruptibly((long)200L, (TimeUnit)TimeUnit.MILLISECONDS);
            }
            log.info("AuthenticationTokenSecretManager is initialized");
        }
        String address = sa.address.toString();
        sld = new ServiceLockData(sld.getServerUUID(ServiceLockData.ThriftService.MANAGER), address, ServiceLockData.ThriftService.MANAGER);
        log.info("Setting manager lock data to {}", (Object)sld.toString());
        try {
            this.managerLock.replaceLockData(sld);
        }
        catch (InterruptedException | KeeperException e) {
            throw new IllegalStateException("Exception updating manager lock", e);
        }
        while (!this.clientService.isServing()) {
            Uninterruptibles.sleepUninterruptibly((long)100L, (TimeUnit)TimeUnit.MILLISECONDS);
        }
        this.managerInitialized.set(true);
        while (this.clientService.isServing()) {
            Uninterruptibles.sleepUninterruptibly((long)500L, (TimeUnit)TimeUnit.MILLISECONDS);
        }
        log.info("Shutting down fate.");
        this.fate().shutdown();
        long deadline = System.currentTimeMillis() + 1000L;
        try {
            statusThread.join(this.remaining(deadline));
        }
        catch (InterruptedException e) {
            throw new IllegalStateException("Exception stopping status thread", e);
        }
        this.tableInformationStatusPool.shutdownNow();
        if (this.authenticationTokenKeyManager != null) {
            this.authenticationTokenKeyManager.gracefulStop();
            try {
                if (null != authenticationTokenKeyManagerThread) {
                    authenticationTokenKeyManagerThread.join(this.remaining(deadline));
                }
            }
            catch (InterruptedException e) {
                throw new IllegalStateException("Exception waiting on delegation-token key manager", e);
            }
        }
        for (TabletGroupWatcher watcher : this.watchers) {
            try {
                watcher.join(this.remaining(deadline));
            }
            catch (InterruptedException e) {
                throw new IllegalStateException("Exception waiting on watcher", e);
            }
        }
        log.info("exiting");
    }

    private void blockForTservers() throws InterruptedException {
        boolean needTservers;
        long initialWait;
        long waitStart = System.nanoTime();
        long minTserverCount = this.getConfiguration().getCount(Property.MANAGER_STARTUP_TSERVER_AVAIL_MIN_COUNT);
        if (minTserverCount <= 0L) {
            log.info("tserver availability check disabled, continuing with-{} servers. To enable, set {}", (Object)this.tserverSet.size(), (Object)Property.MANAGER_STARTUP_TSERVER_AVAIL_MIN_COUNT.getKey());
            return;
        }
        long userWait = TimeUnit.MILLISECONDS.toSeconds(this.getConfiguration().getTimeInMillis(Property.MANAGER_STARTUP_TSERVER_AVAIL_MAX_WAIT));
        long retries = 10L;
        long maxWaitPeriod = initialWait = userWait / retries;
        long waitIncrement = 0L;
        if (userWait <= 0L) {
            log.info("tserver availability check set to block indefinitely, To change, set {} > 0.", (Object)Property.MANAGER_STARTUP_TSERVER_AVAIL_MAX_WAIT.getKey());
            retries = userWait = Long.MAX_VALUE;
            initialWait = 1L;
            maxWaitPeriod = 30L;
            waitIncrement = 5L;
        }
        Retry tserverRetry = Retry.builder().maxRetries(retries).retryAfter(initialWait, TimeUnit.SECONDS).incrementBy(waitIncrement, TimeUnit.SECONDS).maxWait(maxWaitPeriod, TimeUnit.SECONDS).backOffFactor(1.0).logInterval(30L, TimeUnit.SECONDS).createRetry();
        log.info("Checking for tserver availability - need to reach {} servers. Have {}", (Object)minTserverCount, (Object)this.tserverSet.size());
        boolean bl = needTservers = (long)this.tserverSet.size() < minTserverCount;
        while (needTservers && tserverRetry.canRetry()) {
            tserverRetry.waitForNextAttempt(log, "block until minimum tservers reached");
            boolean bl2 = needTservers = (long)this.tserverSet.size() < minTserverCount;
            if (needTservers) {
                tserverRetry.logRetry(log, String.format("Blocking for tserver availability - need to reach %s servers. Have %s Time spent blocking %s seconds.", minTserverCount, this.tserverSet.size(), TimeUnit.NANOSECONDS.toSeconds(System.nanoTime() - waitStart)));
            }
            tserverRetry.useRetry();
        }
        if ((long)this.tserverSet.size() < minTserverCount) {
            log.warn("tserver availability check time expired - continuing. Requested {}, have {} tservers on line.  Time waiting {} sec", new Object[]{this.tserverSet.size(), minTserverCount, TimeUnit.NANOSECONDS.toSeconds(System.nanoTime() - waitStart)});
        } else {
            log.info("tserver availability check completed. Requested {}, have {} tservers on line.  Time waiting {} sec", new Object[]{this.tserverSet.size(), minTserverCount, TimeUnit.NANOSECONDS.toSeconds(System.nanoTime() - waitStart)});
        }
    }

    private long remaining(long deadline) {
        return Math.max(1L, deadline - System.currentTimeMillis());
    }

    public ServiceLock getManagerLock() {
        return this.managerLock;
    }

    private ServiceLockData getManagerLock(ServiceLock.ServiceLockPath zManagerLoc) throws KeeperException, InterruptedException {
        ZooKeeper zooKeeper = this.getContext().getZooReaderWriter().getZooKeeper();
        log.info("trying to get manager lock");
        String managerClientAddress = this.getHostname() + ":" + this.getConfiguration().getPort(Property.MANAGER_CLIENTPORT)[0];
        UUID zooLockUUID = UUID.randomUUID();
        ServiceLockData sld = new ServiceLockData(zooLockUUID, managerClientAddress, ServiceLockData.ThriftService.MANAGER);
        while (true) {
            ManagerLockWatcher managerLockWatcher = new ManagerLockWatcher();
            this.managerLock = new ServiceLock(zooKeeper, zManagerLoc, zooLockUUID);
            this.managerLock.lock((ServiceLock.AccumuloLockWatcher)managerLockWatcher, sld);
            managerLockWatcher.waitForChange();
            if (managerLockWatcher.acquiredLock) break;
            if (!managerLockWatcher.failedToAcquireLock) {
                throw new IllegalStateException("manager lock in unknown state");
            }
            this.managerLock.tryToCancelAsyncLockOrUnlock();
            Uninterruptibles.sleepUninterruptibly((long)1000L, (TimeUnit)TimeUnit.MILLISECONDS);
        }
        this.setManagerState(ManagerState.HAVE_LOCK);
        return sld;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(LiveTServerSet current, Set<TServerInstance> deleted, Set<TServerInstance> added) {
        if (!deleted.isEmpty() || !added.isEmpty()) {
            DeadServerList obit = new DeadServerList(this.getContext());
            if (!added.isEmpty()) {
                log.info("New servers: {}", added);
                for (TServerInstance up : added) {
                    obit.delete(up.getHostPort());
                }
            }
            for (TServerInstance dead : deleted) {
                String cause = "unexpected failure";
                if (this.serversToShutdown.contains(dead)) {
                    cause = "clean shutdown";
                }
                if (this.getManagerGoalState().equals((Object)ManagerGoalState.CLEAN_STOP)) continue;
                obit.post(dead.getHostPort(), cause);
            }
            HashSet<TServerInstance> unexpected = new HashSet<TServerInstance>(deleted);
            unexpected.removeAll(this.serversToShutdown);
            if (!unexpected.isEmpty() && this.stillManager() && !this.getManagerGoalState().equals((Object)ManagerGoalState.CLEAN_STOP)) {
                log.warn("Lost servers {}", unexpected);
            }
            this.serversToShutdown.removeAll(deleted);
            this.badServers.keySet().removeAll(deleted);
            SortedMap<KeyExtent, TServerInstance> sortedMap = this.badServers;
            synchronized (sortedMap) {
                Manager.cleanListByHostAndPort(this.badServers.keySet(), deleted, added);
            }
            sortedMap = this.serversToShutdown;
            synchronized (sortedMap) {
                Manager.cleanListByHostAndPort(this.serversToShutdown, deleted, added);
            }
            sortedMap = this.migrations;
            synchronized (sortedMap) {
                Iterator<Map.Entry<KeyExtent, TServerInstance>> iter = this.migrations.entrySet().iterator();
                while (iter.hasNext()) {
                    Map.Entry<KeyExtent, TServerInstance> entry = iter.next();
                    if (!deleted.contains(entry.getValue())) continue;
                    log.info("Canceling migration of {} to {}", (Object)entry.getKey(), (Object)entry.getValue());
                    iter.remove();
                }
            }
            this.nextEvent.event("There are now %d tablet servers", current.size());
        }
        this.serversToShutdown.retainAll(current.getCurrentServers());
    }

    private static void cleanListByHostAndPort(Collection<TServerInstance> badServers, Set<TServerInstance> deleted, Set<TServerInstance> added) {
        Iterator<TServerInstance> badIter = badServers.iterator();
        block0: while (badIter.hasNext()) {
            TServerInstance bad = badIter.next();
            for (TServerInstance add : added) {
                if (!bad.getHostPort().equals(add.getHostPort())) continue;
                badIter.remove();
                break;
            }
            for (TServerInstance del : deleted) {
                if (!bad.getHostPort().equals(del.getHostPort())) continue;
                badIter.remove();
                continue block0;
            }
        }
    }

    public void stateChanged(TableId tableId, TableState state) {
        this.nextEvent.event("Table state in zookeeper changed for %s to %s", tableId, state);
        if (state == TableState.OFFLINE) {
            this.clearMigrations(tableId);
        }
    }

    public void initialize() {
    }

    public void sessionExpired() {
    }

    public Set<TableId> onlineTables() {
        HashSet<TableId> result = new HashSet<TableId>();
        if (this.getManagerState() != ManagerState.NORMAL) {
            if (this.getManagerState() != ManagerState.UNLOAD_METADATA_TABLETS) {
                result.add(MetadataTable.ID);
            }
            if (this.getManagerState() != ManagerState.UNLOAD_ROOT_TABLET) {
                result.add(RootTable.ID);
            }
            return result;
        }
        ServerContext context = this.getContext();
        TableManager manager = context.getTableManager();
        for (TableId tableId : context.getTableIdToNameMap().keySet()) {
            TableState state = manager.getTableState(tableId);
            if (state == null || state != TableState.ONLINE) continue;
            result.add(tableId);
        }
        return result;
    }

    public Set<TServerInstance> onlineTabletServers() {
        return this.tserverSet.getCurrentServers();
    }

    public Collection<MergeInfo> merges() {
        ArrayList<MergeInfo> result = new ArrayList<MergeInfo>();
        for (TableId tableId : this.getContext().getTableIdToNameMap().keySet()) {
            result.add(this.getMergeInfo(tableId));
        }
        return result;
    }

    public void shutdownTServer(TServerInstance server) {
        this.nextEvent.event("Tablet Server shutdown requested for %s", server);
        this.serversToShutdown.add(server);
    }

    public EventCoordinator getEventCoordinator() {
        return this.nextEvent;
    }

    public VolumeManager getVolumeManager() {
        return this.getContext().getVolumeManager();
    }

    public void assignedTablet(KeyExtent extent) {
        if (extent.isMeta() && this.getManagerState().equals((Object)ManagerState.UNLOAD_ROOT_TABLET)) {
            this.setManagerState(ManagerState.UNLOAD_METADATA_TABLETS);
        }
        if (extent.isRootTablet() && this.getManagerState().equals((Object)ManagerState.STOP)) {
            this.setManagerState(ManagerState.UNLOAD_ROOT_TABLET);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"UW_UNCOND_WAIT"}, justification="TODO needs triage")
    public void waitForBalance() {
        Object object = this.balancedNotifier;
        synchronized (object) {
            long eventCounter;
            do {
                eventCounter = this.nextEvent.waitForEvents(0L, 0L);
                try {
                    this.balancedNotifier.wait();
                }
                catch (InterruptedException e) {
                    log.debug(e.toString(), (Throwable)e);
                }
            } while (this.displayUnassigned() > 0 || !this.migrations.isEmpty() || eventCounter != this.nextEvent.waitForEvents(0L, 0L));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ManagerMonitorInfo getManagerMonitorInfo() {
        ManagerMonitorInfo result = new ManagerMonitorInfo();
        result.tServerInfo = new ArrayList();
        result.tableMap = new HashMap();
        for (Map.Entry<TServerInstance, TabletServerStatus> serverEntry : this.tserverStatus.entrySet()) {
            TabletServerStatus status = serverEntry.getValue();
            result.tServerInfo.add(status);
            for (Map.Entry entry : status.tableMap.entrySet()) {
                TableInfoUtil.add((TableInfo)result.tableMap.computeIfAbsent((String)entry.getKey(), k -> new TableInfo()), (TableInfo)((TableInfo)entry.getValue()));
            }
        }
        result.badTServers = new HashMap();
        Set<TServerInstance> set = this.badServers;
        synchronized (set) {
            for (TServerInstance bad : this.badServers.keySet()) {
                result.badTServers.put(bad.getHostPort(), TabletServerState.UNRESPONSIVE.getId());
            }
        }
        result.state = this.getManagerState();
        result.goalState = this.getManagerGoalState();
        result.unassignedTablets = this.displayUnassigned();
        result.serversShuttingDown = new HashSet();
        set = this.serversToShutdown;
        synchronized (set) {
            for (TServerInstance server : this.serversToShutdown) {
                result.serversShuttingDown.add(server.getHostPort());
            }
        }
        DeadServerList obit = new DeadServerList(this.getContext());
        result.deadTabletServers = obit.getList();
        result.bulkImports = this.bulkImportStatus.getBulkLoadStatus();
        return result;
    }

    public boolean delegationTokensAvailable() {
        return this.delegationTokensAvailable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<KeyExtent> migrationsSnapshot() {
        HashSet<KeyExtent> migrationKeys;
        SortedMap<KeyExtent, TServerInstance> sortedMap = this.migrations;
        synchronized (sortedMap) {
            migrationKeys = new HashSet<KeyExtent>(this.migrations.keySet());
        }
        return Collections.unmodifiableSet(migrationKeys);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<TServerInstance> shutdownServers() {
        Set<TServerInstance> set = this.serversToShutdown;
        synchronized (set) {
            return new HashSet<TServerInstance>(this.serversToShutdown);
        }
    }

    public void updateBulkImportStatus(String directory, BulkImportState state) {
        this.bulkImportStatus.updateBulkImportStatus(Collections.singletonList(directory), state);
    }

    public void removeBulkImportStatus(String directory) {
        this.bulkImportStatus.removeBulkImportStatus(Collections.singletonList(directory));
    }

    public Long getSteadyTime() {
        return this.timeKeeper.getTime();
    }

    public boolean isActiveService() {
        return this.managerInitialized.get();
    }

    public boolean isUpgrading() {
        return this.managerUpgrading.get();
    }

    void initializeBalancer() {
        TabletBalancer localTabletBalancer = (TabletBalancer)Property.createInstanceFromPropertyName((AccumuloConfiguration)this.getConfiguration(), (Property)Property.MANAGER_TABLET_BALANCER, TabletBalancer.class, (Object)new SimpleLoadBalancer());
        localTabletBalancer.init(this.balancerEnvironment);
        this.tabletBalancer = localTabletBalancer;
    }

    Class<?> getBalancerClass() {
        return this.tabletBalancer.getClass();
    }

    void getAssignments(SortedMap<TServerInstance, TabletServerStatus> currentStatus, Map<KeyExtent, UnassignedTablet> unassigned, Map<KeyExtent, TServerInstance> assignedOut) {
        AssignmentParamsImpl params = AssignmentParamsImpl.fromThrift(currentStatus, (Map)unassigned.entrySet().stream().collect(HashMap::new, (m, e) -> m.put((KeyExtent)e.getKey(), ((UnassignedTablet)e.getValue()).getServerInstance()), Map::putAll), assignedOut);
        this.tabletBalancer.getAssignments((TabletBalancer.AssignmentParameters)params);
    }

    private static class ManagerLockWatcher
    implements ServiceLock.AccumuloLockWatcher {
        boolean acquiredLock = false;
        boolean failedToAcquireLock = false;

        private ManagerLockWatcher() {
        }

        public void lostLock(ServiceLock.LockLossReason reason) {
            Halt.halt((String)("Manager lock in zookeeper lost (reason = " + reason + "), exiting!"), (int)-1);
        }

        public void unableToMonitorLockNode(Exception e) {
            Halt.halt((int)-1, () -> log.error("FATAL: No longer able to monitor manager lock node", (Throwable)e));
        }

        public synchronized void acquiredLock() {
            log.debug("Acquired manager lock");
            if (this.acquiredLock || this.failedToAcquireLock) {
                Halt.halt((String)("Zoolock in unexpected state AL " + this.acquiredLock + " " + this.failedToAcquireLock), (int)-1);
            }
            this.acquiredLock = true;
            this.notifyAll();
        }

        public synchronized void failedToAcquireLock(Exception e) {
            log.warn("Failed to get manager lock", (Throwable)e);
            if (e instanceof KeeperException.NoAuthException) {
                String msg = "Failed to acquire manager lock due to incorrect ZooKeeper authentication.";
                log.error("{} Ensure instance.secret is consistent across Accumulo configuration", (Object)msg, (Object)e);
                Halt.halt((String)msg, (int)-1);
            }
            if (this.acquiredLock) {
                Halt.halt((String)("Zoolock in unexpected state FAL " + this.acquiredLock + " " + this.failedToAcquireLock), (int)-1);
            }
            this.failedToAcquireLock = true;
            this.notifyAll();
        }

        public synchronized void waitForChange() {
            while (!this.acquiredLock && !this.failedToAcquireLock) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    private class StatusThread
    implements Runnable {
        private StatusThread() {
        }

        private boolean goodStats() {
            switch (Manager.this.getManagerState()) {
                case UNLOAD_METADATA_TABLETS: {
                    int start = 1;
                    break;
                }
                case UNLOAD_ROOT_TABLET: {
                    int start = 2;
                    break;
                }
                default: {
                    int start = 0;
                }
            }
            for (int i = start; i < Manager.this.watchers.size(); ++i) {
                TabletGroupWatcher watcher = Manager.this.watchers.get(i);
                if (watcher.stats.getLastManagerState() == Manager.this.getManagerState()) continue;
                log.debug("{}: {} != {}", new Object[]{watcher.getName(), watcher.stats.getLastManagerState(), Manager.this.getManagerState()});
                return false;
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            EventCoordinator.Listener eventListener = Manager.this.nextEvent.getListener();
            while (Manager.this.stillManager()) {
                long wait = 10000L;
                try {
                    switch (Manager.this.getManagerGoalState()) {
                        case NORMAL: {
                            Manager.this.setManagerState(ManagerState.NORMAL);
                            break;
                        }
                        case SAFE_MODE: {
                            if (Manager.this.getManagerState() == ManagerState.NORMAL) {
                                Manager.this.setManagerState(ManagerState.SAFE_MODE);
                            }
                            if (Manager.this.getManagerState() == ManagerState.HAVE_LOCK) {
                                Manager.this.setManagerState(ManagerState.SAFE_MODE);
                            }
                            break;
                        }
                        case CLEAN_STOP: {
                            switch (Manager.this.getManagerState()) {
                                case NORMAL: {
                                    Manager.this.setManagerState(ManagerState.SAFE_MODE);
                                    break;
                                }
                                case SAFE_MODE: {
                                    int count = Manager.this.nonMetaDataTabletsAssignedOrHosted();
                                    log.debug(String.format("There are %d non-metadata tablets assigned or hosted", count));
                                    if (count != 0 || !this.goodStats()) break;
                                    Manager.this.setManagerState(ManagerState.UNLOAD_METADATA_TABLETS);
                                    break;
                                }
                                case UNLOAD_METADATA_TABLETS: {
                                    int count = Manager.this.assignedOrHosted(MetadataTable.ID);
                                    log.debug(String.format("There are %d metadata tablets assigned or hosted", count));
                                    if (count != 0 || !this.goodStats()) break;
                                    Manager.this.setManagerState(ManagerState.UNLOAD_ROOT_TABLET);
                                    break;
                                }
                                case UNLOAD_ROOT_TABLET: {
                                    int root_count;
                                    int count = Manager.this.assignedOrHosted(MetadataTable.ID);
                                    if (count > 0 && this.goodStats()) {
                                        log.debug(String.format("%d metadata tablets online", count));
                                        Manager.this.setManagerState(ManagerState.UNLOAD_ROOT_TABLET);
                                    }
                                    if ((root_count = Manager.this.assignedOrHosted(RootTable.ID)) > 0 && this.goodStats()) {
                                        log.debug("The root tablet is still assigned or hosted");
                                    }
                                    if (count + root_count != 0 || !this.goodStats()) break;
                                    Set currentServers = Manager.this.tserverSet.getCurrentServers();
                                    log.debug("stopping {} tablet servers", (Object)currentServers.size());
                                    for (TServerInstance server : currentServers) {
                                        try {
                                            Manager.this.serversToShutdown.add(server);
                                            Manager.this.tserverSet.getConnection(server).fastHalt(Manager.this.managerLock);
                                        }
                                        catch (TException tException) {}
                                        continue;
                                        finally {
                                            Manager.this.tserverSet.remove(server);
                                        }
                                    }
                                    if (!currentServers.isEmpty()) break;
                                    Manager.this.setManagerState(ManagerState.STOP);
                                    break;
                                }
                            }
                            break;
                        }
                    }
                }
                catch (Exception t) {
                    log.error("Error occurred reading / switching manager goal state. Will continue with attempt to update status", (Throwable)t);
                }
                Span span = TraceUtil.startSpan(this.getClass(), (String)"run::updateStatus");
                try {
                    Scope scope = span.makeCurrent();
                    try {
                        wait = this.updateStatus();
                        eventListener.waitForEvents(wait);
                        continue;
                    }
                    finally {
                        if (scope == null) continue;
                        scope.close();
                        continue;
                    }
                }
                catch (Exception t) {
                    TraceUtil.setException((Span)span, (Throwable)t, (boolean)false);
                    log.error("Error balancing tablets, will wait for {} (seconds) and then retry ", (Object)1L, (Object)t);
                    Uninterruptibles.sleepUninterruptibly((long)1000L, (TimeUnit)TimeUnit.MILLISECONDS);
                    continue;
                }
                finally {
                    span.end();
                    continue;
                }
                break;
            }
            return;
        }

        private long updateStatus() {
            Set currentServers = Manager.this.tserverSet.getCurrentServers();
            TreeMap<TabletServerId, TServerStatus> temp = new TreeMap<TabletServerId, TServerStatus>();
            Manager.this.tserverStatus = Manager.this.gatherTableInformation(currentServers, temp);
            Manager.this.tserverStatusForBalancer = Collections.unmodifiableSortedMap(temp);
            this.checkForHeldServer(Manager.this.tserverStatus);
            if (!Manager.this.badServers.isEmpty()) {
                log.debug("not balancing because the balance information is out-of-date {}", Manager.this.badServers.keySet());
            } else if (Manager.this.notHosted() > 0) {
                log.debug("not balancing because there are unhosted tablets: {}", (Object)Manager.this.notHosted());
            } else if (Manager.this.getManagerGoalState() == ManagerGoalState.CLEAN_STOP) {
                log.debug("not balancing because the manager is attempting to stop cleanly");
            } else if (!Manager.this.serversToShutdown.isEmpty()) {
                log.debug("not balancing while shutting down servers {}", Manager.this.serversToShutdown);
            } else {
                for (TabletGroupWatcher tgw : Manager.this.watchers) {
                    if (tgw.isSameTserversAsLastScan(currentServers)) continue;
                    log.debug("not balancing just yet, as collection of live tservers is in flux");
                    return 10000L;
                }
                return this.balanceTablets();
            }
            return 10000L;
        }

        private void checkForHeldServer(SortedMap<TServerInstance, TabletServerStatus> tserverStatus) {
            TServerInstance instance = null;
            int crazyHoldTime = 0;
            int someHoldTime = 0;
            long maxWait = Manager.this.getConfiguration().getTimeInMillis(Property.TSERV_HOLD_TIME_SUICIDE);
            for (Map.Entry<TServerInstance, TabletServerStatus> entry : tserverStatus.entrySet()) {
                if (entry.getValue().getHoldTime() <= 0L) continue;
                ++someHoldTime;
                if (entry.getValue().getHoldTime() <= maxWait) continue;
                instance = entry.getKey();
                ++crazyHoldTime;
            }
            if (crazyHoldTime == 1 && someHoldTime == 1 && tserverStatus.size() > 1) {
                log.warn("Tablet server {} exceeded maximum hold time: attempting to kill it", instance);
                try {
                    LiveTServerSet.TServerConnection connection = Manager.this.tserverSet.getConnection(instance);
                    if (connection != null) {
                        connection.fastHalt(Manager.this.managerLock);
                    }
                }
                catch (TException e) {
                    log.error("{}", (Object)e.getMessage(), (Object)e);
                }
                Manager.this.badServers.putIfAbsent(instance, new AtomicInteger(1));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private long balanceTablets() {
            BalanceParamsImpl params = BalanceParamsImpl.fromThrift(Manager.this.tserverStatusForBalancer, Manager.this.tserverStatus, Manager.this.migrationsSnapshot());
            long wait = Manager.this.tabletBalancer.balance((TabletBalancer.BalanceParameters)params);
            for (TabletMigration m : this.checkMigrationSanity(Manager.this.tserverStatusForBalancer.keySet(), params.migrationsOut())) {
                KeyExtent ke = KeyExtent.fromTabletId((TabletId)m.getTablet());
                if (Manager.this.migrations.containsKey(ke)) {
                    log.warn("balancer requested migration more than once, skipping {}", (Object)m);
                    continue;
                }
                TServerInstance tserverInstance = TabletServerIdImpl.toThrift((TabletServerId)m.getNewTabletServer());
                Manager.this.migrations.put(ke, tserverInstance);
                log.debug("migration {}", (Object)m);
            }
            if (params.migrationsOut().isEmpty()) {
                Object object = Manager.this.balancedNotifier;
                synchronized (object) {
                    Manager.this.balancedNotifier.notifyAll();
                }
            } else {
                Manager.this.nextEvent.event("Migrating %d more tablets, %d total", params.migrationsOut().size(), Manager.this.migrations.size());
            }
            return wait;
        }

        private List<TabletMigration> checkMigrationSanity(Set<TabletServerId> current, List<TabletMigration> migrations) {
            return migrations.stream().filter(m -> {
                boolean includeMigration = false;
                if (m.getTablet() == null) {
                    log.error("Balancer gave back a null tablet {}", m);
                } else if (m.getNewTabletServer() == null) {
                    log.error("Balancer did not set the destination {}", m);
                } else if (m.getOldTabletServer() == null) {
                    log.error("Balancer did not set the source {}", m);
                } else if (!current.contains(m.getOldTabletServer())) {
                    log.warn("Balancer wants to move a tablet from a server that is not current: {}", m);
                } else if (!current.contains(m.getNewTabletServer())) {
                    log.warn("Balancer wants to move a tablet to a server that is not current: {}", m);
                } else {
                    includeMigration = true;
                }
                return includeMigration;
            }).collect(Collectors.toList());
        }
    }

    private class MigrationCleanupThread
    implements Runnable {
        private MigrationCleanupThread() {
        }

        @Override
        public void run() {
            while (Manager.this.stillManager()) {
                if (!Manager.this.migrations.isEmpty()) {
                    try {
                        this.cleanupOfflineMigrations();
                        this.cleanupNonexistentMigrations((AccumuloClient)Manager.this.getContext());
                    }
                    catch (Exception ex) {
                        log.error("Error cleaning up migrations", (Throwable)ex);
                    }
                }
                Uninterruptibles.sleepUninterruptibly((long)300000L, (TimeUnit)TimeUnit.MILLISECONDS);
            }
        }

        private void cleanupNonexistentMigrations(AccumuloClient accumuloClient) throws TableNotFoundException {
            Scanner scanner = accumuloClient.createScanner(MetadataTable.NAME, Authorizations.EMPTY);
            MetadataSchema.TabletsSection.TabletColumnFamily.PREV_ROW_COLUMN.fetch((ScannerBase)scanner);
            HashSet<KeyExtent> found = new HashSet<KeyExtent>();
            for (Map.Entry entry : scanner) {
                KeyExtent extent = KeyExtent.fromMetaPrevRow((Map.Entry)entry);
                if (!Manager.this.migrations.containsKey(extent)) continue;
                found.add(extent);
            }
            Manager.this.migrations.keySet().retainAll(found);
        }

        private void cleanupOfflineMigrations() {
            ServerContext context = Manager.this.getContext();
            TableManager manager = context.getTableManager();
            for (TableId tableId : context.getTableIdToNameMap().keySet()) {
                TableState state = manager.getTableState(tableId);
                if (state != TableState.OFFLINE) continue;
                Manager.this.clearMigrations(tableId);
            }
        }
    }

    static enum TabletGoalState {
        HOSTED(TUnloadTabletGoal.UNKNOWN),
        UNASSIGNED(TUnloadTabletGoal.UNASSIGNED),
        DELETED(TUnloadTabletGoal.DELETED),
        SUSPENDED(TUnloadTabletGoal.SUSPENDED);

        private final TUnloadTabletGoal unloadGoal;

        private TabletGoalState(TUnloadTabletGoal unloadGoal) {
            this.unloadGoal = unloadGoal;
        }

        public TUnloadTabletGoal howUnload() {
            return this.unloadGoal;
        }
    }
}

