/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.manager.tableOps.bulkVer2;

import java.io.IOException;
import java.util.Collections;
import org.apache.accumulo.core.fate.FateTxId;
import org.apache.accumulo.core.fate.Repo;
import org.apache.accumulo.core.gc.ReferenceFile;
import org.apache.accumulo.core.manager.state.tables.TableState;
import org.apache.accumulo.core.manager.thrift.BulkImportState;
import org.apache.accumulo.core.metadata.schema.Ample;
import org.apache.accumulo.manager.Manager;
import org.apache.accumulo.manager.tableOps.ManagerRepo;
import org.apache.accumulo.manager.tableOps.Utils;
import org.apache.accumulo.manager.tableOps.bulkVer2.BulkInfo;
import org.apache.accumulo.server.ServerContext;
import org.apache.accumulo.server.zookeeper.TransactionWatcher;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CleanUpBulkImport
extends ManagerRepo {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(CleanUpBulkImport.class);
    private BulkInfo info;

    public CleanUpBulkImport(BulkInfo info) {
        this.info = info;
    }

    @Override
    public Repo<Manager> call(long tid, Manager manager) throws Exception {
        manager.updateBulkImportStatus(this.info.sourceDir, BulkImportState.CLEANUP);
        log.debug("{} removing the bulkDir processing flag file in {}", (Object)FateTxId.formatTid((long)tid), (Object)this.info.bulkDir);
        Ample ample = manager.getContext().getAmple();
        Path bulkDir = new Path(this.info.bulkDir);
        ample.removeBulkLoadInProgressFlag("/" + bulkDir.getParent().getName() + "/" + bulkDir.getName());
        ample.putGcFileAndDirCandidates(this.info.tableId, Collections.singleton(new ReferenceFile(this.info.tableId, bulkDir.toString())));
        if (this.info.tableState == TableState.ONLINE) {
            Text firstSplit = this.info.firstSplit == null ? null : new Text(this.info.firstSplit);
            Text lastSplit = this.info.lastSplit == null ? null : new Text(this.info.lastSplit);
            log.debug("{} removing the metadata table markers for loaded files in range {} {}", new Object[]{FateTxId.formatTid((long)tid), firstSplit, lastSplit});
            ample.removeBulkLoadEntries(this.info.tableId, tid, firstSplit, lastSplit);
        }
        Utils.unreserveHdfsDirectory(manager, this.info.sourceDir, tid);
        Utils.getReadLock(manager, this.info.tableId, tid).unlock();
        Path renamingFile = new Path(bulkDir, "renames.json");
        Path mappingFile = new Path(bulkDir, "loadmap.json");
        try {
            manager.getVolumeManager().delete(renamingFile);
            manager.getVolumeManager().delete(mappingFile);
        }
        catch (IOException ioe) {
            log.debug("{} Failed to delete renames and/or loadmap", (Object)FateTxId.formatTid((long)tid), (Object)ioe);
        }
        log.debug("completing bulkDir import transaction " + FateTxId.formatTid((long)tid));
        if (this.info.tableState == TableState.ONLINE) {
            TransactionWatcher.ZooArbitrator.cleanup((ServerContext)manager.getContext(), (String)"bulkTx", (long)tid);
        }
        manager.removeBulkImportStatus(this.info.sourceDir);
        return null;
    }
}

