# Contributing to Apache AGE

Welcome, future Contributor! 

First off, thank you for considering contributing to Apache AGE. Team AGE welcomes anyone who is willing to help us mature AGE to become a fully-featured graph database extension for PostgreSQL.

There are multiple ways you can contribute to the Apache AGE and [Apache AGE Viewer](https://github.com/apache/age-viewer) projects. We hope that adding features, fixing bugs, and changing documentations can be fun and educational for anyone and everyone. 

## Code of Conduct

The community members of Apache AGE are expected to follow the 'Apache Way'. Please read the [Code of Conduct](https://www.apache.org/foundation/policies/conduct) provided by Apache Software Foundation.

## How to Start

A great way to get involved in the project is to ask questions on the mailing lists, Apache AGE Discord, or the Apache Reddit forum (r/apacheage). Reviewing the list of projects in the Apache AGE and AGE Viewer GitHubs may help you understand the overall roadmap. 

Once you understand the ins and outs of Apache AGE, share your knowledge by helping the newcomers as well. Spending a few minutes to answer questions are a valuable open source community service, which also demonstrates your expertise. 

We strongly recommend you to subscribe the mailing lists, join the Apache AGE Discord and Apache AGE Reddit community (r/apacheage) to keep up to date on what's happening in AGE. Visit [joinus](https://age.apache.org/joinus) for pathways you can follow to help you get started.

## Pull Requests

Changes to AGE source code are proposed, reviewed, and committed via GitHub pull requests (described in Code Convention). Pull requests are a great way to get your ideas into this repository. Anyone can view and comment on active changes here. Reviewing others' changes are a good way to learn how the change process works and gain exposure to activity in various parts of the code. You can help by reviewing the changes, asking questions, or pointing out issues as simple as typos.

## Documentation Changes

You can propose changes to Apache AGE documentation, edit the Markdown source files for the Apache AGE website pages. 

## Bug Reports

Ideally, bug reports are accompanied by a proposed code change to fix the bug. This isn't always possible, as those who discover a bug may not have the experience to fix it. A bug may be reported by creating a GitHub issue, but without creating a pull request. 

Bug reports are only useful, however, if they include enough information to understand, isolate and ideally reproduce the bug. Simply encountering an error does not mean a bug should be reported; search GitHub and inquire on the Apache AGE's dev mailing list first. Unreproducible bugs or simple error reports without context shall be closed. 

The more context about a bug, the better, such as: how the bug was introduced, by which commit, etc. It assists the committers in the decision process on how far the bug fix should be backported, when the pull request is merged. The pull request to fix the bug should narrow down the problem to the root cause. Data correctness/data loss bugs are very serious. Make sure the corresponding bug report GitHub issue is labeled as correctness or data-loss. Please send an email to dev@age.apache.org after submitting the bug report, to quickly draw attention to the issue. Performance issues are classified as bugs. The pull request to fix a performance bug must provide a benchmark to prove the problem is indeed fixed.
