/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.cloud.aurora.client.sdk;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.airavata.cloud.aurora.client.sdk.Range;
import org.apache.airavata.cloud.aurora.client.sdk.TaskConfig;
import org.apache.thrift.TBase;
import org.apache.thrift.TBaseHelper;
import org.apache.thrift.TException;
import org.apache.thrift.TFieldIdEnum;
import org.apache.thrift.meta_data.FieldMetaData;
import org.apache.thrift.meta_data.FieldValueMetaData;
import org.apache.thrift.meta_data.SetMetaData;
import org.apache.thrift.meta_data.StructMetaData;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolUtil;
import org.apache.thrift.protocol.TSet;
import org.apache.thrift.protocol.TStruct;
import org.apache.thrift.protocol.TTupleProtocol;
import org.apache.thrift.scheme.IScheme;
import org.apache.thrift.scheme.SchemeFactory;
import org.apache.thrift.scheme.StandardScheme;
import org.apache.thrift.scheme.TupleScheme;
import org.apache.thrift.transport.TIOStreamTransport;
import org.apache.thrift.transport.TTransport;

public class InstanceTaskConfig
implements TBase<InstanceTaskConfig, _Fields>,
Serializable,
Cloneable,
Comparable<InstanceTaskConfig> {
    private static final TStruct STRUCT_DESC = new TStruct("InstanceTaskConfig");
    private static final TField TASK_FIELD_DESC = new TField("task", 12, 1);
    private static final TField INSTANCES_FIELD_DESC = new TField("instances", 14, 2);
    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    public TaskConfig task;
    public Set<Range> instances;
    public static final Map<_Fields, FieldMetaData> metaDataMap;

    public InstanceTaskConfig() {
    }

    public InstanceTaskConfig(TaskConfig task, Set<Range> instances) {
        this();
        this.task = task;
        this.instances = instances;
    }

    public InstanceTaskConfig(InstanceTaskConfig other) {
        if (other.isSetTask()) {
            this.task = new TaskConfig(other.task);
        }
        if (other.isSetInstances()) {
            HashSet<Range> __this__instances = new HashSet<Range>(other.instances.size());
            for (Range other_element : other.instances) {
                __this__instances.add(new Range(other_element));
            }
            this.instances = __this__instances;
        }
    }

    public InstanceTaskConfig deepCopy() {
        return new InstanceTaskConfig(this);
    }

    public void clear() {
        this.task = null;
        this.instances = null;
    }

    public TaskConfig getTask() {
        return this.task;
    }

    public InstanceTaskConfig setTask(TaskConfig task) {
        this.task = task;
        return this;
    }

    public void unsetTask() {
        this.task = null;
    }

    public boolean isSetTask() {
        return this.task != null;
    }

    public void setTaskIsSet(boolean value) {
        if (!value) {
            this.task = null;
        }
    }

    public int getInstancesSize() {
        return this.instances == null ? 0 : this.instances.size();
    }

    public Iterator<Range> getInstancesIterator() {
        return this.instances == null ? null : this.instances.iterator();
    }

    public void addToInstances(Range elem) {
        if (this.instances == null) {
            this.instances = new HashSet<Range>();
        }
        this.instances.add(elem);
    }

    public Set<Range> getInstances() {
        return this.instances;
    }

    public InstanceTaskConfig setInstances(Set<Range> instances) {
        this.instances = instances;
        return this;
    }

    public void unsetInstances() {
        this.instances = null;
    }

    public boolean isSetInstances() {
        return this.instances != null;
    }

    public void setInstancesIsSet(boolean value) {
        if (!value) {
            this.instances = null;
        }
    }

    public void setFieldValue(_Fields field, Object value) {
        switch (field) {
            case TASK: {
                if (value == null) {
                    this.unsetTask();
                    break;
                }
                this.setTask((TaskConfig)value);
                break;
            }
            case INSTANCES: {
                if (value == null) {
                    this.unsetInstances();
                    break;
                }
                this.setInstances((Set)value);
            }
        }
    }

    public Object getFieldValue(_Fields field) {
        switch (field) {
            case TASK: {
                return this.getTask();
            }
            case INSTANCES: {
                return this.getInstances();
            }
        }
        throw new IllegalStateException();
    }

    public boolean isSet(_Fields field) {
        if (field == null) {
            throw new IllegalArgumentException();
        }
        switch (field) {
            case TASK: {
                return this.isSetTask();
            }
            case INSTANCES: {
                return this.isSetInstances();
            }
        }
        throw new IllegalStateException();
    }

    public boolean equals(Object that) {
        if (that == null) {
            return false;
        }
        if (that instanceof InstanceTaskConfig) {
            return this.equals((InstanceTaskConfig)that);
        }
        return false;
    }

    public boolean equals(InstanceTaskConfig that) {
        if (that == null) {
            return false;
        }
        boolean this_present_task = this.isSetTask();
        boolean that_present_task = that.isSetTask();
        if (this_present_task || that_present_task) {
            if (!this_present_task || !that_present_task) {
                return false;
            }
            if (!this.task.equals(that.task)) {
                return false;
            }
        }
        boolean this_present_instances = this.isSetInstances();
        boolean that_present_instances = that.isSetInstances();
        if (this_present_instances || that_present_instances) {
            if (!this_present_instances || !that_present_instances) {
                return false;
            }
            if (!this.instances.equals(that.instances)) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        ArrayList<Object> list = new ArrayList<Object>();
        boolean present_task = this.isSetTask();
        list.add(present_task);
        if (present_task) {
            list.add(this.task);
        }
        boolean present_instances = this.isSetInstances();
        list.add(present_instances);
        if (present_instances) {
            list.add(this.instances);
        }
        return list.hashCode();
    }

    @Override
    public int compareTo(InstanceTaskConfig other) {
        if (!this.getClass().equals(other.getClass())) {
            return this.getClass().getName().compareTo(other.getClass().getName());
        }
        int lastComparison = 0;
        lastComparison = Boolean.valueOf(this.isSetTask()).compareTo(other.isSetTask());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetTask() && (lastComparison = TBaseHelper.compareTo((Comparable)this.task, (Comparable)other.task)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetInstances()).compareTo(other.isSetInstances());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetInstances() && (lastComparison = TBaseHelper.compareTo(this.instances, other.instances)) != 0) {
            return lastComparison;
        }
        return 0;
    }

    public _Fields fieldForId(int fieldId) {
        return _Fields.findByThriftId(fieldId);
    }

    public void read(TProtocol iprot) throws TException {
        schemes.get(iprot.getScheme()).getScheme().read(iprot, (TBase)this);
    }

    public void write(TProtocol oprot) throws TException {
        schemes.get(oprot.getScheme()).getScheme().write(oprot, (TBase)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("InstanceTaskConfig(");
        boolean first = true;
        sb.append("task:");
        if (this.task == null) {
            sb.append("null");
        } else {
            sb.append(this.task);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("instances:");
        if (this.instances == null) {
            sb.append("null");
        } else {
            sb.append(this.instances);
        }
        first = false;
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
        if (this.task != null) {
            this.task.validate();
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        try {
            this.write((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((OutputStream)out)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            this.read((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((InputStream)in)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    static {
        schemes.put(StandardScheme.class, new InstanceTaskConfigStandardSchemeFactory());
        schemes.put(TupleScheme.class, new InstanceTaskConfigTupleSchemeFactory());
        EnumMap<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
        tmpMap.put(_Fields.TASK, new FieldMetaData("task", 3, (FieldValueMetaData)new StructMetaData(12, TaskConfig.class)));
        tmpMap.put(_Fields.INSTANCES, new FieldMetaData("instances", 3, (FieldValueMetaData)new SetMetaData(14, (FieldValueMetaData)new StructMetaData(12, Range.class))));
        metaDataMap = Collections.unmodifiableMap(tmpMap);
        FieldMetaData.addStructMetaDataMap(InstanceTaskConfig.class, metaDataMap);
    }

    private static class InstanceTaskConfigTupleScheme
    extends TupleScheme<InstanceTaskConfig> {
        private InstanceTaskConfigTupleScheme() {
        }

        public void write(TProtocol prot, InstanceTaskConfig struct) throws TException {
            TTupleProtocol oprot = (TTupleProtocol)prot;
            BitSet optionals = new BitSet();
            if (struct.isSetTask()) {
                optionals.set(0);
            }
            if (struct.isSetInstances()) {
                optionals.set(1);
            }
            oprot.writeBitSet(optionals, 2);
            if (struct.isSetTask()) {
                struct.task.write((TProtocol)oprot);
            }
            if (struct.isSetInstances()) {
                oprot.writeI32(struct.instances.size());
                for (Range _iter202 : struct.instances) {
                    _iter202.write((TProtocol)oprot);
                }
            }
        }

        public void read(TProtocol prot, InstanceTaskConfig struct) throws TException {
            TTupleProtocol iprot = (TTupleProtocol)prot;
            BitSet incoming = iprot.readBitSet(2);
            if (incoming.get(0)) {
                struct.task = new TaskConfig();
                struct.task.read((TProtocol)iprot);
                struct.setTaskIsSet(true);
            }
            if (incoming.get(1)) {
                TSet _set203 = new TSet(12, iprot.readI32());
                struct.instances = new HashSet<Range>(2 * _set203.size);
                for (int _i205 = 0; _i205 < _set203.size; ++_i205) {
                    Range _elem204 = new Range();
                    _elem204.read((TProtocol)iprot);
                    struct.instances.add(_elem204);
                }
                struct.setInstancesIsSet(true);
            }
        }
    }

    private static class InstanceTaskConfigTupleSchemeFactory
    implements SchemeFactory {
        private InstanceTaskConfigTupleSchemeFactory() {
        }

        public InstanceTaskConfigTupleScheme getScheme() {
            return new InstanceTaskConfigTupleScheme();
        }
    }

    private static class InstanceTaskConfigStandardScheme
    extends StandardScheme<InstanceTaskConfig> {
        private InstanceTaskConfigStandardScheme() {
        }

        public void read(TProtocol iprot, InstanceTaskConfig struct) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField schemeField = iprot.readFieldBegin();
                if (schemeField.type == 0) break;
                switch (schemeField.id) {
                    case 1: {
                        if (schemeField.type == 12) {
                            struct.task = new TaskConfig();
                            struct.task.read(iprot);
                            struct.setTaskIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 2: {
                        if (schemeField.type == 14) {
                            TSet _set198 = iprot.readSetBegin();
                            struct.instances = new HashSet<Range>(2 * _set198.size);
                            for (int _i200 = 0; _i200 < _set198.size; ++_i200) {
                                Range _elem199 = new Range();
                                _elem199.read(iprot);
                                struct.instances.add(_elem199);
                            }
                            iprot.readSetEnd();
                            struct.setInstancesIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            struct.validate();
        }

        public void write(TProtocol oprot, InstanceTaskConfig struct) throws TException {
            struct.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            if (struct.task != null) {
                oprot.writeFieldBegin(TASK_FIELD_DESC);
                struct.task.write(oprot);
                oprot.writeFieldEnd();
            }
            if (struct.instances != null) {
                oprot.writeFieldBegin(INSTANCES_FIELD_DESC);
                oprot.writeSetBegin(new TSet(12, struct.instances.size()));
                for (Range _iter201 : struct.instances) {
                    _iter201.write(oprot);
                }
                oprot.writeSetEnd();
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }
    }

    private static class InstanceTaskConfigStandardSchemeFactory
    implements SchemeFactory {
        private InstanceTaskConfigStandardSchemeFactory() {
        }

        public InstanceTaskConfigStandardScheme getScheme() {
            return new InstanceTaskConfigStandardScheme();
        }
    }

    public static enum _Fields implements TFieldIdEnum
    {
        TASK(1, "task"),
        INSTANCES(2, "instances");

        private static final Map<String, _Fields> byName;
        private final short _thriftId;
        private final String _fieldName;

        public static _Fields findByThriftId(int fieldId) {
            switch (fieldId) {
                case 1: {
                    return TASK;
                }
                case 2: {
                    return INSTANCES;
                }
            }
            return null;
        }

        public static _Fields findByThriftIdOrThrow(int fieldId) {
            _Fields fields = _Fields.findByThriftId(fieldId);
            if (fields == null) {
                throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
            }
            return fields;
        }

        public static _Fields findByName(String name) {
            return byName.get(name);
        }

        private _Fields(short thriftId, String fieldName) {
            this._thriftId = thriftId;
            this._fieldName = fieldName;
        }

        public short getThriftFieldId() {
            return this._thriftId;
        }

        public String getFieldName() {
            return this._fieldName;
        }

        static {
            byName = new HashMap<String, _Fields>();
            for (_Fields field : EnumSet.allOf(_Fields.class)) {
                byName.put(field.getFieldName(), field);
            }
        }
    }
}

