/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.concurrent.lock;

import com.hazelcast.concurrent.lock.AwaitOperation;
import com.hazelcast.concurrent.lock.BaseLockOperation;
import com.hazelcast.concurrent.lock.ConditionKey;
import com.hazelcast.concurrent.lock.LockStoreImpl;
import com.hazelcast.concurrent.lock.LockWaitNotifyKey;
import com.hazelcast.concurrent.lock.UnlockBackupOperation;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.BackupAwareOperation;
import com.hazelcast.spi.Notifier;
import com.hazelcast.spi.ObjectNamespace;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.WaitNotifyKey;
import java.io.IOException;

public class UnlockOperation
extends BaseLockOperation
implements Notifier,
BackupAwareOperation {
    private boolean force = false;
    private transient boolean shouldNotify;

    public UnlockOperation() {
    }

    public UnlockOperation(ObjectNamespace namespace, Data key, int threadId) {
        super(namespace, key, threadId);
    }

    public UnlockOperation(ObjectNamespace namespace, Data key, int threadId, boolean force) {
        super(namespace, key, threadId);
        this.force = force;
    }

    @Override
    public void run() throws Exception {
        LockStoreImpl lockStore = this.getLockStore();
        if (this.force) {
            this.response = lockStore.forceUnlock(this.key);
        } else {
            boolean unlocked = lockStore.unlock(this.key, this.getCallerUuid(), this.threadId);
            this.response = unlocked;
            if (!unlocked) {
                throw new IllegalMonitorStateException("Current thread is not owner of the lock! -> " + lockStore.getOwnerInfo(this.key));
            }
        }
    }

    @Override
    public void afterRun() throws Exception {
        AwaitOperation awaitResponse = this.getLockStore().pollExpiredAwaitOp(this.key);
        if (awaitResponse != null) {
            this.getNodeEngine().getOperationService().runOperation(awaitResponse);
        }
        this.shouldNotify = awaitResponse == null;
    }

    @Override
    public Operation getBackupOperation() {
        return new UnlockBackupOperation(this.namespace, this.key, this.threadId, this.getCallerUuid(), this.force);
    }

    @Override
    public boolean shouldBackup() {
        return Boolean.TRUE.equals(this.response);
    }

    @Override
    public boolean shouldNotify() {
        return this.shouldNotify;
    }

    @Override
    public final WaitNotifyKey getNotifiedKey() {
        ConditionKey conditionKey = this.getLockStore().getSignalKey(this.key);
        return conditionKey != null ? conditionKey : new LockWaitNotifyKey(this.namespace, this.key);
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeBoolean(this.force);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.force = in.readBoolean();
    }
}

