/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.UnaryExpression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.PathMap;
import net.sf.saxon.expr.parser.RoleLocator;
import net.sf.saxon.om.AtomicSequence;
import net.sf.saxon.om.FunctionItem;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ExternalObjectType;
import net.sf.saxon.type.FunctionItemType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.ObjectValue;
import net.sf.saxon.value.StringValue;

public final class SingletonAtomizer
extends UnaryExpression {
    private boolean allowEmpty;
    private RoleLocator role;
    private static final int STRING_KINDS = 8576;
    private static final int UNTYPED_KINDS = 520;
    private static final int UNTYPED_IF_UNTYPED_KINDS = 526;

    public SingletonAtomizer(Expression sequence, RoleLocator role, boolean allowEmpty) {
        super(sequence);
        this.allowEmpty = allowEmpty;
        this.role = role;
    }

    protected OperandRole getOperandRole() {
        return OperandRole.SINGLE_ATOMIC;
    }

    public boolean isAllowEmpty() {
        return this.allowEmpty;
    }

    public Expression simplify(ExpressionVisitor visitor) throws XPathException {
        this.operand = visitor.simplify(this.operand);
        if (this.operand instanceof Literal && ((Literal)this.operand).getValue() instanceof AtomicValue) {
            return this.operand;
        }
        return this;
    }

    public Expression typeCheck(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo) throws XPathException {
        this.operand = visitor.typeCheck(this.operand, contextInfo);
        visitor.resetStaticProperties();
        if (Literal.isEmptySequence(this.operand)) {
            if (!this.allowEmpty) {
                this.typeError("An empty sequence is not allowed as the " + this.role.getMessage(), this.role.getErrorCode(), null);
            }
            return this.operand;
        }
        ItemType operandType = this.operand.getItemType();
        if (operandType.isPlainType()) {
            return this.operand;
        }
        if (!operandType.isAtomizable()) {
            XPathException err = operandType instanceof FunctionItemType ? new XPathException("Cannot atomize a function item", "FOTY0013") : new XPathException("Cannot atomize an element that is defined in the schema to have element-only content", "FOTY0012");
            err.setIsTypeError(true);
            err.setLocator(this);
            throw err;
        }
        return this;
    }

    public Expression optimize(ExpressionVisitor visitor, ContextItemStaticInfo contextItemType) throws XPathException {
        Expression exp = super.optimize(visitor, contextItemType);
        if (exp == this) {
            if (this.operand.getItemType().isPlainType()) {
                return this.operand;
            }
            return this;
        }
        return exp;
    }

    public int computeSpecialProperties() {
        int p = super.computeSpecialProperties();
        return p | 0x400000;
    }

    public Expression copy() {
        SingletonAtomizer e2 = new SingletonAtomizer(this.getBaseExpression().copy(), this.role, this.allowEmpty);
        ExpressionTool.copyLocationInfo(this, e2);
        return e2;
    }

    public RoleLocator getRole() {
        return this.role;
    }

    public PathMap.PathMapNodeSet addToPathMap(PathMap pathMap, PathMap.PathMapNodeSet pathMapNodeSet) {
        ItemType operandItemType;
        TypeHierarchy th;
        PathMap.PathMapNodeSet result = this.operand.addToPathMap(pathMap, pathMapNodeSet);
        if (result != null && ((th = this.getConfiguration().getTypeHierarchy()).relationship(NodeKindTest.ELEMENT, operandItemType = this.operand.getItemType()) != 4 || th.relationship(NodeKindTest.DOCUMENT, operandItemType) != 4)) {
            result.setAtomized();
        }
        return null;
    }

    public AtomicValue evaluateItem(XPathContext context) throws XPathException {
        Item item;
        int found = 0;
        AtomicValue result = null;
        SequenceIterator iter = this.operand.iterate(context);
        while ((item = iter.next()) != null) {
            if (item instanceof AtomicValue) {
                if (found++ > 0) {
                    this.typeError("A sequence of more than one item is not allowed as the " + this.role.getMessage(), this.role.getErrorCode(), context);
                }
                result = (AtomicValue)item;
                continue;
            }
            if (item instanceof FunctionItem) {
                this.typeError("A function item cannot appear as the " + this.role.getMessage(), "FOTY0013", context);
                continue;
            }
            if (item instanceof ObjectValue) {
                return new StringValue(item.getStringValue());
            }
            AtomicSequence value = ((NodeInfo)item).atomize();
            if ((found += SequenceTool.getLength(value)) > 1) {
                this.typeError("A sequence of more than one item is not allowed as the " + this.role.getMessage(), this.role.getErrorCode(), context);
            }
            result = value.head();
        }
        if (found == 0 && !this.allowEmpty) {
            this.typeError("An empty sequence is not allowed as the " + this.role.getMessage(), this.role.getErrorCode(), null);
        }
        return result;
    }

    public ItemType getItemType() {
        boolean isSchemaAware;
        block10: {
            isSchemaAware = true;
            try {
                isSchemaAware = this.getContainer().getPackageData().isSchemaAware();
            }
            catch (NullPointerException err) {
                if (this.getConfiguration().isLicensedFeature(1)) break block10;
                isSchemaAware = false;
            }
        }
        ItemType in = this.operand.getItemType();
        if (in.isPlainType()) {
            return in;
        }
        if (in instanceof NodeTest) {
            int kinds = ((NodeTest)in).getNodeKindMask();
            if (!isSchemaAware) {
                if ((kinds | 0x2180) == 8576) {
                    return BuiltInAtomicType.STRING;
                }
                if ((kinds | 0x20E) == 526) {
                    return BuiltInAtomicType.UNTYPED_ATOMIC;
                }
            } else if ((kinds | 0x208) == 520) {
                return BuiltInAtomicType.UNTYPED_ATOMIC;
            }
            return in.getAtomizedItemType();
        }
        if (in instanceof ExternalObjectType) {
            return in.getAtomizedItemType();
        }
        return BuiltInAtomicType.ANY_ATOMIC;
    }

    public int computeCardinality() {
        if (this.allowEmpty) {
            return 24576;
        }
        return 16384;
    }

    public String getExpressionName() {
        return "atomizeSingleton";
    }

    public String toShortString() {
        return this.operand.toShortString();
    }
}

