/*
 * Decompiled with CFR 0.152.
 */
package org.globus.gsi.trustmanager;

import java.security.cert.CertPathValidatorException;
import java.security.cert.X509Certificate;
import org.globus.gsi.GSIConstants;
import org.globus.gsi.trustmanager.CertificateChecker;
import org.globus.gsi.trustmanager.X509ProxyCertPathValidator;
import org.globus.gsi.util.ProxyCertificateUtil;

public class IdentityChecker
implements CertificateChecker {
    private X509ProxyCertPathValidator proxyCertValidator;

    public IdentityChecker(X509ProxyCertPathValidator proxyCertPathValidator) {
        this.proxyCertValidator = proxyCertPathValidator;
    }

    public void invoke(X509Certificate cert, GSIConstants.CertificateType certType) throws CertPathValidatorException {
        if (this.proxyCertValidator.getIdentityCertificate() == null) {
            if (ProxyCertificateUtil.isLimitedProxy(certType)) {
                this.proxyCertValidator.setLimited(true);
                if (this.proxyCertValidator.isRejectLimitedProxy()) {
                    throw new CertPathValidatorException("Limited proxy not accepted");
                }
            }
            if (!ProxyCertificateUtil.isImpersonationProxy(certType)) {
                this.proxyCertValidator.setIdentityCert(cert);
            }
        }
    }
}

