/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.opsworks.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.opsworks.model.Recipes;
import com.amazonaws.services.opsworks.model.UpdateLayerRequest;
import com.amazonaws.services.opsworks.model.VolumeConfiguration;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;

public class UpdateLayerRequestMarshaller
implements Marshaller<Request<UpdateLayerRequest>, UpdateLayerRequest> {
    public Request<UpdateLayerRequest> marshall(UpdateLayerRequest updateLayerRequest) {
        if (updateLayerRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)updateLayerRequest, "AWSOpsWorks");
        String target = "OpsWorks_20130218.UpdateLayer";
        request.addHeader("X-Amz-Target", target);
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            Recipes customRecipes;
            ListWithAutoConstructFlag volumeConfigurationsList;
            ListWithAutoConstructFlag packagesList;
            ListWithAutoConstructFlag customSecurityGroupIdsList;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter((Writer)stringWriter);
            jsonWriter.object();
            if (updateLayerRequest.getLayerId() != null) {
                jsonWriter.key("LayerId").value((Object)updateLayerRequest.getLayerId());
            }
            if (updateLayerRequest.getName() != null) {
                jsonWriter.key("Name").value((Object)updateLayerRequest.getName());
            }
            if (updateLayerRequest.getShortname() != null) {
                jsonWriter.key("Shortname").value((Object)updateLayerRequest.getShortname());
            }
            if (updateLayerRequest.getAttributes() != null) {
                jsonWriter.key("Attributes");
                jsonWriter.object();
                for (Map.Entry<String, String> attributesListValue : updateLayerRequest.getAttributes().entrySet()) {
                    if (attributesListValue.getValue() == null) continue;
                    jsonWriter.key(attributesListValue.getKey());
                    jsonWriter.value((Object)attributesListValue.getValue());
                }
                jsonWriter.endObject();
            }
            if (updateLayerRequest.getCustomInstanceProfileArn() != null) {
                jsonWriter.key("CustomInstanceProfileArn").value((Object)updateLayerRequest.getCustomInstanceProfileArn());
            }
            if (!((customSecurityGroupIdsList = (ListWithAutoConstructFlag)updateLayerRequest.getCustomSecurityGroupIds()) == null || customSecurityGroupIdsList.isAutoConstruct() && customSecurityGroupIdsList.isEmpty())) {
                jsonWriter.key("CustomSecurityGroupIds");
                jsonWriter.array();
                for (String customSecurityGroupIdsListValue : customSecurityGroupIdsList) {
                    if (customSecurityGroupIdsListValue == null) continue;
                    jsonWriter.value((Object)customSecurityGroupIdsListValue);
                }
                jsonWriter.endArray();
            }
            if (!((packagesList = (ListWithAutoConstructFlag)updateLayerRequest.getPackages()) == null || packagesList.isAutoConstruct() && packagesList.isEmpty())) {
                jsonWriter.key("Packages");
                jsonWriter.array();
                for (String packagesListValue : packagesList) {
                    if (packagesListValue == null) continue;
                    jsonWriter.value((Object)packagesListValue);
                }
                jsonWriter.endArray();
            }
            if (!((volumeConfigurationsList = (ListWithAutoConstructFlag)updateLayerRequest.getVolumeConfigurations()) == null || volumeConfigurationsList.isAutoConstruct() && volumeConfigurationsList.isEmpty())) {
                jsonWriter.key("VolumeConfigurations");
                jsonWriter.array();
                for (VolumeConfiguration volumeConfigurationsListValue : volumeConfigurationsList) {
                    if (volumeConfigurationsListValue == null) continue;
                    jsonWriter.object();
                    if (volumeConfigurationsListValue.getMountPoint() != null) {
                        jsonWriter.key("MountPoint").value((Object)volumeConfigurationsListValue.getMountPoint());
                    }
                    if (volumeConfigurationsListValue.getRaidLevel() != null) {
                        jsonWriter.key("RaidLevel").value((Object)volumeConfigurationsListValue.getRaidLevel());
                    }
                    if (volumeConfigurationsListValue.getNumberOfDisks() != null) {
                        jsonWriter.key("NumberOfDisks").value((Object)volumeConfigurationsListValue.getNumberOfDisks());
                    }
                    if (volumeConfigurationsListValue.getSize() != null) {
                        jsonWriter.key("Size").value((Object)volumeConfigurationsListValue.getSize());
                    }
                    if (volumeConfigurationsListValue.getVolumeType() != null) {
                        jsonWriter.key("VolumeType").value((Object)volumeConfigurationsListValue.getVolumeType());
                    }
                    if (volumeConfigurationsListValue.getIops() != null) {
                        jsonWriter.key("Iops").value((Object)volumeConfigurationsListValue.getIops());
                    }
                    jsonWriter.endObject();
                }
                jsonWriter.endArray();
            }
            if (updateLayerRequest.isEnableAutoHealing() != null) {
                jsonWriter.key("EnableAutoHealing").value((Object)updateLayerRequest.isEnableAutoHealing());
            }
            if (updateLayerRequest.isAutoAssignElasticIps() != null) {
                jsonWriter.key("AutoAssignElasticIps").value((Object)updateLayerRequest.isAutoAssignElasticIps());
            }
            if (updateLayerRequest.isAutoAssignPublicIps() != null) {
                jsonWriter.key("AutoAssignPublicIps").value((Object)updateLayerRequest.isAutoAssignPublicIps());
            }
            if ((customRecipes = updateLayerRequest.getCustomRecipes()) != null) {
                ListWithAutoConstructFlag shutdownList;
                ListWithAutoConstructFlag undeployList;
                ListWithAutoConstructFlag deployList;
                ListWithAutoConstructFlag configureList;
                jsonWriter.key("CustomRecipes");
                jsonWriter.object();
                ListWithAutoConstructFlag setupList = (ListWithAutoConstructFlag)customRecipes.getSetup();
                if (!(setupList == null || setupList.isAutoConstruct() && setupList.isEmpty())) {
                    jsonWriter.key("Setup");
                    jsonWriter.array();
                    for (String setupListValue : setupList) {
                        if (setupListValue == null) continue;
                        jsonWriter.value((Object)setupListValue);
                    }
                    jsonWriter.endArray();
                }
                if (!((configureList = (ListWithAutoConstructFlag)customRecipes.getConfigure()) == null || configureList.isAutoConstruct() && configureList.isEmpty())) {
                    jsonWriter.key("Configure");
                    jsonWriter.array();
                    for (String configureListValue : configureList) {
                        if (configureListValue == null) continue;
                        jsonWriter.value((Object)configureListValue);
                    }
                    jsonWriter.endArray();
                }
                if (!((deployList = (ListWithAutoConstructFlag)customRecipes.getDeploy()) == null || deployList.isAutoConstruct() && deployList.isEmpty())) {
                    jsonWriter.key("Deploy");
                    jsonWriter.array();
                    for (String deployListValue : deployList) {
                        if (deployListValue == null) continue;
                        jsonWriter.value((Object)deployListValue);
                    }
                    jsonWriter.endArray();
                }
                if (!((undeployList = (ListWithAutoConstructFlag)customRecipes.getUndeploy()) == null || undeployList.isAutoConstruct() && undeployList.isEmpty())) {
                    jsonWriter.key("Undeploy");
                    jsonWriter.array();
                    for (String undeployListValue : undeployList) {
                        if (undeployListValue == null) continue;
                        jsonWriter.value((Object)undeployListValue);
                    }
                    jsonWriter.endArray();
                }
                if (!((shutdownList = (ListWithAutoConstructFlag)customRecipes.getShutdown()) == null || shutdownList.isAutoConstruct() && shutdownList.isEmpty())) {
                    jsonWriter.key("Shutdown");
                    jsonWriter.array();
                    for (String shutdownListValue : shutdownList) {
                        if (shutdownListValue == null) continue;
                        jsonWriter.value((Object)shutdownListValue);
                    }
                    jsonWriter.endArray();
                }
                jsonWriter.endObject();
            }
            if (updateLayerRequest.isInstallUpdatesOnBoot() != null) {
                jsonWriter.key("InstallUpdatesOnBoot").value((Object)updateLayerRequest.isInstallUpdatesOnBoot());
            }
            if (updateLayerRequest.isUseEbsOptimizedInstances() != null) {
                jsonWriter.key("UseEbsOptimizedInstances").value((Object)updateLayerRequest.isUseEbsOptimizedInstances());
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", "application/x-amz-json-1.1");
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

