/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.service.profile.handlers;

import java.util.List;
import org.apache.airavata.common.exception.ApplicationSettingsException;
import org.apache.airavata.common.utils.DBEventManagerConstants;
import org.apache.airavata.common.utils.DBEventService;
import org.apache.airavata.common.utils.ServerSettings;
import org.apache.airavata.model.dbevent.CrudType;
import org.apache.airavata.model.dbevent.EntityType;
import org.apache.airavata.model.error.AuthorizationException;
import org.apache.airavata.model.security.AuthzToken;
import org.apache.airavata.model.user.UserProfile;
import org.apache.airavata.service.profile.client.ProfileServiceClientFactory;
import org.apache.airavata.service.profile.commons.user.entities.UserProfileEntity;
import org.apache.airavata.service.profile.iam.admin.services.cpi.IamAdminServices;
import org.apache.airavata.service.profile.iam.admin.services.cpi.exception.IamAdminServicesException;
import org.apache.airavata.service.profile.user.core.repositories.UserProfileRepository;
import org.apache.airavata.service.profile.user.cpi.UserProfileService;
import org.apache.airavata.service.profile.user.cpi.exception.UserProfileServiceException;
import org.apache.airavata.service.profile.utils.ProfileServiceUtils;
import org.apache.airavata.service.security.interceptor.SecurityCheck;
import org.apache.thrift.TBase;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserProfileServiceHandler
implements UserProfileService.Iface {
    private static final Logger logger = LoggerFactory.getLogger(UserProfileServiceHandler.class);
    private UserProfileRepository userProfileRepository = new UserProfileRepository(UserProfile.class, UserProfileEntity.class);

    @SecurityCheck
    public String addUserProfile(AuthzToken authzToken, UserProfile userProfile) throws UserProfileServiceException, AuthorizationException, TException {
        try {
            userProfile.setUserId(userProfile.getUserId().toLowerCase());
            userProfile.setAiravataInternalUserId(userProfile.getUserId() + "@" + userProfile.getGatewayId());
            userProfile = this.userProfileRepository.updateUserProfile(userProfile, this.getIAMUserProfileUpdater(authzToken, userProfile));
            if (null != userProfile) {
                logger.info("Added UserProfile with userId: " + userProfile.getUserId());
                ProfileServiceUtils.getDbEventPublisher().publish(ProfileServiceUtils.getDBEventMessageContext(EntityType.USER_PROFILE, CrudType.CREATE, (TBase)userProfile), DBEventManagerConstants.getRoutingKey((String)DBEventService.DB_EVENT.toString()));
                return userProfile.getUserId();
            }
            throw new Exception("User creation failed. Please try again.");
        }
        catch (Exception e) {
            logger.error("Error while creating user profile", (Throwable)e);
            UserProfileServiceException exception = new UserProfileServiceException();
            exception.setMessage("Error while creating user profile. More info : " + e.getMessage());
            throw exception;
        }
    }

    @SecurityCheck
    public boolean updateUserProfile(AuthzToken authzToken, UserProfile userProfile) throws UserProfileServiceException, AuthorizationException, TException {
        try {
            Runnable iamUserProfileUpdater = this.getIAMUserProfileUpdater(authzToken, userProfile);
            if (this.userProfileRepository.updateUserProfile(userProfile, iamUserProfileUpdater) != null) {
                logger.info("Updated UserProfile with userId: " + userProfile.getUserId());
                ProfileServiceUtils.getDbEventPublisher().publish(ProfileServiceUtils.getDBEventMessageContext(EntityType.USER_PROFILE, CrudType.UPDATE, (TBase)userProfile), DBEventManagerConstants.getRoutingKey((String)DBEventService.DB_EVENT.toString()));
                return true;
            }
            return false;
        }
        catch (Exception e) {
            logger.error("Error while Updating user profile", (Throwable)e);
            UserProfileServiceException exception = new UserProfileServiceException();
            exception.setMessage("Error while Updating user profile. More info : " + e.getMessage());
            throw exception;
        }
    }

    private Runnable getIAMUserProfileUpdater(AuthzToken authzToken, UserProfile userProfile) throws UserProfileServiceException {
        IamAdminServices.Client iamAdminServicesClient = this.getIamAdminServicesClient();
        return () -> {
            try {
                iamAdminServicesClient.updateUserProfile(authzToken, userProfile);
            }
            catch (TException e) {
                throw new RuntimeException("Failed to update user profile in IAM service", e);
            }
        };
    }

    @SecurityCheck
    public UserProfile getUserProfileById(AuthzToken authzToken, String userId, String gatewayId) throws UserProfileServiceException, AuthorizationException, TException {
        try {
            UserProfile userProfile = this.userProfileRepository.getUserProfileByIdAndGateWay(userId, gatewayId);
            if (userProfile != null) {
                return userProfile;
            }
            throw new Exception("User with userId: " + userId + ", in Gateway: " + gatewayId + ", does not exist.");
        }
        catch (Exception e) {
            logger.error("Error retrieving user profile by ID", (Throwable)e);
            UserProfileServiceException exception = new UserProfileServiceException();
            exception.setMessage("Error retrieving user profile by ID. More info : " + e.getMessage());
            throw exception;
        }
    }

    @SecurityCheck
    public boolean deleteUserProfile(AuthzToken authzToken, String userId, String gatewayId) throws UserProfileServiceException, AuthorizationException, TException {
        try {
            UserProfile userProfile = this.userProfileRepository.getUserProfileByIdAndGateWay(userId, gatewayId);
            boolean deleteSuccess = this.userProfileRepository.delete((Object)userId);
            logger.info("Delete UserProfile with userId: " + userId + ", " + (deleteSuccess ? "Success!" : "Failed!"));
            if (deleteSuccess) {
                ProfileServiceUtils.getDbEventPublisher().publish(ProfileServiceUtils.getDBEventMessageContext(EntityType.USER_PROFILE, CrudType.DELETE, (TBase)userProfile), DBEventManagerConstants.getRoutingKey((String)DBEventService.DB_EVENT.toString()));
            }
            return deleteSuccess;
        }
        catch (Exception e) {
            logger.error("Error while deleting user profile", (Throwable)e);
            UserProfileServiceException exception = new UserProfileServiceException();
            exception.setMessage("Error while deleting user profile. More info : " + e.getMessage());
            throw exception;
        }
    }

    @SecurityCheck
    public List<UserProfile> getAllUserProfilesInGateway(AuthzToken authzToken, String gatewayId, int offset, int limit) throws UserProfileServiceException, AuthorizationException, TException {
        try {
            List usersInGateway = this.userProfileRepository.getAllUserProfilesInGateway(gatewayId, offset, limit);
            if (usersInGateway != null) {
                return usersInGateway;
            }
            throw new Exception("There are no users for the requested gatewayId: " + gatewayId);
        }
        catch (Exception e) {
            logger.error("Error while retrieving user profile List", (Throwable)e);
            UserProfileServiceException exception = new UserProfileServiceException();
            exception.setMessage("Error while retrieving user profile List. More info : " + e.getMessage());
            throw exception;
        }
    }

    public boolean doesUserExist(AuthzToken authzToken, String userId, String gatewayId) throws UserProfileServiceException, AuthorizationException, TException {
        try {
            UserProfile userProfile = this.userProfileRepository.getUserProfileByIdAndGateWay(userId, gatewayId);
            return null != userProfile;
        }
        catch (Exception e) {
            logger.error("Error while finding user profile", (Throwable)e);
            UserProfileServiceException exception = new UserProfileServiceException();
            exception.setMessage("Error while finding user profile. More info : " + e.getMessage());
            throw exception;
        }
    }

    private IamAdminServices.Client getIamAdminServicesClient() throws UserProfileServiceException {
        try {
            int serverPort = Integer.parseInt(ServerSettings.getProfileServiceServerPort());
            String serverHost = ServerSettings.getProfileServiceServerHost();
            return ProfileServiceClientFactory.createIamAdminServiceClient((String)serverHost, (int)serverPort);
        }
        catch (ApplicationSettingsException | IamAdminServicesException e) {
            logger.error("Failed to create IAM Admin Services client", e);
            UserProfileServiceException ex = new UserProfileServiceException("Failed to create IAM Admin Services client");
            throw ex;
        }
    }
}

