/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.security.wsutil.client;

import eu.emi.security.authn.x509.X509CertChainValidator;
import eu.emi.security.authn.x509.X509Credential;
import eu.emi.security.authn.x509.impl.CertificateUtils;
import eu.emi.security.authn.x509.impl.FormatMode;
import eu.emi.security.authn.x509.impl.HostnameMismatchCallback;
import eu.emi.security.authn.x509.impl.SocketFactoryCreator;
import eu.unicore.security.canl.LoggingX509TrustManager;
import eu.unicore.util.Log;
import eu.unicore.util.httpclient.HostnameMismatchCallbackImpl;
import eu.unicore.util.httpclient.IClientConfiguration;
import eu.unicore.util.httpclient.NoAuthKeyManager;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.log4j.Logger;

public class MySSLSocketFactory
extends SSLSocketFactory {
    private static final Logger log = Log.getLogger("unicore.security", MySSLSocketFactory.class);
    private SSLContext sslcontext = null;
    private IClientConfiguration sec;

    public MySSLSocketFactory(IClientConfiguration sec) {
        this.sec = sec;
    }

    private synchronized SSLContext createSSLContext() {
        try {
            X509KeyManager km;
            if (this.sec.doSSLAuthn()) {
                km = this.sec.getCredential().getKeyManager();
                if (log.isTraceEnabled()) {
                    this.debugKS(this.sec.getCredential());
                }
            } else {
                km = new NoAuthKeyManager();
                log.trace("Not authenticating client");
            }
            X509TrustManager tm = SocketFactoryCreator.getSSLTrustManager((X509CertChainValidator)this.sec.getValidator());
            tm = new LoggingX509TrustManager(tm, "ssl");
            if (log.isTraceEnabled()) {
                this.debugTS((X509CertChainValidator)this.sec.getValidator());
            }
            SSLContext sslcontext = SSLContext.getInstance("TLS");
            sslcontext.init(new KeyManager[]{km}, new TrustManager[]{tm}, null);
            return sslcontext;
        }
        catch (Exception e) {
            log.fatal(e.getMessage(), e);
            throw new RuntimeException(e);
        }
    }

    private void debugTS(X509CertChainValidator validator) {
        X509Certificate[] trustedCerts;
        for (X509Certificate cert : trustedCerts = validator.getTrustedIssuers()) {
            log.trace("Currently(!) trusted certificate:\n" + CertificateUtils.format((X509Certificate)cert, (FormatMode)FormatMode.FULL));
        }
    }

    private void debugKS(X509Credential c) {
        Certificate[] certs = c.getCertificateChain();
        X509Certificate[] certs509 = CertificateUtils.convertToX509Chain((Certificate[])certs);
        log.trace("Client's certificate chain:" + CertificateUtils.format((X509Certificate[])certs509, (FormatMode)FormatMode.FULL));
    }

    private SSLContext getSSLContext() {
        if (this.sslcontext == null) {
            this.sslcontext = this.createSSLContext();
        }
        return this.sslcontext;
    }

    public Socket createSocket(String host, int port, InetAddress localAddress, int localPort, HttpParams params) throws IOException, UnknownHostException {
        if (params == null) {
            throw new IllegalArgumentException("Parameters may not be null");
        }
        int timeout = HttpConnectionParams.getConnectionTimeout((HttpParams)params);
        SSLSocketFactory socketfactory = this.getSSLContext().getSocketFactory();
        if (timeout == 0) {
            Socket socket = socketfactory.createSocket(host, port, localAddress, localPort);
            this.checkHostname((SSLSocket)socket);
            return socket;
        }
        Socket socket = socketfactory.createSocket();
        InetSocketAddress localaddr = new InetSocketAddress(localAddress, localPort);
        InetSocketAddress remoteaddr = new InetSocketAddress(host, port);
        socket.bind(localaddr);
        socket.connect(remoteaddr, timeout);
        this.checkHostname((SSLSocket)socket);
        return socket;
    }

    private void checkHostname(SSLSocket socket) throws IOException {
        HostnameMismatchCallbackImpl callback = new HostnameMismatchCallbackImpl(this.sec.getServerHostnameCheckingMode());
        SocketFactoryCreator.connectWithHostnameChecking((SSLSocket)socket, (HostnameMismatchCallback)callback);
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress clientHost, int clientPort) throws IOException, UnknownHostException {
        Socket socket = this.getSSLContext().getSocketFactory().createSocket(host, port, clientHost, clientPort);
        this.checkHostname((SSLSocket)socket);
        return socket;
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
        Socket socket = this.getSSLContext().getSocketFactory().createSocket(host, port);
        this.checkHostname((SSLSocket)socket);
        return socket;
    }

    @Override
    public Socket createSocket(Socket socket, String host, int port, boolean autoClose) throws IOException, UnknownHostException {
        Socket socket2 = this.getSSLContext().getSocketFactory().createSocket(socket, host, port, autoClose);
        this.checkHostname((SSLSocket)socket2);
        return socket2;
    }

    @Override
    public String[] getDefaultCipherSuites() {
        return this.createSSLContext().getSupportedSSLParameters().getCipherSuites();
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return this.createSSLContext().getSupportedSSLParameters().getCipherSuites();
    }

    @Override
    public Socket createSocket(InetAddress host, int port) throws IOException {
        Socket socket = this.getSSLContext().getSocketFactory().createSocket(host, port);
        this.checkHostname((SSLSocket)socket);
        return socket;
    }

    @Override
    public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
        Socket socket = this.getSSLContext().getSocketFactory().createSocket(address, port, localAddress, localPort);
        this.checkHostname((SSLSocket)socket);
        return socket;
    }
}

