/*
 * Decompiled with CFR 0.152.
 */
package org.xmlpull.infoset.wrapper;

import org.xmlpull.infoset.XmlAttribute;
import org.xmlpull.infoset.XmlBuilderException;
import org.xmlpull.infoset.XmlComment;
import org.xmlpull.infoset.XmlContainer;
import org.xmlpull.infoset.XmlDocument;
import org.xmlpull.infoset.XmlElement;
import org.xmlpull.infoset.XmlElementView;
import org.xmlpull.infoset.XmlNamespace;

public class XmlElementAdapter
implements XmlElement {
    private XmlElementAdapter topAdapter;
    private XmlElement target;
    private XmlContainer parent;

    public XmlElementAdapter(XmlElement target) {
        this.setTarget(target);
    }

    private void setTarget(XmlElement target) {
        this.target = target;
        if (target.getParent() != null) {
            this.parent = target.getParent();
            if (this.parent instanceof XmlDocument) {
                XmlDocument doc = (XmlDocument)this.parent;
                doc.setDocumentElement(this);
            }
            if (this.parent instanceof XmlElement) {
                XmlElement parentEl = (XmlElement)this.parent;
                parentEl.replaceChild(this, target);
            }
        }
        for (Object child : target.children()) {
            this.fixImportedChildParent(child);
        }
    }

    @Override
    public XmlElement clone() throws CloneNotSupportedException {
        XmlElementAdapter ela = (XmlElementAdapter)super.clone();
        ela.parent = null;
        ela.target = this.target.clone();
        return ela;
    }

    public XmlElement getTarget() {
        return this.target;
    }

    public XmlElementAdapter getTopAdapter() {
        return this.topAdapter != null ? this.topAdapter : this;
    }

    public void setTopAdapter(XmlElementAdapter adapter) {
        this.topAdapter = adapter;
        if (this.target instanceof XmlElementAdapter) {
            ((XmlElementAdapter)this.target).setTopAdapter(adapter);
        }
    }

    public static XmlElementAdapter castOrWrap(XmlElement el, Class adapterClass) {
        if (el == null) {
            throw new IllegalArgumentException("null element can not be wrapped");
        }
        if (!XmlElementAdapter.class.isAssignableFrom(adapterClass)) {
            throw new IllegalArgumentException("class for cast/wrap must extend " + XmlElementAdapter.class);
        }
        if (el instanceof XmlElementAdapter) {
            XmlElementAdapter currentAdap = (XmlElementAdapter)el;
            Class<?> currentAdapClass = currentAdap.getClass();
            if (adapterClass.isAssignableFrom(currentAdapClass)) {
                return currentAdap;
            }
            XmlElementAdapter topAdapter = currentAdap = currentAdap.getTopAdapter();
            while (currentAdap.topAdapter != null) {
                currentAdapClass = currentAdap.getClass();
                if (currentAdapClass.isAssignableFrom(adapterClass)) {
                    return currentAdap;
                }
                if (!(currentAdap.target instanceof XmlElementAdapter)) break;
                currentAdap = (XmlElementAdapter)currentAdap.target;
            }
            try {
                currentAdap.topAdapter = (XmlElementAdapter)adapterClass.getConstructor(XmlElement.class).newInstance(topAdapter);
                currentAdap.topAdapter.setTopAdapter(currentAdap.topAdapter);
                return currentAdap.topAdapter;
            }
            catch (Exception e) {
                throw new XmlBuilderException("could not create wrapper of " + adapterClass, e);
            }
        }
        try {
            XmlElementAdapter t = (XmlElementAdapter)adapterClass.getConstructor(XmlElement.class).newInstance(el);
            return t;
        }
        catch (Exception e) {
            throw new XmlBuilderException("could not wrap element " + el, e);
        }
    }

    private void fixImportedChildParent(Object child) {
        XmlElement childEl;
        XmlContainer childElParent;
        if (child instanceof XmlElement && (childElParent = (childEl = (XmlElement)child).getParent()) == this.target) {
            childEl.setParent(this);
        }
    }

    private XmlElement fixElementParent(XmlElement el) {
        el.setParent(this);
        return el;
    }

    @Override
    public XmlContainer getRoot() {
        XmlContainer root = this.target.getRoot();
        if (root == this.target) {
            root = this;
        }
        return root;
    }

    @Override
    public XmlContainer getParent() {
        return this.parent;
    }

    @Override
    public void setParent(XmlContainer parent) {
        this.parent = parent;
    }

    @Override
    public XmlNamespace newNamespace(String prefix, String namespaceName) {
        return this.target.newNamespace(prefix, namespaceName);
    }

    @Override
    public XmlAttribute attribute(String attributeName) {
        return this.target.attribute(attributeName);
    }

    @Override
    public XmlAttribute attribute(XmlNamespace attributeNamespaceName, String attributeName) {
        return this.target.attribute(attributeNamespaceName, attributeName);
    }

    @Override
    public XmlAttribute requiredAttribute(String attributeName) throws XmlBuilderException {
        return this.target.requiredAttribute(attributeName);
    }

    @Override
    public XmlAttribute requiredAttribute(XmlNamespace attributeNamespaceName, String attributeName) throws XmlBuilderException {
        return this.target.requiredAttribute(attributeNamespaceName, attributeName);
    }

    @Override
    public Iterable<XmlAttribute> attributes() {
        return this.target.attributes();
    }

    @Override
    public void removeAllChildren() {
        this.target.removeAllChildren();
    }

    @Override
    public XmlElement setAttribute(String attributeType, String attributePrefix, String attributeNamespace, String attributeName, String attributeValue, boolean specified) {
        return this.target.setAttribute(attributeType, attributePrefix, attributeNamespace, attributeName, attributeValue, specified);
    }

    @Override
    public String attributeValue(String attributeName) {
        return this.target.attributeValue(attributeName);
    }

    @Override
    public String attributeValue(XmlNamespace attributeNamespace, String attributeName) {
        return this.target.attributeValue(attributeNamespace, attributeName);
    }

    @Override
    public String requiredAttributeValue(String attributeName) throws XmlBuilderException {
        return this.target.requiredAttributeValue(attributeName);
    }

    @Override
    public String requiredAttributeValue(XmlNamespace attributeNamespace, String attributeName) throws XmlBuilderException {
        return this.target.requiredAttributeValue(attributeNamespace, attributeName);
    }

    @Override
    public XmlElement setAttributeValue(XmlNamespace namespace, String name, String value) {
        return this.target.setAttributeValue(namespace, name, value);
    }

    @Override
    public String getNamespaceName() {
        return this.target.getNamespaceName();
    }

    @Override
    public void ensureChildrenCapacity(int minCapacity) {
        this.target.ensureChildrenCapacity(minCapacity);
    }

    @Override
    public Iterable<XmlNamespace> namespaces() {
        return this.target.namespaces();
    }

    @Override
    public void removeAllAttributes() {
        this.target.removeAllAttributes();
    }

    @Override
    public XmlNamespace getNamespace() {
        return this.target.getNamespace();
    }

    @Override
    public String getBaseUri() {
        return this.target.getBaseUri();
    }

    @Override
    public void removeAttribute(XmlAttribute attr) {
        this.target.removeAttribute(attr);
    }

    @Override
    public XmlNamespace declareNamespace(String prefix, String namespaceName) {
        return this.target.declareNamespace(prefix, namespaceName);
    }

    @Override
    public void removeAllNamespaceDeclarations() {
        this.target.removeAllNamespaceDeclarations();
    }

    @Override
    public boolean hasAttributes() {
        return this.target.hasAttributes();
    }

    @Override
    public XmlElement setAttribute(String type, XmlNamespace namespace, String name, String value, boolean specified) {
        return this.target.setAttribute(type, namespace, name, value, specified);
    }

    @Override
    public XmlNamespace declareNamespace(XmlNamespace namespace) {
        return this.target.declareNamespace(namespace);
    }

    @Override
    public XmlElement setAttributeValue(String name, String value) {
        return this.target.setAttributeValue(name, value);
    }

    @Override
    public boolean hasNamespaceDeclarations() {
        return this.target.hasNamespaceDeclarations();
    }

    @Override
    public XmlNamespace lookupNamespaceByName(String namespaceName) {
        XmlContainer p;
        XmlNamespace ns = this.target.lookupNamespaceByName(namespaceName);
        if (ns == null && (p = this.getParent()) instanceof XmlElement) {
            XmlElement e = (XmlElement)p;
            return e.lookupNamespaceByName(namespaceName);
        }
        return ns;
    }

    @Override
    public XmlNamespace lookupNamespaceByPrefix(String namespacePrefix) {
        XmlContainer p;
        XmlNamespace ns = this.target.lookupNamespaceByPrefix(namespacePrefix);
        if (ns == null && (p = this.getParent()) instanceof XmlElement) {
            XmlElement e = (XmlElement)p;
            return e.lookupNamespaceByPrefix(namespacePrefix);
        }
        return ns;
    }

    @Override
    public XmlNamespace newNamespace(String namespaceName) {
        return this.target.newNamespace(namespaceName);
    }

    @Override
    public void setBaseUri(String baseUri) {
        this.target.setBaseUri(baseUri);
    }

    @Override
    public void setNamespace(XmlNamespace namespace) {
        this.target.setNamespace(namespace);
    }

    @Override
    public void ensureNamespaceDeclarationsCapacity(int minCapacity) {
        this.target.ensureNamespaceDeclarationsCapacity(minCapacity);
    }

    @Override
    public String getName() {
        return this.target.getName();
    }

    @Override
    public void setName(String name) {
        this.target.setName(name);
    }

    @Override
    public XmlElement setAttribute(String type, XmlNamespace namespace, String name, String value) {
        return this.target.setAttribute(type, namespace, name, value);
    }

    @Override
    public void ensureAttributesCapacity(int minCapacity) {
        this.target.ensureAttributesCapacity(minCapacity);
    }

    @Override
    public XmlElement setAttribute(XmlAttribute attributeValueToAdd) {
        return this.target.setAttribute(attributeValueToAdd);
    }

    @Override
    public XmlElement element(int position) {
        return this.target.element(position);
    }

    @Override
    public XmlElement requiredElement(String name) throws XmlBuilderException {
        return this.target.requiredElement(name);
    }

    @Override
    public XmlElement element(String name) {
        return this.target.element(name);
    }

    @Override
    public XmlElement requiredElement(XmlNamespace n, String name) {
        return this.target.requiredElement(n, name);
    }

    @Override
    public XmlElement element(XmlNamespace n, String name) {
        return this.target.element(n, name);
    }

    @Override
    public XmlElement element(XmlNamespace n, String name, boolean create) {
        return this.target.element(n, name, create);
    }

    public Iterable elements(XmlNamespace n, String name) {
        return this.target.elements(n, name);
    }

    @Override
    public XmlElement newElement(XmlNamespace namespace, String name) {
        return this.target.newElement(namespace, name);
    }

    @Override
    public XmlElement addElement(XmlElement child) {
        return this.fixElementParent(this.target.addElement(child));
    }

    @Override
    public XmlElement addElement(int pos, XmlElement child) {
        return this.fixElementParent(this.target.addElement(pos, child));
    }

    @Override
    public XmlElement addElement(String name) {
        return this.fixElementParent(this.target.addElement(name));
    }

    @Override
    public XmlComment addComment(String content) {
        return this.target.addComment(content);
    }

    @Override
    public void addChild(Object child) {
        this.target.addChild(child);
        this.fixImportedChildParent(child);
    }

    @Override
    public void insertChild(int pos, Object childToInsert) {
        this.target.insertChild(pos, childToInsert);
        this.fixImportedChildParent(childToInsert);
    }

    @Override
    public void removeChild(Object child) {
        this.target.removeChild(child);
    }

    @Override
    public void removeElement(XmlElement el) {
        this.target.removeElement(el);
    }

    @Override
    public Iterable children() {
        return this.target.children();
    }

    public Iterable requiredElementContent() {
        return this.target.requiredElementContent();
    }

    @Override
    public String requiredText() {
        return this.target.requiredText();
    }

    @Override
    public boolean hasChild(Object child) {
        return this.target.hasChild(child);
    }

    @Override
    public XmlElement newElement(String namespaceName, String name) {
        return this.target.newElement(namespaceName, name);
    }

    @Override
    public XmlElement addElement(XmlNamespace namespace, String name) {
        return this.fixElementParent(this.target.addElement(namespace, name));
    }

    @Override
    public boolean hasChildren() {
        return this.target.hasChildren();
    }

    @Override
    public void addChild(int pos, Object child) {
        this.target.addChild(pos, child);
        this.fixImportedChildParent(child);
    }

    @Override
    public void replaceChild(Object newChild, Object oldChild) {
        this.target.replaceChild(newChild, oldChild);
        this.fixImportedChildParent(newChild);
    }

    @Override
    public void replaceElement(XmlElement newElement, XmlElement oldElement) {
        this.target.replaceChild(newElement, oldElement);
        this.fixImportedChildParent(newElement);
    }

    @Override
    public void replaceLikeElementsWith(XmlElement element) {
        this.target.replaceLikeElementsWith(element);
        this.fixImportedChildParent(element);
    }

    @Override
    public XmlElement newElement(String name) {
        return this.target.newElement(name);
    }

    @Override
    public XmlComment newComment(String content) {
        return this.target.newComment(content);
    }

    @Override
    public void setText(String textContent) {
        this.target.setText(textContent);
    }

    @Override
    public <T extends XmlElementView> T viewAs(Class<T> someViewClass) throws XmlBuilderException {
        return this.target.viewAs(someViewClass);
    }

    @Override
    public void addView(XmlElementView newView) throws XmlBuilderException {
        this.target.addView(newView);
    }

    @Override
    public <T extends XmlElementView> Iterable<T> elements(XmlNamespace n, String name, Class<T> someViewClass) {
        return this.target.elements(n, name, someViewClass);
    }
}

