/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.nio.serialization;

import com.hazelcast.logging.Logger;
import com.hazelcast.nio.ClassLoaderUtil;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.DataSerializable;
import com.hazelcast.nio.serialization.DataSerializableFactory;
import com.hazelcast.nio.serialization.DataSerializerHook;
import com.hazelcast.nio.serialization.HazelcastSerializationException;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.nio.serialization.SerializationConstants;
import com.hazelcast.nio.serialization.StreamSerializer;
import com.hazelcast.util.ExceptionUtil;
import com.hazelcast.util.ServiceLoader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

final class DataSerializer
implements StreamSerializer<DataSerializable> {
    private static final String FACTORY_ID = "com.hazelcast.DataSerializerHook";
    private final Map<Integer, DataSerializableFactory> factories = new HashMap<Integer, DataSerializableFactory>();

    DataSerializer(Map<Integer, ? extends DataSerializableFactory> dataSerializableFactories, ClassLoader classLoader) {
        try {
            Iterator<DataSerializerHook> hooks = ServiceLoader.iterator(DataSerializerHook.class, FACTORY_ID, classLoader);
            while (hooks.hasNext()) {
                DataSerializerHook hook = hooks.next();
                DataSerializableFactory factory = hook.createFactory();
                if (factory == null) continue;
                this.register(hook.getFactoryId(), factory);
            }
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow(e);
        }
        if (dataSerializableFactories != null) {
            for (Map.Entry<Integer, ? extends DataSerializableFactory> entry : dataSerializableFactories.entrySet()) {
                this.register(entry.getKey(), entry.getValue());
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void register(int factoryId, DataSerializableFactory factory) {
        DataSerializableFactory current = this.factories.get(factoryId);
        if (current != null) {
            if (!current.equals(factory)) throw new IllegalArgumentException("DataSerializableFactory[" + factoryId + "] is already registered! " + current + " -> " + factory);
            Logger.getLogger(this.getClass()).warning("DataSerializableFactory[" + factoryId + "] is already registered! Skipping " + factory);
            return;
        } else {
            this.factories.put(factoryId, factory);
        }
    }

    @Override
    public int getTypeId() {
        return SerializationConstants.CONSTANT_TYPE_DATA;
    }

    @Override
    public final DataSerializable read(ObjectDataInput in) throws IOException {
        boolean identified = in.readBoolean();
        int id = 0;
        int factoryId = 0;
        String className = null;
        try {
            DataSerializable ds;
            if (identified) {
                factoryId = in.readInt();
                DataSerializableFactory dsf = this.factories.get(factoryId);
                if (dsf == null) {
                    throw new HazelcastSerializationException("No DataSerializerFactory registered for namespace: " + factoryId);
                }
                id = in.readInt();
                ds = dsf.create(id);
                if (ds == null) {
                    throw new HazelcastSerializationException(dsf + " is not be able to create an instance for id: " + id);
                }
            } else {
                className = in.readUTF();
                ds = (DataSerializable)ClassLoaderUtil.newInstance(in.getClassLoader(), className);
            }
            ds.readData(in);
            return ds;
        }
        catch (Exception e) {
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            if (e instanceof HazelcastSerializationException) {
                throw (HazelcastSerializationException)e;
            }
            throw new HazelcastSerializationException("Problem while reading DataSerializable, namespace: " + factoryId + ", id: " + id + ", class: " + className + ", exception: " + e.getMessage(), e);
        }
    }

    @Override
    public final void write(ObjectDataOutput out, DataSerializable obj) throws IOException {
        boolean identified = obj instanceof IdentifiedDataSerializable;
        out.writeBoolean(identified);
        if (identified) {
            IdentifiedDataSerializable ds = (IdentifiedDataSerializable)obj;
            out.writeInt(ds.getFactoryId());
            out.writeInt(ds.getId());
        } else {
            out.writeUTF(obj.getClass().getName());
        }
        obj.writeData(out);
    }

    @Override
    public void destroy() {
        this.factories.clear();
    }
}

