/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.xml.javax.converter;

import java.io.Reader;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.compass.core.CompassException;
import org.compass.core.config.CompassConfigurable;
import org.compass.core.config.CompassSettings;
import org.compass.core.config.ConfigurationException;
import org.compass.core.converter.ConversionException;
import org.compass.core.converter.xsem.SupportsXmlContentWrapper;
import org.compass.core.converter.xsem.XmlContentConverter;
import org.compass.core.xml.AliasedXmlObject;
import org.compass.core.xml.XmlObject;
import org.compass.core.xml.javax.NodeAliasedXmlObject;
import org.compass.core.xml.javax.NodeXmlObject;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class NodeXmlContentConverter
implements XmlContentConverter,
CompassConfigurable,
SupportsXmlContentWrapper {
    private static Log log = LogFactory.getLog(NodeXmlContentConverter.class);
    private DocumentBuilder documentBuilder;
    private Transformer transformer;

    public void configure(CompassSettings settings) throws CompassException {
        try {
            this.documentBuilder = this.doCreateDocumentBuilder(settings);
        }
        catch (ParserConfigurationException e) {
            throw new ConfigurationException("Failed to create document builder", e);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Using document builder [" + this.documentBuilder.getClass().getName() + "]"));
        }
        try {
            this.transformer = this.doCreateTransformer(settings);
        }
        catch (TransformerConfigurationException e) {
            throw new ConfigurationException("Failed to create transformer", e);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Using transformer [" + this.transformer.getClass().getName() + "]"));
        }
    }

    protected DocumentBuilder doCreateDocumentBuilder(CompassSettings settings) throws ParserConfigurationException {
        return DocumentBuilderFactory.newInstance().newDocumentBuilder();
    }

    protected Transformer doCreateTransformer(CompassSettings settings) throws TransformerConfigurationException {
        return TransformerFactory.newInstance().newTransformer();
    }

    public boolean supports(String wrapper) {
        return !"singleton".equals(wrapper);
    }

    public AliasedXmlObject fromXml(String alias, Reader xml) throws ConversionException {
        Document document;
        try {
            document = this.documentBuilder.parse(new InputSource(xml));
        }
        catch (Exception e) {
            throw new ConversionException("Failed to parse alias[" + alias + "] xml[" + xml + "]", e);
        }
        return new NodeAliasedXmlObject(alias, document);
    }

    public String toXml(XmlObject xmlObject) throws ConversionException {
        NodeXmlObject nodeXmlObject = (NodeXmlObject)xmlObject;
        DOMSource source = new DOMSource(nodeXmlObject.getNode());
        StringWriter sw = new StringWriter();
        StreamResult result = new StreamResult(sw);
        try {
            this.transformer.transform(source, result);
        }
        catch (Exception e) {
            throw new ConversionException("Failed to marshall to xml, this should not happen", e);
        }
        return sw.toString();
    }
}

