/*
 * Decompiled with CFR 0.152.
 */
package org.compass.gps.device;

import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.compass.core.CompassCallbackWithoutResult;
import org.compass.core.CompassException;
import org.compass.core.CompassSession;
import org.compass.core.spi.InternalCompassSession;
import org.compass.gps.CompassGps;
import org.compass.gps.CompassGpsDevice;
import org.compass.gps.CompassGpsException;
import org.compass.gps.IndexPlan;
import org.compass.gps.MirrorDataChangesGpsDevice;
import org.compass.gps.spi.CompassGpsInterfaceDevice;

public abstract class AbstractGpsDevice
implements CompassGpsDevice {
    protected Log log = LogFactory.getLog(this.getClass());
    private String name;
    protected CompassGpsInterfaceDevice compassGps;
    private volatile boolean started = false;
    private boolean internalMirrorDataChanges = false;
    private String[] filteredEntitiesForIndex;
    private Set filteredEntitiesLookupForIndex;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public CompassGps getGps() {
        return this.compassGps;
    }

    public void injectGps(CompassGps compassGps) {
        this.compassGps = (CompassGpsInterfaceDevice)compassGps;
    }

    public void setFilteredEntitiesForIndex(String[] filteredEntitiesForIndex) {
        this.filteredEntitiesForIndex = filteredEntitiesForIndex;
    }

    public String buildMessage(String message) {
        return "{" + this.name + "}: " + message;
    }

    public boolean isFilteredForIndex(String entity) {
        return this.filteredEntitiesLookupForIndex != null && this.filteredEntitiesLookupForIndex.contains(entity);
    }

    public synchronized void index(final IndexPlan indexPlan) throws CompassGpsException {
        if (!this.isRunning()) {
            throw new IllegalStateException(this.buildMessage("must be running in order to perform the index operation"));
        }
        this.compassGps.executeForIndex(new CompassCallbackWithoutResult(){

            protected void doInCompassWithoutResult(CompassSession session) throws CompassException {
                AbstractGpsDevice.this.doIndex(session, indexPlan);
                ((InternalCompassSession)session).flush();
            }
        });
    }

    protected abstract void doIndex(CompassSession var1, IndexPlan var2) throws CompassGpsException;

    public synchronized void start() throws CompassGpsException {
        if (this.name == null) {
            throw new IllegalArgumentException("Must set the name for the device");
        }
        if (this.compassGps == null) {
            throw new IllegalArgumentException(this.buildMessage("Must set the compassGps for the device, or add it to an active CompassGps instance"));
        }
        if (!this.started) {
            if (this instanceof MirrorDataChangesGpsDevice) {
                this.internalMirrorDataChanges = ((MirrorDataChangesGpsDevice)((Object)this)).isMirrorDataChanges();
            }
            if (this.filteredEntitiesForIndex != null) {
                this.filteredEntitiesLookupForIndex = new HashSet();
                for (int i = 0; i < this.filteredEntitiesForIndex.length; ++i) {
                    this.filteredEntitiesLookupForIndex.add(this.filteredEntitiesForIndex[i]);
                }
            }
            this.doStart();
            this.started = true;
        }
    }

    protected void doStart() throws CompassGpsException {
    }

    public synchronized void stop() throws CompassGpsException {
        if (this.started) {
            this.doStop();
            this.started = false;
        }
    }

    protected void doStop() throws CompassGpsException {
    }

    public boolean isRunning() {
        return this.started;
    }

    public boolean isPerformingIndexOperation() {
        return this.compassGps.isPerformingIndexOperation();
    }

    public boolean shouldMirrorDataChanges() {
        if (!this.internalMirrorDataChanges) {
            return false;
        }
        return this.isRunning();
    }
}

