/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.base.tracker;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Queue;
import java.util.Set;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.AxisFault;
import org.apache.axis2.description.AxisModule;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.AxisEvent;
import org.apache.axis2.engine.AxisObserver;
import org.apache.axis2.transport.base.tracker.AxisServiceFilter;
import org.apache.axis2.transport.base.tracker.AxisServiceTrackerListener;

public class AxisServiceTracker {
    private final AxisObserver observer = new AxisObserver(){

        @Override
        public void init(AxisConfiguration axisConfig) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void serviceUpdate(AxisEvent event, final AxisService service) {
            switch (event.getEventType()) {
                case 1: 
                case 3: {
                    boolean pending;
                    if (!AxisServiceTracker.this.filter.matches(service)) break;
                    Object object = AxisServiceTracker.this.lock;
                    synchronized (object) {
                        pending = AxisServiceTracker.this.pendingActions != null;
                        if (pending) {
                            AxisServiceTracker.this.pendingActions.add(new Runnable(){

                                public void run() {
                                    AxisServiceTracker.this.serviceAdded(service);
                                }
                            });
                        }
                    }
                    if (pending) break;
                    AxisServiceTracker.this.serviceAdded(service);
                    break;
                }
                case 0: 
                case 2: {
                    boolean pending;
                    Object object = AxisServiceTracker.this.lock;
                    synchronized (object) {
                        pending = AxisServiceTracker.this.pendingActions != null;
                        if (pending) {
                            AxisServiceTracker.this.pendingActions.add(new Runnable(){

                                public void run() {
                                    AxisServiceTracker.this.serviceRemoved(service);
                                }
                            });
                        }
                    }
                    if (pending) break;
                    AxisServiceTracker.this.serviceRemoved(service);
                }
            }
        }

        @Override
        public void moduleUpdate(AxisEvent event, AxisModule module) {
        }

        @Override
        public void addParameter(Parameter param) throws AxisFault {
        }

        @Override
        public void removeParameter(Parameter param) throws AxisFault {
        }

        @Override
        public void deserializeParameters(OMElement parameterElement) throws AxisFault {
        }

        @Override
        public Parameter getParameter(String name) {
            return null;
        }

        @Override
        public ArrayList<Parameter> getParameters() {
            return null;
        }

        @Override
        public boolean isParameterLocked(String parameterName) {
            return false;
        }

        @Override
        public void serviceGroupUpdate(AxisEvent event, AxisServiceGroup serviceGroup) {
        }
    };
    private final AxisConfiguration config;
    final AxisServiceFilter filter;
    private final AxisServiceTrackerListener listener;
    final Object lock = new Object();
    Queue<Runnable> pendingActions;
    private Set<AxisService> services;

    public AxisServiceTracker(AxisConfiguration config, AxisServiceFilter filter, AxisServiceTrackerListener listener) {
        this.config = config;
        this.filter = filter;
        this.listener = listener;
    }

    public boolean isStarted() {
        return this.services != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        if (this.services != null) {
            throw new IllegalStateException();
        }
        Object object = this.lock;
        synchronized (object) {
            this.pendingActions = new LinkedList<Runnable>();
            this.config.addObservers(this.observer);
            this.services = new HashSet<AxisService>();
        }
        for (AxisService service : this.config.getServices().values()) {
            if (!service.isActive() || !this.filter.matches(service)) continue;
            this.serviceAdded(service);
        }
        while (true) {
            Runnable action;
            Object object2 = this.lock;
            synchronized (object2) {
                action = this.pendingActions.poll();
                if (action == null) {
                    this.pendingActions = null;
                    break;
                }
            }
            action.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void serviceAdded(AxisService service) {
        boolean callListener;
        Object object = this.lock;
        synchronized (object) {
            callListener = this.services.add(service);
        }
        if (callListener) {
            this.listener.serviceAdded(service);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void serviceRemoved(AxisService service) {
        boolean callListener;
        Object object = this.lock;
        synchronized (object) {
            callListener = this.services.remove(service);
        }
        if (callListener) {
            this.listener.serviceRemoved(service);
        }
    }

    public void stop() {
        if (this.services == null) {
            throw new IllegalStateException();
        }
        this.config.getObserversList().remove(this.observer);
        for (AxisService service : this.services) {
            this.listener.serviceRemoved(service);
        }
        this.services = null;
    }
}

