/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.core.transports;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axis2.AxisFault;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.TransportInDescription;
import org.apache.axis2.description.TransportOutDescription;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.CarbonException;
import org.wso2.carbon.core.persistence.AbstractPersistenceManager;
import org.wso2.carbon.core.persistence.PersistenceFactory;
import org.wso2.carbon.core.transports.TransportBuilderUtils;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;

public class TransportPersistenceManager
extends AbstractPersistenceManager {
    private static final String TRANSPORT_LISTENER = "listener";
    private static final String TRANSPORT_SENDER = "sender";
    private static final Log log = LogFactory.getLog(TransportPersistenceManager.class);

    public TransportPersistenceManager(AxisConfiguration axisConfig) throws AxisFault {
        super(axisConfig);
        try {
            if (this.pf == null) {
                this.pf = PersistenceFactory.getInstance(axisConfig);
            }
        }
        catch (Exception e) {
            log.error((Object)"Error getting PersistenceFactory instance", (Throwable)e);
        }
    }

    public void saveTransportListener(TransportInDescription transportIn, boolean enabled) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Saving the " + transportIn.getName() + " listener configuration"));
        }
        OMElement element = TransportBuilderUtils.serializeTransportListener(transportIn);
        this.saveTransport(element, enabled);
    }

    public void saveTransportSender(TransportOutDescription transportOut, boolean enabled) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Saving the " + transportOut.getName() + " sender configuration"));
        }
        OMElement element = TransportBuilderUtils.serializeTransportSender(transportOut);
        this.saveTransport(element, enabled);
    }

    public void saveTransport(OMElement element, boolean enabled) throws Exception {
        boolean listener = false;
        if ("transportReceiver".equals(element.getLocalName())) {
            listener = true;
        } else if ("transportSender".equals(element.getLocalName())) {
            listener = false;
        } else {
            this.handleFault("Invalid transport configuration element");
        }
        String name = element.getAttributeValue(new QName("name"));
        if (name == null || "".equals(name)) {
            this.handleFault("Transport configuration does not specify the name attribute");
        }
        String path = "/repository/transports/" + name + "/";
        path = listener ? path + TRANSPORT_LISTENER : path + TRANSPORT_SENDER;
        Resource resource = this.configRegistry.newResource();
        resource.setContent((Object)element.toString());
        resource.setProperty("Protocol.Name", name);
        resource.setProperty("Transport.Enabled", String.valueOf(enabled));
        this.configRegistry.put(path, resource);
        resource.discard();
    }

    public OMElement getTransportElement(String name, boolean listener) throws Exception {
        Resource resource = this.getTransportResource(this.configRegistry, name, listener);
        if (resource != null) {
            ByteArrayInputStream in = new ByteArrayInputStream((byte[])resource.getContent());
            resource.discard();
            StAXOMBuilder builder = new StAXOMBuilder((InputStream)in);
            OMElement el = builder.getDocumentElement();
            in.close();
            return el;
        }
        return null;
    }

    public TransportInDescription getTransportListener(String name, boolean init) throws Exception {
        OMElement element = this.getTransportElement(name, true);
        if (element != null) {
            return TransportBuilderUtils.processTransportReceiver(element, init);
        }
        return null;
    }

    public TransportOutDescription getTransportSender(String name, boolean init) throws Exception {
        OMElement element = this.getTransportElement(name, false);
        if (element != null) {
            return TransportBuilderUtils.processTransportSender(element, init);
        }
        return null;
    }

    public void addParameter(String name, boolean listener, boolean enabled, Parameter p) throws Exception {
        OMElement element = this.getTransportElement(name, listener);
        if (element != null) {
            element.addChild((OMNode)TransportBuilderUtils.serializeParameter(p, OMAbstractFactory.getOMFactory()));
            this.saveTransport(element, enabled);
        }
    }

    public void removeParameter(String name, boolean listener, boolean enabled, String paramName) throws Exception {
        OMElement element = this.getTransportElement(name, listener);
        if (element != null) {
            Iterator params = element.getChildrenWithLocalName("parameter");
            OMElement p = null;
            while (params.hasNext() && !paramName.equals((p = (OMElement)params.next()).getAttributeValue(new QName("name")))) {
            }
            if (p != null) {
                p.detach();
            }
            this.saveTransport(element, enabled);
        }
    }

    public String[] getEnabledTransports(boolean listener) throws Exception {
        if (!this.configRegistry.resourceExists("/repository/transports/")) {
            return null;
        }
        org.wso2.carbon.registry.core.Collection transports = (org.wso2.carbon.registry.core.Collection)this.configRegistry.get("/repository/transports/");
        String[] childResources = transports.getChildren();
        if (childResources == null || childResources.length == 0) {
            return null;
        }
        ArrayList<String> enabledTransports = new ArrayList<String>();
        for (String childPath : childResources) {
            Resource resource;
            if (!childPath.endsWith("/")) {
                childPath = childPath + "/";
            }
            if (!this.configRegistry.resourceExists(childPath = listener ? childPath + TRANSPORT_LISTENER : childPath + TRANSPORT_SENDER) || !Boolean.valueOf((resource = this.configRegistry.get(childPath)).getProperty("Transport.Enabled")).booleanValue()) continue;
            enabledTransports.add(resource.getProperty("Protocol.Name"));
        }
        if (enabledTransports.size() > 0) {
            return enabledTransports.toArray(new String[enabledTransports.size()]);
        }
        return null;
    }

    public Resource getTransportResource(String name) throws Exception {
        return this.getTransportResource(this.configRegistry, name, true);
    }

    public void setTransportEnabled(String name, boolean listener, boolean enabled) throws Exception {
        Resource resource = this.getTransportResource(this.configRegistry, name, listener);
        if (resource != null) {
            resource.setProperty("Transport.Enabled", String.valueOf(enabled));
            this.configRegistry.put(resource.getPath(), resource);
            resource.discard();
        }
    }

    public void updateEnabledTransports(Collection<TransportInDescription> listeners, Collection<TransportOutDescription> senders) throws Exception {
        for (TransportInDescription listener : listeners) {
            if (this.getTransportResource(this.configRegistry, listener.getName(), true) != null) continue;
            this.saveTransportListener(listener, false);
        }
        for (TransportOutDescription sender : senders) {
            if (this.getTransportResource(this.configRegistry, sender.getName(), false) != null) continue;
            this.saveTransportSender(sender, false);
        }
    }

    public void saveTransportConfiguration(String transport, URL configFileURL) throws Exception {
        OMElement conf;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Persiting the initial transport configuration for " + transport));
        }
        if (this.getTransportElement(transport, true) == null) {
            conf = TransportBuilderUtils.parseTransportConfiguration(transport, configFileURL, true);
            if (conf != null) {
                this.saveTransport(conf, false);
            } else {
                log.warn((Object)("No transport listener configuration found for : " + transport));
            }
        }
        if (this.getTransportElement(transport, false) == null) {
            conf = TransportBuilderUtils.parseTransportConfiguration(transport, configFileURL, false);
            if (conf != null) {
                this.saveTransport(conf, false);
            } else {
                log.warn((Object)("No transport sender configuration found for : " + transport));
            }
        }
    }

    private Resource getTransportResource(Registry registry, String name, boolean listener) throws Exception {
        String path = "/repository/transports/" + name + "/";
        path = listener ? path + TRANSPORT_LISTENER : path + TRANSPORT_SENDER;
        if (registry.resourceExists(path)) {
            return registry.get(path);
        }
        return null;
    }

    private void handleFault(String msg) throws CarbonException {
        log.error((Object)msg);
        throw new CarbonException(msg);
    }
}

