/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.security.wsutil.client;

import eu.unicore.security.wsutil.OperationsRequiringSignature;
import eu.unicore.security.wsutil.RequiresSignature;
import eu.unicore.security.wsutil.client.ConditionalGetInHandler;
import eu.unicore.security.wsutil.client.ConditionalGetOutHandler;
import eu.unicore.security.wsutil.client.ContextDSigDecider;
import eu.unicore.security.wsutil.client.DSigOutHandler;
import eu.unicore.security.wsutil.client.ExtendedTDOutHandler;
import eu.unicore.security.wsutil.client.OnDemandSAAJOutInterceptor;
import eu.unicore.security.wsutil.client.SAMLAttributePushOutHandler;
import eu.unicore.security.wsutil.client.WSClientFactory;
import eu.unicore.util.Log;
import eu.unicore.util.httpclient.DefaultClientConfiguration;
import eu.unicore.util.httpclient.IClientConfiguration;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.jws.WebMethod;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.message.Message;
import org.apache.log4j.Logger;

public class UnicoreWSClientFactory
extends WSClientFactory {
    private static final Logger logger = Log.getLogger("unicore.client", UnicoreWSClientFactory.class);
    protected final IClientConfiguration security;
    private ContextDSigDecider decider;

    public UnicoreWSClientFactory() {
        this(new DefaultClientConfiguration());
    }

    public UnicoreWSClientFactory(IClientConfiguration sec) {
        super(sec);
        this.security = this.securityProperties;
    }

    @Override
    protected void initHandlers() {
        super.initHandlers();
        this.decider = new ContextDSigDecider();
        IClientConfiguration security = this.securityProperties;
        this.addHandlers(this.outHandlers, security.getOutHandlerClassNames());
        if (security.doSignMessage()) {
            this.outHandlers.add(new OnDemandSAAJOutInterceptor(this.decider));
            this.outHandlers.add(new DSigOutHandler(security.getCredential(), this.decider));
        }
        if (security.getETDSettings() != null) {
            this.outHandlers.add(new ExtendedTDOutHandler(security));
        }
        SAMLAttributePushOutHandler samlOutHandler = new SAMLAttributePushOutHandler();
        this.outHandlers.add(samlOutHandler);
        this.addHandlers(this.inHandlers, security.getInHandlerClassNames());
        this.inHandlers.add(new ConditionalGetInHandler());
        this.outHandlers.add(new ConditionalGetOutHandler());
    }

    private Class<Interceptor<? extends Message>> loadClass(String name) throws ClassNotFoundException {
        IClientConfiguration security = this.securityProperties;
        if (security.getClassLoader() != null) {
            return Class.forName(name, true, security.getClassLoader());
        }
        return Class.forName(name);
    }

    private void addHandlers(List<Interceptor<? extends Message>> list, String[] handlers) {
        if (handlers == null) {
            return;
        }
        for (String className : handlers) {
            if (className != null && className.length() != 0) {
                try {
                    Class<Interceptor<? extends Message>> clazz = this.loadClass(className);
                    Interceptor<? extends Message> h = clazz.newInstance();
                    list.add(h);
                    logger.debug("Sucessfully added security handler <" + className + ">");
                }
                catch (Exception e) {
                    logger.error("Could not setup security handler <" + className + "!", e);
                }
                continue;
            }
            logger.debug("No security handlers added.");
        }
    }

    @Override
    protected <T> void setupProxyInterface(Class<T> iFace, Client wsClient) {
        super.setupProxyInterface(iFace, wsClient);
        wsClient.getRequestContext().put(ContextDSigDecider.SIGNED_OPERATIONS, UnicoreWSClientFactory.getOperationsToSign(iFace));
    }

    public static <T> Set<String> getOperationsToSign(Class<T> iFace) {
        Method[] methods;
        HashSet<String> opsToSign = new HashSet<String>();
        OperationsRequiringSignature list = iFace.getAnnotation(OperationsRequiringSignature.class);
        if (list != null) {
            for (String s : list.operations()) {
                opsToSign.add(s);
            }
        }
        for (Method m : methods = iFace.getMethods()) {
            if (m.getAnnotation(RequiresSignature.class) == null) continue;
            WebMethod wm = m.getAnnotation(WebMethod.class);
            if (wm != null && wm.action() != null && !wm.action().equals("")) {
                opsToSign.add(wm.action());
                continue;
            }
            logger.warn("Method <" + m.getName() + "> is marked as requiring a " + "signature but no SOAP action is defined for it. " + "This method invocations won't be signed.");
        }
        return opsToSign;
    }
}

