/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.dsmlv2.actions;

import java.io.IOException;
import org.apache.directory.api.dsmlv2.Dsmlv2Container;
import org.apache.directory.api.dsmlv2.Dsmlv2StatesEnum;
import org.apache.directory.api.dsmlv2.GrammarAction;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class ReadSoapHeader
extends GrammarAction {
    public ReadSoapHeader() {
        super("Reads SOAP header");
    }

    @Override
    public void action(Dsmlv2Container container) throws XmlPullParserException {
        try {
            XmlPullParser xpp = container.getParser();
            StringBuilder sb = new StringBuilder();
            String startTag = xpp.getText();
            sb.append(startTag);
            startTag = startTag.substring(1, startTag.length() - 1);
            int tagType = -1;
            String endTag = "";
            while (!startTag.equals(endTag)) {
                tagType = xpp.next();
                endTag = xpp.getText();
                sb.append(endTag);
                if (tagType != 3) continue;
                endTag = endTag.substring(2, endTag.length() - 1);
            }
            container.setState(Dsmlv2StatesEnum.SOAP_HEADER_END_TAG);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

