/*
 * Decompiled with CFR 0.152.
 */
package org.databene.contiperf.report;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.databene.contiperf.ExecutionConfig;
import org.databene.contiperf.PerformanceRequirement;
import org.databene.contiperf.report.AbstractReportModule;
import org.databene.contiperf.util.ContiPerfUtil;
import org.databene.stat.LatencyCounter;

public class CSVSummaryReportModule
extends AbstractReportModule {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static Set<File> usedFiles = new HashSet<File>();
    private File file = null;

    @Override
    public String getReportReferenceLabel(String serviceId) {
        return serviceId == null ? "CSV Summary" : null;
    }

    @Override
    public String getReportReference(String serviceId) {
        return serviceId == null ? CSVSummaryReportModule.filename() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void starting(String serviceId) {
        Set<File> set = usedFiles;
        synchronized (set) {
            this.file = new File(this.context.getReportFolder(), CSVSummaryReportModule.filename());
            if (!usedFiles.contains(this.file) && this.file.exists()) {
                if (!this.file.delete()) {
                    throw new RuntimeException("Previous file version could not be deleted: " + this.file);
                }
                usedFiles.add(this.file);
            }
            if (!this.file.exists()) {
                this.writeHeader(serviceId);
            }
        }
    }

    @Override
    public void completed(String serviceId, LatencyCounter[] counters, ExecutionConfig executionConfig, PerformanceRequirement requirement) {
        this.writeStats(serviceId, counters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeHeader(String serviceId) {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(this.file, true);
            String line = "serviceId,startTime,duration,invocations,min,average,median,90%,95%,99%,max" + LINE_SEPARATOR;
            ((OutputStream)out).write(line.getBytes());
        }
        catch (IOException e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                ContiPerfUtil.close(out);
                throw throwable;
            }
            ContiPerfUtil.close(out);
        }
        ContiPerfUtil.close(out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeStats(String serviceId, LatencyCounter[] counters) {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(this.file, true);
            DecimalFormat decForm = new DecimalFormat("0.#", DecimalFormatSymbols.getInstance(Locale.US));
            decForm.setGroupingUsed(false);
            LatencyCounter mainCounter = counters[0];
            String avg = decForm.format(mainCounter.averageLatency());
            String message = serviceId + ',' + mainCounter.getStartTime() + ',' + mainCounter.duration() + ',' + mainCounter.sampleCount() + ',' + mainCounter.minLatency() + ',' + avg + ',' + mainCounter.percentileLatency(50) + ',' + mainCounter.percentileLatency(90) + ',' + mainCounter.percentileLatency(95) + ',' + mainCounter.percentileLatency(99) + ',' + mainCounter.maxLatency() + LINE_SEPARATOR;
            ((OutputStream)out).write(message.getBytes());
        }
        catch (IOException e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                ContiPerfUtil.close(out);
                throw throwable;
            }
            ContiPerfUtil.close(out);
        }
        ContiPerfUtil.close(out);
    }

    private static String filename() {
        return "summary.csv";
    }
}

