/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.jsr303.groups;

import java.util.LinkedList;
import java.util.List;
import javax.validation.GroupDefinitionException;
import org.apache.bval.jsr303.groups.Group;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Groups {
    protected List<Group> groups = new LinkedList<Group>();
    protected List<List<Group>> sequences = new LinkedList<List<Group>>();

    public List<Group> getGroups() {
        return this.groups;
    }

    public List<List<Group>> getSequences() {
        return this.sequences;
    }

    void insertGroup(Group group) {
        if (!this.groups.contains(group)) {
            this.groups.add(group);
        }
    }

    void insertSequence(List<Group> groups) {
        if (groups == null || groups.isEmpty()) {
            return;
        }
        if (!this.sequences.contains(groups)) {
            this.sequences.add(groups);
        }
    }

    public void assertDefaultGroupSequenceIsExpandable(List<Group> defaultGroups) {
        for (List<Group> groupList : this.sequences) {
            int idx = groupList.indexOf(Group.DEFAULT);
            if (idx == -1) continue;
            this.ensureExpandable(groupList, defaultGroups, idx);
        }
    }

    private void ensureExpandable(List<Group> groupList, List<Group> defaultGroupList, int defaultGroupIndex) {
        for (int i = 0; i < defaultGroupList.size(); ++i) {
            int index;
            Group group = defaultGroupList.get(i);
            if (group.isDefault() || (index = groupList.indexOf(group)) == -1 || i == 0 && index == defaultGroupIndex - 1 || i == defaultGroupList.size() - 1 && index == defaultGroupIndex + 1) continue;
            throw new GroupDefinitionException("Unable to expand default group list" + defaultGroupList + " into sequence " + groupList);
        }
    }
}

