/*
 * Decompiled with CFR 0.152.
 */
package edu.uiuc.ncsa.security.delegation.storage.impl;

import edu.uiuc.ncsa.security.core.IdentifiableProvider;
import edu.uiuc.ncsa.security.delegation.storage.Client;
import edu.uiuc.ncsa.security.delegation.storage.ClientKeys;
import edu.uiuc.ncsa.security.storage.data.ConversionMap;
import edu.uiuc.ncsa.security.storage.data.MapConverter;
import edu.uiuc.ncsa.security.storage.data.SerializationKeys;

public class ClientConverter<V extends Client>
extends MapConverter<V> {
    public ClientConverter(IdentifiableProvider<V> identifiableProvider) {
        this(new ClientKeys(), identifiableProvider);
    }

    public ClientConverter(SerializationKeys keys, IdentifiableProvider<V> identifiableProvider) {
        super(keys, identifiableProvider);
    }

    protected ClientKeys getCK() {
        return (ClientKeys)this.keys;
    }

    public V fromMap(ConversionMap<String, Object> map, V v) {
        Client value = (Client)super.fromMap(map, v);
        value.setName(map.getString((Object)this.getCK().name(new String[0])));
        value.setHomeUri(map.getString((Object)this.getCK().homeURL(new String[0])));
        value.setCreationTS(map.getDate((Object)this.getCK().creationTS(new String[0])));
        value.setErrorUri(map.getString((Object)this.getCK().errorURL(new String[0])));
        value.setSecret(map.getString((Object)this.getCK().secret(new String[0])));
        value.setEmail(map.getString((Object)this.getCK().email(new String[0])));
        value.setProxyLimited(map.getBoolean((Object)this.getCK().proxyLimited(new String[0])));
        return (V)((Object)value);
    }

    public void toMap(V client, ConversionMap<String, Object> map) {
        super.toMap(client, map);
        map.put((Object)this.getCK().secret(new String[0]), (Object)((Client)((Object)client)).getSecret());
        map.put((Object)this.getCK().name(new String[0]), (Object)((Client)((Object)client)).getName());
        map.put((Object)this.getCK().homeURL(new String[0]), (Object)((Client)((Object)client)).getHomeUri());
        map.put((Object)this.getCK().creationTS(new String[0]), (Object)((Client)((Object)client)).getCreationTS());
        map.put((Object)this.getCK().errorURL(new String[0]), (Object)((Client)((Object)client)).getErrorUri());
        map.put((Object)this.getCK().email(new String[0]), (Object)((Client)((Object)client)).getEmail());
        map.put((Object)this.getCK().proxyLimited(new String[0]), (Object)((Client)((Object)client)).isProxyLimited());
    }
}

