/*
 * Decompiled with CFR 0.152.
 */
package org.apache.custos.service.federated.client.cilogon;

import java.util.Base64;
import javax.validation.constraints.NotNull;
import org.apache.custos.service.federated.client.cilogon.CILogonInstitution;
import org.apache.custos.service.federated.client.cilogon.CILogonRequest;
import org.apache.custos.service.federated.client.cilogon.CILogonResponse;
import org.json.JSONException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Component
public class CILogonClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(CILogonClient.class);
    private final RestTemplate template = new RestTemplate();
    @Value(value="${ciLogon.admin.client.id}")
    private String adminClientId;
    @Value(value="${ciLogon.admin.client.secret}")
    private String adminClientSecret;
    @Value(value="${ciLogon.admin.auth.endpoint:https://test.cilogon.org/oauth2/oidc-cm}")
    private String ciLogonAuthEndpoint;
    @Value(value="${ciLogon.institutions.endpoint:https://cilogon.org/idplist/}")
    private String ciLogonInstitutionsEndpoint;

    public CILogonResponse registerClient(@NotNull String clientName, @NotNull String[] redirectURIs, @NotNull String comment, String[] scopes, String homeURL, String contactEmail) throws JSONException {
        CILogonRequest req = new CILogonRequest();
        req.setClientName(clientName);
        req.setRedirectURIs(redirectURIs);
        req.setComment(comment);
        if (scopes != null && scopes.length > 0) {
            req.setScope(scopes);
        }
        if (homeURL != null) {
            req.setClientURI(homeURL);
        }
        if (contactEmail != null) {
            req.setContacts(new String[]{contactEmail});
        }
        HttpHeaders headers = new HttpHeaders();
        headers.add("Authorization", this.getBearerToken());
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity entity = new HttpEntity((Object)req, (MultiValueMap)headers);
        ResponseEntity responseEntity = this.template.exchange(this.ciLogonAuthEndpoint, HttpMethod.POST, entity, CILogonResponse.class, new Object[0]);
        return (CILogonResponse)responseEntity.getBody();
    }

    public CILogonResponse getClient(@NotNull String clientId) {
        HttpHeaders headers = new HttpHeaders();
        headers.add("Authorization", this.getBearerToken());
        headers.setContentType(MediaType.APPLICATION_JSON);
        String url = this.ciLogonAuthEndpoint + "?client_id=" + clientId;
        LOGGER.info("URL: {}", (Object)url);
        HttpEntity entity = new HttpEntity((Object)"parameters", (MultiValueMap)headers);
        ResponseEntity responseEntity = this.template.exchange(url, HttpMethod.GET, entity, CILogonResponse.class, new Object[0]);
        return (CILogonResponse)responseEntity.getBody();
    }

    public void updateClient(@NotNull String clientId, @NotNull String clientName, @NotNull String[] redirectURIs, @NotNull String comment, String[] scopes, String homeURL, String contactEmail) {
        CILogonRequest req = new CILogonRequest();
        req.setClientName(clientName);
        req.setRedirectURIs(redirectURIs);
        req.setComment(comment);
        if (scopes != null && scopes.length > 0) {
            req.setScope(scopes);
        }
        if (homeURL != null) {
            req.setClientURI(homeURL);
        }
        if (contactEmail != null) {
            req.setContacts(new String[]{contactEmail});
        }
        HttpHeaders headers = new HttpHeaders();
        headers.add("Authorization", this.getBearerToken());
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity entity = new HttpEntity((Object)req, (MultiValueMap)headers);
        String url = this.ciLogonAuthEndpoint + "?client_id=" + clientId;
        this.template.put(url, (Object)entity, new Object[0]);
    }

    public void deleteClient(@NotNull String clientId) {
        String url = this.ciLogonAuthEndpoint + "?client_id=" + clientId;
        HttpHeaders headers = new HttpHeaders();
        headers.add("Authorization", this.getBearerToken());
        HttpEntity entity = new HttpEntity((MultiValueMap)headers);
        this.template.exchange(url, HttpMethod.DELETE, entity, String.class, new Object[0]);
    }

    public CILogonInstitution[] getInstitutions() {
        HttpHeaders headers = new HttpHeaders();
        headers.add("Authorization", this.getBearerToken());
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity entity = new HttpEntity((MultiValueMap)headers);
        String url = this.ciLogonInstitutionsEndpoint;
        ResponseEntity responseEntity = this.template.exchange(url, HttpMethod.GET, entity, CILogonInstitution[].class, new Object[0]);
        return (CILogonInstitution[])responseEntity.getBody();
    }

    private String getBearerToken() {
        String decoded = this.adminClientId + ":" + this.adminClientSecret;
        return "Bearer " + Base64.getEncoder().encodeToString(decoded.getBytes());
    }
}

