/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtq.xml.types;

import com.ibm.xtq.xml.types.AnyAtomicType;
import com.ibm.xtq.xml.types.CollectionType;
import com.ibm.xtq.xml.types.ItemType;
import com.ibm.xtq.xml.types.OccurrenceIndicator;
import com.ibm.xtq.xml.types.Type;
import com.ibm.xtq.xml.types.TypeConstants;
import com.ibm.xtq.xml.types.TypeFactory;
import com.ibm.xtq.xml.types.XSequenceType;

public class ChoiceType
extends CollectionType {
    public static final ChoiceType NUMERIC = new ChoiceType();
    private boolean m_allSingleItems = true;

    public ChoiceType() {
    }

    public ChoiceType(Type type) {
        this.addType(type);
    }

    public ChoiceType(Type type, Type type2) {
        this.addType(type);
        this.addType(type2);
    }

    @Override
    public void addType(Type type) {
        if (type instanceof ChoiceType) {
            ChoiceType choiceType = (ChoiceType)type;
            int n = choiceType.size();
            for (int i = 0; i < n; ++i) {
                this.addSingleType(choiceType.get(i));
            }
        } else {
            this.addSingleType(type);
        }
    }

    private void addSingleType(Type type) {
        if (!this.m_types.contains(type)) {
            this.m_types.add(type);
            if (!(type instanceof ItemType)) {
                this.m_allSingleItems = false;
            }
            if (!this.m_hasNodeType && type.mayContainNodeType()) {
                this.m_hasNodeType = true;
            }
        }
    }

    @Override
    public Type getPrimeType() {
        if (this.m_allSingleItems) {
            return this;
        }
        return super.getPrimeType();
    }

    @Override
    public Type getApproximateType() {
        if (this.m_allSingleItems) {
            return this;
        }
        return TypeFactory.newType(this.getPrimeType(), this.getQuantifier());
    }

    @Override
    public OccurrenceIndicator getQuantifier() {
        int n = this.m_types.size();
        OccurrenceIndicator occurrenceIndicator = this.get(0).getQuantifier();
        for (int i = 1; i < n; ++i) {
            occurrenceIndicator = occurrenceIndicator.choice(this.get(i).getQuantifier());
        }
        if (this.canBeEmpty()) {
            return occurrenceIndicator.product(OccurrenceIndicator.ZERO_OR_ONE);
        }
        return occurrenceIndicator;
    }

    @Override
    public Type getAtomizedType() {
        if (!this.m_hasNodeType) {
            return this;
        }
        int n = this.size();
        ChoiceType choiceType = new ChoiceType(this.get(0).getAtomizedType());
        for (int i = 1; i < n; ++i) {
            choiceType.addType(this.get(i).getAtomizedType());
        }
        if (choiceType.size() == 1) {
            return choiceType.get(0);
        }
        return choiceType;
    }

    @Override
    public String getRuntimeType() {
        int n = this.size();
        String string = this.get(0).getRuntimeType();
        for (int i = 1; i < n; ++i) {
            String string2 = this.get(i).getRuntimeType();
            if (string2.equals(string)) continue;
            if (this.mayContainNodeType()) {
                return "com.ibm.xtq.xml.datamodel.XSequence";
            }
            OccurrenceIndicator occurrenceIndicator = this.getQuantifier();
            if (occurrenceIndicator == OccurrenceIndicator.ONE || occurrenceIndicator == OccurrenceIndicator.ZERO_OR_ONE) {
                return "com.ibm.xtq.xml.datamodel.XItem";
            }
            return "com.ibm.xtq.xml.datamodel.XSequence";
        }
        return string;
    }

    @Override
    public int castableAs(AnyAtomicType anyAtomicType, boolean bl) {
        int n = this.m_types.size();
        boolean bl2 = true;
        boolean bl3 = true;
        for (int i = 0; i < n; ++i) {
            Type type = (Type)this.m_types.get(i);
            int n2 = (type = type.getAtomizedType()).castableAs(anyAtomicType, bl);
            if (n2 == 1) {
                bl3 = false;
                continue;
            }
            if (n2 == 0) {
                bl2 = false;
                continue;
            }
            bl2 = false;
            bl3 = false;
        }
        if (bl2) {
            return 1;
        }
        if (bl3) {
            return 0;
        }
        return 2;
    }

    @Override
    public int typeMatches(XSequenceType xSequenceType, boolean bl) {
        if (this.canBeEmpty()) {
            return 2;
        }
        Type type = this.get(0);
        int n = this.size();
        int n2 = type.typeMatches(xSequenceType, bl);
        if (n2 == 2) {
            return 2;
        }
        for (int i = 1; i < n; ++i) {
            int n3 = this.get(i).typeMatches(xSequenceType, bl);
            if (n3 == 2) {
                return 2;
            }
            if (n2 != 0 && n3 == 0 || n2 == 0 && n3 != 0) {
                return 2;
            }
            if (n3 != 3) continue;
            n2 = n3;
        }
        return n2;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(");
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                stringBuffer.append(" | ");
            }
            stringBuffer.append(this.get(i).toString());
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        if (object instanceof ChoiceType) {
            ChoiceType choiceType = (ChoiceType)object;
            int n = this.size();
            if (n == choiceType.size()) {
                for (int i = 0; i < n; ++i) {
                    if (choiceType.contains(this.get(i))) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        return false;
    }

    static {
        NUMERIC.addSingleType(TypeConstants.INTEGER);
        NUMERIC.addSingleType(TypeConstants.DECIMAL);
        NUMERIC.addSingleType(TypeConstants.FLOAT);
        NUMERIC.addSingleType(TypeConstants.DOUBLE);
    }
}

