/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtq.xslt.typechecker.v2;

import com.ibm.xtq.ast.nodes.AnalyzeString;
import com.ibm.xtq.ast.nodes.ApplyTemplates;
import com.ibm.xtq.ast.nodes.AttributeSet;
import com.ibm.xtq.ast.nodes.CallTemplate;
import com.ibm.xtq.ast.nodes.CollationElement;
import com.ibm.xtq.ast.nodes.CompAttrConstructor;
import com.ibm.xtq.ast.nodes.CompElemConstructor;
import com.ibm.xtq.ast.nodes.CompNamespaceConstructor;
import com.ibm.xtq.ast.nodes.Copy;
import com.ibm.xtq.ast.nodes.CopyOf;
import com.ibm.xtq.ast.nodes.DirAttributeConstructor;
import com.ibm.xtq.ast.nodes.DirElemConstructor;
import com.ibm.xtq.ast.nodes.DirPIConstructor;
import com.ibm.xtq.ast.nodes.Expr;
import com.ibm.xtq.ast.nodes.Fallback;
import com.ibm.xtq.ast.nodes.ForEach;
import com.ibm.xtq.ast.nodes.ForEachGroup;
import com.ibm.xtq.ast.nodes.FunctionDecl;
import com.ibm.xtq.ast.nodes.If;
import com.ibm.xtq.ast.nodes.Key;
import com.ibm.xtq.ast.nodes.Message;
import com.ibm.xtq.ast.nodes.Node;
import com.ibm.xtq.ast.nodes.Number;
import com.ibm.xtq.ast.nodes.Param;
import com.ibm.xtq.ast.nodes.PerformSort;
import com.ibm.xtq.ast.nodes.ResultDocument;
import com.ibm.xtq.ast.nodes.Sequence;
import com.ibm.xtq.ast.nodes.Sort;
import com.ibm.xtq.ast.nodes.Template;
import com.ibm.xtq.ast.nodes.Text;
import com.ibm.xtq.ast.nodes.TransletOutput;
import com.ibm.xtq.ast.nodes.TypeExpr;
import com.ibm.xtq.ast.nodes.UnsupportedElement;
import com.ibm.xtq.ast.nodes.UseAttributeSets;
import com.ibm.xtq.ast.nodes.ValueOf;
import com.ibm.xtq.ast.nodes.VarDecl;
import com.ibm.xtq.ast.nodes.VariableBase;
import com.ibm.xtq.ast.nodes.When;
import com.ibm.xtq.ast.nodes.WithParam;
import com.ibm.xtq.ast.nodes.XTQProgram;
import com.ibm.xtq.ast.res.ASTBaseMsg;
import com.ibm.xtq.common.utils.Assert;
import com.ibm.xtq.common.utils.Util;
import com.ibm.xtq.common.utils.WrappedRuntimeException;
import com.ibm.xtq.xml.res.XMLMessages;
import com.ibm.xtq.xml.types.AggregateType;
import com.ibm.xtq.xml.types.ChoiceType;
import com.ibm.xtq.xml.types.CollectionType;
import com.ibm.xtq.xml.types.ExtendedTypes;
import com.ibm.xtq.xml.types.ItemType;
import com.ibm.xtq.xml.types.OccurrenceIndicator;
import com.ibm.xtq.xml.types.Type;
import com.ibm.xtq.xml.types.TypeConstants;
import com.ibm.xtq.xml.types.XSequenceType;
import com.ibm.xtq.xslt.drivers.XSLTCompiler;
import com.ibm.xtq.xslt.res.ErrorMsg;
import com.ibm.xtq.xslt.translator.ASTDecorator;
import com.ibm.xtq.xslt.translator.ASTDecorator2;
import com.ibm.xtq.xslt.translator.StaticError;
import com.ibm.xtq.xslt.translator.StylesheetHelper;
import com.ibm.xtq.xslt.translator.XSLTCHelper;
import com.ibm.xtq.xslt.translator.v2.Stylesheet2Helper;
import com.ibm.xtq.xslt.translator.v2.XSLTC2Helper;
import com.ibm.xtq.xslt.typechecker.TypeCheckError;
import com.ibm.xtq.xslt.typechecker.v2.XPath2TypeChecker;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.xml.namespace.QName;

public class XSLT2TypeChecker
extends XPath2TypeChecker {
    private static final String AttributeSetPrefix = "$as$";
    private XSLTCompiler _xsltc;

    public XSLT2TypeChecker(XSLTCompiler xSLTCompiler) {
        super(xSLTCompiler);
        this._xsltc = xSLTCompiler;
    }

    public XSLTCompiler getXSLTC() {
        return this._xsltc;
    }

    @Override
    public boolean isAttrVisitor() {
        return false;
    }

    @Override
    public boolean visitNode(Expr expr, int n) {
        this.setStylesheetVersion(expr.getProgramVersion());
        Expr expr2 = ASTDecorator2.getUseWhen(expr);
        if (expr2 != null) {
            this.useWhen(expr2);
        }
        try {
            switch (n) {
                case 16: {
                    return this.unsupportedElement(expr);
                }
                case 193: {
                    return this.analyzeString(expr);
                }
                case 194: {
                    return this.applyImports(expr);
                }
                case 195: {
                    return this.applyTemplates(expr);
                }
                case 159: {
                    return this.xslAttribute(expr);
                }
                case 196: {
                    return this.attributeSet(expr);
                }
                case 105: {
                    return this.callTemplate(expr);
                }
                case 197: {
                    return this.choose(expr);
                }
                case 134: {
                    return this.comment(expr);
                }
                case 198: {
                    return this.copy(expr);
                }
                case 199: {
                    return this.copyOf(expr);
                }
                case 220: {
                    return this.decimalFormat(expr);
                }
                case 157: {
                    return this.xslElement(expr);
                }
                case 200: {
                    return this.fallback(expr);
                }
                case 201: {
                    return this.forEach(expr);
                }
                case 202: {
                    return this.forEachGroup(expr);
                }
                case 209: {
                    return this.performSort(expr);
                }
                case 32: {
                    return this.function(expr);
                }
                case 56: {
                    return this.xslIf(expr);
                }
                case 221: {
                    return this.xslImport(expr);
                }
                case 222: {
                    return this.include(expr);
                }
                case 223: {
                    return this.key(expr);
                }
                case 203: {
                    return this.matchingSubstring(expr);
                }
                case 226: {
                    return this.message(expr);
                }
                case 224: {
                    return this.namespaceAlias(expr);
                }
                case 204: {
                    return this.nonMatchingSubstring(expr);
                }
                case 206: {
                    return this.number(expr);
                }
                case 207: {
                    return this.otherwise(expr);
                }
                case 212: {
                    return this.output(expr);
                }
                case 208: {
                    break;
                }
                case 45: {
                    return this.param(expr);
                }
                case 141: {
                    return this.processingInstruction(expr);
                }
                case 210: {
                    return this.xslResultDocument(expr);
                }
                case 211: {
                    return this.sort(expr);
                }
                case 231: 
                case 232: {
                    return this.stripSpace(expr);
                }
                case 3: {
                    return this.stylesheet(expr);
                }
                case 227: {
                    return this.template(expr);
                }
                case 228: {
                    return this.text(expr);
                }
                case 214: {
                    return this.valueOf(expr);
                }
                case 233: {
                    return this.sequence(expr);
                }
                case 29: {
                    return this.variable(expr);
                }
                case 34: {
                    return this.param(expr);
                }
                case 215: {
                    return this.when(expr);
                }
                case 217: {
                    return this.withParam(expr);
                }
                case 108: {
                    return this.literalElement(expr);
                }
                case 116: {
                    return this.literalAttribute(expr);
                }
                case 229: {
                    return this.redirectExtension(expr);
                }
                case 156: {
                    return this.xslDocument(expr);
                }
                case 234: {
                    return this.xslNamespace(expr);
                }
            }
        }
        catch (TypeCheckError typeCheckError) {
            typeCheckError.printStackTrace();
            throw new WrappedRuntimeException(typeCheckError);
        }
        return true;
    }

    private void useWhen(Expr expr) {
        super.visitNode(expr, expr.getId());
    }

    @Override
    public void visitTree(Expr expr) {
        if (this.visitNode(expr, expr.getId())) {
            this.visitChildren(expr);
        }
    }

    protected void visitChildren(Expr expr) {
        int n = expr.jjtGetNumChildren();
        Vector vector = null;
        for (int i = 0; i < n; ++i) {
            Expr expr2 = (Expr)expr.jjtGetChild(i);
            this._staticContext.setCurrentNode(expr2);
            this.visitTree(expr2);
            vector = this.possibleProcessVarOrParamScope(vector, expr2);
        }
        this.popScope(expr, vector);
    }

    private void popScope(Expr expr, Vector vector) {
        this._staticContext.setCurrentNode(expr);
        if (vector != null) {
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                this.removeVariable((QName)vector.elementAt(i));
            }
        }
    }

    private Vector possibleProcessVarOrParamScope(Vector vector, Expr expr) {
        QName qName = this.updateScope(expr);
        if (qName != null) {
            if (vector == null) {
                vector = new Vector<QName>(2);
            }
            vector.addElement(qName);
        }
        return vector;
    }

    @Override
    public void leaveNode(Expr expr, int n) {
    }

    private boolean unsupportedElement(Expr expr) {
        UnsupportedElement unsupportedElement = (UnsupportedElement)expr;
        List list = unsupportedElement.getFallbacks();
        if (list != null) {
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                Fallback fallback = (Fallback)list.get(i);
                this.visitTree(fallback);
            }
        }
        return false;
    }

    private boolean applyImports(Expr expr) {
        return true;
    }

    private boolean applyTemplates(Expr expr) throws TypeCheckError {
        ApplyTemplates applyTemplates = (ApplyTemplates)expr;
        XTQProgram xTQProgram = this._parser.getTopLevelXTQProgram();
        QName qName = applyTemplates.getModeName();
        if (qName != null && !qName.getLocalPart().equals("#current")) {
            Stylesheet2Helper.getMode(xTQProgram, qName, null);
        }
        Expr expr2 = applyTemplates.getExpression();
        ASTDecorator2.setType(applyTemplates, Type.ITEM);
        if (expr2 != null) {
            Type type = this.visitExpression(expr2);
            return true;
        }
        return true;
    }

    private boolean xslAttribute(Expr expr) throws TypeCheckError {
        Expr expr2;
        CompAttrConstructor compAttrConstructor = (CompAttrConstructor)expr;
        if (!compAttrConstructor.isIgnore()) {
            if (compAttrConstructor.getNameExpr() == null) {
                return true;
            }
            this.attributeValueTemplate(compAttrConstructor.getNameExpr());
            expr2 = compAttrConstructor.getNamespaceExpr();
            if (expr2 != null) {
                this.attributeValueTemplate(expr2);
            }
        }
        expr2 = compAttrConstructor.getSeparatorExpr();
        Expr expr3 = compAttrConstructor.getSelectExpr();
        if (null != expr3) {
            this.attributeValue(expr3);
        }
        if (null != expr2) {
            this.attributeValueTemplate(expr2);
        }
        ASTDecorator2.setType(expr, Type.ATTRIBUTE);
        return !compAttrConstructor.isIgnore();
    }

    private boolean xslResultDocument(Expr expr) throws TypeCheckError {
        ResultDocument resultDocument = (ResultDocument)expr;
        Expr expr2 = resultDocument.getByteOrderMarkExpr();
        if (expr2 != null) {
            this.attributeValueTemplate(expr2);
        }
        if ((expr2 = resultDocument.getCdataSectionNamesExpr()) != null) {
            this.attributeValueTemplate(expr2);
        }
        if ((expr2 = resultDocument.getDocTypePublicExpr()) != null) {
            this.attributeValueTemplate(expr2);
        }
        if ((expr2 = resultDocument.getDocTypeSystemExpr()) != null) {
            this.attributeValueTemplate(expr2);
        }
        if ((expr2 = resultDocument.getEncodingExpr()) != null) {
            this.attributeValueTemplate(expr2);
        }
        if ((expr2 = resultDocument.getEscapeUriAttributesExpr()) != null) {
            this.attributeValueTemplate(expr2);
        }
        if ((expr2 = resultDocument.getFormatExpr()) != null) {
            this.attributeValueTemplate(expr2);
        }
        if ((expr2 = resultDocument.getHrefExpr()) != null) {
            this.attributeValueTemplate(expr2);
        }
        if ((expr2 = resultDocument.getIncludeContentTypeExpr()) != null) {
            this.attributeValueTemplate(expr2);
        }
        if ((expr2 = resultDocument.getIndentExpr()) != null) {
            this.attributeValueTemplate(expr2);
        }
        if ((expr2 = resultDocument.getMediaTypeExpr()) != null) {
            this.attributeValueTemplate(expr2);
        }
        if ((expr2 = resultDocument.getMethodExpr()) != null) {
            this.attributeValueTemplate(expr2);
        }
        if ((expr2 = resultDocument.getNormalizationFormExpr()) != null) {
            this.attributeValueTemplate(expr2);
        }
        if ((expr2 = resultDocument.getOmitXmlDeclarationExpr()) != null) {
            this.attributeValueTemplate(expr2);
        }
        if ((expr2 = resultDocument.getOutputVersionExpr()) != null) {
            this.attributeValueTemplate(expr2);
        }
        if ((expr2 = resultDocument.getStandaloneExpr()) != null) {
            this.attributeValueTemplate(expr2);
        }
        if ((expr2 = resultDocument.getUndeclarePrefixesExpr()) != null) {
            this.attributeValueTemplate(expr2);
        }
        ASTDecorator2.setType(expr, Type.EMPTY);
        return true;
    }

    private boolean attributeValue(Expr expr) throws TypeCheckError {
        int n = expr.jjtGetNumChildren();
        for (int i = 0; i < n; ++i) {
            Node node = expr.jjtGetChild(i);
            if (!(node instanceof Expr)) continue;
            Expr expr2 = (Expr)node;
            this.visitExpression(expr2);
        }
        return false;
    }

    private boolean simpleAttributeValue(Expr expr) {
        return false;
    }

    private boolean attributeValueTemplate(Expr expr) throws TypeCheckError {
        if (expr.getId() == 40) {
            for (int i = 0; i < expr.jjtGetNumChildren(); ++i) {
                Expr expr2 = (Expr)expr.jjtGetChild(i);
                this.visitExpression(expr2);
            }
        } else {
            this.visitExpression(expr);
        }
        return false;
    }

    private boolean attributeSet(Expr expr) {
        AttributeSet attributeSet = (AttributeSet)expr;
        if (attributeSet.isIgnore()) {
            return false;
        }
        String string = AttributeSetPrefix + this._xsltc.nextAttributeSetSerial();
        ASTDecorator.setAttributeSetMethodName(attributeSet, string);
        UseAttributeSets useAttributeSets = attributeSet.getUseSets();
        if (useAttributeSets != null) {
            this.useAttributeSets(useAttributeSets);
        }
        return true;
    }

    private boolean callTemplate(Expr expr) {
        CallTemplate callTemplate = (CallTemplate)expr;
        QName qName = callTemplate.getQName();
        Template template = this._staticContext.lookupTemplate(qName);
        if (template != null) {
            Type type = ASTDecorator2.getType(template);
            if (type == null) {
                ASTDecorator2.setType(template, Type.ITEM);
                type = this.inferSequenceConstructorType(template, false);
                TypeExpr typeExpr = template.getResultType();
                if (null != typeExpr) {
                    type = XSLTC2Helper.convertSequenceType(this._staticContext, this.getXSLTC().getTypeFactory(), typeExpr);
                }
            }
            ASTDecorator2.setType(callTemplate, type);
            return true;
        }
        ErrorMsg errorMsg = new ErrorMsg("TEMPLATE_UNDEF_ERR", (Object)qName, (Object)this);
        throw new StaticError(errorMsg);
    }

    private boolean choose(Expr expr) {
        Type type = this.inferSequenceConstructorType(expr, true);
        ASTDecorator2.setType(expr, type);
        return false;
    }

    private boolean comment(Expr expr) {
        ASTDecorator2.setType(expr, Type.COMMENT);
        return true;
    }

    private boolean copy(Expr expr) {
        Copy copy = (Copy)expr;
        UseAttributeSets useAttributeSets = copy.getUseSets();
        if (useAttributeSets != null) {
            this.useAttributeSets(useAttributeSets);
        }
        Type type = this.inferSequenceConstructorType(copy, false);
        ASTDecorator2.setType(copy, type);
        return false;
    }

    private boolean useAttributeSets(UseAttributeSets useAttributeSets) {
        return false;
    }

    private boolean copyOf(Expr expr) throws TypeCheckError {
        CopyOf copyOf = (CopyOf)expr;
        Expr expr2 = copyOf.getExpression();
        Type type = this.visitExpression(expr2);
        ASTDecorator2.setType(copyOf, type);
        return false;
    }

    private boolean decimalFormat(Expr expr) {
        return false;
    }

    private boolean xslElement(Expr expr) throws TypeCheckError {
        CompElemConstructor compElemConstructor = (CompElemConstructor)expr;
        if (!compElemConstructor.isIgnore()) {
            this.attributeValueTemplate(compElemConstructor.getNameExpr());
            Expr expr2 = compElemConstructor.getNamespaceExpr();
            if (expr2 != null) {
                this.attributeValueTemplate(expr2);
            }
        }
        ASTDecorator2.setType(expr, Type.ELEMENT);
        return true;
    }

    private boolean xslDocument(Expr expr) throws TypeCheckError {
        ASTDecorator2.setType(expr, Type.DOCUMENT);
        return true;
    }

    private boolean xslNamespace(Expr expr) throws TypeCheckError {
        CompNamespaceConstructor compNamespaceConstructor = (CompNamespaceConstructor)expr;
        Expr expr2 = compNamespaceConstructor.getName();
        if (null != expr2) {
            this.attributeValueTemplate(expr2);
        }
        ASTDecorator2.setType(expr, Type.NCNAME);
        return true;
    }

    private boolean fallback(Expr expr) {
        Type type = this.inferSequenceConstructorType(expr, false);
        ASTDecorator2.setType(expr, type);
        return false;
    }

    private boolean forEach(Expr expr) throws TypeCheckError {
        ForEach forEach = (ForEach)expr;
        Expr expr2 = forEach.getExpression();
        Type type = this.visitExpression(expr2);
        Type type2 = this.inferSequenceConstructorType(expr, false);
        if (type2 instanceof ItemType) {
            type2 = new XSequenceType((ItemType)type2, OccurrenceIndicator.ZERO_OR_MORE);
        }
        ASTDecorator2.setType(forEach, type2);
        return false;
    }

    private boolean forEachGroup(Expr expr) throws TypeCheckError {
        ForEachGroup forEachGroup = (ForEachGroup)expr;
        this.visitExpression(forEachGroup.getSelectExpr());
        this.visitExpression(forEachGroup.getGroupExpr());
        Type type = this.inferSequenceConstructorType(forEachGroup, false);
        ASTDecorator2.setType(forEachGroup, type);
        return true;
    }

    private boolean performSort(Expr expr) throws TypeCheckError {
        PerformSort performSort = (PerformSort)expr;
        Type type = performSort.getSelect() != null ? this.visitExpression(performSort.getSelect()) : this.inferSequenceConstructorType(performSort, false);
        ASTDecorator2.setType(performSort, type);
        return false;
    }

    private boolean xslIf(Expr expr) throws TypeCheckError {
        If if_ = (If)expr;
        Expr expr2 = if_.getExpression();
        this.visitExpression(expr2);
        Type type = this.inferSequenceConstructorType(expr, false);
        ASTDecorator2.setType(if_, type);
        return false;
    }

    private boolean xslImport(Expr expr) {
        return false;
    }

    private boolean include(Expr expr) {
        return false;
    }

    private boolean key(Expr expr) throws TypeCheckError {
        Key key = (Key)expr;
        Expr expr2 = key.getMatch();
        this.visitExpression(expr2);
        Expr expr3 = key.getUse();
        Type type = this.visitExpression(expr3);
        return false;
    }

    private boolean message(Expr expr) throws TypeCheckError {
        Object object;
        Message message = (Message)expr;
        Expr expr2 = message.getSelect();
        if (expr2 != null) {
            object = this.visitExpression(expr2);
            ASTDecorator2.setType(expr2, (Type)object);
        }
        if ((object = message.getTerminateExpr()) != null) {
            this.attributeValueTemplate((Expr)object);
        }
        ASTDecorator2.setType(expr, Type.EMPTY);
        return true;
    }

    private boolean namespaceAlias(Expr expr) {
        return false;
    }

    private boolean number(Expr expr) throws TypeCheckError {
        Expr expr2;
        Expr expr3;
        Expr expr4;
        Expr expr5;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Number number = (Number)expr;
        Expr expr6 = number.getValueExpr();
        if (expr6 != null) {
            object5 = this.visitExpression(expr6);
        }
        if ((object5 = number.getCount()) != null) {
            if (expr6 != null) {
                object4 = XMLMessages.createXMLMessage("ER_CONFLICTING_ATTRIBUTE", new Object[]{"value", "count"});
                object3 = new ErrorMsg((String)object4, number, false);
                this._parser.reportError(3, (ASTBaseMsg)object3);
            }
            this.visitExpression((Expr)object5);
        }
        if ((object4 = number.getFrom()) != null) {
            if (expr6 != null) {
                object3 = XMLMessages.createXMLMessage("ER_CONFLICTING_ATTRIBUTE", new Object[]{"value", "from"});
                object2 = new ErrorMsg((String)object3, number, false);
                this._parser.reportError(3, (ASTBaseMsg)object2);
            }
            this.visitExpression((Expr)object4);
        }
        if ((object3 = number.getSelect()) != null) {
            if (expr6 != null) {
                object2 = XMLMessages.createXMLMessage("ER_CONFLICTING_ATTRIBUTE", new Object[]{"value", "select"});
                object = new ErrorMsg((String)object2, number, false);
                this._parser.reportError(3, (ASTBaseMsg)object);
            }
            object2 = this.visitExpression((Expr)object3);
        }
        if ((object2 = number.getFormat()) != null) {
            this.attributeValueTemplate((Expr)object2);
        }
        if ((object = number.getLang()) != null) {
            this.attributeValueTemplate((Expr)object);
        }
        if ((expr5 = number.getLetterValue()) != null) {
            this.attributeValueTemplate(expr5);
        }
        if ((expr4 = number.getGroupingSeparator()) != null) {
            this.attributeValueTemplate(expr4);
        }
        if ((expr3 = number.getGroupingSize()) != null) {
            this.attributeValueTemplate(expr3);
        }
        if ((expr2 = number.getOrdinal()) != null) {
            this.attributeValueTemplate(expr2);
        }
        ASTDecorator2.setType(number, Type.TEXT);
        return true;
    }

    private boolean otherwise(Expr expr) {
        Type type = this.inferSequenceConstructorType(expr, false);
        ASTDecorator2.setType(expr, type);
        return false;
    }

    private boolean output(Expr expr) {
        return true;
    }

    private boolean processingInstruction(Expr expr) throws TypeCheckError {
        DirPIConstructor dirPIConstructor = (DirPIConstructor)expr;
        this.attributeValue(dirPIConstructor.getName());
        ASTDecorator2.setType(expr, Type.PI);
        return true;
    }

    private boolean sort(Expr expr) throws TypeCheckError {
        Sort sort = (Sort)expr;
        if (sort.getSelect() != null) {
            this.visitExpression(sort.getSelect());
        }
        if (sort.getLang() != null) {
            this.attributeValueTemplate(sort.getLang());
        }
        if (sort.getOrder() != null) {
            this.attributeValueTemplate(sort.getOrder());
        }
        if (sort.getCollation() != null) {
            this.attributeValueTemplate(sort.getCollation());
        }
        if (sort.getStable() != null) {
            this.attributeValueTemplate(sort.getStable());
        }
        if (sort.getCaseOrder() != null) {
            this.attributeValueTemplate(sort.getCaseOrder());
        }
        if (sort.getDataType() != null) {
            this.attributeValueTemplate(sort.getDataType());
        }
        ASTDecorator2.setType(sort, Type.EMPTY);
        return true;
    }

    private boolean stripSpace(Expr expr) {
        return true;
    }

    private boolean stylesheet(Expr expr) {
        Expr expr2;
        FunctionDecl functionDecl;
        Enumeration enumeration;
        Enumeration enumeration2;
        boolean bl;
        XTQProgram xTQProgram = (XTQProgram)expr;
        XSLTCompiler xSLTCompiler = this.getXSLTC();
        QName qName = StylesheetHelper.makeStylesheetName(this._xsltc, "__stylesheet_");
        ASTDecorator.setStylesheetNextModeSerial(xTQProgram, 1);
        XTQProgram xTQProgram2 = this._staticContext.addXTQProgram(qName, xTQProgram);
        if (xTQProgram2 != null) {
            ErrorMsg errorMsg = new ErrorMsg("MULTIPLE_STYLESHEET_ERR", this);
            this._parser.reportError(3, errorMsg);
        }
        if (bl = this._staticContext.hasGlobals()) {
            enumeration2 = this._staticContext.getGlobals().elements();
            while (enumeration2.hasMoreElements()) {
                enumeration = (VariableBase)enumeration2.nextElement();
                this.updateScope((Expr)((Object)enumeration));
            }
        }
        if (bl) {
            enumeration2 = this._staticContext.getGlobals().elements();
            xSLTCompiler.setInGlobal(true);
            while (enumeration2.hasMoreElements()) {
                enumeration = (VariableBase)enumeration2.nextElement();
                this._staticContext.setCurrentNode((Expr)((Object)enumeration));
                this.visitTree((Expr)((Object)enumeration));
            }
            xSLTCompiler.setInGlobal(false);
        }
        if (null != (enumeration2 = this._staticContext.getStylesheetFunctions()) && ((Hashtable)((Object)enumeration2)).size() > 0) {
            enumeration = ((Hashtable)((Object)enumeration2)).elements();
            while (enumeration.hasMoreElements()) {
                functionDecl = (FunctionDecl)enumeration.nextElement();
                if (functionDecl.isOverride() || !XSLTCHelper.isExtFunction(functionDecl, this._xsltc, this.getExtensionFunctionTable())) continue;
                ((Hashtable)((Object)enumeration2)).remove(functionDecl);
            }
        }
        this._staticContext.setCurrentNode(xTQProgram);
        if (null != enumeration2 && ((Hashtable)((Object)enumeration2)).size() > 0) {
            enumeration = ((Hashtable)((Object)enumeration2)).elements();
            while (enumeration.hasMoreElements()) {
                functionDecl = (FunctionDecl)enumeration.nextElement();
                this._staticContext.setCurrentNode(functionDecl);
                this.visitTree(functionDecl);
            }
        }
        this._staticContext.setCurrentNode(xTQProgram);
        int n = xTQProgram.jjtGetNumChildren();
        for (int i = 0; i < n; ++i) {
            expr2 = (Expr)xTQProgram.jjtGetChild(i);
            int n2 = expr2.getId();
            if (n2 == 29 || n2 == 34 || n2 == 105) continue;
            this._staticContext.setCurrentNode(expr2);
            this.visitTree(expr2);
        }
        this._staticContext.setCurrentNode(xTQProgram);
        if (bl) {
            Enumeration enumeration3 = this._staticContext.getGlobals().elements();
            while (enumeration3.hasMoreElements()) {
                expr2 = (VariableBase)enumeration3.nextElement();
                this.removeVariable(((VariableBase)expr2).getQName());
            }
        }
        this.reconcileCollationElements();
        return false;
    }

    private void reconcileCollationElements() {
        String[] stringArray = this._staticContext.getCollationElementNames();
        if (stringArray.length > 0) {
            Object object;
            String string = null;
            boolean bl = true;
            int n = Integer.MIN_VALUE;
            for (int i = 0; i < stringArray.length; ++i) {
                object = stringArray[i];
                CollationElement collationElement = this._staticContext.getCollationElement((String)object);
                if (!collationElement.isDuplicateName()) continue;
                String string2 = XMLMessages.createXMLMessage("TWO_COLLATIONS_WITH_THE_SAME_NAME", new Object[]{object});
                ErrorMsg errorMsg = new ErrorMsg(string2, collationElement, false);
                this._parser.reportError(4, errorMsg);
            }
            if (bl) {
                this._staticContext.setDefaultCollationName(string);
            } else {
                String string3 = XMLMessages.createXMLMessage("TWO_DEFAULT_COLLATIONS", new Object[0]);
                object = new ErrorMsg(string3, this._staticContext.getCollationElement(string), false);
                this._parser.reportError(3, (ASTBaseMsg)object);
            }
        }
    }

    private boolean template(Expr expr) throws TypeCheckError {
        Type type;
        TypeExpr typeExpr;
        Template template = (Template)expr;
        Expr expr2 = template.getPattern();
        if (expr2 != null) {
            this.visitExpression(expr2);
        }
        if ((typeExpr = template.getResultType()) != null) {
            XSequenceType xSequenceType = XSLTC2Helper.convertSequenceType(this._staticContext, this.getCompiler().getTypeFactory(), typeExpr);
            ASTDecorator2.setAsType(template, xSequenceType);
            type = xSequenceType;
        } else {
            type = this.inferSequenceConstructorType(template, false);
        }
        ASTDecorator2.setType(expr, type);
        return true;
    }

    private boolean text(Expr expr) {
        ASTDecorator2.setType(expr, Type.TEXT);
        return false;
    }

    private boolean transform(Expr expr) {
        return true;
    }

    private boolean valueOf(Expr expr) throws TypeCheckError {
        ValueOf valueOf = (ValueOf)expr;
        Expr expr2 = valueOf.getSeparatorExpr();
        Expr expr3 = valueOf.getExpression();
        if (null != expr3) {
            this.visitExpression(expr3);
        }
        if (null != expr2) {
            this.attributeValueTemplate(expr2);
        }
        ASTDecorator2.setType(valueOf, Type.TEXT);
        return true;
    }

    private boolean sequence(Expr expr) throws TypeCheckError {
        Sequence sequence = (Sequence)expr;
        Expr expr2 = sequence.getExpression();
        Type type = this.visitExpression(expr2);
        ASTDecorator2.setType(sequence, type);
        return true;
    }

    private boolean param(Expr expr) throws TypeCheckError {
        Param param = (Param)expr;
        Expr expr2 = param.getExpression();
        Type type = null;
        TypeExpr typeExpr = param.getType();
        if (expr2 != null) {
            type = this.visitExpression(expr2);
        } else if (typeExpr != null && param.hasContents()) {
            type = this.inferSequenceConstructorType(expr, false);
        } else if (typeExpr == null && param.hasContents()) {
            type = Type.DOCUMENT;
            ASTDecorator2.setImplicitDocNode(param, true);
        } else {
            type = Type.STRING;
            ASTDecorator2.setNoSelectAndSeqConstruct(param, true);
        }
        if (typeExpr != null) {
            XSequenceType xSequenceType = XSLTC2Helper.convertSequenceType(this._staticContext, this.getCompiler().getTypeFactory(), typeExpr);
            ASTDecorator2.setAsType(param, xSequenceType);
            type = expr2 == null && !param.hasContents() ? Type.EMPTY : xSequenceType;
        }
        ASTDecorator2.setParamDefaultValueType(param, type);
        ASTDecorator2.setVariableType(param, ExtendedTypes.ITEM_ZERO_OR_MORE);
        return param.hasContents();
    }

    private boolean variable(Expr expr) throws TypeCheckError {
        VarDecl varDecl = (VarDecl)expr;
        Expr expr2 = varDecl.getExpression();
        Type type = null;
        TypeExpr typeExpr = varDecl.getType();
        if (expr2 != null) {
            type = this.visitExpression(expr2);
        } else if (typeExpr != null && varDecl.hasContents()) {
            type = this.inferSequenceConstructorType(expr, false);
        } else if (typeExpr == null && varDecl.hasContents()) {
            type = Type.DOCUMENT;
            ASTDecorator2.setImplicitDocNode(varDecl, true);
        } else {
            type = Type.STRING;
            ASTDecorator2.setNoSelectAndSeqConstruct(varDecl, true);
        }
        if (typeExpr != null) {
            XSequenceType xSequenceType = XSLTC2Helper.convertSequenceType(this._staticContext, this.getCompiler().getTypeFactory(), typeExpr);
            ASTDecorator2.setAsType(varDecl, xSequenceType);
            type = expr2 == null && !varDecl.hasContents() ? Type.EMPTY : xSequenceType;
        }
        ASTDecorator2.setVariableType(varDecl, type);
        return varDecl.hasContents();
    }

    private boolean withParam(Expr expr) throws TypeCheckError {
        WithParam withParam = (WithParam)expr;
        Expr expr2 = withParam.getExpression();
        Type type = null;
        TypeExpr typeExpr = withParam.getType();
        if (expr2 != null) {
            type = this.visitExpression(expr2);
        } else if (typeExpr != null && withParam.hasContents()) {
            type = this.inferSequenceConstructorType(expr, false);
        } else if (typeExpr == null && withParam.hasContents()) {
            type = Type.DOCUMENT;
            ASTDecorator2.setImplicitDocNode(withParam, true);
        } else {
            type = Type.STRING;
            ASTDecorator2.setNoSelectAndSeqConstruct(withParam, true);
        }
        if (typeExpr != null) {
            XSequenceType xSequenceType = XSLTC2Helper.convertSequenceType(this._staticContext, this.getCompiler().getTypeFactory(), typeExpr);
            ASTDecorator2.setAsType(withParam, xSequenceType);
            type = expr2 == null && !withParam.hasContents() ? Type.EMPTY : xSequenceType;
        }
        ASTDecorator2.setType(expr, type);
        return withParam.hasContents();
    }

    private boolean when(Expr expr) throws TypeCheckError {
        When when = (When)expr;
        Expr expr2 = when.getExpression();
        this.visitExpression(expr2);
        Type type = this.inferSequenceConstructorType(expr, false);
        ASTDecorator2.setType(expr, type);
        return false;
    }

    private boolean literalElement(Expr expr) {
        DirElemConstructor dirElemConstructor = (DirElemConstructor)expr;
        List list = dirElemConstructor.getAttributeElements();
        if (list != null) {
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                Expr expr2 = (Expr)list.get(i);
                this.visitNode(expr2, expr2.getId());
            }
        }
        ASTDecorator2.setType(expr, Type.ELEMENT);
        return true;
    }

    private boolean literalAttribute(Expr expr) throws TypeCheckError {
        DirAttributeConstructor dirAttributeConstructor = (DirAttributeConstructor)expr;
        this.attributeValue(dirAttributeConstructor);
        ASTDecorator2.setType(expr, Type.ATTRIBUTE);
        return true;
    }

    private boolean redirectExtension(Expr expr) throws TypeCheckError {
        TransletOutput transletOutput = (TransletOutput)expr;
        this.attributeValue(transletOutput.getFilename());
        return true;
    }

    protected Type inferSequenceConstructorType(Expr expr, boolean bl) {
        Object object;
        int n = 0;
        int n2 = expr.jjtGetNumChildren();
        Type[] typeArray = new Type[n2];
        Object object2 = null;
        for (int i = 0; i < n2; ++i) {
            Expr expr2 = (Expr)expr.jjtGetChild(i);
            if (expr2 instanceof Text && ((Text)expr2).isIgnore()) continue;
            this._staticContext.setCurrentNode(expr2);
            this.visitTree(expr2);
            object2 = this.possibleProcessVarOrParamScope((Vector)object2, expr2);
            Type type = ASTDecorator2.getType(expr2);
            int n3 = expr2.getId();
            if (n3 == 34 || n3 == 29 || n3 == 217 || n3 == 211) continue;
            Assert._assert(type != null, "ast node appears to be untyped!!!");
            typeArray[n] = type;
            ++n;
        }
        this.popScope(expr, (Vector)object2);
        if (n == 0) {
            object = TypeConstants.EMPTY;
        } else if (n == 1) {
            object = typeArray[0];
        } else {
            object2 = bl ? new ChoiceType() : new AggregateType();
            Vector vector = null;
            for (int i = 0; i < n; ++i) {
                ((CollectionType)object2).addType(typeArray[0]);
            }
            this.popScope(expr, vector);
            object = object2;
        }
        return object;
    }

    public boolean function(Expr expr) {
        Object object;
        Expr expr22;
        FunctionDecl functionDecl = (FunctionDecl)expr;
        String string = "func_" + Util.escape(Util.getStringRep(functionDecl.getQName())) + "_" + functionDecl.getArity();
        ASTDecorator2.setFunctionUniqueName(functionDecl, string);
        List list = functionDecl.getParameters();
        for (Expr expr22 : list) {
            this.visitTree(expr22);
        }
        expr22 = functionDecl.getResultType();
        if (expr22 != null) {
            XSequenceType xSequenceType = XSLTC2Helper.convertSequenceType(this._staticContext, this.getCompiler().getTypeFactory(), expr22);
            ASTDecorator2.setAsType(functionDecl, xSequenceType);
            object = xSequenceType;
        } else {
            object = this.inferSequenceConstructorType(functionDecl, false);
        }
        ASTDecorator2.setFunctionType(functionDecl, (Type)object);
        return true;
    }

    private boolean analyzeString(Expr expr) throws TypeCheckError {
        Expr expr2;
        AnalyzeString analyzeString = (AnalyzeString)expr;
        Expr expr3 = analyzeString.getRegex();
        if (null != expr3) {
            this.attributeValueTemplate(expr3);
        }
        if (null != (expr2 = analyzeString.getFlags())) {
            this.attributeValueTemplate(expr2);
        }
        Type type = this.inferSequenceConstructorType(analyzeString, true);
        ASTDecorator2.setType(analyzeString, type);
        return false;
    }

    private boolean matchingSubstring(Expr expr) {
        Type type = this.inferSequenceConstructorType(expr, false);
        ASTDecorator2.setType(expr, type);
        return false;
    }

    private boolean nonMatchingSubstring(Expr expr) {
        Type type = this.inferSequenceConstructorType(expr, false);
        ASTDecorator2.setType(expr, type);
        return false;
    }
}

