/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtq.xslt.drivers;

import com.ibm.xtq.ast.nodes.Expr;
import com.ibm.xtq.ast.nodes.XTQProgram;
import com.ibm.xtq.ast.parsers.xslt.SourceLoader;
import com.ibm.xtq.ast.parsers.xslt.XSLTParser;
import com.ibm.xtq.bcel.classfile.JavaClass;
import com.ibm.xtq.common.utils.ErrorHandler;
import com.ibm.xtq.common.utils.Util;
import com.ibm.xtq.common.utils.WrappedRuntimeException;
import com.ibm.xtq.xslt.VisitorBase;
import com.ibm.xtq.xslt.drivers.AutoFunctorizingXSLTCompiler;
import com.ibm.xtq.xslt.drivers.XPathCompiler;
import com.ibm.xtq.xslt.drivers.XSLTCompilerSettings;
import com.ibm.xtq.xslt.drivers.XSLTLinker;
import com.ibm.xtq.xslt.drivers.XSLTLinkerSettings;
import com.ibm.xtq.xslt.drivers.XylemRuntimePreCompiler;
import com.ibm.xtq.xslt.jaxp.HandledRuntimeException;
import com.ibm.xtq.xslt.jaxp.SourceLocationImpl;
import com.ibm.xtq.xslt.res.ErrorMsg;
import com.ibm.xtq.xslt.runtime.RuntimeLibrary;
import com.ibm.xtq.xslt.translator.StaticError;
import com.ibm.xtq.xslt.translator.XSLTDebugTranslator;
import com.ibm.xtq.xslt.translator.v1.XSLTTranslator;
import com.ibm.xtq.xslt.translator.v2.XSLT2Translator;
import com.ibm.xtq.xslt.typechecker.TypeCheckError;
import com.ibm.xtq.xslt.typechecker.TypeCheckerBase;
import com.ibm.xtq.xslt.typechecker.v1.XSLTTypeChecker;
import com.ibm.xtq.xslt.typechecker.v2.XSLT2TypeChecker;
import com.ibm.xtq.xslt.xylem.instructions.CoerceInstruction;
import com.ibm.xtq.xslt.xylem.optimizers.SAXEventStreamOptimizer;
import com.ibm.xtq.xslt.xylem.optimizers.XPathUnionOptimizer;
import com.ibm.xtq.xslt.xylem.optimizers.XSLTReverseInliningOptimizer;
import com.ibm.xtq.xslt.xylem.parser.FormHandler;
import com.ibm.xtq.xslt.xylem.parser.TypeHandler;
import com.ibm.xylem.Functor;
import com.ibm.xylem.Instruction;
import com.ibm.xylem.Logger;
import com.ibm.xylem.Module;
import com.ibm.xylem.ModuleSignature;
import com.ibm.xylem.ModuleSignatureStore;
import com.ibm.xylem.PostOrderOptimizer;
import com.ibm.xylem.ReductionHelper;
import com.ibm.xylem.TypeEnvironment;
import com.ibm.xylem.codegen.CodeGenerationSettings;
import com.ibm.xylem.codegen.bcel.ClassCollector;
import com.ibm.xylem.codegen.bcel.Resource;
import com.ibm.xylem.instructions.AssertTypeInstruction;
import com.ibm.xylem.instructions.LetInstruction;
import com.ibm.xylem.instructions.LiteralInstruction;
import com.ibm.xylem.instructions.StreamInstruction;
import com.ibm.xylem.optimizers.SimpleUnflattenStreamOptimizer;
import com.ibm.xylem.parser.ClassLoaderSourceResolver;
import com.ibm.xylem.parser.Parser;
import com.ibm.xylem.utils.SourceLocation;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.lang.ref.SoftReference;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.TransformerConfigurationException;
import org.apache.xml.serializer.utils.SystemIDResolver;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public class XSLTCompiler
extends XPathCompiler {
    public static final boolean ENABLE_EXPERIMENT_OPTIMIZATIONS = false;
    private SourceLoader m_loader = null;
    private XTQProgram m_stylesheet = null;
    private int m_stylesheetSerial = 1;
    private int m_attributeSetSerial = 0;
    private Vector m_characterData;
    public static final int FILE_OUTPUT = 1;
    public static final int BYTEARRAY_OUTPUT = 2;
    public static final int JAR_OUTPUT = 4;
    public static final int JAVA_SOURCE = 8;
    public static final int BYTEARRAY_AND_FILE_OUTPUT = 3;
    public static final int BYTEARRAY_AND_JAR_OUTPUT = 6;
    public static final int JAVA_SOURCE_AND_FILE_OUTPUT = 9;
    static final Logger s_logger = Logger.getInstance(XSLTCompiler.class);
    private static File s_precompiled10RuntimeLibrary_xml11 = null;
    private static File s_precompiled10RuntimeLibrarySignature_xml11 = null;
    private static File s_precompiled10RuntimeLibrary_xml10 = null;
    private static File s_precompiled10RuntimeLibrarySignature_xml10 = null;
    private static File s_precompiled20RuntimeLibrary = null;
    private static File s_precompiled20RuntimeLibrarySignature = null;
    private Module m_runtimeLibrary = null;
    private Module m_stylesheetModule = null;
    private boolean m_debug = false;
    private String m_jarFileName = null;
    private String m_className = null;
    private File m_destDir = null;
    private String m_packageName = null;
    private boolean m_trace = false;
    private XSLTCompilerSettings m_compiSettings = null;
    private XSLTLinkerSettings m_linkerSettings = null;
    private Vector m_classes = new Vector();
    private Vector m_resources = new Vector();
    private byte[][] m_bytecodes;
    private String[] m_cnames;
    private int m_outputType = 2;
    private boolean m_templateInlining = false;
    private boolean m_generateBCEL = false;
    private ModuleSignature m_moduleSignature = null;
    private static SoftReference rtlibModule;
    private static int reductionHelperCount;

    public XSLTCompiler() {
        this("1.0");
    }

    public XSLTCompiler(String string) {
        this(string, new XSLTParser(string.equals("2.0")));
    }

    public XSLTCompiler(String string, XSLTParser xSLTParser) {
        super(string, xSLTParser);
        this.m_compiSettings = new XSLTCompilerSettings();
        this.m_compiSettings.setVersion(string);
        this.m_linkerSettings = new XSLTLinkerSettings(this.m_compiSettings);
    }

    public XSLTCompiler(XSLTCompilerSettings xSLTCompilerSettings) {
        super(xSLTCompilerSettings.getVersion(), new XSLTParser(xSLTCompilerSettings.getVersion().equals("2.0")));
        this.m_compiSettings = xSLTCompilerSettings;
        this.m_linkerSettings = new XSLTLinkerSettings(xSLTCompilerSettings);
    }

    public XSLTCompiler(XSLTLinkerSettings xSLTLinkerSettings) {
        super(xSLTLinkerSettings.getVersion(), new XSLTParser(xSLTLinkerSettings.getVersion().equals("2.0")));
        this.m_compiSettings = xSLTLinkerSettings.getCompilerSettings();
        this.m_linkerSettings = xSLTLinkerSettings;
    }

    public String getXSLTVersion() {
        return this.m_compiSettings.getVersion();
    }

    public void setStreamResultOnly(boolean bl) {
        this.m_compiSettings.setStreamResultOnly(bl);
        CodeGenerationSettings codeGenerationSettings = this.m_linkerSettings.getCodeGenerationSettings();
        codeGenerationSettings.setOrderSafeSplit(!bl);
    }

    public void setXML10Only(boolean bl) {
        this.m_compiSettings.setXML10Only(bl);
        CodeGenerationSettings codeGenerationSettings = this.m_linkerSettings.getCodeGenerationSettings();
        this._parser.setXML10Only(bl);
    }

    public boolean isStreamResultOnly() {
        return this.m_compiSettings.isStreamResultOnly();
    }

    public void setOutputType(int n) {
        this.m_outputType = n;
    }

    public Properties getOutputProperties() {
        Properties properties = this._parser.getOutputProperties();
        return properties;
    }

    @Override
    public void reset() {
        super.reset();
        this.m_classes.removeAllElements();
        this.m_resources.removeAllElements();
        this.m_bytecodes = null;
        this.m_stylesheet = null;
        this.m_stylesheetSerial = 1;
        this.m_attributeSetSerial = 0;
    }

    public void setSourceLoader(SourceLoader sourceLoader) {
        this.m_loader = sourceLoader;
    }

    public SourceLoader getSourceLoader() {
        return this.m_loader;
    }

    public void setTemplateInlining(boolean bl) {
        this.m_templateInlining = bl;
    }

    public boolean getTemplateInlining() {
        return this.m_templateInlining;
    }

    public void setPIParameters(String string, String string2, String string3) {
        this._parser.setPIParameters(string, string2, string3);
    }

    public void handleXSLTCErrors(String string) {
        Vector vector = this.getErrors();
        if (vector != null) {
            for (ErrorMsg errorMsg : vector) {
                s_logger.error(string + ": " + errorMsg.toString());
            }
        }
    }

    public boolean compile(URL uRL) {
        try {
            InputStream inputStream = uRL.openStream();
            InputSource inputSource = new InputSource(inputStream);
            inputSource.setSystemId(uRL.toString());
            return this.compile(inputSource, this.m_className);
        }
        catch (IOException iOException) {
            this._parser.reportError(2, new ErrorMsg(iOException));
            return false;
        }
    }

    public boolean compile(URL uRL, String string) {
        try {
            InputStream inputStream = uRL.openStream();
            InputSource inputSource = new InputSource(inputStream);
            inputSource.setSystemId(uRL.toString());
            return this.compile(inputSource, string);
        }
        catch (IOException iOException) {
            this._parser.reportError(2, new ErrorMsg(iOException));
            return false;
        }
    }

    public boolean compile(InputStream inputStream, String string) {
        InputSource inputSource = new InputSource(inputStream);
        inputSource.setSystemId(string);
        return this.compile(inputSource, string);
    }

    public boolean compile(InputSource inputSource, String string) {
        try {
            Module module = this.compileRuntime();
            this.setRuntimeLibrary(module);
            XTQProgram xTQProgram = this.buildAST(inputSource, string);
            Module module2 = this.translate(xTQProgram);
            if (this.getDoPostASTProcessing()) {
                this.postASTProcessing(module, module2, null);
            }
            this.linkAndCodeGen(module, module2);
        }
        catch (WrappedRuntimeException wrappedRuntimeException) {
            Exception exception = wrappedRuntimeException.getException();
            if (exception instanceof TransformerConfigurationException) {
                throw wrappedRuntimeException;
            }
            this._parser.reportError(2, new ErrorMsg(wrappedRuntimeException));
        }
        catch (HandledRuntimeException handledRuntimeException) {
            throw handledRuntimeException;
        }
        catch (Exception exception) {
            this._parser.reportError(2, new ErrorMsg(exception));
        }
        catch (Error error) {
            this._parser.reportError(2, new ErrorMsg(error));
        }
        return !this.errorsFound();
    }

    public String getTransletSuperclassName() {
        return "com.ibm.xtq.ast.runtime.AbstractTranslet";
    }

    public Expr makeAST(InputSource inputSource, String string) {
        this.reset();
        String string2 = null;
        String string3 = null;
        if (inputSource != null) {
            string2 = inputSource.getSystemId();
            string3 = inputSource.getPublicId();
        }
        if (this.m_className == null) {
            if (string != null) {
                this.setClassName(string);
            } else if (string2 != null && !string2.equals("")) {
                this.setClassName(Util.baseName(string2));
            }
            if (this.m_className == null || this.m_className.length() == 0) {
                this.setClassName("GregorSamsa");
            }
        }
        Expr expr = null;
        XMLReader xMLReader = this._parser.getXMLReader();
        expr = xMLReader == null ? this._parser.parse(inputSource) : this._parser.parse(xMLReader, inputSource);
        if (!this.errorsFound() && expr != null) {
            this.makeASTCompletion(string2, string3, expr);
        }
        return this.m_stylesheet;
    }

    public XTQProgram makeASTCompletion(String string, String string2, Expr expr) {
        this.m_stylesheet = this._parser.makeStylesheet(expr);
        this._parser.setTopLevelXTQProgram(this.m_stylesheet);
        this.m_stylesheet.setSourceLoader(this.m_loader);
        this.m_stylesheet.setSystemId(string);
        this.m_stylesheet.setPublicId(string2);
        this.m_stylesheet.setParentXTQProgram(null);
        this.m_stylesheet.setTemplateInlining(this.m_templateInlining);
        this._parser.setCurrentXTQProgram(this.m_stylesheet);
        this._parser.createAST(this.m_stylesheet);
        if (!this.errorsFound()) {
            try {
                TypeCheckerBase typeCheckerBase = this.m_compiSettings.getVersion().equals("2.0") ? new XSLT2TypeChecker(this) : new XSLTTypeChecker(this);
                typeCheckerBase.visitTree(this.m_stylesheet);
            }
            catch (WrappedRuntimeException wrappedRuntimeException) {
                Exception exception = wrappedRuntimeException.getException();
                exception = exception instanceof TypeCheckError ? exception : wrappedRuntimeException;
                this._parser.reportError(3, new ErrorMsg(exception));
            }
            catch (StaticError staticError) {
                this._parser.reportError(3, new ErrorMsg(staticError));
            }
        }
        return this.m_stylesheet;
    }

    public boolean compile(Vector vector) {
        int n = vector.size();
        if (n == 0) {
            return true;
        }
        if (n == 1) {
            Object e = vector.firstElement();
            if (e instanceof URL) {
                return this.compile((URL)e);
            }
            return false;
        }
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            this.m_className = null;
            Object e = enumeration.nextElement();
            if (!(e instanceof URL) || this.compile((URL)e)) continue;
            return false;
        }
        return true;
    }

    public byte[][] getBytecodes() {
        if (this.m_bytecodes == null) {
            int n = this.m_classes.size();
            byte[][] byArrayArray = new byte[n][];
            String[] stringArray = new String[n];
            for (int i = 0; i < n; ++i) {
                JavaClass javaClass = (JavaClass)this.m_classes.get(i);
                byArrayArray[i] = javaClass.getBytes();
                stringArray[i] = javaClass.getClassName();
            }
            this.m_bytecodes = byArrayArray;
            this.m_cnames = stringArray;
            this.m_classes.removeAllElements();
        }
        return this.m_bytecodes;
    }

    public String[] getNames() {
        return this.m_cnames;
    }

    public Vector getErrors() {
        return this._parser.getErrors();
    }

    public Vector getWarnings() {
        return this._parser.getWarnings();
    }

    public void printErrors() {
        this._parser.printErrors();
    }

    public void printWarnings() {
        this._parser.printWarnings();
    }

    public void setClassName(String string) {
        String string2 = Util.baseName(string);
        String string3 = Util.noExtName(string2);
        String string4 = Util.toJavaName(string3);
        this.m_className = this.m_packageName == null ? string4 : this.m_packageName + '.' + string4;
    }

    public String getClassName() {
        return this.m_className;
    }

    private String classFileName(String string) {
        return string.replace('.', File.separatorChar) + ".class";
    }

    private File getOutputFile(String string) {
        if (this.m_destDir != null) {
            return new File(this.m_destDir, this.classFileName(string));
        }
        return new File(this.classFileName(string));
    }

    public boolean setDestDirectory(String string) {
        File file = new File(string);
        if (file.exists() || file.mkdirs()) {
            this.m_destDir = file;
            return true;
        }
        this.m_destDir = null;
        return false;
    }

    public void setPackageName(String string) {
        this.m_packageName = string;
        if (this.m_className != null) {
            this.setClassName(this.m_className);
        }
    }

    public void setJarFileName(String string) {
        this.m_jarFileName = string.endsWith(".jar") ? string : string + ".jar";
    }

    public String getJarFileName() {
        return this.m_jarFileName;
    }

    public void setStylesheet(XTQProgram xTQProgram) {
        if (this.m_stylesheet == null) {
            this.m_stylesheet = xTQProgram;
        }
    }

    public XTQProgram getStylesheet() {
        return this.m_stylesheet;
    }

    public int nextStylesheetSerial() {
        return this.m_stylesheetSerial++;
    }

    public int nextAttributeSetSerial() {
        return this.m_attributeSetSerial++;
    }

    public void setDebug(boolean bl) {
        this.m_debug = bl;
        this._parser.setDebug(bl);
    }

    public boolean debug() {
        return this.m_debug;
    }

    public void setTrace(boolean bl) {
        this.m_trace = bl;
    }

    public boolean trace() {
        return this.m_trace;
    }

    public void setDisableSetParameter(boolean bl) {
        this.m_compiSettings.setDisableSetParameter(bl);
    }

    public boolean disableSetParameter() {
        return this.m_compiSettings.getDisableSetParameter();
    }

    public String getCharacterData(int n) {
        return ((StringBuffer)this.m_characterData.elementAt(n)).toString();
    }

    public int getCharacterDataCount() {
        return this.m_characterData != null ? this.m_characterData.size() : 0;
    }

    public int addCharacterData(String string) {
        StringBuffer stringBuffer;
        if (this.m_characterData == null) {
            this.m_characterData = new Vector();
            stringBuffer = new StringBuffer();
            this.m_characterData.addElement(stringBuffer);
        } else {
            stringBuffer = (StringBuffer)this.m_characterData.elementAt(this.m_characterData.size() - 1);
        }
        if (string.length() + stringBuffer.length() > 21845) {
            stringBuffer = new StringBuffer();
            this.m_characterData.addElement(stringBuffer);
        }
        int n = stringBuffer.length();
        stringBuffer.append(string);
        return n;
    }

    @Override
    public SourceLocation createSourceLocation(Expr expr) {
        return new SourceLocationImpl(expr.getSystemId(), expr.getPublicId(), expr.getStartLineNumber(), expr.getStartColumnNumber(), expr.getEndLineNumber(), expr.getEndColumnNumber());
    }

    public boolean getGenerateBCEL() {
        return this.m_generateBCEL;
    }

    public void setGenerateBCEL(boolean bl) {
        CodeGenerationSettings codeGenerationSettings = this.m_linkerSettings.getCodeGenerationSettings();
        this.m_generateBCEL = bl;
        if (bl) {
            codeGenerationSettings.setTargetLanguage(2);
        } else {
            codeGenerationSettings.setTargetLanguage(1);
        }
    }

    public int getSplitLimit() {
        return this.m_compiSettings.getPrereductionSplitLimit();
    }

    public void setSplitLimit(int n) {
        this.m_compiSettings.setPrereductionSplitLimit(n);
        CodeGenerationSettings codeGenerationSettings = this.m_linkerSettings.getCodeGenerationSettings();
        codeGenerationSettings.setBCELAutoSplitFunctions(n == 0);
    }

    public ClassCollector getByteCodeClassCollecter() {
        ChainedClassCollector chainedClassCollector = null;
        if ((this.m_outputType & 2) != 0) {
            chainedClassCollector = new CachingClassCollector(chainedClassCollector);
        }
        if ((this.m_outputType & 1) != 0) {
            chainedClassCollector = new WritingClassCollector(chainedClassCollector);
        }
        return chainedClassCollector;
    }

    public void outputToJar() throws IOException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Enumeration enumeration;
        Manifest manifest = new Manifest();
        Attributes attributes = manifest.getMainAttributes();
        attributes.put(Attributes.Name.MANIFEST_VERSION, "1.2");
        Map<String, Attributes> map = manifest.getEntries();
        Enumeration enumeration2 = this.m_classes.elements();
        String string = new Date().toString();
        Attributes.Name name = new Attributes.Name("Date");
        while (enumeration2.hasMoreElements()) {
            enumeration = (JavaClass)enumeration2.nextElement();
            object4 = ((JavaClass)((Object)enumeration)).getClassName().replace('.', '/');
            object3 = new Attributes();
            ((Attributes)object3).put(name, string);
            map.put((String)object4 + ".class", (Attributes)object3);
        }
        enumeration = this.m_resources.elements();
        while (enumeration.hasMoreElements()) {
            object4 = (Resource)enumeration.nextElement();
            object3 = new Attributes();
            ((Attributes)object3).put(name, string);
            map.put(object4.getName(), (Attributes)object3);
        }
        boolean bl = SystemIDResolver.isAbsolutePath(this.m_jarFileName);
        object3 = null;
        object3 = bl ? new File(this.m_jarFileName) : new File(this.m_destDir, this.m_jarFileName);
        JarOutputStream jarOutputStream = new JarOutputStream((OutputStream)new FileOutputStream((File)object3), manifest);
        enumeration2 = this.m_classes.elements();
        while (enumeration2.hasMoreElements()) {
            object2 = (JavaClass)enumeration2.nextElement();
            object = ((JavaClass)object2).getClassName().replace('.', '/');
            jarOutputStream.putNextEntry(new JarEntry((String)object + ".class"));
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(2048);
            ((JavaClass)object2).dump(byteArrayOutputStream);
            byteArrayOutputStream.writeTo(jarOutputStream);
        }
        enumeration = this.m_resources.elements();
        while (enumeration.hasMoreElements()) {
            object2 = (Resource)enumeration.nextElement();
            jarOutputStream.putNextEntry(new JarEntry(object2.getName()));
            object = new ByteArrayOutputStream(2048);
            object2.dump((OutputStream)object);
            ((ByteArrayOutputStream)object).writeTo(jarOutputStream);
        }
        jarOutputStream.close();
    }

    public Module compileRuntime() throws Exception {
        String string = this.m_compiSettings.getVersion();
        boolean bl = this.m_compiSettings.getXML10Only();
        if ("1.0".equals(string)) {
            return XSLTCompiler.compileRuntime10(bl);
        }
        if ("2.0".equals(string)) {
            return XSLTCompiler.compileRuntime20();
        }
        throw new StaticError("ERR_VERSION_NUM");
    }

    private static synchronized Module compileRuntime10(boolean bl) throws Exception {
        String string;
        File file;
        File file2;
        s_logger.info(RuntimeLibrary.verboseVersionWithCopyright());
        s_logger.info(" XSLT version 1.0");
        InputStream inputStream = XylemRuntimePreCompiler.getPrecompiledRuntime("1.0");
        InputStream inputStream2 = XylemRuntimePreCompiler.getPrecompiledRuntimeSignature("1.0");
        if (inputStream != null && inputStream2 != null) {
            return XSLTCompiler.loadModule10(inputStream, inputStream2);
        }
        if (bl) {
            file2 = s_precompiled10RuntimeLibrary_xml10;
            file = s_precompiled10RuntimeLibrarySignature_xml10;
            string = "xylemxsltcrt_xml10";
        } else {
            file2 = s_precompiled10RuntimeLibrary_xml11;
            string = "xylemxsltcrt";
            file = s_precompiled10RuntimeLibrarySignature_xml11;
        }
        if (file2 != null) {
            s_logger.debug("Reusing the cached XSLTC runtime library: " + file2);
            return XSLTCompiler.loadModule10(new FileInputStream(file2), new FileInputStream(file));
        }
        Module module = XSLTCompiler.genRuntimeModule10(bl);
        file2 = File.createTempFile(string, "xylemo");
        if (bl) {
            s_precompiled10RuntimeLibrary_xml10 = file2;
        } else {
            s_precompiled10RuntimeLibrary_xml11 = file2;
        }
        FileOutputStream fileOutputStream = new FileOutputStream(file2);
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
        Module.writeModule(objectOutputStream, module);
        objectOutputStream.flush();
        fileOutputStream.close();
        file2.deleteOnExit();
        file = File.createTempFile(string, "xylemo");
        if (bl) {
            s_precompiled10RuntimeLibrarySignature_xml10 = file;
        } else {
            s_precompiled10RuntimeLibrarySignature_xml11 = file;
        }
        fileOutputStream = new FileOutputStream(file);
        objectOutputStream = new ObjectOutputStream(fileOutputStream);
        module.m_signature.write(objectOutputStream);
        objectOutputStream.flush();
        fileOutputStream.close();
        file.deleteOnExit();
        s_logger.debug("Cached the XSLTC runtime library: " + file2 + " / " + file);
        return module;
    }

    public static Module genRuntimeModule10(boolean bl) throws Exception {
        ClassLoaderSourceResolver classLoaderSourceResolver = new ClassLoaderSourceResolver();
        String string = bl ? "com/ibm/xtq/xslt/runtime/v1/xsltcxml10.xylem" : "com/ibm/xtq/xslt/runtime/v1/xsltcxml11.xylem";
        Parser parser = new Parser(classLoaderSourceResolver, classLoaderSourceResolver.resolve(null, string), new ModuleSignatureStore(new LinkedList()));
        new TypeHandler().registerTypes(parser);
        new FormHandler().registerForms(parser);
        ModuleSignature moduleSignature = parser.parseExternalModuleSignature(classLoaderSourceResolver.resolve(null, "com/ibm/xtq/xslt/runtime/v1/xsltc.xylemi"));
        Module module = parser.parseModule(moduleSignature);
        module.typeCheck();
        module.reduce();
        return module;
    }

    private static Module loadModule10(InputStream inputStream, InputStream inputStream2) throws Exception {
        Module module;
        Module module2 = module = rtlibModule == null ? null : (Module)rtlibModule.get();
        if (module == null) {
            ModuleSignatureStore moduleSignatureStore = new ModuleSignatureStore(new ArrayList());
            ObjectInputStream objectInputStream = new ObjectInputStream(inputStream2);
            ModuleSignature moduleSignature = new ModuleSignature();
            moduleSignature.read(objectInputStream, moduleSignatureStore);
            inputStream2.close();
            moduleSignatureStore.registerModuleSignature("xslt1", moduleSignature);
            objectInputStream = new ObjectInputStream(inputStream);
            module = Module.readModule(objectInputStream, moduleSignatureStore);
            inputStream.close();
            module.typeCheckReduced();
            reductionHelperCount = ReductionHelper.getIntermediateIdentifierCount();
            rtlibModule = new SoftReference<Module>(module);
        }
        ReductionHelper.resetIntermediateIdentifierCounter(reductionHelperCount);
        return module.cloneModule();
    }

    private static Module compileRuntime20() throws Exception {
        s_logger.info(RuntimeLibrary.verboseVersionWithCopyright());
        s_logger.info(" XSLT version 2.0");
        if (s_precompiled20RuntimeLibrary != null) {
            s_logger.debug("Reusing the cached XSLTC runtime library: " + s_precompiled20RuntimeLibrary);
            ModuleSignatureStore moduleSignatureStore = new ModuleSignatureStore(new ArrayList());
            FileInputStream fileInputStream = new FileInputStream(s_precompiled20RuntimeLibrarySignature);
            ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
            ModuleSignature moduleSignature = new ModuleSignature();
            moduleSignature.read(objectInputStream, moduleSignatureStore);
            fileInputStream.close();
            moduleSignatureStore.registerModuleSignature("xslt2", moduleSignature);
            fileInputStream = new FileInputStream(s_precompiled20RuntimeLibrary);
            objectInputStream = new ObjectInputStream(fileInputStream);
            Module module = Module.readModule(objectInputStream, moduleSignatureStore);
            fileInputStream.close();
            module.typeCheckReduced();
            return module;
        }
        Module module = XSLTCompiler.genRuntimeModule20();
        s_precompiled20RuntimeLibrary = File.createTempFile("xylemxsltc2rt", "xylemo");
        FileOutputStream fileOutputStream = new FileOutputStream(s_precompiled20RuntimeLibrary);
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
        Module.writeModule(objectOutputStream, module);
        objectOutputStream.flush();
        fileOutputStream.close();
        s_precompiled20RuntimeLibrary.deleteOnExit();
        s_precompiled20RuntimeLibrarySignature = File.createTempFile("xylemxsltc2rt", "xylemo");
        fileOutputStream = new FileOutputStream(s_precompiled20RuntimeLibrarySignature);
        objectOutputStream = new ObjectOutputStream(fileOutputStream);
        module.m_signature.write(objectOutputStream);
        objectOutputStream.flush();
        fileOutputStream.close();
        s_precompiled20RuntimeLibrarySignature.deleteOnExit();
        s_logger.debug("Cached the XSLTC runtime library: " + s_precompiled20RuntimeLibrary + " / " + s_precompiled20RuntimeLibrarySignature);
        module.typeCheckReduced();
        return module;
    }

    public static Module genRuntimeModule20() throws Exception {
        ClassLoaderSourceResolver classLoaderSourceResolver = new ClassLoaderSourceResolver();
        Parser parser = new Parser(classLoaderSourceResolver, classLoaderSourceResolver.resolve(null, "com/ibm/xtq/xslt/runtime/v2/MainLib2.xylem"));
        new TypeHandler().registerTypes(parser);
        new FormHandler().registerForms(parser);
        Module module = parser.parseModuleFragment();
        module.setName("xslt2");
        module.exportAllSymbols();
        module.typeCheck();
        module.exportAllSymbols();
        module.reduce();
        return module;
    }

    public XTQProgram buildAST(InputSource inputSource, String string) throws TransformerConfigurationException {
        XTQProgram xTQProgram = (XTQProgram)this.makeAST(inputSource, string);
        if (this.errorsFound()) {
            Vector vector = this._parser.getErrors();
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < vector.size(); ++i) {
                stringBuffer.append(vector.elementAt(i));
            }
            if (stringBuffer.length() > 0) {
                throw new RuntimeException(stringBuffer.toString());
            }
            ErrorMsg errorMsg = new ErrorMsg("STYLESHEET_ERRORS");
            throw new RuntimeException(errorMsg.getFormattedMessage());
        }
        return xTQProgram;
    }

    public Module translate(XTQProgram xTQProgram) {
        xTQProgram.setCallsNodeset(this.callsNodeset());
        xTQProgram.setHasIdCall(this.hasIdCall());
        Module module = null;
        if (this.m_compiSettings.getVersion().equals("2.0")) {
            XSLT2Translator xSLT2Translator = new XSLT2Translator(this);
            ((VisitorBase)xSLT2Translator).visitTree(xTQProgram);
            module = xSLT2Translator.getStylesheetModule();
        } else {
            XSLTTranslator xSLTTranslator;
            if (this.m_trace) {
                xSLTTranslator = new XSLTDebugTranslator(this);
            } else {
                xSLTTranslator = new XSLTTranslator(this);
                if (this.disableSetParameter()) {
                    xSLTTranslator.setDisableSetParameter(true);
                }
            }
            ((VisitorBase)xSLTTranslator).visitTree(xTQProgram);
            module = xSLTTranslator.getModule();
        }
        if (this.errorsFound()) {
            ErrorMsg errorMsg = new ErrorMsg("STYLESHEET_ERRORS");
            throw new RuntimeException(errorMsg.getFormattedMessage());
        }
        return module;
    }

    @Override
    public Module getRuntimeLibrary() {
        return this.m_runtimeLibrary;
    }

    @Override
    public void setRuntimeLibrary(Module module) {
        this.m_runtimeLibrary = module;
    }

    public void cleanRuntimeLibrary() {
        this.setRuntimeLibrary(null);
    }

    public Module getStylesheetModule() {
        return this.m_stylesheetModule;
    }

    public void setStylesheetModule(Module module) {
        this.m_stylesheetModule = module;
    }

    public void cleanStylesheetModule() {
        this.setStylesheetModule(null);
    }

    public ModuleSignature getModuleSignature() {
        return this.m_moduleSignature;
    }

    public void setModuleSignature(ModuleSignature moduleSignature) {
        this.m_moduleSignature = moduleSignature;
    }

    public int getPrereductionSplitLimit() {
        return this.m_compiSettings.getPrereductionSplitLimit();
    }

    public boolean errorsFound() {
        return this.getParser().errorsFound();
    }

    public boolean isSerializationTraceEnabled() {
        return this.m_compiSettings.isSerializationTraceEnabled();
    }

    public void setTraceImportsAndIncludes(boolean bl) {
        this.m_compiSettings.setTraceImportsAndIncludes(bl);
    }

    public void setDoPostASTProcessing(boolean bl) {
        this.m_compiSettings.setDoPostASTProcessing(bl);
    }

    public boolean getDoPostASTProcessing() {
        return this.m_compiSettings.isDoPostASTProcessing();
    }

    public void postASTProcessing(Module module, Module module2, String string) throws Exception {
        try {
            if (string != null) {
                AutoFunctorizingXSLTCompiler.postASTProcessingForFunctor(this);
            } else {
                XSLTCompiler.postASTProcessing(module2, module, this.getSplitLimit(), this.getCompilerSettings().isStreamResultOnly());
            }
        }
        catch (Exception exception) {
            s_logger.error("Post AST Processing: error compiling stylesheet", exception);
        }
    }

    public Templates linkAndCodeGen(Module module, Module module2) throws Exception {
        this.m_linkerSettings.getCodeGenerationSettings().setBCELClassCollector(this.getByteCodeClassCollecter());
        XSLTLinker.compileProgram(module2, module, 1, Collections.EMPTY_LIST, this.m_linkerSettings);
        if ((this.m_outputType & 4) != 0) {
            this.outputToJar();
        }
        return null;
    }

    public boolean isInterpreted() {
        return this.m_compiSettings.isInterpreted();
    }

    public void setInterpreted(boolean bl) {
        this.m_compiSettings.setInterpreted(bl);
    }

    public boolean isXHTMLCompatability() {
        return this.m_compiSettings.isXHTMLCompatability();
    }

    public void setXHTMLCompatability(boolean bl) {
        this.m_compiSettings.setXHTMLCompatability(bl);
    }

    public XSLTCompilerSettings getCompilerSettings() {
        return this.m_compiSettings;
    }

    public static Module compileStylesheetToModule(InputStream inputStream, Module module, ModuleSignature moduleSignature, String string, boolean bl) throws Exception {
        XSLTCompiler xSLTCompiler = new XSLTCompiler(string);
        xSLTCompiler.setStreamResultOnly(!bl);
        xSLTCompiler.setModuleSignature(moduleSignature);
        xSLTCompiler.setRuntimeLibrary(module);
        InputSource inputSource = new InputSource(inputStream);
        inputSource.setSystemId("");
        XTQProgram xTQProgram = xSLTCompiler.buildAST(inputSource, null);
        Module module2 = xSLTCompiler.translate(xTQProgram);
        if (xSLTCompiler.getDoPostASTProcessing()) {
            xSLTCompiler.postASTProcessing(module, module2, null);
        }
        return module2;
    }

    public static Module compileStylesheetToModule(Source source, Module module, ModuleSignature moduleSignature, boolean bl, String string, boolean bl2, boolean bl3, ErrorHandler errorHandler, boolean bl4, SourceLoader sourceLoader, boolean bl5) throws Exception {
        s_logger.info("Compiling stylesheet: " + source);
        XSLTCompiler xSLTCompiler = new XSLTCompiler(string);
        xSLTCompiler.setStreamResultOnly(!bl2);
        xSLTCompiler.setInterpreted(bl5);
        xSLTCompiler.setModuleSignature(moduleSignature);
        xSLTCompiler.setRuntimeLibrary(module);
        xSLTCompiler.setTrace(bl3);
        xSLTCompiler.setErrorHandler(errorHandler);
        xSLTCompiler.setSecureProcessing(bl4);
        xSLTCompiler.setSourceLoader(sourceLoader);
        InputSource inputSource = com.ibm.xtq.xslt.jaxp.Util.getInputSource(xSLTCompiler.getParser(), source);
        XTQProgram xTQProgram = xSLTCompiler.buildAST(inputSource, null);
        Module module2 = xSLTCompiler.translate(xTQProgram);
        if (bl) {
            xSLTCompiler.postASTProcessing(module, module2, null);
        }
        return module2;
    }

    public static final void postASTProcessing(Module module, Module module2, int n, boolean bl) throws Exception {
        s_logger.info("Post-processing AST");
        module.typeCheck();
        if (XPathUnionOptimizer.RUN_UNION_OPTIMIZER) {
            module.optimize(new XPathUnionOptimizer());
            module.clearTypeInformation();
            module.typeCheck();
        }
        module.optimize(new PostOrderOptimizer(){

            @Override
            protected void optimizeChildren(Instruction instruction) {
                StreamInstruction streamInstruction;
                if (instruction instanceof StreamInstruction && (streamInstruction = (StreamInstruction)instruction).isString()) {
                    return;
                }
                super.optimizeChildren(instruction);
            }

            @Override
            protected Instruction optimizeStep(Instruction instruction) {
                LetInstruction letInstruction;
                if (instruction instanceof CoerceInstruction) {
                    CoerceInstruction coerceInstruction = (CoerceInstruction)instruction;
                    TypeEnvironment typeEnvironment = this.getCurrentFunction().getTypeEnvironment();
                    if (coerceInstruction.getType().equals(coerceInstruction.getOperand().getCachedType().resolveType(typeEnvironment))) {
                        return coerceInstruction.getOperand();
                    }
                } else if (instruction instanceof AssertTypeInstruction) {
                    AssertTypeInstruction assertTypeInstruction = (AssertTypeInstruction)instruction;
                    TypeEnvironment typeEnvironment = this.getCurrentFunction().getTypeEnvironment();
                    if (assertTypeInstruction.getType().equals(assertTypeInstruction.getOperand().getCachedType().resolveType(typeEnvironment))) {
                        return assertTypeInstruction.getOperand();
                    }
                } else if (instruction instanceof LetInstruction && (letInstruction = (LetInstruction)instruction).getBody() instanceof LiteralInstruction) {
                    return letInstruction.getBody();
                }
                return instruction;
            }
        });
        if (bl) {
            module.optimize(new SAXEventStreamOptimizer());
        }
        if (0 != n) {
            module.optimize(new SimpleUnflattenStreamOptimizer(n));
            module.optimize(new XSLTReverseInliningOptimizer(n));
            module.clearTypeInformation(true);
        }
        module.typeCheck();
        module.reduce();
        module.formalizeSignature("");
    }

    public static Module compileStylesheetToModule(URL uRL, Module module, ModuleSignature moduleSignature, boolean bl, XSLTCompilerSettings xSLTCompilerSettings, SourceLoader sourceLoader, boolean bl2) throws Exception {
        Object object;
        InputSource inputSource;
        s_logger.info("Compiling stylesheet: " + uRL);
        XSLTCompiler xSLTCompiler = new XSLTCompiler(xSLTCompilerSettings);
        if (null != sourceLoader) {
            xSLTCompiler.setSourceLoader(sourceLoader);
        }
        xSLTCompiler.setModuleSignature(moduleSignature);
        xSLTCompiler.setRuntimeLibrary(module);
        if (null != sourceLoader && bl2) {
            inputSource = sourceLoader.loadSource("", uRL.toString(), null);
        } else {
            object = uRL.openStream();
            inputSource = new InputSource((InputStream)object);
            inputSource.setSystemId(uRL.toString());
        }
        object = xSLTCompiler.buildAST(inputSource, uRL.toString());
        Module module2 = xSLTCompiler.translate((XTQProgram)object);
        if (bl) {
            xSLTCompiler.postASTProcessing(module, module2, null);
        }
        return module2;
    }

    public static Module compileStylesheetToModule(URL uRL, Module module, ModuleSignature moduleSignature, boolean bl, XSLTCompilerSettings xSLTCompilerSettings) throws Exception {
        return XSLTCompiler.compileStylesheetToModule(uRL, module, moduleSignature, bl, xSLTCompilerSettings, null, false);
    }

    public static Module compileRuntimeLibrary(String string) throws Exception {
        XSLTCompiler xSLTCompiler = new XSLTCompiler(string);
        return xSLTCompiler.compileRuntime();
    }

    public XSLTLinkerSettings getLinkerSettings() {
        return this.m_linkerSettings;
    }

    public String getFunctorName() {
        return this.m_linkerSettings.getFunctorName();
    }

    public void setFunctorName(String string) {
        this.m_linkerSettings.setFunctorName(string);
    }

    public String getFunctorParamLocalName() {
        return this.m_linkerSettings.getFunctorParamLocalName();
    }

    public void setFunctorParamLocalName(String string) {
        this.m_linkerSettings.setFunctorParamLocalName(string);
    }

    public ModuleSignature getFunctorParamSignature() {
        return this.m_linkerSettings.getFunctorParamSignature();
    }

    public void setFunctorParamSignature(ModuleSignature moduleSignature) {
        this.m_linkerSettings.setFunctorParamSignature(moduleSignature);
    }

    public Functor getXylemFunctorOutput() {
        return this.m_linkerSettings.getXylemFunctorOutput();
    }

    public void setXylemFunctorOutput(Functor functor) {
        this.m_linkerSettings.setXylemFunctorOutput(functor);
    }

    @Override
    public void setErrorHandler(ErrorHandler errorHandler) {
        super.setErrorHandler(errorHandler);
        this.m_linkerSettings.setErrorHandler(errorHandler);
    }

    private class WritingClassCollector
    extends ChainedClassCollector {
        public WritingClassCollector(ClassCollector classCollector) {
            super(classCollector);
        }

        @Override
        public void handleGeneratedClass(JavaClass javaClass) {
            try {
                javaClass.dump(XSLTCompiler.this.getOutputFile(javaClass.getClassName()));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        @Override
        public void handleGeneratedResource(Resource resource) {
            try {
                resource.dump(new FileOutputStream(new File(XSLTCompiler.this.m_destDir, resource.getName())));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private class CachingClassCollector
    extends ChainedClassCollector {
        public CachingClassCollector(ClassCollector classCollector) {
            super(classCollector);
        }

        @Override
        public void handleGeneratedClass(JavaClass javaClass) {
            XSLTCompiler.this.m_classes.add(javaClass);
        }

        @Override
        public void handleGeneratedResource(Resource resource) {
            XSLTCompiler.this.m_resources.add(resource);
        }
    }

    private abstract class ChainedClassCollector
    extends ClassCollector {
        private ClassCollector m_nextCollector;

        public ChainedClassCollector(ClassCollector classCollector) {
            this.m_nextCollector = classCollector;
        }

        public abstract void handleGeneratedClass(JavaClass var1);

        public abstract void handleGeneratedResource(Resource var1);

        @Override
        public final void acceptGeneratedClass(JavaClass javaClass) {
            this.handleGeneratedClass(javaClass);
            if (this.m_nextCollector != null) {
                this.m_nextCollector.acceptGeneratedClass(javaClass);
            }
        }

        @Override
        public final void acceptGeneratedResource(Resource resource) {
            this.handleGeneratedResource(resource);
            if (this.m_nextCollector != null) {
                this.m_nextCollector.acceptGeneratedResource(resource);
            }
        }
    }
}

