/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xylem.optimizers;

import com.ibm.xylem.Function;
import com.ibm.xylem.Instruction;
import com.ibm.xylem.Module;
import com.ibm.xylem.Optimizer;
import com.ibm.xylem.Type;
import com.ibm.xylem.builders.LetChainBuilder;
import com.ibm.xylem.instructions.ChooseInstruction;
import com.ibm.xylem.instructions.FunctionCallInstruction;
import com.ibm.xylem.instructions.LiteralInstruction;
import java.util.LinkedList;
import java.util.List;

public abstract class InlineFunctions
extends Optimizer {
    private LinkedList m_inlineStack = new LinkedList();
    private Module m_module;

    protected InlineFunctions(Module module) {
        this.m_module = module;
    }

    @Override
    protected Instruction optimizeStep(Instruction instruction) {
        FunctionCallInstruction functionCallInstruction;
        Function function;
        if (instruction instanceof FunctionCallInstruction && (function = this.getFunction(functionCallInstruction = (FunctionCallInstruction)instruction)) != null && this.shouldInline(function, this.m_inlineStack)) {
            this.m_inlineStack.addLast(function);
            Instruction instruction2 = LetChainBuilder.inlinebody(functionCallInstruction.m_parameters, function.m_parameters, function.getBody());
            instruction2 = this.optimize(instruction2);
            this.m_inlineStack.removeLast();
            return new ChooseInstruction(LiteralInstruction.booleanTrueLiteral(), instruction2, null);
        }
        return instruction;
    }

    private Function getFunction(FunctionCallInstruction functionCallInstruction) {
        String string = functionCallInstruction.getFunction();
        return this.m_module.getFunction(string);
    }

    protected abstract boolean shouldInline(Function var1, List var2);

    public static class ByParamType
    extends InlineFunctions {
        private Type m_type;
        private int m_limit;

        public ByParamType(Type type, int n, Module module) {
            super(module);
            this.m_type = type;
            this.m_limit = n;
            if (this.m_type == null) {
                throw new RuntimeException();
            }
        }

        @Override
        protected boolean shouldInline(Function function, List list) {
            s_logger.debug("inlining call to " + function.getName() + " ?");
            if (list.size() > this.m_limit) {
                s_logger.debug(" no -- too deep.");
                return false;
            }
            for (int i = 0; i < function.m_parameters.length; ++i) {
                if (!this.m_type.equals(function.m_parameters[i].getBindingType())) continue;
                s_logger.debug(" yes.");
                return true;
            }
            s_logger.debug(" no -- no params of type " + this.m_type);
            return false;
        }
    }
}

