/*  Licensed to the Apache Software Foundation (ASF) under one or more
 *  contributor license agreements.  See the NOTICE file distributed with
 *  this work for additional information regarding copyright ownership.
 *  The ASF licenses this file to You under the Apache License, Version 2.0
 *  (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.apache.aries.jpa.blueprint.aries.itest;

import org.apache.aries.jpa.container.itest.bundle.blueprint.TestService;
import org.apache.aries.jpa.itest.AbstractJPAItest;
import org.junit.Test;
import org.ops4j.pax.exam.Configuration;
import org.ops4j.pax.exam.Option;

import static org.ops4j.pax.exam.CoreOptions.mavenBundle;

public class BlueprintDaoTest extends AbstractJPAItest {

    @Test
    public void testNestedTransactionsWithIsolatedEntityManagers() throws Exception {
        TestService testService = getService(TestService.class, null);
        testService.performTest();
    }

    @Configuration
    public Option[] configuration() {
        return new Option[] {
                baseOptions(), //
                jta12Bundles(), //
                ariesJpa20(), //
                hibernate(), //
                derbyDSF(), //
                testBundle(), //
                testBundleBlueprintDao(),
                mavenBundle("org.apache.aries.transaction", "org.apache.aries.transaction.blueprint", "2.3.0"),
//                 debug()
        };
    }
}
