/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.subsystem.core.internal;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.aries.subsystem.core.internal.BasicSubsystem;
import org.apache.aries.subsystem.core.internal.ResourceHelper;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;
import org.osgi.resource.Resource;
import org.osgi.service.repository.Repository;

public class SystemRepository
implements Repository {
    private final BasicSubsystem root;

    public SystemRepository(BasicSubsystem root) {
        this.root = root;
    }

    public Map<Requirement, Collection<Capability>> findProviders(Collection<? extends Requirement> requirements) {
        HashMap<Requirement, Collection<Capability>> result = new HashMap<Requirement, Collection<Capability>>();
        for (Requirement requirement : requirements) {
            result.put(requirement, this.findProviders(requirement));
        }
        return result;
    }

    public Collection<Capability> findProviders(Requirement requirement) {
        HashSet<Capability> result = new HashSet<Capability>();
        this.findProviders(requirement, result, this.root);
        return result;
    }

    private void findProviders(Requirement requirement, Collection<Capability> capabilities, BasicSubsystem subsystem) {
        for (Capability capability : subsystem.getCapabilities(requirement.getNamespace())) {
            if (!ResourceHelper.matches(requirement, capability)) continue;
            capabilities.add(capability);
        }
        for (Resource constituent : subsystem.getConstituents()) {
            if (constituent instanceof BasicSubsystem) {
                this.findProviders(requirement, capabilities, (BasicSubsystem)constituent);
                continue;
            }
            for (Capability capability : constituent.getCapabilities(requirement.getNamespace())) {
                if (!ResourceHelper.matches(requirement, capability)) continue;
                capabilities.add(capability);
            }
        }
    }
}

