/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.subsystem.obr.internal;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.Version;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;
import org.osgi.resource.Resource;
import org.osgi.service.repository.Repository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceHelper {
    private static final Logger logger = LoggerFactory.getLogger(ResourceHelper.class);

    public static String getContentAttribute(Resource resource) {
        return (String)ResourceHelper.getContentAttribute(resource, "osgi.content");
    }

    public static Object getContentAttribute(Resource resource, String name) {
        List capabilities = resource.getCapabilities("osgi.content");
        Capability capability = (Capability)capabilities.get(0);
        return capability.getAttributes().get(name);
    }

    public static Object getIdentityAttribute(Resource resource, String name) {
        List capabilities = resource.getCapabilities("osgi.identity");
        Capability capability = (Capability)capabilities.get(0);
        return capability.getAttributes().get(name);
    }

    public static Resource getResource(Requirement requirement, Repository repository) {
        Map map = repository.findProviders(Arrays.asList(requirement));
        Collection capabilities = (Collection)map.get(requirement);
        return capabilities == null ? null : (capabilities.size() == 0 ? null : ((Capability)capabilities.iterator().next()).getResource());
    }

    public static String getSymbolicNameAttribute(Resource resource) {
        return (String)ResourceHelper.getIdentityAttribute(resource, "osgi.identity");
    }

    public static String getTypeAttribute(Resource resource) {
        String result = (String)ResourceHelper.getIdentityAttribute(resource, "type");
        if (result == null) {
            result = "osgi.bundle";
        }
        return result;
    }

    public static Version getVersionAttribute(Resource resource) {
        Version result = (Version)ResourceHelper.getIdentityAttribute(resource, "version");
        if (result == null) {
            result = Version.emptyVersion;
        }
        return result;
    }

    public static boolean matches(Requirement requirement, Capability capability) {
        boolean result = false;
        if (requirement == null && capability == null) {
            result = true;
        } else if (requirement == null || capability == null) {
            result = false;
        } else if (!capability.getNamespace().equals(requirement.getNamespace())) {
            result = false;
        } else {
            String filterStr = (String)requirement.getDirectives().get("filter");
            if (filterStr == null) {
                result = true;
            } else {
                try {
                    if (FrameworkUtil.createFilter((String)filterStr).matches(capability.getAttributes())) {
                        result = true;
                    }
                }
                catch (InvalidSyntaxException e) {
                    logger.debug("Requirement had invalid filter string: " + requirement, (Throwable)e);
                    result = false;
                }
            }
        }
        return result;
    }
}

