/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.rewriter.rules;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.SelectOperator;
import org.apache.hyracks.algebricks.core.rewriter.base.IAlgebraicRewriteRule;
import org.apache.hyracks.api.exceptions.SourceLocation;

public class BreakSelectIntoConjunctsRule
implements IAlgebraicRewriteRule {
    private List<Mutable<ILogicalExpression>> selectOperatorConditionConjuncts = new ArrayList<Mutable<ILogicalExpression>>();

    public boolean rewritePost(Mutable<ILogicalOperator> operatorRef, IOptimizationContext context) {
        return false;
    }

    public boolean rewritePre(Mutable<ILogicalOperator> operatorRef, IOptimizationContext context) throws AlgebricksException {
        AbstractLogicalOperator expectedSelectOperator = (AbstractLogicalOperator)operatorRef.getValue();
        if (expectedSelectOperator.getOperatorTag() != LogicalOperatorTag.SELECT) {
            return false;
        }
        SelectOperator originalSelectOperator = (SelectOperator)expectedSelectOperator;
        ILogicalExpression selectOperatorCondition = (ILogicalExpression)originalSelectOperator.getCondition().getValue();
        this.selectOperatorConditionConjuncts.clear();
        if (!selectOperatorCondition.splitIntoConjuncts(this.selectOperatorConditionConjuncts)) {
            return false;
        }
        SourceLocation sourceLoc = originalSelectOperator.getSourceLocation();
        Mutable originalSelectOperatorInputs = (Mutable)originalSelectOperator.getInputs().get(0);
        boolean isFirst = true;
        ILogicalExpression firstExpression = null;
        SelectOperator bottomOperator = originalSelectOperator;
        for (Mutable<ILogicalExpression> expressionRef : this.selectOperatorConditionConjuncts) {
            ILogicalExpression expression = (ILogicalExpression)expressionRef.getValue();
            if (isFirst) {
                isFirst = false;
                firstExpression = expression;
                continue;
            }
            SelectOperator newSelectOperator = new SelectOperator((Mutable)new MutableObject((Object)expression), originalSelectOperator.getRetainMissing(), originalSelectOperator.getMissingPlaceholderVariable());
            newSelectOperator.setSourceLocation(sourceLoc);
            List bottomOperatorInputs = bottomOperator.getInputs();
            bottomOperatorInputs.clear();
            bottomOperatorInputs.add(new MutableObject((Object)newSelectOperator));
            context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)bottomOperator);
            bottomOperator = newSelectOperator;
        }
        bottomOperator.getInputs().add(originalSelectOperatorInputs);
        originalSelectOperator.getCondition().setValue(firstExpression);
        context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)bottomOperator);
        context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)originalSelectOperator);
        return true;
    }
}

