/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.core.algebra.operators.physical;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.exceptions.NotImplementedException;
import org.apache.hyracks.algebricks.common.utils.ListSet;
import org.apache.hyracks.algebricks.core.algebra.base.IHyracksJobBuilder;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.base.PhysicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.expressions.IExpressionRuntimeProvider;
import org.apache.hyracks.algebricks.core.algebra.expressions.IVariableTypeEnvironment;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractBinaryJoinOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.IOperatorSchema;
import org.apache.hyracks.algebricks.core.algebra.operators.physical.AbstractHashJoinPOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.physical.AbstractJoinPOperator;
import org.apache.hyracks.algebricks.core.algebra.properties.ILocalStructuralProperty;
import org.apache.hyracks.algebricks.core.algebra.properties.IPhysicalPropertiesVector;
import org.apache.hyracks.algebricks.core.algebra.properties.LocalGroupingProperty;
import org.apache.hyracks.algebricks.core.jobgen.impl.JobGenContext;
import org.apache.hyracks.algebricks.core.jobgen.impl.JobGenHelper;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.algebricks.runtime.evaluators.TuplePairEvaluatorFactory;
import org.apache.hyracks.api.dataflow.IOperatorDescriptor;
import org.apache.hyracks.api.dataflow.value.IBinaryHashFunctionFamily;
import org.apache.hyracks.api.dataflow.value.IMissingWriterFactory;
import org.apache.hyracks.api.dataflow.value.IPredicateEvaluatorFactory;
import org.apache.hyracks.api.dataflow.value.IPredicateEvaluatorFactoryProvider;
import org.apache.hyracks.api.dataflow.value.ITuplePairComparatorFactory;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;
import org.apache.hyracks.api.job.IOperatorDescriptorRegistry;
import org.apache.hyracks.api.job.JobSpecification;
import org.apache.hyracks.dataflow.std.join.OptimizedHybridHashJoinOperatorDescriptor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HybridHashJoinPOperator
extends AbstractHashJoinPOperator {
    private final int maxInputBuildSizeInFrames;
    private final double fudgeFactor;
    private static final Logger LOGGER = LogManager.getLogger();

    public HybridHashJoinPOperator(AbstractBinaryJoinOperator.JoinKind kind, AbstractJoinPOperator.JoinPartitioningType partitioningType, List<LogicalVariable> sideLeftOfEqualities, List<LogicalVariable> sideRightOfEqualities, int maxInputSizeInFrames, int aveRecordsPerFrame, double fudgeFactor) {
        super(kind, partitioningType, sideLeftOfEqualities, sideRightOfEqualities);
        this.maxInputBuildSizeInFrames = maxInputSizeInFrames;
        this.fudgeFactor = fudgeFactor;
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("HybridHashJoinPOperator constructed with: JoinKind=" + kind + ", JoinPartitioningType=" + partitioningType + ", List<LogicalVariable>=" + sideLeftOfEqualities + ", List<LogicalVariable>=" + sideRightOfEqualities + ", int maxInputSize0InFrames=" + maxInputSizeInFrames + ", int aveRecordsPerFrame=" + aveRecordsPerFrame + ", double fudgeFactor=" + fudgeFactor + ".");
        }
    }

    @Override
    public PhysicalOperatorTag getOperatorTag() {
        return PhysicalOperatorTag.HYBRID_HASH_JOIN;
    }

    @Override
    public boolean isMicroOperator() {
        return false;
    }

    public double getFudgeFactor() {
        return this.fudgeFactor;
    }

    @Override
    public String toString() {
        return this.getOperatorTag().toString() + " " + this.keysLeftBranch + this.keysRightBranch;
    }

    @Override
    public void contributeRuntimeOperator(IHyracksJobBuilder builder, JobGenContext context, ILogicalOperator op, IOperatorSchema propagatedSchema, IOperatorSchema[] inputSchemas, IOperatorSchema outerPlanSchema) throws AlgebricksException {
        HybridHashJoinPOperator.validateNumKeys(this.keysLeftBranch, this.keysRightBranch);
        int[] keysLeft = JobGenHelper.variablesToFieldIndexes(this.keysLeftBranch, inputSchemas[0]);
        int[] keysRight = JobGenHelper.variablesToFieldIndexes(this.keysRightBranch, inputSchemas[1]);
        IVariableTypeEnvironment env = context.getTypeEnvironment(op);
        IBinaryHashFunctionFamily[] leftHashFunFamilies = JobGenHelper.variablesToBinaryHashFunctionFamilies(this.keysLeftBranch, env, context);
        IBinaryHashFunctionFamily[] rightHashFunFamilies = JobGenHelper.variablesToBinaryHashFunctionFamilies(this.keysRightBranch, env, context);
        IPredicateEvaluatorFactoryProvider predEvaluatorFactoryProvider = context.getPredicateEvaluatorFactoryProvider();
        IPredicateEvaluatorFactory predEvaluatorFactory = predEvaluatorFactoryProvider == null ? null : predEvaluatorFactoryProvider.getPredicateEvaluatorFactory(keysLeft, keysRight);
        RecordDescriptor recDescriptor = JobGenHelper.mkRecordDescriptor(context.getTypeEnvironment(op), propagatedSchema, context);
        IOperatorSchema[] conditionInputSchemas = new IOperatorSchema[]{propagatedSchema};
        IExpressionRuntimeProvider expressionRuntimeProvider = context.getExpressionRuntimeProvider();
        AbstractBinaryJoinOperator joinOp = (AbstractBinaryJoinOperator)op;
        IScalarEvaluatorFactory cond = expressionRuntimeProvider.createEvaluatorFactory((ILogicalExpression)joinOp.getCondition().getValue(), context.getTypeEnvironment(op), conditionInputSchemas, context);
        TuplePairEvaluatorFactory comparatorFactory = new TuplePairEvaluatorFactory(cond, false, context.getBinaryBooleanInspectorFactory());
        TuplePairEvaluatorFactory reverseComparatorFactory = new TuplePairEvaluatorFactory(cond, true, context.getBinaryBooleanInspectorFactory());
        JobSpecification spec = builder.getJobSpec();
        IOperatorDescriptor opDesc = this.generateOptimizedHashJoinRuntime(context, inputSchemas, keysLeft, keysRight, leftHashFunFamilies, rightHashFunFamilies, (ITuplePairComparatorFactory)comparatorFactory, (ITuplePairComparatorFactory)reverseComparatorFactory, predEvaluatorFactory, recDescriptor, (IOperatorDescriptorRegistry)spec);
        opDesc.setSourceLocation(op.getSourceLocation());
        this.contributeOpDesc(builder, (AbstractLogicalOperator)op, opDesc);
        ILogicalOperator src1 = (ILogicalOperator)op.getInputs().get(0).getValue();
        builder.contributeGraphEdge(src1, 0, op, 0);
        ILogicalOperator src2 = (ILogicalOperator)op.getInputs().get(1).getValue();
        builder.contributeGraphEdge(src2, 0, op, 1);
    }

    private IOperatorDescriptor generateOptimizedHashJoinRuntime(JobGenContext context, IOperatorSchema[] inputSchemas, int[] keysLeft, int[] keysRight, IBinaryHashFunctionFamily[] leftHashFunFamilies, IBinaryHashFunctionFamily[] rightHashFunFamilies, ITuplePairComparatorFactory comparatorFactory, ITuplePairComparatorFactory reverseComparatorFactory, IPredicateEvaluatorFactory predEvaluatorFactory, RecordDescriptor recDescriptor, IOperatorDescriptorRegistry spec) {
        int memSizeInFrames = this.localMemoryRequirements.getMemoryBudgetInFrames();
        switch (this.kind) {
            case INNER: {
                return new OptimizedHybridHashJoinOperatorDescriptor(spec, memSizeInFrames, this.maxInputBuildSizeInFrames, this.getFudgeFactor(), keysLeft, keysRight, leftHashFunFamilies, rightHashFunFamilies, recDescriptor, comparatorFactory, reverseComparatorFactory, predEvaluatorFactory);
            }
            case LEFT_OUTER: {
                IMissingWriterFactory[] nonMatchWriterFactories = new IMissingWriterFactory[inputSchemas[1].getSize()];
                for (int j = 0; j < nonMatchWriterFactories.length; ++j) {
                    nonMatchWriterFactories[j] = context.getMissingWriterFactory();
                }
                return new OptimizedHybridHashJoinOperatorDescriptor(spec, memSizeInFrames, this.maxInputBuildSizeInFrames, this.getFudgeFactor(), keysLeft, keysRight, leftHashFunFamilies, rightHashFunFamilies, recDescriptor, comparatorFactory, reverseComparatorFactory, predEvaluatorFactory, true, nonMatchWriterFactories);
            }
        }
        throw new NotImplementedException();
    }

    @Override
    protected List<ILocalStructuralProperty> deliveredLocalProperties(ILogicalOperator op, IOptimizationContext context) throws AlgebricksException {
        ArrayList<ILocalStructuralProperty> deliveredLocalProperties = new ArrayList<ILocalStructuralProperty>();
        if (this.kind != AbstractBinaryJoinOperator.JoinKind.LEFT_OUTER) {
            return deliveredLocalProperties;
        }
        AbstractLogicalOperator probeOp = (AbstractLogicalOperator)op.getInputs().get(0).getValue();
        IPhysicalPropertiesVector probeSideProperties = probeOp.getPhysicalOperator().getDeliveredProperties();
        List<ILocalStructuralProperty> probeSideLocalProperties = probeSideProperties.getLocalProperties();
        if (probeSideLocalProperties != null) {
            for (ILocalStructuralProperty property : probeSideLocalProperties) {
                ListSet groupingVars = new ListSet();
                ListSet leftBranchVars = new ListSet();
                property.getVariables((Collection<LogicalVariable>)groupingVars);
                leftBranchVars.addAll(this.getKeysLeftBranch());
                if (!groupingVars.containsAll((Collection<?>)leftBranchVars)) continue;
                deliveredLocalProperties.add(new LocalGroupingProperty((Set<LogicalVariable>)groupingVars));
            }
        }
        return deliveredLocalProperties;
    }
}

