/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.dataflow.data.nontagged.comparators;

import org.apache.asterix.dataflow.data.common.ILogicalBinaryComparator;
import org.apache.asterix.dataflow.data.common.TaggedValueReference;
import org.apache.asterix.dataflow.data.nontagged.comparators.LogicalComplexBinaryComparator;
import org.apache.asterix.dataflow.data.nontagged.comparators.LogicalGenericBinaryComparator;
import org.apache.asterix.dataflow.data.nontagged.comparators.LogicalScalarBinaryComparator;
import org.apache.asterix.dataflow.data.nontagged.serde.ADoubleSerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.AFloatSerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.AInt16SerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.AInt32SerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.AInt64SerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.AInt8SerializerDeserializer;
import org.apache.asterix.om.base.ADouble;
import org.apache.asterix.om.base.AFloat;
import org.apache.asterix.om.base.AInt16;
import org.apache.asterix.om.base.AInt32;
import org.apache.asterix.om.base.AInt64;
import org.apache.asterix.om.base.AInt8;
import org.apache.asterix.om.base.IAObject;
import org.apache.asterix.om.typecomputer.impl.TypeComputeUtils;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.om.types.hierachy.ATypeHierarchy;

public class ComparatorUtil {
    private ComparatorUtil() {
    }

    public static ILogicalBinaryComparator createLogicalComparator(IAType left, IAType right, boolean isEquality) {
        IAType leftType = TypeComputeUtils.getActualType(left);
        IAType rightType = TypeComputeUtils.getActualType(right);
        if (leftType.getTypeTag().isDerivedType() && rightType.getTypeTag().isDerivedType()) {
            return new LogicalComplexBinaryComparator(leftType, rightType, isEquality);
        }
        if (leftType.getTypeTag() == ATypeTag.ANY || rightType.getTypeTag() == ATypeTag.ANY) {
            return new LogicalGenericBinaryComparator(leftType, rightType, isEquality);
        }
        return LogicalScalarBinaryComparator.of(isEquality);
    }

    static ILogicalBinaryComparator.Result returnMissingOrNullOrMismatch(ATypeTag leftTag, ATypeTag rightTag) {
        if (leftTag == ATypeTag.MISSING || rightTag == ATypeTag.MISSING) {
            return ILogicalBinaryComparator.Result.MISSING;
        }
        if (leftTag == ATypeTag.NULL || rightTag == ATypeTag.NULL) {
            return ILogicalBinaryComparator.Result.NULL;
        }
        if (!ATypeHierarchy.isCompatible(leftTag, rightTag)) {
            return ILogicalBinaryComparator.Result.INCOMPARABLE;
        }
        return null;
    }

    static int compareNumbers(ATypeTag lTag, byte[] l, int lStart, ATypeTag rTag, byte[] r, int rStart) {
        if (lTag == ATypeTag.DOUBLE || rTag == ATypeTag.DOUBLE) {
            return Double.compare(ComparatorUtil.getDoubleValue(lTag, l, lStart), ComparatorUtil.getDoubleValue(rTag, r, rStart));
        }
        if (lTag == ATypeTag.FLOAT || rTag == ATypeTag.FLOAT) {
            return Float.compare((float)ComparatorUtil.getDoubleValue(lTag, l, lStart), (float)ComparatorUtil.getDoubleValue(rTag, r, rStart));
        }
        if (lTag == ATypeTag.BIGINT || rTag == ATypeTag.BIGINT) {
            return Long.compare(ComparatorUtil.getLongValue(lTag, l, lStart), ComparatorUtil.getLongValue(rTag, r, rStart));
        }
        if (lTag == ATypeTag.INTEGER || lTag == ATypeTag.SMALLINT || lTag == ATypeTag.TINYINT) {
            return Integer.compare((int)ComparatorUtil.getLongValue(lTag, l, lStart), (int)ComparatorUtil.getLongValue(rTag, r, rStart));
        }
        throw new UnsupportedOperationException();
    }

    static ILogicalBinaryComparator.Result compareNumWithConstant(TaggedValueReference left, IAObject right) {
        ATypeTag leftTag = left.getTag();
        ATypeTag rightTag = right.getType().getTypeTag();
        byte[] leftBytes = left.getByteArray();
        int start = left.getStartOffset();
        if (leftTag == ATypeTag.DOUBLE || rightTag == ATypeTag.DOUBLE) {
            return ILogicalBinaryComparator.asResult(Double.compare(ComparatorUtil.getDoubleValue(leftTag, leftBytes, start), ComparatorUtil.getConstantDouble(right)));
        }
        if (leftTag == ATypeTag.FLOAT || rightTag == ATypeTag.FLOAT) {
            return ILogicalBinaryComparator.asResult(Float.compare((float)ComparatorUtil.getDoubleValue(leftTag, leftBytes, start), (float)ComparatorUtil.getConstantDouble(right)));
        }
        if (leftTag == ATypeTag.BIGINT || rightTag == ATypeTag.BIGINT) {
            return ILogicalBinaryComparator.asResult(Long.compare(ComparatorUtil.getLongValue(leftTag, leftBytes, start), ComparatorUtil.getConstantLong(right)));
        }
        if (leftTag == ATypeTag.INTEGER || leftTag == ATypeTag.SMALLINT || leftTag == ATypeTag.TINYINT) {
            return ILogicalBinaryComparator.asResult(Integer.compare((int)ComparatorUtil.getLongValue(leftTag, leftBytes, start), (int)ComparatorUtil.getConstantLong(right)));
        }
        throw new UnsupportedOperationException();
    }

    static ILogicalBinaryComparator.Result compareConstants(IAObject leftConstant, IAObject rightConstant) {
        ATypeTag leftTag = leftConstant.getType().getTypeTag();
        ATypeTag rightTag = rightConstant.getType().getTypeTag();
        if (leftTag == ATypeTag.DOUBLE || rightTag == ATypeTag.DOUBLE) {
            return ILogicalBinaryComparator.asResult(Double.compare(ComparatorUtil.getConstantDouble(leftConstant), ComparatorUtil.getConstantDouble(rightConstant)));
        }
        if (leftTag == ATypeTag.FLOAT || rightTag == ATypeTag.FLOAT) {
            return ILogicalBinaryComparator.asResult(Float.compare((float)ComparatorUtil.getConstantDouble(leftConstant), (float)ComparatorUtil.getConstantDouble(rightConstant)));
        }
        if (leftTag == ATypeTag.BIGINT || rightTag == ATypeTag.BIGINT) {
            return ILogicalBinaryComparator.asResult(Long.compare(ComparatorUtil.getConstantLong(leftConstant), ComparatorUtil.getConstantLong(rightConstant)));
        }
        if (leftTag == ATypeTag.INTEGER || leftTag == ATypeTag.SMALLINT || leftTag == ATypeTag.TINYINT) {
            return ILogicalBinaryComparator.asResult(Integer.compare((int)ComparatorUtil.getConstantLong(leftConstant), (int)ComparatorUtil.getConstantLong(rightConstant)));
        }
        throw new UnsupportedOperationException();
    }

    private static double getDoubleValue(ATypeTag numericTag, byte[] bytes, int start) {
        switch (numericTag) {
            case TINYINT: {
                return AInt8SerializerDeserializer.getByte(bytes, start);
            }
            case SMALLINT: {
                return AInt16SerializerDeserializer.getShort(bytes, start);
            }
            case INTEGER: {
                return AInt32SerializerDeserializer.getInt(bytes, start);
            }
            case BIGINT: {
                return AInt64SerializerDeserializer.getLong(bytes, start);
            }
            case FLOAT: {
                return AFloatSerializerDeserializer.getFloat(bytes, start);
            }
            case DOUBLE: {
                return ADoubleSerializerDeserializer.getDouble(bytes, start);
            }
        }
        throw new UnsupportedOperationException();
    }

    private static long getLongValue(ATypeTag numericTag, byte[] bytes, int start) {
        switch (numericTag) {
            case TINYINT: {
                return AInt8SerializerDeserializer.getByte(bytes, start);
            }
            case SMALLINT: {
                return AInt16SerializerDeserializer.getShort(bytes, start);
            }
            case INTEGER: {
                return AInt32SerializerDeserializer.getInt(bytes, start);
            }
            case BIGINT: {
                return AInt64SerializerDeserializer.getLong(bytes, start);
            }
        }
        throw new UnsupportedOperationException();
    }

    private static double getConstantDouble(IAObject numeric) {
        ATypeTag tag = numeric.getType().getTypeTag();
        switch (tag) {
            case DOUBLE: {
                return ((ADouble)numeric).getDoubleValue();
            }
            case FLOAT: {
                return ((AFloat)numeric).getFloatValue();
            }
            case BIGINT: {
                return ((AInt64)numeric).getLongValue();
            }
            case INTEGER: {
                return ((AInt32)numeric).getIntegerValue();
            }
            case SMALLINT: {
                return ((AInt16)numeric).getShortValue();
            }
            case TINYINT: {
                return ((AInt8)numeric).getByteValue();
            }
        }
        throw new UnsupportedOperationException();
    }

    private static long getConstantLong(IAObject numeric) {
        ATypeTag tag = numeric.getType().getTypeTag();
        switch (tag) {
            case BIGINT: {
                return ((AInt64)numeric).getLongValue();
            }
            case INTEGER: {
                return ((AInt32)numeric).getIntegerValue();
            }
            case SMALLINT: {
                return ((AInt16)numeric).getShortValue();
            }
            case TINYINT: {
                return ((AInt8)numeric).getByteValue();
            }
        }
        throw new UnsupportedOperationException();
    }
}

