/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.implementation.jackson;

import com.azure.core.implementation.ReflectionUtilsApi;
import com.azure.core.util.logging.ClientLogger;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;

final class HeaderCollectionHandler {
    private static final int CACHE_SIZE_LIMIT = 10000;
    private static final Map<Field, MethodHandle> FIELD_TO_SETTER_CACHE = new ConcurrentHashMap<Field, MethodHandle>();
    private final String prefix;
    private final int prefixLength;
    private final Map<String, String> values;
    private final Field declaringField;

    HeaderCollectionHandler(String prefix, Field declaringField) {
        this.prefix = prefix;
        this.prefixLength = prefix.length();
        this.values = new HashMap<String, String>();
        this.declaringField = declaringField;
    }

    boolean headerStartsWithPrefix(String headerName) {
        return headerName.startsWith(this.prefix);
    }

    void addHeader(String headerName, String headerValue) {
        this.values.put(headerName.substring(this.prefixLength), headerValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void injectValuesIntoDeclaringField(Object deserializedHeaders, ClientLogger logger) {
        if (this.usePublicSetter(deserializedHeaders, logger)) {
            return;
        }
        boolean declaredFieldAccessibleBackup = this.declaringField.isAccessible();
        try {
            if (!declaredFieldAccessibleBackup) {
                AccessController.doPrivileged(() -> {
                    this.declaringField.setAccessible(true);
                    return null;
                });
            }
            this.declaringField.set(deserializedHeaders, this.values);
            logger.verbose("Set header collection by accessing the field directly.");
        }
        catch (IllegalAccessException ex) {
            logger.warning("Failed to inject header collection values into deserialized headers.", ex);
        }
        finally {
            if (!declaredFieldAccessibleBackup) {
                AccessController.doPrivileged(() -> {
                    this.declaringField.setAccessible(false);
                    return null;
                });
            }
        }
    }

    private boolean usePublicSetter(Object deserializedHeaders, ClientLogger logger) {
        Class<?> clazz = deserializedHeaders.getClass();
        String clazzSimpleName = clazz.getSimpleName();
        String fieldName = this.declaringField.getName();
        MethodHandle setterHandler = HeaderCollectionHandler.getFromCache(this.declaringField, field -> {
            MethodHandles.Lookup lookupToUse;
            try {
                lookupToUse = ReflectionUtilsApi.INSTANCE.getLookupToUse(clazz);
            }
            catch (Throwable t) {
                logger.verbose("Failed to retrieve MethodHandles.Lookup for field {}.", field, t);
                return null;
            }
            String setterName = HeaderCollectionHandler.getPotentialSetterName(fieldName);
            try {
                MethodHandle handle = lookupToUse.findVirtual(clazz, setterName, MethodType.methodType(clazz, Map.class));
                logger.verbose("Using MethodHandle for setter {} on class {}.", setterName, clazzSimpleName);
                return handle;
            }
            catch (ReflectiveOperationException ex) {
                logger.verbose("Failed to retrieve MethodHandle for setter {} on class {}.", setterName, clazzSimpleName, ex);
                try {
                    Method setterMethod = deserializedHeaders.getClass().getDeclaredMethod(setterName, Map.class);
                    MethodHandle handle = lookupToUse.unreflect(setterMethod);
                    logger.verbose("Using unreflected MethodHandle for setter {} on class {}.", setterName, clazzSimpleName);
                    return handle;
                }
                catch (ReflectiveOperationException ex2) {
                    logger.verbose("Failed to unreflect MethodHandle for setter {} on class {}.", setterName, clazzSimpleName, ex2);
                    return null;
                }
            }
        });
        if (setterHandler == null) {
            return false;
        }
        try {
            setterHandler.invokeWithArguments(deserializedHeaders, this.values);
            logger.verbose("Set header collection {} on class {} using MethodHandle.", fieldName, clazzSimpleName);
            return true;
        }
        catch (Throwable ex) {
            logger.verbose("Failed to set header {} collection on class {} using MethodHandle.", fieldName, clazzSimpleName, ex);
            return false;
        }
    }

    private static String getPotentialSetterName(String fieldName) {
        return "set" + fieldName.substring(0, 1).toUpperCase(Locale.ROOT) + fieldName.substring(1);
    }

    private static MethodHandle getFromCache(Field key, Function<Field, MethodHandle> compute) {
        if (FIELD_TO_SETTER_CACHE.size() >= 10000) {
            FIELD_TO_SETTER_CACHE.clear();
        }
        return FIELD_TO_SETTER_CACHE.computeIfAbsent(key, compute);
    }
}

