/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.geo.evaluators.functions;

import com.esri.core.geometry.Geometry;
import com.esri.core.geometry.GeometryCursor;
import com.esri.core.geometry.ogc.OGCGeometry;
import org.apache.asterix.geo.evaluators.functions.AbstractSTSingleGeometryDescriptor;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.functions.IFunctionDescriptor;
import org.apache.asterix.om.functions.IFunctionDescriptorFactory;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.api.exceptions.HyracksDataException;

public class STAreaDescriptor
extends AbstractSTSingleGeometryDescriptor {
    private static final long serialVersionUID = 1L;
    public static final IFunctionDescriptorFactory FACTORY = new IFunctionDescriptorFactory(){

        public IFunctionDescriptor createFunctionDescriptor() {
            return new STAreaDescriptor();
        }
    };

    @Override
    protected Object evaluateOGCGeometry(OGCGeometry geometry) throws HyracksDataException {
        double area;
        if (!"GeometryCollection".equals(geometry.geometryType())) {
            area = geometry.getEsriGeometry().calculateArea2D();
        } else {
            GeometryCursor cursor = geometry.getEsriGeometryCursor();
            Geometry geometry1 = cursor.next();
            area = 0.0;
            while (geometry1 != null) {
                area += geometry1.calculateArea2D();
                geometry1 = cursor.next();
            }
        }
        return area;
    }

    public FunctionIdentifier getIdentifier() {
        return BuiltinFunctions.ST_AREA;
    }
}

