/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.common.context;

import java.util.HashMap;
import java.util.Map;
import org.apache.asterix.common.api.IDiskWriteRateLimiterProvider;
import org.apache.asterix.common.api.INcApplicationContext;
import org.apache.asterix.common.utils.StoragePathUtil;
import org.apache.hyracks.api.application.INCServiceContext;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.storage.common.IResource;
import org.apache.hyracks.storage.common.buffercache.IRateLimiter;
import org.apache.hyracks.storage.common.buffercache.SleepRateLimiter;

public class DiskWriteRateLimiterProvider
implements IDiskWriteRateLimiterProvider {
    private final Map<Integer, IRateLimiter> limiters = new HashMap<Integer, IRateLimiter>();

    @Override
    public synchronized IRateLimiter getRateLimiter(INCServiceContext serviceCtx, IResource resource) throws HyracksDataException {
        int partition = StoragePathUtil.getPartitionNumFromRelativePath(resource.getPath());
        IRateLimiter limiter = this.limiters.get(partition);
        if (limiter == null) {
            INcApplicationContext appCtx = (INcApplicationContext)serviceCtx.getApplicationContext();
            long writeRateLimit = appCtx.getStorageProperties().getWriteRateLimit();
            limiter = SleepRateLimiter.create((long)writeRateLimit);
            this.limiters.put(partition, limiter);
        }
        return limiter;
    }
}

