/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.optimizer.rules.am;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.asterix.metadata.entities.Dataset;
import org.apache.asterix.metadata.entities.Index;
import org.apache.asterix.optimizer.rules.am.IOptimizableFuncExpr;
import org.apache.asterix.optimizer.rules.am.array.ArrayIndexStructureMatcher;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.algebricks.common.utils.Quadruple;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.expressions.ScalarFunctionCallExpression;

public class AccessMethodAnalysisContext {
    private final ArrayIndexStructureMatcher arrayIndexStructureMatcher = new ArrayIndexStructureMatcher();
    private List<IOptimizableFuncExpr> matchedFuncExprs = new ArrayList<IOptimizableFuncExpr>();
    private Map<Index, List<Pair<Integer, Integer>>> indexExprsAndVars = new TreeMap<Index, List<Pair<Integer, Integer>>>();
    private Map<Index, Dataset> indexDatasetMap = new TreeMap<Index, Dataset>();
    private Map<Index, Integer> indexNumMatchedKeys = new TreeMap<Index, Integer>();
    private Mutable<ILogicalOperator> lojSpecialGroupByOpRef = null;
    private ScalarFunctionCallExpression lojIsMissingNullFuncInSpecialGroupBy = null;
    private Quadruple<Boolean, Boolean, Boolean, Boolean> indexOnlyPlanInfo = new Quadruple((Object)false, (Object)false, (Object)false, (Object)false);

    public void addIndexExpr(Dataset dataset, Index index, Integer exprIndex, Integer varIndex) {
        List<Pair<Integer, Integer>> exprs = this.getIndexExprsFromIndexExprsAndVars(index);
        if (exprs == null) {
            exprs = new ArrayList<Pair<Integer, Integer>>();
            this.putIndexExprToIndexExprsAndVars(index, exprs);
        }
        exprs.add((Pair<Integer, Integer>)new Pair((Object)exprIndex, (Object)varIndex));
        this.putDatasetIntoIndexDatasetMap(index, dataset);
    }

    public List<IOptimizableFuncExpr> getMatchedFuncExprs() {
        return this.matchedFuncExprs;
    }

    public IOptimizableFuncExpr getMatchedFuncExpr(int index) {
        return this.matchedFuncExprs.get(index);
    }

    public void addMatchedFuncExpr(IOptimizableFuncExpr optFuncExpr) {
        this.matchedFuncExprs.add(optFuncExpr);
    }

    public Iterator<Map.Entry<Index, List<Pair<Integer, Integer>>>> getIteratorForIndexExprsAndVars() {
        return this.indexExprsAndVars.entrySet().iterator();
    }

    public boolean isIndexExprsAndVarsEmpty() {
        return this.indexExprsAndVars.isEmpty();
    }

    public List<Pair<Integer, Integer>> getIndexExprsFromIndexExprsAndVars(Index index) {
        return this.indexExprsAndVars.get(index);
    }

    public void putIndexExprToIndexExprsAndVars(Index index, List<Pair<Integer, Integer>> exprs) {
        this.indexExprsAndVars.put(index, exprs);
    }

    public Integer getNumberOfMatchedKeys(Index index) {
        return this.indexNumMatchedKeys.get(index);
    }

    public void putNumberOfMatchedKeys(Index index, Integer numMatchedKeys) {
        this.indexNumMatchedKeys.put(index, numMatchedKeys);
    }

    public void setLOJSpecialGroupByOpRef(Mutable<ILogicalOperator> opRef) {
        this.lojSpecialGroupByOpRef = opRef;
    }

    public Mutable<ILogicalOperator> getLOJSpecialGroupByOpRef() {
        return this.lojSpecialGroupByOpRef;
    }

    public void setLOJIsMissingNullFuncInSpecialGroupBy(ScalarFunctionCallExpression isMissingNullFunc) {
        this.lojIsMissingNullFuncInSpecialGroupBy = isMissingNullFunc;
    }

    public ScalarFunctionCallExpression getLOJIsMissingNullFuncInSpecialGroupBy() {
        return this.lojIsMissingNullFuncInSpecialGroupBy;
    }

    public Dataset getDatasetFromIndexDatasetMap(Index idx) {
        return this.getIndexDatasetMap().get(idx);
    }

    public void putDatasetIntoIndexDatasetMap(Index idx, Dataset ds) {
        this.getIndexDatasetMap().put(idx, ds);
    }

    public void setIndexOnlyPlanInfo(Quadruple<Boolean, Boolean, Boolean, Boolean> indexOnlyPlanInfo) {
        this.indexOnlyPlanInfo = indexOnlyPlanInfo;
    }

    public Quadruple<Boolean, Boolean, Boolean, Boolean> getIndexOnlyPlanInfo() {
        return this.indexOnlyPlanInfo;
    }

    public Map<Index, Dataset> getIndexDatasetMap() {
        return this.indexDatasetMap;
    }

    public void setIndexDatasetMap(Map<Index, Dataset> indexDatasetMap) {
        this.indexDatasetMap = indexDatasetMap;
    }

    public ArrayIndexStructureMatcher getArrayIndexStructureMatcher() {
        return this.arrayIndexStructureMatcher;
    }
}

