/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.dataflow.std.group.aggregators;

import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.hyracks.api.comm.IFrameTupleAccessor;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.primitive.IntegerPointable;
import org.apache.hyracks.dataflow.std.group.AggregateState;
import org.apache.hyracks.dataflow.std.group.IFieldAggregateDescriptor;
import org.apache.hyracks.dataflow.std.group.IFieldAggregateDescriptorFactory;

public class IntSumFieldAggregatorFactory
implements IFieldAggregateDescriptorFactory {
    private static final long serialVersionUID = 1L;
    private final int aggField;
    private final boolean useObjectState;

    public IntSumFieldAggregatorFactory(int aggField, boolean useObjState) {
        this.aggField = aggField;
        this.useObjectState = useObjState;
    }

    @Override
    public IFieldAggregateDescriptor createAggregator(IHyracksTaskContext ctx, RecordDescriptor inRecordDescriptor, RecordDescriptor outRecordDescriptor) throws HyracksDataException {
        return new IFieldAggregateDescriptor(){

            @Override
            public void reset() {
            }

            @Override
            public void outputPartialResult(DataOutput fieldOutput, byte[] data, int offset, AggregateState state) throws HyracksDataException {
                int sum = !IntSumFieldAggregatorFactory.this.useObjectState ? IntegerPointable.getInteger((byte[])data, (int)offset) : (Integer)state.state;
                try {
                    fieldOutput.writeInt(sum);
                }
                catch (IOException e) {
                    throw new HyracksDataException("I/O exception when writing aggregation to the output buffer.");
                }
            }

            @Override
            public void outputFinalResult(DataOutput fieldOutput, byte[] data, int offset, AggregateState state) throws HyracksDataException {
                int sum = !IntSumFieldAggregatorFactory.this.useObjectState ? IntegerPointable.getInteger((byte[])data, (int)offset) : (Integer)state.state;
                try {
                    fieldOutput.writeInt(sum);
                }
                catch (IOException e) {
                    throw new HyracksDataException("I/O exception when writing aggregation to the output buffer.");
                }
            }

            @Override
            public void init(IFrameTupleAccessor accessor, int tIndex, DataOutput fieldOutput, AggregateState state) throws HyracksDataException {
                int sum = 0;
                int tupleOffset = accessor.getTupleStartOffset(tIndex);
                int fieldStart = accessor.getFieldStartOffset(tIndex, IntSumFieldAggregatorFactory.this.aggField);
                sum += IntegerPointable.getInteger((byte[])accessor.getBuffer().array(), (int)(tupleOffset + accessor.getFieldSlotsLength() + fieldStart));
                if (!IntSumFieldAggregatorFactory.this.useObjectState) {
                    try {
                        fieldOutput.writeInt(sum);
                    }
                    catch (IOException e) {
                        throw new HyracksDataException("I/O exception when initializing the aggregator.");
                    }
                } else {
                    state.state = sum;
                }
            }

            @Override
            public boolean needsObjectState() {
                return IntSumFieldAggregatorFactory.this.useObjectState;
            }

            @Override
            public boolean needsBinaryState() {
                return !IntSumFieldAggregatorFactory.this.useObjectState;
            }

            @Override
            public AggregateState createState() {
                return new AggregateState(new Integer(0));
            }

            @Override
            public void close() {
            }

            @Override
            public void aggregate(IFrameTupleAccessor accessor, int tIndex, byte[] data, int offset, AggregateState state) throws HyracksDataException {
                int sum = 0;
                int tupleOffset = accessor.getTupleStartOffset(tIndex);
                int fieldStart = accessor.getFieldStartOffset(tIndex, IntSumFieldAggregatorFactory.this.aggField);
                sum += IntegerPointable.getInteger((byte[])accessor.getBuffer().array(), (int)(tupleOffset + accessor.getFieldSlotsLength() + fieldStart));
                if (!IntSumFieldAggregatorFactory.this.useObjectState) {
                    ByteBuffer buf = ByteBuffer.wrap(data);
                    buf.putInt(offset, sum += buf.getInt(offset));
                } else {
                    state.state = sum += ((Integer)state.state).intValue();
                }
            }
        };
    }
}

