/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.functions;

import java.io.IOException;
import org.apache.asterix.formats.nontagged.BinaryComparatorFactoryProvider;
import org.apache.asterix.formats.nontagged.SerializerDeserializerProvider;
import org.apache.asterix.om.base.AInt32;
import org.apache.asterix.om.base.AMutableInt32;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.functions.IFunctionDescriptorFactory;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.AbstractCollectionType;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.EnumDeserializer;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.runtime.evaluators.base.AbstractScalarFunctionDynamicDescriptor;
import org.apache.asterix.runtime.evaluators.common.ListAccessor;
import org.apache.asterix.runtime.evaluators.functions.PointableHelper;
import org.apache.asterix.runtime.functions.FunctionTypeInferers;
import org.apache.asterix.runtime.utils.DescriptorFactoryUtil;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.runtime.base.IEvaluatorContext;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.dataflow.value.IBinaryComparator;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

public class ArrayBinarySearchDescriptor
extends AbstractScalarFunctionDynamicDescriptor {
    private static final long serialVersionUID = 1L;
    private IAType[] argTypes;
    public static final IFunctionDescriptorFactory FACTORY = DescriptorFactoryUtil.createFactory(ArrayBinarySearchDescriptor::new, FunctionTypeInferers.SET_ARGUMENTS_TYPE);

    public void setImmutableStates(Object ... states) {
        this.argTypes = (IAType[])states;
    }

    public FunctionIdentifier getIdentifier() {
        return BuiltinFunctions.ARRAY_BINARY_SEARCH;
    }

    public IScalarEvaluatorFactory createEvaluatorFactory(final IScalarEvaluatorFactory[] args) throws AlgebricksException {
        return new IScalarEvaluatorFactory(){
            private static final long serialVersionUID = 1L;

            public IScalarEvaluator createScalarEvaluator(IEvaluatorContext ctx) throws HyracksDataException {
                return new ArrayBinarySearchEval(args, ctx, ArrayBinarySearchDescriptor.this.argTypes);
            }
        };
    }

    private int fetchFirstValue(int midIndexArg, ArrayBackedValueStorage storage, ArrayBackedValueStorage storage2, ListAccessor listAccessor, IBinaryComparator comp, IPointable tempVal1, IPointable tempVal2) throws IOException {
        int midIndex = midIndexArg;
        if (midIndex == 0) {
            return midIndex;
        }
        storage.reset();
        listAccessor.getOrWriteItem(midIndex, tempVal1, storage);
        storage.reset();
        listAccessor.getOrWriteItem(midIndex - 1, tempVal2, storage2);
        int prevComparison = comp.compare(tempVal1.getByteArray(), tempVal1.getStartOffset(), tempVal1.getLength(), tempVal2.getByteArray(), tempVal2.getStartOffset(), tempVal2.getLength());
        if (prevComparison != 0) {
            return midIndex;
        }
        --midIndex;
        int counter = 0;
        while (prevComparison == 0) {
            if (midIndex - ++counter == 0) {
                return 0;
            }
            storage2.reset();
            listAccessor.getOrWriteItem(midIndex - counter, tempVal2, storage2);
            prevComparison = comp.compare(tempVal1.getByteArray(), tempVal1.getStartOffset(), tempVal1.getLength(), tempVal2.getByteArray(), tempVal2.getStartOffset(), tempVal2.getLength());
            if (prevComparison == 0) continue;
            return midIndex - counter + 1;
        }
        return -1;
    }

    public class ArrayBinarySearchEval
    implements IScalarEvaluator {
        private final ArrayBackedValueStorage storage;
        private final ArrayBackedValueStorage tempStorage;
        private final IScalarEvaluator listArgEval;
        private final IScalarEvaluator searchArgEval;
        private final IPointable listArg;
        private final IPointable searchArg;
        private final IPointable tempVal;
        private final IPointable tempVal2;
        private final ListAccessor listAccessor;
        private final IBinaryComparator comp;
        private final ISerializerDeserializer<AInt32> serde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.AINT32);
        private final AMutableInt32 resIndex = new AMutableInt32(0);

        public ArrayBinarySearchEval(IScalarEvaluatorFactory[] args, IEvaluatorContext ctx, IAType[] argTypes) throws HyracksDataException {
            this.storage = new ArrayBackedValueStorage();
            this.tempStorage = new ArrayBackedValueStorage();
            this.listArg = new VoidPointable();
            this.searchArg = new VoidPointable();
            this.tempVal = new VoidPointable();
            this.tempVal2 = new VoidPointable();
            this.listArgEval = args[0].createScalarEvaluator(ctx);
            this.searchArgEval = args[1].createScalarEvaluator(ctx);
            this.listAccessor = new ListAccessor();
            this.comp = this.createComparator(argTypes[0], argTypes[1]);
        }

        private IBinaryComparator createComparator(IAType listType, IAType searchValueType) {
            BuiltinType itemType = listType.getTypeTag().isListType() ? ((AbstractCollectionType)listType).getItemType() : BuiltinType.ANY;
            return BinaryComparatorFactoryProvider.INSTANCE.getBinaryComparatorFactory((Object)itemType, (Object)searchValueType, true).createBinaryComparator();
        }

        public void evaluate(IFrameTupleReference tuple, IPointable result) throws HyracksDataException {
            int offset;
            this.listArgEval.evaluate(tuple, this.listArg);
            this.searchArgEval.evaluate(tuple, this.searchArg);
            if (PointableHelper.checkAndSetMissingOrNull(result, this.listArg, this.searchArg)) {
                return;
            }
            byte[] listBytes = this.listArg.getByteArray();
            ATypeTag listType = (ATypeTag)EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(listBytes[offset = this.listArg.getStartOffset()]);
            if (listType != ATypeTag.ARRAY) {
                PointableHelper.setNull(result);
                return;
            }
            byte[] searchBytes = this.searchArg.getByteArray();
            int searchOffset = this.searchArg.getStartOffset();
            this.listAccessor.reset(listBytes, offset);
            int listLen = this.listAccessor.size();
            int low = 0;
            int high = listLen - 1;
            try {
                while (low <= high) {
                    int mid = low + (high - low) / 2;
                    this.storage.reset();
                    this.listAccessor.getOrWriteItem(mid, this.tempVal, this.storage);
                    int comparison = this.comp.compare(this.tempVal.getByteArray(), this.tempVal.getStartOffset(), this.tempVal.getLength(), searchBytes, searchOffset, this.searchArg.getLength());
                    if (comparison == 0) {
                        int firstFoundIndex = ArrayBinarySearchDescriptor.this.fetchFirstValue(mid, this.storage, this.tempStorage, this.listAccessor, this.comp, this.tempVal, this.tempVal2);
                        this.storage.reset();
                        this.resIndex.setValue(firstFoundIndex);
                        this.serde.serialize((Object)this.resIndex, this.storage.getDataOutput());
                        result.set((IValueReference)this.storage);
                        return;
                    }
                    if (comparison < 0) {
                        low = mid + 1;
                        continue;
                    }
                    high = mid - 1;
                }
                this.storage.reset();
                this.resIndex.setValue(-1);
                this.serde.serialize((Object)this.resIndex, this.storage.getDataOutput());
                result.set((IValueReference)this.storage);
            }
            catch (IOException e) {
                throw HyracksDataException.create((Throwable)e);
            }
        }
    }
}

