/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.library.java.base;

import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.asterix.builders.RecordBuilder;
import org.apache.asterix.common.exceptions.ErrorCode;
import org.apache.asterix.common.exceptions.RuntimeDataException;
import org.apache.asterix.dataflow.data.nontagged.serde.ARecordSerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.AStringSerializerDeserializer;
import org.apache.asterix.external.api.IJObject;
import org.apache.asterix.external.library.java.base.JComplexObject;
import org.apache.asterix.external.library.java.base.JObject;
import org.apache.asterix.om.base.AMutableString;
import org.apache.asterix.om.base.ARecord;
import org.apache.asterix.om.base.AString;
import org.apache.asterix.om.base.IAObject;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.om.utils.RecordUtil;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.util.LogRedactionUtil;

public final class JRecord
extends JComplexObject<Map<String, Object>> {
    private static final AStringSerializerDeserializer aStringSerDer = AStringSerializerDeserializer.INSTANCE;
    private ARecordType recordType;
    private IJObject[] fields;
    private Map<String, IJObject> openFields;
    RecordBuilder recordBuilder = new RecordBuilder();
    ArrayBackedValueStorage fieldNameBuffer = new ArrayBackedValueStorage();
    ArrayBackedValueStorage fieldValueBuffer = new ArrayBackedValueStorage();
    AMutableString nameString = new AMutableString("");

    public JRecord() {
        this.recordType = RecordUtil.FULLY_OPEN_RECORD_TYPE;
        this.fields = new IJObject[0];
        this.openFields = new LinkedHashMap<String, IJObject>();
    }

    public JRecord(ARecordType recordType, IJObject[] fields) {
        this.recordType = recordType;
        this.fields = fields;
        this.openFields = new LinkedHashMap<String, IJObject>();
    }

    public JRecord(ARecordType recordType, IJObject[] fields, Map<String, IJObject> openFields) {
        this(recordType, fields);
        this.openFields = openFields;
    }

    public void addField(String fieldName, IJObject fieldValue) throws HyracksDataException {
        int pos = this.getFieldPosByName(fieldName);
        if (pos >= 0) {
            throw new RuntimeDataException(ErrorCode.LIBRARY_JAVA_JOBJECTS_FIELD_ALREADY_DEFINED, new Serializable[]{"closed"});
        }
        if (this.openFields.get(fieldName) != null) {
            throw new RuntimeDataException(ErrorCode.LIBRARY_JAVA_JOBJECTS_FIELD_ALREADY_DEFINED, new Serializable[]{"open"});
        }
        this.openFields.put(fieldName, fieldValue);
    }

    public IJObject getValueByName(String fieldName) throws HyracksDataException {
        int fieldPos = this.getFieldPosByName(fieldName);
        if (fieldPos >= 0) {
            return this.fields[fieldPos];
        }
        IJObject fieldValue = this.openFields.get(fieldName);
        if (fieldValue == null) {
            throw new RuntimeDataException(ErrorCode.LIBRARY_JAVA_JOBJECTS_UNKNOWN_FIELD, new Serializable[]{LogRedactionUtil.userData((String)fieldName)});
        }
        return fieldValue;
    }

    public void setValueAtPos(int pos, IJObject jObject) {
        this.fields[pos] = jObject;
    }

    @Override
    public IAType getIAType() {
        return this.recordType;
    }

    public void setField(String fieldName, IJObject fieldValue) throws HyracksDataException {
        int pos = this.getFieldPosByName(fieldName);
        if (pos >= 0) {
            this.fields[pos] = fieldValue;
        } else {
            this.openFields.put(fieldName, fieldValue);
        }
    }

    private int getFieldPosByName(String fieldName) {
        String[] fieldNames;
        int index = 0;
        for (String name : fieldNames = this.recordType.getFieldNames()) {
            if (name.equals(fieldName)) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    public ARecordType getRecordType() {
        return this.recordType;
    }

    @Override
    public void serialize(DataOutput output, boolean writeTypeTag) throws HyracksDataException {
        this.recordBuilder.reset(this.recordType);
        int index = 0;
        for (IJObject jObject : this.fields) {
            this.fieldValueBuffer.reset();
            jObject.serialize(this.fieldValueBuffer.getDataOutput(), writeTypeTag);
            this.recordBuilder.addField(index, (IValueReference)this.fieldValueBuffer);
            ++index;
        }
        try {
            if (this.openFields != null && !this.openFields.isEmpty()) {
                for (Map.Entry entry : this.openFields.entrySet()) {
                    this.fieldNameBuffer.reset();
                    this.fieldValueBuffer.reset();
                    this.nameString.setValue((String)entry.getKey());
                    this.fieldNameBuffer.getDataOutput().write(ATypeTag.STRING.serialize());
                    aStringSerDer.serialize((AString)this.nameString, this.fieldNameBuffer.getDataOutput());
                    ((IJObject)entry.getValue()).serialize(this.fieldValueBuffer.getDataOutput(), writeTypeTag);
                    this.recordBuilder.addField((IValueReference)this.fieldNameBuffer, (IValueReference)this.fieldValueBuffer);
                }
            }
        }
        catch (IOException ae) {
            throw HyracksDataException.create((Throwable)ae);
        }
        this.recordBuilder.write(output, writeTypeTag);
    }

    @Override
    public IAObject getIAObject() {
        int numberOfOpenFields = this.openFields.size();
        String[] openFieldNames = new String[numberOfOpenFields];
        IAType[] openFieldTypes = new IAType[numberOfOpenFields];
        IAObject[] openFieldValues = new IAObject[numberOfOpenFields];
        IAObject[] closedFieldValues = new IAObject[this.fields.length];
        int idx = 0;
        for (Map.Entry<String, IJObject> entry : this.openFields.entrySet()) {
            openFieldNames[idx] = entry.getKey();
            openFieldTypes[idx] = entry.getValue().getIAObject().getType();
            openFieldValues[idx] = entry.getValue().getIAObject();
        }
        for (int iter1 = 0; iter1 < this.fields.length; ++iter1) {
            closedFieldValues[iter1] = this.fields[iter1].getIAObject();
        }
        ARecordType openPartRecType = new ARecordType(null, openFieldNames, openFieldTypes, true);
        ARecordType mergedRecordType = ARecordSerializerDeserializer.mergeRecordTypes((ARecordType)this.recordType, (ARecordType)openPartRecType);
        IAObject[] mergedFields = ARecordSerializerDeserializer.mergeFields((IAObject[])closedFieldValues, (IAObject[])openFieldValues);
        return new ARecord(mergedRecordType, mergedFields);
    }

    @Override
    public void setValueGeneric(Map<String, Object> o) throws HyracksDataException {
        this.reset();
        for (Map.Entry<String, Object> e : o.entrySet()) {
            IAType asxClass = JObject.convertType(e.getValue().getClass());
            IJObject obj = (IJObject)this.pool.allocate((Object)asxClass);
            obj.setValueGeneric(e.getValue());
            this.openFields.put(e.getKey(), obj);
        }
    }

    @Override
    public Map<String, Object> getValueGeneric() {
        HashMap<String, Object> rec = new HashMap<String, Object>();
        String[] closedFieldNames = this.recordType.getFieldNames();
        int idx = 0;
        for (IJObject j : this.fields) {
            rec.put(closedFieldNames[idx], j.getValueGeneric());
            ++idx;
        }
        this.openFields.entrySet().forEach(e -> rec.put((String)e.getKey(), ((IJObject)e.getValue()).getValueGeneric()));
        return rec;
    }

    @Override
    public void reset() throws HyracksDataException {
        if (this.openFields != null && !this.openFields.isEmpty()) {
            this.openFields.clear();
        }
        if (this.fields != null) {
            for (IJObject field : this.fields) {
                if (field == null) continue;
                field.reset();
            }
        }
    }

    public void reset(IJObject[] fields, Map<String, IJObject> openFields) throws HyracksDataException {
        this.reset();
        this.fields = fields;
        this.openFields = openFields;
    }
}

