/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.rewriter.util;

import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.IPhysicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalExpressionTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.BroadcastExpressionAnnotation;
import org.apache.hyracks.algebricks.core.algebra.expressions.HashJoinExpressionAnnotation;
import org.apache.hyracks.algebricks.core.algebra.expressions.VariableReferenceExpression;
import org.apache.hyracks.algebricks.core.algebra.functions.AlgebricksBuiltinFunctions;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractBinaryJoinOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.visitors.LogicalPropertiesVisitor;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.visitors.VariableUtilities;
import org.apache.hyracks.algebricks.core.algebra.operators.physical.AbstractJoinPOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.physical.HybridHashJoinPOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.physical.InMemoryHashJoinPOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.physical.NestedLoopJoinPOperator;
import org.apache.hyracks.algebricks.core.algebra.properties.ILogicalPropertiesVector;
import org.apache.hyracks.algebricks.core.algebra.util.OperatorPropertiesUtil;
import org.apache.hyracks.algebricks.core.config.AlgebricksConfig;
import org.apache.hyracks.api.exceptions.ErrorCode;
import org.apache.hyracks.api.exceptions.IError;
import org.apache.hyracks.api.exceptions.IWarningCollector;
import org.apache.hyracks.api.exceptions.SourceLocation;
import org.apache.hyracks.api.exceptions.Warning;

public class JoinUtils {
    private JoinUtils() {
    }

    public static void setJoinAlgorithmAndExchangeAlgo(AbstractBinaryJoinOperator op, boolean topLevelOp, IOptimizationContext context) throws AlgebricksException {
        if (!topLevelOp) {
            throw new IllegalStateException("Micro operator not implemented for: " + op.getOperatorTag());
        }
        LinkedList<LogicalVariable> sideLeft = new LinkedList<LogicalVariable>();
        LinkedList<LogicalVariable> sideRight = new LinkedList<LogicalVariable>();
        List varsLeft = ((ILogicalOperator)((Mutable)op.getInputs().get(0)).getValue()).getSchema();
        List varsRight = ((ILogicalOperator)((Mutable)op.getInputs().get(1)).getValue()).getSchema();
        ILogicalExpression conditionExpr = (ILogicalExpression)op.getCondition().getValue();
        if (JoinUtils.isHashJoinCondition(conditionExpr, varsLeft, varsRight, sideLeft, sideRight)) {
            LinkedList<LogicalVariable> scanVarsLeft = new LinkedList<LogicalVariable>();
            LinkedList<LogicalVariable> scanVarsRight = new LinkedList<LogicalVariable>();
            VariableUtilities.getLiveVariablesInDescendantDataScans((ILogicalOperator)((ILogicalOperator)((Mutable)op.getInputs().get(0)).getValue()), scanVarsLeft);
            VariableUtilities.getLiveVariablesInDescendantDataScans((ILogicalOperator)((ILogicalOperator)((Mutable)op.getInputs().get(1)).getValue()), scanVarsRight);
            BroadcastExpressionAnnotation.BroadcastSide broadcastSide = JoinUtils.getBroadcastJoinSide(conditionExpr, scanVarsLeft, scanVarsRight, context);
            if (broadcastSide == null) {
                HashJoinExpressionAnnotation.BuildSide buildSide = JoinUtils.getHashJoinBuildSide(conditionExpr, scanVarsLeft, scanVarsRight, context);
                if (buildSide == null) {
                    JoinUtils.setHashJoinOp(op, AbstractJoinPOperator.JoinPartitioningType.PAIRWISE, sideLeft, sideRight, context);
                } else {
                    switch (buildSide) {
                        case RIGHT: {
                            JoinUtils.setHashJoinOp(op, AbstractJoinPOperator.JoinPartitioningType.PAIRWISE, sideLeft, sideRight, context);
                            break;
                        }
                        case LEFT: {
                            if (op.getJoinKind() == AbstractBinaryJoinOperator.JoinKind.INNER) {
                                Mutable opRef0 = (Mutable)op.getInputs().get(0);
                                Mutable opRef1 = (Mutable)op.getInputs().get(1);
                                ILogicalOperator tmp = (ILogicalOperator)opRef0.getValue();
                                opRef0.setValue((Object)((ILogicalOperator)opRef1.getValue()));
                                opRef1.setValue((Object)tmp);
                                JoinUtils.setHashJoinOp(op, AbstractJoinPOperator.JoinPartitioningType.PAIRWISE, sideRight, sideLeft, context);
                                break;
                            }
                            JoinUtils.setHashJoinOp(op, AbstractJoinPOperator.JoinPartitioningType.PAIRWISE, sideLeft, sideRight, context);
                            break;
                        }
                        default: {
                            throw new IllegalStateException(buildSide.toString());
                        }
                    }
                }
            } else {
                switch (broadcastSide) {
                    case RIGHT: {
                        JoinUtils.setHashJoinOp(op, AbstractJoinPOperator.JoinPartitioningType.BROADCAST, sideLeft, sideRight, context);
                        break;
                    }
                    case LEFT: {
                        if (op.getJoinKind() == AbstractBinaryJoinOperator.JoinKind.INNER) {
                            Mutable opRef0 = (Mutable)op.getInputs().get(0);
                            Mutable opRef1 = (Mutable)op.getInputs().get(1);
                            ILogicalOperator tmp = (ILogicalOperator)opRef0.getValue();
                            opRef0.setValue((Object)((ILogicalOperator)opRef1.getValue()));
                            opRef1.setValue((Object)tmp);
                            JoinUtils.setHashJoinOp(op, AbstractJoinPOperator.JoinPartitioningType.BROADCAST, sideRight, sideLeft, context);
                            break;
                        }
                        JoinUtils.setHashJoinOp(op, AbstractJoinPOperator.JoinPartitioningType.PAIRWISE, sideLeft, sideRight, context);
                        break;
                    }
                    default: {
                        throw new IllegalStateException(broadcastSide.toString());
                    }
                }
            }
        } else {
            JoinUtils.warnIfCrossProduct(conditionExpr, op.getSourceLocation(), context);
            JoinUtils.setNestedLoopJoinOp(op);
        }
    }

    private static void setNestedLoopJoinOp(AbstractBinaryJoinOperator op) {
        op.setPhysicalOperator((IPhysicalOperator)new NestedLoopJoinPOperator(op.getJoinKind(), AbstractJoinPOperator.JoinPartitioningType.BROADCAST));
    }

    private static void setHashJoinOp(AbstractBinaryJoinOperator op, AbstractJoinPOperator.JoinPartitioningType partitioningType, List<LogicalVariable> sideLeft, List<LogicalVariable> sideRight, IOptimizationContext context) {
        op.setPhysicalOperator((IPhysicalOperator)new HybridHashJoinPOperator(op.getJoinKind(), partitioningType, sideLeft, sideRight, context.getPhysicalOptimizationConfig().getMaxFramesForJoinLeftInput(), context.getPhysicalOptimizationConfig().getMaxRecordsPerFrame(), context.getPhysicalOptimizationConfig().getFudgeFactor()));
    }

    public static boolean hybridToInMemHashJoin(AbstractBinaryJoinOperator op, IOptimizationContext context) throws AlgebricksException {
        HybridHashJoinPOperator hhj = (HybridHashJoinPOperator)op.getPhysicalOperator();
        if (hhj.getPartitioningType() != AbstractJoinPOperator.JoinPartitioningType.BROADCAST) {
            return false;
        }
        ILogicalOperator opBuild = (ILogicalOperator)((Mutable)op.getInputs().get(1)).getValue();
        LogicalPropertiesVisitor.computeLogicalPropertiesDFS((ILogicalOperator)opBuild, (IOptimizationContext)context);
        ILogicalPropertiesVector v = context.getLogicalPropertiesVector(opBuild);
        boolean loggerTraceEnabled = AlgebricksConfig.ALGEBRICKS_LOGGER.isTraceEnabled();
        if (loggerTraceEnabled) {
            AlgebricksConfig.ALGEBRICKS_LOGGER.trace("// HybridHashJoin inner branch -- Logical properties for " + opBuild.getOperatorTag() + ": " + v + "\n");
        }
        if (v != null) {
            int size2 = v.getMaxOutputFrames();
            int hhjMemSizeInFrames = hhj.getLocalMemoryRequirements().getMemoryBudgetInFrames();
            if (size2 > 0 && (double)size2 * hhj.getFudgeFactor() <= (double)hhjMemSizeInFrames) {
                if (loggerTraceEnabled) {
                    AlgebricksConfig.ALGEBRICKS_LOGGER.trace("// HybridHashJoin inner branch " + opBuild.getOperatorTag() + " fits in memory\n");
                }
                op.setPhysicalOperator((IPhysicalOperator)new InMemoryHashJoinPOperator(hhj.getKind(), hhj.getPartitioningType(), hhj.getKeysLeftBranch(), hhj.getKeysRightBranch(), v.getNumberOfTuples() * 2));
                return true;
            }
        }
        return false;
    }

    private static boolean isHashJoinCondition(ILogicalExpression e, Collection<LogicalVariable> inLeftAll, Collection<LogicalVariable> inRightAll, Collection<LogicalVariable> outLeftFields, Collection<LogicalVariable> outRightFields) {
        switch (e.getExpressionTag()) {
            case FUNCTION_CALL: {
                AbstractFunctionCallExpression fexp = (AbstractFunctionCallExpression)e;
                FunctionIdentifier fi = fexp.getFunctionIdentifier();
                if (fi.equals((Object)AlgebricksBuiltinFunctions.AND)) {
                    for (Mutable a : fexp.getArguments()) {
                        if (JoinUtils.isHashJoinCondition((ILogicalExpression)a.getValue(), inLeftAll, inRightAll, outLeftFields, outRightFields)) continue;
                        return false;
                    }
                    return true;
                }
                AlgebricksBuiltinFunctions.ComparisonKind ck = AlgebricksBuiltinFunctions.getComparisonType((FunctionIdentifier)fi);
                if (ck != AlgebricksBuiltinFunctions.ComparisonKind.EQ) {
                    return false;
                }
                ILogicalExpression opLeft = (ILogicalExpression)((Mutable)fexp.getArguments().get(0)).getValue();
                ILogicalExpression opRight = (ILogicalExpression)((Mutable)fexp.getArguments().get(1)).getValue();
                if (opLeft.getExpressionTag() != LogicalExpressionTag.VARIABLE || opRight.getExpressionTag() != LogicalExpressionTag.VARIABLE) {
                    return false;
                }
                LogicalVariable var1 = ((VariableReferenceExpression)opLeft).getVariableReference();
                if (inLeftAll.contains(var1) && !outLeftFields.contains(var1)) {
                    outLeftFields.add(var1);
                } else if (inRightAll.contains(var1) && !outRightFields.contains(var1)) {
                    outRightFields.add(var1);
                } else {
                    return false;
                }
                LogicalVariable var2 = ((VariableReferenceExpression)opRight).getVariableReference();
                if (inLeftAll.contains(var2) && !outLeftFields.contains(var2)) {
                    outLeftFields.add(var2);
                } else if (inRightAll.contains(var2) && !outRightFields.contains(var2)) {
                    outRightFields.add(var2);
                } else {
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    private static BroadcastExpressionAnnotation.BroadcastSide getBroadcastJoinSide(ILogicalExpression e, List<LogicalVariable> varsLeft, List<LogicalVariable> varsRight, IOptimizationContext context) {
        BroadcastExpressionAnnotation.BroadcastSide side = null;
        if (e.getExpressionTag() != LogicalExpressionTag.FUNCTION_CALL) {
            return null;
        }
        AbstractFunctionCallExpression fexp = (AbstractFunctionCallExpression)e;
        FunctionIdentifier fi = fexp.getFunctionIdentifier();
        if (fi.equals((Object)AlgebricksBuiltinFunctions.AND)) {
            for (Mutable a : fexp.getArguments()) {
                BroadcastExpressionAnnotation.BroadcastSide newSide = JoinUtils.getBroadcastJoinSide((ILogicalExpression)a.getValue(), varsLeft, varsRight, context);
                if (side == null) {
                    side = newSide;
                    continue;
                }
                if (newSide == null || newSide.equals((Object)side)) continue;
                return null;
            }
            return side;
        }
        BroadcastExpressionAnnotation bcastAnnotation = (BroadcastExpressionAnnotation)fexp.getAnnotation(BroadcastExpressionAnnotation.class);
        if (bcastAnnotation != null) {
            BroadcastExpressionAnnotation.BroadcastSide bcastSide = bcastAnnotation.getBroadcastSide();
            if (bcastSide != null) {
                return bcastSide;
            }
            String broadcastObject = "$$" + bcastAnnotation.getName();
            if (varsRight.stream().map(LogicalVariable::toString).anyMatch(v -> v.equals(broadcastObject))) {
                bcastAnnotation.setBroadcastSide(BroadcastExpressionAnnotation.BroadcastSide.RIGHT);
                return bcastAnnotation.getBroadcastSide();
            }
            if (varsLeft.stream().map(LogicalVariable::toString).anyMatch(v -> v.equals(broadcastObject))) {
                bcastAnnotation.setBroadcastSide(BroadcastExpressionAnnotation.BroadcastSide.LEFT);
                return bcastAnnotation.getBroadcastSide();
            }
            IWarningCollector warningCollector = context.getWarningCollector();
            if (warningCollector.shouldWarn()) {
                warningCollector.warn(Warning.of((SourceLocation)e.getSourceLocation(), (IError)ErrorCode.INAPPLICABLE_HINT, (Serializable[])new Serializable[]{"broadcast hash join", "broadcast " + bcastAnnotation.getName()}));
            }
            return null;
        }
        return null;
    }

    private static HashJoinExpressionAnnotation.BuildSide getHashJoinBuildSide(ILogicalExpression e, List<LogicalVariable> varsLeft, List<LogicalVariable> varsRight, IOptimizationContext context) {
        HashJoinExpressionAnnotation.BuildSide side = null;
        if (e.getExpressionTag() != LogicalExpressionTag.FUNCTION_CALL) {
            return null;
        }
        AbstractFunctionCallExpression fexp = (AbstractFunctionCallExpression)e;
        FunctionIdentifier fi = fexp.getFunctionIdentifier();
        if (fi.equals((Object)AlgebricksBuiltinFunctions.AND)) {
            for (Mutable a : fexp.getArguments()) {
                HashJoinExpressionAnnotation.BuildSide newSide = JoinUtils.getHashJoinBuildSide((ILogicalExpression)a.getValue(), varsLeft, varsRight, context);
                if (side == null) {
                    side = newSide;
                    continue;
                }
                if (newSide == null || newSide.equals((Object)side)) continue;
                return null;
            }
            return side;
        }
        HashJoinExpressionAnnotation hashJoinAnnotation = (HashJoinExpressionAnnotation)fexp.getAnnotation(HashJoinExpressionAnnotation.class);
        if (hashJoinAnnotation != null) {
            HashJoinExpressionAnnotation.BuildSide buildSide = hashJoinAnnotation.getBuildSide();
            if (buildSide != null) {
                return buildSide;
            }
            boolean build = hashJoinAnnotation.getBuildOrProbe() == HashJoinExpressionAnnotation.BuildOrProbe.BUILD;
            boolean probe = hashJoinAnnotation.getBuildOrProbe() == HashJoinExpressionAnnotation.BuildOrProbe.PROBE;
            String buildOrProbeObject = "$$" + hashJoinAnnotation.getName();
            if (build && varsRight.stream().map(LogicalVariable::toString).anyMatch(v -> v.equals(buildOrProbeObject)) || probe && varsLeft.stream().map(LogicalVariable::toString).anyMatch(v -> v.equals(buildOrProbeObject))) {
                hashJoinAnnotation.setBuildSide(HashJoinExpressionAnnotation.BuildSide.RIGHT);
                return hashJoinAnnotation.getBuildSide();
            }
            if (build && varsLeft.stream().map(LogicalVariable::toString).anyMatch(v -> v.equals(buildOrProbeObject)) || probe && varsRight.stream().map(LogicalVariable::toString).anyMatch(v -> v.equals(buildOrProbeObject))) {
                hashJoinAnnotation.setBuildSide(HashJoinExpressionAnnotation.BuildSide.LEFT);
                return hashJoinAnnotation.getBuildSide();
            }
            IWarningCollector warningCollector = context.getWarningCollector();
            if (warningCollector.shouldWarn()) {
                warningCollector.warn(Warning.of((SourceLocation)e.getSourceLocation(), (IError)ErrorCode.INAPPLICABLE_HINT, (Serializable[])new Serializable[]{"hash join", (build ? "build " : "probe ") + "with " + hashJoinAnnotation.getName()}));
            }
            return null;
        }
        return null;
    }

    private static void warnIfCrossProduct(ILogicalExpression conditionExpr, SourceLocation sourceLoc, IOptimizationContext context) {
        IWarningCollector warningCollector;
        if (OperatorPropertiesUtil.isAlwaysTrueCond((ILogicalExpression)conditionExpr) && sourceLoc != null && (warningCollector = context.getWarningCollector()).shouldWarn()) {
            warningCollector.warn(Warning.of((SourceLocation)sourceLoc, (IError)ErrorCode.CROSS_PRODUCT_JOIN, (Serializable[])new Serializable[0]));
        }
    }
}

